import React from 'react';
import { editor as Monaco } from 'monaco-editor';
import { MultiModalResponse } from '@kui-shell/core';
import { Options as MonacoOptions } from './lib/defaults';
import '../../../../web/scss/components/Editor/Editor.scss';
declare type Props = MonacoOptions & {
    response: MultiModalResponse;
    tabUUID: string;
    originalContent: string;
    modifiedContent: string;
    contentType: string;
    /** Use a light theme? Default: false */
    light?: boolean;
    /** Size height to fit? */
    sizeToFit?: boolean;
    renderSideBySide?: boolean;
};
interface State {
    editor: Monaco.IDiffEditor;
    wrapper: HTMLDivElement;
    catastrophicError: Error;
    cleaners: (() => void)[];
}
export default class DiffEditor extends React.PureComponent<Props, State> {
    constructor(props: Props);
    static getDerivedStateFromError(error: Error): {
        catastrophicError: Error;
    };
    componentDidCatch(error: Error, errorInfo: React.ErrorInfo): void;
    /** Called whenever we have proposed (props,state); we derive a new State */
    static getDerivedStateFromProps(props: Props, state: State): Partial<State>;
    /** Called when this component is no longer attached to the document */
    componentWillUnmount(): void;
    /** Called when we no longer need the monaco-editor instance */
    private destroyMonaco;
    /** Called when we have a ready wrapper (monaco's init requires an wrapper */
    private static initMonaco;
    render(): JSX.Element;
}
export {};
