/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import React from 'react';
import { Icons, TextWithIconWidget } from '../../../';
import { cwd, inBrowser, wireToStandardEvents, unwireToStandardEvents, i18n } from '@kui-shell/core';
const strings = i18n('plugin-client-common');
export default class CurrentWorkingDirectory extends React.PureComponent {
    constructor(props) {
        super(props);
        this.handler = this.reportCurrentDirectory.bind(this);
        this.state = {
            text: '',
            viewLevel: inBrowser() ? 'hidden' : 'normal'
        };
    }
    /**
     * Check the current working directory
     *
     */
    reportCurrentDirectory() {
        return __awaiter(this, void 0, void 0, function* () {
            const dir = cwd();
            this.setState({
                text: dir ? (dir === process.env.HOME ? dir : dir.replace(process.env.HOME, '~')) : undefined,
                viewLevel: dir ? 'normal' : 'hidden'
            });
        });
    }
    /**
     * Once we have mounted, we immediately check the state,
     * and schedule an update based on standard REPL events.
     *
     */
    componentDidMount() {
        this.handler();
        wireToStandardEvents(this.handler);
    }
    /** Make sure to unsubscribe! */
    componentWillUnmount() {
        unwireToStandardEvents(this.handler);
    }
    render() {
        return (React.createElement(TextWithIconWidget, { className: ['kui--half-popover-width', this.props.className].filter(_ => _).join(' '), text: this.state.text, viewLevel: this.state.viewLevel, id: "kui--plugin-client-common--current-working-directory", title: strings('Your current working directory'), textOnclick: "ls" },
            React.createElement(Icons, { icon: "Location" })));
    }
}
//# sourceMappingURL=CurrentWorkingDirectory.js.map