"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _Card = _interopRequireDefault(require("../components/spi/Card"));

var _commentary = require("./commentary");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

/**
 * card command usage
 */
const usage = {
  command: 'card',
  strict: 'card',
  example: 'card [<card body text>] [--title <card title text>]',
  docs: 'Card',
  optional: [{
    name: 'body',
    docs: 'card body text'
  }, {
    name: '--title',
    docs: 'Content rendered inside the CardTitle'
  },
  /* {
    name: '--icon',
    docs: 'Attribute that specifies the URL of the image to put on the card.'
  }, */
  {
    name: '-f',
    docs: 'File that contains the texts'
  }, {
    name: '--file',
    docs: 'File that contains the texts'
  }]
};
/**
 * card command handler
 *
 */

function doCard(opts) {
  return __awaiter(this, void 0, void 0, function* () {
    const argv = opts.argvNoOptions;
    const option = opts.parsedOptions;
    const {
      title
      /* , icon */

    } = option;
    const filepath = option.filename || option.f;

    if (filepath) {
      const data = yield (0, _commentary.fetchMarkdownFile)(filepath, opts);
      return {
        react: (0, _Card.default)({
          title,
          children: data
          /*, icon */

        })
      };
    } else {
      const body = argv.slice(1);

      if (body) {
        return {
          react: (0, _Card.default)({
            title,
            children: body
            /* , icon */

          })
        };
      } else {
        throw new Error('Invalid arguments: need card body text');
      }
    }
  });
}
/**
 * This plugin introduces the /card command
 *
 */


var _default = commandTree => __awaiter(void 0, void 0, void 0, function* () {
  commandTree.listen('/card', doCard, {
    usage
  });
});

exports.default = _default;