"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _Icons = _interopRequireDefault(require("../../spi/Icons"));

var _Breadcrumb = _interopRequireDefault(require("../../spi/Breadcrumb"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * TitleBar
 * ---------------------------------
 * | Kind | Namespace    S | M m x |
 * ---------------------------------
 *
 *  Kind: props.kind
 *  Namespace: props.namespace
 */
class Window extends _react.default.PureComponent {
  quitButton() {
    return _react.default.createElement("div", {
      className: "sidecar-bottom-stripe-button sidecar-bottom-stripe-quit"
    }, _react.default.createElement("a", {
      href: "#",
      className: "graphical-icon kui--tab-navigatable kui--notab-when-sidecar-hidden",
      tabIndex: -1,
      "aria-label": "Close",
      onClick: () => this.props.onClose()
    }, _react.default.createElement(_Icons.default, {
      icon: "WindowClose"
    })));
  }
  /** back button */


  back() {
    if (this.props.back) {
      return this.props.back.enabled ? _react.default.createElement("span", {
        className: "sidecar-bottom-stripe-button"
      }, _react.default.createElement("a", {
        href: "#",
        className: "graphical-icon kui--tab-navigable"
      }, _react.default.createElement(_Icons.default, {
        icon: "Back",
        onClick: this.props.back.onClick,
        onMouseDown: evt => evt.preventDefault(),
        className: "kui--sidecar--titlebar-navigation--back"
      }))) : _react.default.createElement("span", {
        className: "sidecar-bottom-stripe-button disabled"
      }, _react.default.createElement("a", {
        className: "disabled graphical-icon"
      }, _react.default.createElement(_Icons.default, {
        icon: "Back",
        onClick: this.props.back.onClick,
        className: "kui--sidecar--titlebar-navigation--back"
      })));
    }
  }
  /** forward button */


  forward() {
    if (this.props.forward) {
      return this.props.forward.enabled ? _react.default.createElement("span", {
        className: "sidecar-bottom-stripe-button"
      }, _react.default.createElement("a", {
        href: "#",
        className: "graphical-icon kui--tab-navigable"
      }, _react.default.createElement(_Icons.default, {
        icon: "Forward",
        onClick: this.props.forward.onClick,
        onMouseDown: evt => evt.preventDefault(),
        className: "kui--sidecar--titlebar-navigation--forward"
      }))) : _react.default.createElement("span", {
        className: "sidecar-bottom-stripe-button disabled"
      }, _react.default.createElement("a", {
        className: "disabled graphical-icon"
      }, _react.default.createElement(_Icons.default, {
        icon: "Forward",
        onClick: this.props.forward.onClick,
        className: "kui--sidecar--titlebar-navigation--forward"
      })));
    }
  }
  /** render history navigation UI */


  history() {
    const breadcrumbs = this.props.breadcrumbs && this.props.breadcrumbs.filter(_ => _.label);
    return _react.default.createElement("div", {
      className: "kui--sidecar--titlebar-navigation"
    }, this.back(), this.forward(), breadcrumbs && breadcrumbs.length > 0 && _react.default.createElement(_Breadcrumb.default, {
      breadcrumbs: breadcrumbs,
      repl: this.props.repl
    }));
  }

  render() {
    return _react.default.createElement("div", {
      className: 'sidecar-bottom-stripe zoomable' + (this.props.breadcrumbs ? ' kui--sidecar--titlebar-has-breadcrumbs' : '')
    }, this.history(), _react.default.createElement("div", {
      className: "sidecar-bottom-stripe-left-bits"
    }), _react.default.createElement("div", {
      className: "sidecar-bottom-stripe-right-bits"
    }, _react.default.createElement("div", {
      className: "sidecar-window-buttons"
    }, !this.props.notCloseable && this.quitButton())));
  }

}

exports.default = Window;