"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _ = require("../../..");

var _TopNavSidecarV = require("./TopNavSidecarV2");

var _Navigation = _interopRequireDefault(require("../../spi/Navigation"));

var _BaseSidecarV = _interopRequireDefault(require("./BaseSidecarV2"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* eslint-disable @typescript-eslint/no-empty-function */

/** Lazily load KuiContent; see https://github.com/IBM/kui/issues/3746 */
const KuiContent = _react.default.lazy(() => Promise.resolve().then(() => require('../../Content/KuiContent')));
/**
 *
 * LeftNavSidecar
 * -------------------------
 * | <TitleBar/>           |
 * -------------------------
 * | A1   |                |
 * |  a1  | <Content>      |
 * |  a2  |  <KuiContent/> |
 * | B1   | </Content>     |
 * |  b1  |                |
 * |  b2  |                |
 * -------------------------
 *  ^^^^^ <SideNav/>
 *   A1, B1: <SideNavMenu/>
 *   a1, b1: <SideNavMenuItem/>
 *
 */


class LeftNavSidecar extends _BaseSidecarV.default {
  constructor(props) {
    super(props);
    this._onChange = this.changeCurrent.bind(this);
    this.state = this.getState(props.tab, props.response);
  }
  /** 30/70 split between the Terminal and the LeftNavSidecar */


  defaultWidth() {
    return "70%"
    /* Split70 */
    ;
  }
  /** @return State for the given `Response` */


  getState(tab, response) {
    const navigations = []; // get state from each of the left navigation

    response.menus.forEach(menu => {
      const state = (0, _TopNavSidecarV.getStateFromMMR)(tab, {
        modes: menu.items
      });
      navigations.push(Object.assign({
        title: menu.label
      }, state));
    });
    return {
      allNavs: navigations,
      allLinks: response.links || [],
      current: {
        menuIdx: 0,
        tabIdx: navigations[0].currentTabIndex
      },
      response
    };
  }

  changeCurrent(menuIdx, tabIdx) {
    this.setState(({
      current
    }) => {
      const newCurrent = Object.assign({}, current, {
        menuIdx,
        tabIdx
      });
      return {
        current: newCurrent
      };
    });
  }
  /** render the leftnav part */


  nav() {
    return _react.default.createElement(_Navigation.default, {
      tab: this.props.tab,
      current: this.current,
      changeCurrent: this._onChange
    });
  }

  bodyContent(tabIdx, menuIdx = 0) {
    return _react.default.createElement(_react.default.Suspense, {
      fallback: _react.default.createElement("div", null)
    }, _react.default.createElement(KuiContent, {
      key: `${menuIdx}-${tabIdx}`,
      tab: this.props.tab,
      mode: this.current.allNavs[menuIdx].tabs[tabIdx],
      isActive: true,
      args: {
        argsForMode: undefined,
        argvNoOptions: this.props.argvNoOptions,
        parsedOptions: this.props.parsedOptions
      },
      response: {
        modes: this.current.response.menus[menuIdx].items
      },
      execUUID: this.props.execUUID
    }));
  }

  bodyContainer(tabIdx, menuIdx) {
    return _react.default.createElement("div", {
      className: "kui--sidecar-content"
    }, this.bodyContent(tabIdx, menuIdx));
  }

  render() {
    if (!this.current || !this.current.response) {
      return _react.default.createElement(_.Loading, null);
    }

    return _react.default.createElement("div", {
      className: 'kui--sidecar kui--inverted-color-context kui--nav-view kui--sidecar-nested ' + this.width(),
      ref: this.dom,
      "data-view": "leftnav"
    }, ' ', this.title({
      breadcrumbs: this.current.response.breadcrumbs
    }), _react.default.createElement("div", {
      className: "kui--sidecar-header-and-body zoomable"
    }, this.nav(), this.bodyContainer(this.current.current.tabIdx, this.current.current.menuIdx)));
  }

}

exports.default = LeftNavSidecar;