"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _core = require("@kui-shell/core");

var _TitleBar = _interopRequireDefault(require("./TitleBar"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
class BaseSidecar extends _react.default.PureComponent {
  constructor() {
    super(...arguments);
    /** screenshotable region */

    this.dom = _react.default.createRef();

    this._preventDefault = evt => evt.preventDefault();

    this._stopPropagation = evt => evt.stopPropagation();
  }

  get current() {
    return this.state;
  }

  defaultWidth() {
    return this.props.defaultWidth || "60%"
    /* Split60 */
    ;
  }
  /** Escape key toggles sidecar visibility */


  onEscape(evt) {
    if (evt.key === 'Escape' && this.props.active && !document.getElementById('confirm-dialog') && !(0, _core.isPopup)() && this.current) {
      if (this.props.willChangeSize) {
        this.props.willChangeSize(this.props.width === "0%"
        /* Closed */
        ? this.defaultWidth() : "0%"
        /* Closed */
        );
      }
    }
  }

  onMaximize() {
    if (this.props.willChangeSize) {
      this.props.willChangeSize("100%"
      /* Maximized */
      );
    }

    this.setState({
      isMaximized: true
    });
  }

  onRestore() {
    if (this.props.willChangeSize) {
      this.props.willChangeSize(this.defaultWidth());
    }

    this.setState({
      isMaximized: false
    });
  }

  onClose() {
    if (this.props.onClose) {
      this.props.onClose();
    }

    if (this.props.willChangeSize) {
      this.props.willChangeSize("0%"
      /* Closed */
      );
    }
  }

  isFixedWidth() {
    return false;
  }

  width() {
    return 'visible' + (this.state.isMaximized ? ' maximized' : '');
  }

  title(props) {
    return _react.default.createElement(_TitleBar.default, Object.assign({}, props, {
      notCloseable: true,
      repl: this.props.tab.REPL,
      width: this.defaultWidth(),
      onClose: this.onClose.bind(this)
    }));
  }

}

exports.default = BaseSidecar;