"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _Modal = _interopRequireDefault(require("../spi/Modal"));

var _core = require("@kui-shell/core");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const strings = (0, _core.i18n)('plugin-core-support');

function isActive(state) {
  return state.isActive;
}

class Confirm extends _react.default.PureComponent {
  constructor(props) {
    super(props);
    this.initEvents();
    this.state = {
      isActive: false
    };
  }

  initEvents() {
    const requestChannel = `/kui-shell/Confirm/v1/tab/${this.props.uuid}`;

    _core.eventChannelUnsafe.on(requestChannel, this.onConfirmStart.bind(this));
  }

  onConfirmStart({
    command,
    asking,
    execUUID
  }) {
    this.setState({
      isActive: true,
      command,
      asking,
      execUUID
    });
  }
  /** User has confirmed the command */


  onConfirm(confirmed) {
    if (isActive(this.state)) {
      this.setState({
        isActive: false
      });
      const responseChannel = `/kui-shell/Confirm/v1/tab/${this.props.uuid}/execUUID/${this.state.execUUID}/confirmed`;

      _core.eventChannelUnsafe.emit(responseChannel, {
        confirmed
      });
    }
  }

  render() {
    if (!isActive(this.state)) {
      return _react.default.createElement(_react.default.Fragment, null);
    } else {
      return _react.default.createElement(_Modal.default, {
        id: "confirm-dialog",
        isOpen: true,
        titleIconVariant: "danger",
        title: strings('pleaseConfirm'),
        primaryButtonText: strings('yesIAmSure'),
        secondaryButtonText: strings('cancel'),
        onSubmit: () => this.onConfirm(true),
        onClose: () => this.onConfirm(false)
      }, _react.default.createElement("p", {
        className: "bx--modal-content__text"
      }, strings('aboutToExecute')), _react.default.createElement("p", {
        className: "bx--modal-content__text"
      }, _react.default.createElement("strong", {
        className: "red-text"
      }, this.state.command)), _react.default.createElement("p", {
        className: "bx--modal-content__text"
      }, this.state.asking || strings('areYouSure')));
    }
  }

}

exports.default = Confirm;