"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = renderTable;

var _react = _interopRequireDefault(require("react"));

var _core = require("@kui-shell/core");

var _ = require("../../../");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const PaginatedTable = _react.default.lazy(() => Promise.resolve().then(() => require('./PaginatedTable')));

const LivePaginatedTable = _react.default.lazy(() => Promise.resolve().then(() => require('./LivePaginatedTable')));

function renderTable(tab, repl, response, paginate = 20, toolbars = false, asGrid = false, onRender, isPartOfMiniSplit = false, isWidthConstrained = false) {
  if ((0, _core.isWatchable)(response)) {
    return _react.default.createElement(_react.default.Suspense, {
      fallback: _react.default.createElement("div", null)
    }, _react.default.createElement(_.KuiContext.Consumer, null, config => _react.default.createElement(LivePaginatedTable, {
      tab: tab,
      repl: repl,
      config: config,
      response: response,
      paginate: paginate,
      title: !config.disableTableTitle,
      toolbars: toolbars,
      asGrid: asGrid,
      onRender: onRender,
      isPartOfMiniSplit: isPartOfMiniSplit,
      isWidthConstrained: isWidthConstrained
    })));
  } else {
    return _react.default.createElement(_react.default.Suspense, {
      fallback: _react.default.createElement("div", null)
    }, _react.default.createElement(_.KuiContext.Consumer, null, config => {
      return _react.default.createElement(PaginatedTable, {
        tab: tab,
        repl: repl,
        config: config,
        response: response,
        paginate: paginate,
        title: !config.disableTableTitle,
        toolbars: toolbars,
        asGrid: asGrid,
        onRender: onRender,
        isPartOfMiniSplit: isPartOfMiniSplit,
        isWidthConstrained: isWidthConstrained
      });
    }));
  }
}