"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _Icons = _interopRequireDefault(require("../../spi/Icons"));

var _Breadcrumb = _interopRequireDefault(require("../../spi/Breadcrumb"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const Markdown = _react.default.lazy(() => Promise.resolve().then(() => require('../Markdown')));

class Toolbar extends _react.default.PureComponent {
  hasGridButtons() {
    return this.props.gridableColumn !== undefined && this.props.gridableColumn >= 0;
  }

  hasButtons() {
    return this.hasGridButtons() || this.props.hasSequenceButton || this.props.hasHistogramButton;
  }

  viewController() {
    if (this.hasGridButtons() || this.props.hasSequenceButton || this.props.hasHistogramButton) {
      return _react.default.createElement(_react.default.Fragment, null, _react.default.createElement("a", {
        role: "presentation",
        href: "#",
        className: "kui--table-navigatable kui--toolbar-button-with-icon kui--toolbar-button-as-list",
        "data-enabled": !this.props.asGrid && !this.props.asSequence && !this.props.asTimeline && !this.props.asHistogram,
        onClick: () => {
          this.props.setAsGrid(false);
          this.props.setAsSequence(false);
          this.props.setAsTimeline(false);
          this.props.setAsHistogram(false);
        }
      }, _react.default.createElement(_Icons.default, {
        icon: "List"
      })), this.hasGridButtons() && _react.default.createElement("a", {
        role: "presentation",
        href: "#",
        className: "kui--table-navigatable kui--toolbar-button-with-icon kui--toolbar-button-as-grid",
        "data-enabled": this.props.asGrid,
        onClick: () => {
          this.props.setAsSequence(false);
          this.props.setAsGrid(true);
          this.props.setAsTimeline(false);
        }
      }, _react.default.createElement(_Icons.default, {
        icon: "Grid"
      })), this.props.hasSequenceButton && _react.default.createElement("a", {
        role: "presentation",
        href: "#",
        className: "kui--table-navigatable kui--toolbar-button-with-icon kui--toolbar-button-as-sequence",
        "data-enabled": this.props.asSequence,
        onClick: () => {
          this.props.setAsGrid(false);
          this.props.setAsSequence(true);
          this.props.setAsTimeline(false);
        }
      }, _react.default.createElement(_Icons.default, {
        icon: "Sequence"
      })), this.props.hasHistogramButton && _react.default.createElement("a", {
        role: "presentation",
        href: "#",
        className: "kui--table-navigatable kui--toolbar-button-with-icon kui--toolbar-button-as-histogram",
        "data-enabled": this.props.asHistogram,
        onClick: () => {
          this.props.setAsGrid(false);
          this.props.setAsSequence(false);
          this.props.setAsHistogram(true);
          this.props.setAsTimeline(false);
        }
      }, _react.default.createElement(_Icons.default, {
        icon: "ChartBar"
      })), this.props.hasTimelineButton && _react.default.createElement("a", {
        role: "presentation",
        href: "#",
        className: "kui--table-navigatable kui--toolbar-button-with-icon kui--toolbar-button-as-timeline",
        "data-enabled": this.props.asTimeline,
        onClick: () => {
          this.props.setAsGrid(false);
          this.props.setAsSequence(false);
          this.props.setAsTimeline(true);
        }
      }, _react.default.createElement(_Icons.default, {
        icon: "ChartBar"
      })));
    }
  }

  previousPage() {
    this.props.setPage(this.props.page - 1);
  }

  nextPage() {
    this.props.setPage(this.props.page + 1);
  }

  paginationController() {
    if (this.props.paginate) {
      const start = (this.props.page - 1) * this.props.pageSize + 1;
      const end = this.props.page * this.props.pageSize;
      const isFirstPage = this.props.page === 1;
      const nPages = Math.ceil(this.props.totalItems / this.props.pageSize);
      const isLastPage = this.props.page === nPages;
      const maxLength = end.toString().length;
      const rangeText = `${start.toString().padStart(maxLength)} \u2014 ${end} of ${this.props.totalItems}`;
      return _react.default.createElement("div", {
        className: "kui--data-table-toolbar-pagination bx--pagination"
      }, _react.default.createElement("span", {
        className: "kui--data-table-toolbar-pagination-info"
      }, rangeText), _react.default.createElement("button", {
        type: "button",
        onMouseDown: evt => evt.preventDefault(),
        disabled: isFirstPage,
        className: 'bx--pagination__button bx--pagination__button--backward' + (isFirstPage ? ' bx--pagination__button--no-index' : ''),
        "aria-label": "Previous page",
        onClick: () => this.previousPage()
      }, _react.default.createElement(_Icons.default, {
        icon: "PreviousPage"
      })), _react.default.createElement("button", {
        type: "button",
        onMouseDown: evt => evt.preventDefault(),
        disabled: isLastPage,
        className: 'bx--pagination__button bx--pagination__button--forward' + (isLastPage ? ' bx--pagination__button--no-index' : ''),
        "aria-label": "Next page",
        onClick: () => this.nextPage()
      }, _react.default.createElement(_Icons.default, {
        icon: "NextPage"
      })));
    }
  }

  breadcrumbs() {
    if (this.props.breadcrumbs) {
      return _react.default.createElement(_Breadcrumb.default, {
        breadcrumbs: this.props.breadcrumbs,
        repl: this.props.repl
      });
    }
  }

  buttons() {
    if (this.hasButtons()) {
      return _react.default.createElement("div", {
        className: "kui--data-table-toolbar-buttons"
      }, this.viewController());
    }
  }
  /** so that buttons are flush-left and pagination is flush-right */


  filler() {
    return _react.default.createElement("div", {
      className: "kui--data-table-toolbar-filler"
    });
  }

  messageStream() {
    if (this.props.stream) {
      return this.props.stream.map((_, idx) => _react.default.createElement("div", {
        key: `${_}-${idx}`,
        className: "kui--data-table-footer-messages kui--inverted-color-context"
      }, _react.default.createElement("div", {
        className: "kui--data-table-footer-message"
      }, _react.default.createElement(Markdown, {
        source: _,
        noExternalLinks: true,
        repl: this.props.repl
      }))));
    }
  }

  caption() {
    return this.props.caption && _react.default.createElement("div", {
      className: "kui--table-caption flex-layout even-smaller-text sub-text"
    }, this.props.caption);
  }

  render() {
    const className = 'kui--data-table-toolbar' + (this.props.className ? ` ${this.props.className}` : '');
    return _react.default.createElement("div", {
      className: className,
      "data-frame": this.props.framed || undefined
    }, this.breadcrumbs(), this.buttons(), this.props.children, this.filler(), this.caption(), this.messageStream(), this.paginationController());
  }

}

exports.default = Toolbar;