"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _core = require("@kui-shell/core");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const Popover = _react.default.lazy(() => Promise.resolve().then(() => require('../../spi/Popover')));

class TextWithIconWidget extends _react.default.PureComponent {
  /** Render the content (excluding any popover/tooltip wrappers) part */
  content() {
    const iconClassName = 'kui--status-stripe-icon ' + (this.props.iconIsNarrow ? 'tiny-right-pad' : 'small-right-pad') + (this.props.iconOnclick ? ' clickable' : '');
    const iconPart = this.props.iconOnclick ? _react.default.createElement("a", {
      href: "#",
      className: iconClassName,
      onMouseDown: evt => evt.preventDefault(),
      onClick: !this.props.iconOnclick ? undefined : evt => {
        evt.stopPropagation();

        if (typeof this.props.iconOnclick === 'string') {
          (0, _core.pexecInCurrentTab)(this.props.iconOnclick);
        } else {
          this.props.iconOnclick();
        }
      }
    }, this.props.children) : _react.default.createElement("span", {
      className: iconClassName
    }, this.props.children);

    const textPart = _react.default.createElement("span", {
      className: "kui--status-stripe-text"
    }, this.props.text);

    return _react.default.createElement("div", {
      className: 'kui--status-stripe-element' + (this.props.textOnclick || this.props.popover ? ' kui--status-stripe-element-clickable' : '') + (!this.props.id ? '' : ' ' + this.props.id) + (this.props.className ? ' ' + this.props.className : ''),
      title: this.props.title,
      "data-view": this.props.viewLevel,
      onClick: !this.props.textOnclick ? undefined : () => {
        if (typeof this.props.textOnclick === 'string') {
          (0, _core.pexecInCurrentTab)(this.props.textOnclick);
        } else {
          this.props.textOnclick();
        }
      }
    }, iconPart, textPart);
  }

  render() {
    if (this.props.popover) {
      return _react.default.createElement(Popover, Object.assign({
        maxWidth: "40rem",
        minWidth: "5rem",
        position: "top",
        triggerClassName: "kui--status-stripe-element-wrapper"
      }, this.props.popover), this.content());
    } else {
      return this.content();
    }
  }

}

exports.default = TextWithIconWidget;