"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _2 = require("../../../");

var _core = require("@kui-shell/core");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

const strings = (0, _core.i18n)('plugin-client-common');

class CurrentWorkingDirectory extends _react.default.PureComponent {
  constructor(props) {
    super(props);
    this.handler = this.reportCurrentDirectory.bind(this);
    this.state = {
      text: '',
      viewLevel: (0, _core.inBrowser)() ? 'hidden' : 'normal'
    };
  }
  /**
   * Check the current working directory
   *
   */


  reportCurrentDirectory() {
    return __awaiter(this, void 0, void 0, function* () {
      const dir = (0, _core.cwd)();
      this.setState({
        text: dir ? dir === process.env.HOME ? dir : dir.replace(process.env.HOME, '~') : undefined,
        viewLevel: dir ? 'normal' : 'hidden'
      });
    });
  }
  /**
   * Once we have mounted, we immediately check the state,
   * and schedule an update based on standard REPL events.
   *
   */


  componentDidMount() {
    this.handler();
    (0, _core.wireToStandardEvents)(this.handler);
  }
  /** Make sure to unsubscribe! */


  componentWillUnmount() {
    (0, _core.unwireToStandardEvents)(this.handler);
  }

  render() {
    return _react.default.createElement(_2.TextWithIconWidget, {
      className: ['kui--half-popover-width', this.props.className].filter(_ => _).join(' '),
      text: this.state.text,
      viewLevel: this.state.viewLevel,
      id: "kui--plugin-client-common--current-working-directory",
      title: strings('Your current working directory'),
      textOnclick: "ls"
    }, _react.default.createElement(_2.Icons, {
      icon: "Location"
    }));
  }

}

exports.default = CurrentWorkingDirectory;