/*
 * Copyright 2019 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import { defaultFlags, doCreate, getter, doDelete, describer, registerConfig, registerEdit, registerApplySubcommands, doRun } from '@kui-shell/plugin-kubectl';
import { registerLogs, registerExec } from '@kui-shell/plugin-kubectl/logs';
const command = 'oc';
export default (registrar) => {
    registrar.listen(`/${command}/apply`, doCreate('apply', command), defaultFlags);
    registrar.listen(`/${command}/create`, doCreate('create', command), defaultFlags);
    registrar.listen(`/${command}/delete`, doDelete(command), defaultFlags);
    registrar.listen(`/${command}/run`, doRun(command), defaultFlags);
    getter(registrar, command);
    describer(registrar, command);
    registerConfig(registrar, command);
    registerEdit(registrar, command);
    registerApplySubcommands(registrar, command);
    registerExec(registrar, command);
    registerLogs(registrar, command);
};
//# sourceMappingURL=delegates.js.map