/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import * as assert from 'assert';
import { Common, CLI, ReplExpect, SidecarExpect, Selectors, Util, Keys } from '@kui-shell/test';
import { remotePodYaml, waitForGreen, createNS, allocateNS, deleteNS } from '@kui-shell/plugin-kubectl/tests/lib/k8s/utils';
import { mode as lastAppliedMode } from '../../lib/view/modes/last-applied';
const commands = ['kubectl'];
if (process.env.NEEDS_OC) {
    commands.push('oc');
}
const podName = 'nginx';
const sourceFile = remotePodYaml;
commands.forEach(command => {
    // FIXME: Mengting: apply in place can't give us the success toolbar message
    xdescribe(`${command} apply subcommands ${process.env.MOCHA_RUN_TARGET || ''}`, function () {
        before(Common.before(this));
        after(Common.after(this));
        const ns = createNS();
        const inNamespace = `-n ${ns}`;
        allocateNS(this, ns, command);
        const doCreate = (verb) => {
            it(`should ${verb === 'create' ? 'create' : 'update'} sample pod from URL via ${command} ${verb}`, () => __awaiter(this, void 0, void 0, function* () {
                try {
                    const selector = yield CLI.command(`${command} ${verb} -f ${sourceFile} ${inNamespace}`, this.app).then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME(podName) }));
                    // wait for the badge to become green
                    yield waitForGreen(this.app, selector);
                }
                catch (err) {
                    yield Common.oops(this, true)(err);
                }
            }));
        };
        const editLastApplied = (key, value, viaFile) => {
            it(`should edit last applied configuration via ${command} apply edit-last-applied ${viaFile && '-f'}`, () => CLI.command(`${command} apply edit-last-applied ${viaFile || `pod ${podName}`} ${inNamespace}`, this.app)
                .then(ReplExpect.ok)
                .then(SidecarExpect.open)
                .then(SidecarExpect.showing(podName, undefined, undefined, ns))
                .then(SidecarExpect.mode(lastAppliedMode))
                .then((res) => __awaiter(this, void 0, void 0, function* () {
                const actualText = yield Util.getValueFromMonaco(res);
                const labelsLineIdx = actualText.split(/\n/).indexOf('  labels:');
                // +2 here because nth-child is indexed from 1, and we want the line after that
                const lineSelector = `${Selectors.SIDECAR(res.count)} .view-lines > .view-line:nth-child(${labelsLineIdx +
                    2}) .mtk5:last-child`;
                yield this.app.client.$(lineSelector).then(_ => _.click());
                yield new Promise(resolve => setTimeout(resolve, 2000));
                yield this.app.client.keys(`${Keys.End}${Keys.ENTER}${key}: ${value}${Keys.ENTER}`);
                yield new Promise(resolve => setTimeout(resolve, 2000));
                console.error('1');
                yield this.app.client.$(Selectors.SIDECAR_MODE_BUTTON(res.count, 'Save')).then(_ => _.click());
                // FIXME: the apply in place can't give us 'Successfully Applied'
                yield SidecarExpect.toolbarAlert({ type: 'success', text: 'Successfully Applied', exact: false })(res);
                yield this.app.client
                    .$(Selectors.SIDECAR_MODE_BUTTON(res.count, 'Save'))
                    .then(_ => _.waitForDisplayed({ timeout: 10000, reverse: true }));
            }))
                .catch(Common.oops(this, true)));
        };
        // check that we can view this last applied configuration via "apply view-last-applied"
        const viewLastApplied = (expectString, viaFile) => {
            it(`view last applied configuration via ${command} apply view-last-applied ${viaFile && '-f'}`, () => CLI.command(`${command} apply view-last-applied ${viaFile || `pod ${podName}`} ${inNamespace}`, this.app)
                .then(ReplExpect.ok)
                .then(SidecarExpect.open)
                .then(SidecarExpect.showing(podName, undefined, undefined, ns))
                .then(SidecarExpect.mode(lastAppliedMode))
                .then((res) => __awaiter(this, void 0, void 0, function* () {
                const actualText = yield Util.getValueFromMonaco(res);
                assert.ok(actualText.indexOf(expectString) !== -1);
            }))
                .catch(Common.oops(this, true)));
        };
        /* Here comes the tests */
        doCreate('create');
        // no last applied configuration, yet
        it(`view last applied configuration and expect 404 via ${command}`, () => CLI.command(`${command} apply view-last-applied pod ${podName} ${inNamespace}`, this.app)
            .then(ReplExpect.error(404))
            .catch(Common.oops(this, true)));
        it(`should fail to set last applied configuration via ${command} apply set-last-applied`, () => CLI.command(`${command} apply set-last-applied pod ${podName} ${inNamespace} -f ${sourceFile}`, this.app)
            .then(ReplExpect.error(1))
            .catch(Common.oops(this, true)));
        it(`should succeed to set last applied configuration via ${command} apply set-last-applied --create-annotation`, () => CLI.command(`${command} apply set-last-applied pod ${podName} ${inNamespace} -f ${sourceFile} --create-annotation`, this.app)
            .then(ReplExpect.okWithPtyOutput('configured'))
            .catch(Common.oops(this, true)));
        editLastApplied('foo', 'bar');
        viewLastApplied('foo: bar', `-f ${sourceFile}`);
        editLastApplied('foo1', 'bar1', `-f ${sourceFile}`);
        viewLastApplied('foo1: bar1');
        deleteNS(this, ns, command);
    });
});
//# sourceMappingURL=apply-subcommands.js.map