import React from 'react';
import { ModeRegistration, ToolbarText } from '@kui-shell/core';
import { Terminal as XTerminal } from 'xterm';
import { KubeResource } from '../../model/resource';
import { ContainerProps, ContainerState, ContainerComponent, StreamingStatus } from './ContainerCommon';
import '../../../../web/scss/components/Terminal/Terminal.scss';
/** Cleanup function */
declare type Cleaner = () => void;
/** React state for the Terminal */
export interface TerminalState extends ContainerState {
    /** Are we streaming? */
    isLive: StreamingStatus;
    /** Has the PTY been terminated? */
    isTerminated: boolean;
    /** Have we received any data yet, from the PTY? */
    gotSomeData: boolean;
    /** Are we in the period between pty init and got-some-data before
     * we want to complain about not having any data? */
    waitingForHysteresis: boolean;
    dom: HTMLDivElement;
    xterm: XTerminal;
    doResize: () => void;
    perTerminalCleaners: Cleaner[];
}
export declare class Terminal<S extends TerminalState = TerminalState> extends ContainerComponent<S> {
    private readonly cleaners;
    /** After some period of receiving no data, auto-abort the PTY */
    private isIdle;
    private idleTimeout?;
    constructor(props: ContainerProps);
    /** Which container should we focus on by default? */
    protected defaultContainer(): string;
    /** Subclasses: override this! */
    protected mode(): string;
    private doXon;
    private doXoff;
    private doFocus;
    /**
     * Convert the current theme to an xterm.js ITheme
     *
     */
    private static injectTheme;
    private onWindowResize;
    private onTabLayoutChange;
    /** When we are going away, make sure to abort the streaming job. */
    componentWillUnmount(): void;
    private disposeTerminal;
    /** Finish up the initialization of the stream */
    componentDidUpdate(): void;
    private abortPriorJob;
    protected showContainer(container: string, extraState?: (curState: S) => Partial<S>): void;
    static getDerivedStateFromProps(props: ContainerProps, state: TerminalState): Partial<TerminalState>;
    protected toolbarText(status: StreamingStatus): ToolbarText;
    /** @return the command to issue in order to initialize the pty stream */
    protected ptyCommand(): {
        command: string;
        isLive?: 'Live' | 'Paused';
    };
    /** Write to the UI */
    protected write(line: string): void;
    /** Indicate that we have received some data */
    private gotSomeData;
    /** Tell the user whether or not we are preparing to idle the PTY */
    private indicate;
    private initiateIdleCountdown;
    private initiateIdleTimer;
    private _unmounted;
    private _initInProgressForContainer;
    private _initCount;
    /** Initialize a PTY stream from the current state's settings */
    private initStream;
    /** Are we focusing on all containers? */
    protected isAllContainers(): boolean;
    private static initTerminal;
    /** Should we wait a bit before proclaiming we have no data? */
    protected needsHysteresis(): boolean;
    /** Render in the case we have received no information from the PTY */
    protected nothingToShow(): React.ReactNode;
    /** If needsHysteresis(), and we haven't yet received any data, render as such */
    protected maybeNothingToShow(): React.ReactNode;
    /** Not ready to render? */
    protected notReady(): boolean;
    render(): JSX.Element;
}
/**
 * Add a Pods mode button to the given modes model, if called for by
 * the given resource.
 *
 */
export declare const terminalMode: ModeRegistration<KubeResource>;
export default terminalMode;
