/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import React from 'react';
import { DropDown, Icons } from '@kui-shell/plugin-client-common';
import { i18n } from '@kui-shell/core';
const strings = i18n('plugin-kubectl');
/**
 * We will wait this many milliseconds after the PTY is ready for log
 * data to arrive before proclaiming No log data.
 *
 */
export const HYSTERESIS = 1500;
export class ContainerComponent extends React.PureComponent {
    toolbarButtonsForError(status) {
        if (status === 'Stopped' || status === 'Error') {
            return [
                {
                    mode: 'retry-streaming',
                    label: strings('Retry'),
                    kind: 'view',
                    icon: React.createElement(Icons, { icon: "Retry", onClick: () => this.showContainer(this.state.container) }),
                    command: () => { } // eslint-disable-line @typescript-eslint/no-empty-function
                }
            ];
        }
        else {
            return [];
        }
    }
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    toolbarButtonsForStreaming(status) {
        return [];
    }
    /** Buttons to display in the Toolbar. */
    toolbarButtons(status) {
        return this.toolbarButtonsForError(status).concat(this.toolbarButtonsForStreaming(status), this.containerList());
    }
    supportsAllContainers() {
        return false;
    }
    /** When we are going away, make sure to abort the streaming job. */
    componentWillUnmount() {
        if (this.state.job) {
            this.state.job.abort();
        }
    }
    /** Update Toolbar text and Toolbar buttons. */
    updateToolbar(status) {
        this.props.toolbarController.willUpdateToolbar(this.toolbarText(status), this.toolbarButtons(status), true // replace default buttons
        );
    }
    showContainer(container) {
        this.setState({ container });
    }
    /** Render a selection component that allows user to select a container. */
    containerOptions() {
        const { containers = [] } = this.props.pod.spec;
        const actions = containers
            .map(_ => ({
            label: _.name,
            isSelected: this.state.container === _.name,
            hasDivider: false,
            handler: () => this.showContainer(_.name)
        }))
            .concat(!this.supportsAllContainers() || containers.length === 1
            ? []
            : [
                {
                    label: strings('All Containers'),
                    isSelected: this.isAllContainers(),
                    hasDivider: true,
                    handler: () => this.showContainer(undefined)
                }
            ]);
        return React.createElement(DropDown, { isPlain: true, actions: actions, className: "kui--repl-block-right-element" });
    }
    /** Are we focusing on all containers? */
    isAllContainers() {
        return !this.state.container;
    }
    /** List of containers that is compatible with toolbar buttons model */
    containerList() {
        return [
            {
                mode: 'container-list',
                label: 'Select a container',
                kind: 'view',
                command: () => { },
                icon: this.containerOptions()
            }
        ];
    }
}
//# sourceMappingURL=ContainerCommon.js.map