import { Arguments } from '@kui-shell/core';
import { KubeOptions } from '../../controller/kubectl/options';
/**
 * A major and minor version pair
 *
 */
export interface KubernetesVersion {
    major: number;
    minor: number;
}
/**
 * @return the { major, minor } of the Kubernetes server associated
 * with the context specified by the given command line `args`. If the
 * command line does not specify a context or kubeconfig, the default
 * association, of `kubectl` to a cluster, will be observed.
 *
 */
export default function kubeServerVersion(args: Arguments<KubeOptions>): Promise<KubernetesVersion>;
