/// <reference types="node" />
import { BodyData } from 'needle';
import { Arguments, ExecOptions, REPL } from '@kui-shell/core';
import { KubeOptions } from '../../controller/kubectl/options';
export interface ObjectStream<T extends object> {
    on(evt: 'data', cb: (obj: T) => void): any;
    on(evt: 'done', cb: () => void): any;
}
export declare function openStream<T extends object>(args: Pick<Arguments, 'REPL'>, url: string, mgmt: Pick<ExecOptions, 'onInit' | 'onReady' | 'onExit'>, headers?: Record<string, string>): Promise<void>;
interface FetchOptions<Data extends BodyData | BodyData[]> {
    returnErrors?: boolean;
    data?: Data;
    headers?: Record<string, string>;
    method?: 'get' | 'put' | 'post' | 'delete';
}
export declare function _needle(repl: REPL, url: string, opts?: FetchOptions<BodyData>, retryCount?: number): Promise<{
    statusCode: number;
    body: string | object;
}>;
export declare type ReturnedError = {
    code: number | string;
    error: string;
};
export declare type FetchedFile = string | Buffer | object | ReturnedError;
export declare function isReturnedError(file: FetchedFile): file is ReturnedError;
/**
 * Either fetch a remote file or read a local one
 *
 */
export declare function fetchFile(repl: REPL, url: string, opts?: FetchOptions<BodyData | BodyData[]>): Promise<FetchedFile[]>;
/** same as fetchFile, but returning a string rather than a Buffer */
export declare function fetchFileString(repl: REPL, url: string, headers?: Record<string, string>): Promise<(void | string)[]>;
export declare function fetchFileKustomize(repl: REPL, url: string): Promise<{
    data: string;
    dir?: string;
}>;
/**
 * fetch raw files from `filepath`
 */
export declare function fetchRawFiles(args: Arguments<KubeOptions>, filepath: string): Promise<string | object>;
export default fetchFileString;
export declare function fetchFilesVFS(args: Arguments<KubeOptions>, filepath: string, fetchNestedYamls?: boolean): Promise<{
    filepath: string;
    data: string;
}[]>;
export declare function fetchKusto(args: Arguments<KubeOptions>, kusto: string): Promise<{
    customization: {
        filepath: string;
        data: string;
        contentType: string;
        isFor: string;
    };
    templates: {
        filepath: string;
        data: string;
        contentType: string;
        isFor: string;
    }[];
}>;
