import { Arguments, ExecOptions, Registrar } from '@kui-shell/core';
import RawResponse from './response';
import { KubeOptions } from './options';
/** this is the subset of Arguments that we need */
declare type Args = Pick<Arguments<KubeOptions>, 'command' | 'argv' | 'parsedOptions' | 'execOptions'>;
export declare function doNativeExec(args: Args): Promise<RawResponse>;
/**
 * A convenience wrapper over `doNativeExec` that extracts only
 * stdout, and discards the exit code and stderr.
 *
 */
export declare function doExecRaw(command: string, parsedOptions: KubeOptions, execOptions: ExecOptions): Promise<string>;
declare const _default: (registrar: Registrar) => Promise<void>;
export default _default;
