import { KubeResource } from '../../lib/model/resource';
/**
 * A way to uniquely identify a resource in a cluster
 *
 */
export interface ResourceRef {
    group?: string;
    version?: string;
    kind: string;
    name: string;
    namespace: string;
}
/**
 * Extract the group and version from an `apiVersion` string
 *
 */
export declare function versionOf(apiVersion: string): {
    group: string;
    version: string;
};
/**
 * e.g. HorizontalPodAutoscaler.v1.autoscaling
 *      -> { kind: 'HorizontalPodAutoscaler', version: 'v1', group: 'autoscaling' }
 *
 */
export declare function split(fqn: string): Pick<Required<ResourceRef>, 'kind' | 'group' | 'version'>;
/**
 * format apiversion: `group`/`version` or `version`
 * e.g. v1 or apps/v1
 *
 */
export declare function apiVersionString(version: string, group: string): string;
export declare function kindPart(apiVersion: string, kind: string): string;
export declare function kindPartOf(resource: KubeResource): string;
export declare function kindAndNamespaceOf(resource: KubeResource): string;
export declare function fqn(apiVersion: string, kind: string, name: string, namespace: string): string;
export declare function fqnOf(resource: KubeResource): string;
export declare function fqnOfRef({ group, version, kind, name, namespace }: ResourceRef): string;
export default fqn;
