/*
 * Copyright 2018 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import Debug from 'debug';
import { openStream, fetchFile, fetchFileString } from '../lib/util/fetch-file';
const debug = Debug('plugin-kubectl/controller/fetch-file');
function isFile(filepath) {
    return __awaiter(this, void 0, void 0, function* () {
        const { lstat } = yield import('fs');
        return new Promise((resolve, reject) => {
            lstat(filepath, (err, stats) => {
                if (err) {
                    if (err.code === 'ENOENT') {
                        resolve(false);
                    }
                    else {
                        reject(err);
                    }
                }
                else {
                    resolve(stats.isFile());
                }
            });
        });
    });
}
function fetchKustomizeString(repl, uri) {
    return __awaiter(this, void 0, void 0, function* () {
        const [isFile0, { join }] = yield Promise.all([isFile(uri), import('path')]);
        if (isFile0) {
            return { data: yield fetchFileString(repl, uri)[0] };
        }
        else {
            const k1 = join(uri, 'kustomization.yml');
            const k2 = join(uri, 'kustomization.yaml');
            const k3 = join(uri, 'Kustomization');
            const [isFile1, isFile2, isFile3] = yield Promise.all([isFile(k1), isFile(k2), isFile(k3)]);
            const dir = uri; // if we are here, then `uri` is a directory
            if (isFile1) {
                return { data: (yield fetchFileString(repl, k1))[0] || '', dir };
            }
            else if (isFile2) {
                return { data: (yield fetchFileString(repl, k2))[0] || '', dir };
            }
            else if (isFile3) {
                return { data: (yield fetchFileString(repl, k3))[0] || '', dir };
            }
        }
    });
}
/**
 * A server-side shim to allow browser-based clients to fetch `-f`
 * file content.
 *
 */
export default (registrar) => {
    registrar.listen(`/_openstream`, (args) => __awaiter(void 0, void 0, void 0, function* () {
        const uri = args.argvNoOptions[args.argvNoOptions.indexOf('_openstream') + 1];
        const headers = typeof args.execOptions.data === 'object' && !Buffer.isBuffer(args.execOptions.data)
            ? args.execOptions.data.headers
            : undefined;
        debug('openstream', uri);
        if (!args.execOptions.onInit) {
            throw new Error('Internal Error: onInit required');
        }
        // eslint-disable-next-line no-async-promise-executor
        return new Promise((resolve, reject) => __awaiter(void 0, void 0, void 0, function* () {
            try {
                yield openStream(args, uri, {
                    onInit: args.execOptions.onInit,
                    onReady: args.execOptions.onReady,
                    onExit: exitCode => {
                        debug('got exit from stream', exitCode);
                        if (args.execOptions.onExit) {
                            args.execOptions.onExit(exitCode);
                        }
                        resolve(true);
                    }
                }, headers);
            }
            catch (err) {
                reject(err);
            }
        }));
    }), { requiresLocal: true });
    registrar.listen(`/_fetchfile`, ({ argvNoOptions, parsedOptions, REPL, execOptions }) => __awaiter(void 0, void 0, void 0, function* () {
        const uri = argvNoOptions[argvNoOptions.indexOf('_fetchfile') + 1];
        const opts = typeof execOptions.data === 'object' && !Buffer.isBuffer(execOptions.data) ? execOptions.data : undefined;
        if (!parsedOptions.kustomize) {
            return { mode: 'raw', content: yield fetchFile(REPL, uri, opts) };
        }
        else {
            return { mode: 'raw', content: yield fetchKustomizeString(REPL, uri) };
        }
    }), { requiresLocal: true, flags: { boolean: ['kustomize'] } });
};
//# sourceMappingURL=fetch-file.js.map