/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import TrafficLight, { toTrafficLight } from '../../../lib/model/traffic-light';
/** Do not i18n! */
export const Kind = 'Kind';
export const Status = 'Status';
export const standardStatusHeader = {
    name: 'Name',
    attributes: [
        {
            key: Kind,
            value: Kind
        },
        {
            key: Status,
            value: Status
        }
    ]
};
export function rowWith(name, kind, status, trafficLight, originalRow, extraAttrs = []) {
    const overlay = {
        name,
        attributes: extraAttrs.concat([
            {
                key: Kind,
                value: kind
            },
            {
                key: Status,
                value: status,
                tag: 'badge',
                css: trafficLight
            }
        ])
    };
    if (originalRow) {
        return Object.assign({}, originalRow, overlay);
    }
    else {
        return overlay;
    }
}
// eslint-disable-next-line @typescript-eslint/no-unused-vars
export function unifyHeaders(headers) {
    return standardStatusHeader;
}
function getFromLabel(object, field) {
    return object.metadata && object.metadata.labels ? object.metadata.labels[field] : undefined;
}
function getFromSelector(object, field) {
    if (object.spec && object.spec.selector && object.spec.selector.matchLabels) {
        return object.spec.selector.matchLabels[field];
    }
}
export function unifyRow(row, kind) {
    const name = row.name;
    const badgeColumnIdx = row.attributes.findIndex(_ => _.tag === 'badge');
    const status = badgeColumnIdx >= 0 ? row.attributes[badgeColumnIdx].value : 'Unknown';
    const trafficLight = badgeColumnIdx >= 0 ? toTrafficLight(row.attributes[badgeColumnIdx].css) : TrafficLight.Gray;
    const extraAttrs = [];
    const tier = row.object
        ? getFromLabel(row.object, 'tier') ||
            getFromLabel(row.object, 'app.kubernetes.io/component') ||
            getFromSelector(row.object, 'tier')
        : '';
    extraAttrs.push({ key: 'Tier', value: tier });
    const app = row.object
        ? getFromLabel(row.object, 'app') ||
            getFromLabel(row.object, 'app.kubernetes.io/name') ||
            getFromSelector(row.object, 'app')
        : '';
    extraAttrs.push({ key: 'Application', value: app });
    return rowWith(name, kind, status, trafficLight, row, extraAttrs);
}
export function unifyRows(rows, kinds) {
    return rows.map((row, idx) => {
        const kind = Array.isArray(kinds) ? kinds[idx] : kinds;
        return unifyRow(row, kind);
    });
}
export function unifyTable(table, kind) {
    const overlay = {
        header: unifyHeaders([table.header]),
        body: unifyRows(table.body, kind)
    };
    return Object.assign({}, table, overlay);
}
//# sourceMappingURL=unify.js.map