/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { CLI, Common, ReplExpect, Selectors, SidecarExpect, Util } from '@kui-shell/test';
import { defaultModeForGet, openSidecarByList, waitForGreen } from '@kui-shell/plugin-kubectl/tests/lib/k8s/utils';
export let res;
export function create(ns, command, inputEncoded, podName) {
    it(`should create sample pod from URL`, () => {
        return CLI.command(`echo ${inputEncoded} | base64 --decode | ${command} create -f - -n ${ns}`, this.app)
            .then(ReplExpect.okWithPtyOutput(podName))
            .catch(Common.oops(this, true));
    });
}
export function wait(ns, command, podName, splitIndex) {
    if (process.env.USE_WATCH_PANE) {
        it(`should wait for the pod to come up`, () => __awaiter(this, void 0, void 0, function* () {
            try {
                res = yield CLI.command(`${command} get pod ${podName} -n ${ns} -w`, this.app);
                yield this.app.client
                    .$(Selectors.CURRENT_GRID_ONLINE_FOR_SPLIT(splitIndex, podName))
                    .then(_ => _.waitForExist());
            }
            catch (err) {
                yield Common.oops(this, true)(err);
            }
        }));
    }
    else {
        it(`should wait for the pod to come up`, () => {
            return CLI.command(`${command} get pod ${podName} -n ${ns} -w`, this.app)
                .then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME(podName) }))
                .then(selector => waitForGreen(this.app, selector))
                .catch(Common.oops(this, true));
        });
    }
}
export function get(ns, command, podName, wait = true) {
    it(`should get pod ${podName} via ${command} then click`, () => __awaiter(this, void 0, void 0, function* () {
        try {
            yield openSidecarByList(this, `${command} get pods ${podName} -n ${ns}`, podName, wait, defaultModeForGet);
        }
        catch (err) {
            return Common.oops(this, true)(err);
        }
    }));
}
export function clickRetry(res) {
    return __awaiter(this, void 0, void 0, function* () {
        yield Util.clickSidecarModeButton(this, res, 'retry-streaming');
    });
}
function waitUntilPreviousIs(type, previous, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const click = clickRetry.bind(this);
        yield new Promise(resolve => setTimeout(resolve, 2000));
        yield this.app.client.waitUntil(() => __awaiter(this, void 0, void 0, function* () {
            if (!(yield this.app.client.$(Selectors.SIDECAR_TOOLBAR_TEXT(res.count, type)).then(_ => _.isExisting()))) {
                yield new Promise(resolve => setTimeout(resolve, 2000));
                yield click(res);
                yield new Promise(resolve => setTimeout(resolve, 2000));
                return false;
            }
            else {
                return true;
            }
        }));
        yield SidecarExpect.toolbarText({ type, text: previous ? 'previous instance' : '' })(res);
    });
}
export function logs(ns, command, podName, containerName, type, previous) {
    const wait = waitUntilPreviousIs.bind(this, type, previous);
    it(`should get logs for ${podName} with previous=${previous} via command`, () => __awaiter(this, void 0, void 0, function* () {
        try {
            res = yield CLI.command(`${command} logs ${podName} -c ${containerName} -n ${ns} ${previous ? '--previous' : ''}`, this.app)
                .then(ReplExpect.ok)
                .then(SidecarExpect.open)
                .then(SidecarExpect.showing(podName, undefined, undefined, ns))
                .then(SidecarExpect.mode('logs'));
            yield wait(res);
        }
        catch (err) {
            yield Common.oops(this, true);
        }
    }));
}
export function clickPrevious(type, previous) {
    const wait = waitUntilPreviousIs.bind(this, type, previous);
    it(`should click the previous toggle button and expect previous=${previous}`, () => __awaiter(this, void 0, void 0, function* () {
        const mode = 'kubectl-logs-previous-toggle';
        yield Util.clickSidecarModeButton(this, res, mode);
        yield wait(res);
    }));
}
//# sourceMappingURL=helpers.js.map