"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.matchInternalRegex = matchInternalRegex;
exports.default = void 0;

var _ibm = _interopRequireDefault(require("./ibm"));

var _kube = _interopRequireDefault(require("./kube"));

var _istio = _interopRequireDefault(require("./istio"));

var _calico = _interopRequireDefault(require("./calico"));

var _knative = _interopRequireDefault(require("./knative"));

var _openshift = _interopRequireDefault(require("./openshift"));

var _operators = _interopRequireDefault(require("./operators"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2021 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * This heuristic exports a map from Namespace-as-string to `true`
 * that indicates whether the given-named namespace is a
 * system/internal namespace.
 *
 * To extend, either add a new namespace name to one of the existing
 * files, or create a new file and add it to the `isInternal` array below
 *
 */

/** Make sure to add any new files to this array */
const isInternal = [..._ibm.default, ..._kube.default, ..._istio.default, ..._calico.default, ..._knative.default, ..._openshift.default, ..._operators.default];
/** Format a regex string from the internal namespaces list e.g. /(kube-node-lease|kube-public)/ */

const internalRegex = new RegExp(isInternal.reduce((regex, str, idx, array) => {
  if (idx === 0) {
    regex = `(${str}`;
  } else {
    regex = `${regex}|${str}`;
  }

  if (idx === array.length - 1) {
    regex += ')';
  }

  return regex;
}, ''));

function matchInternalRegex(ns) {
  return internalRegex.test(ns);
}

var _default = matchInternalRegex;
exports.default = _default;