"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.selectorToString = void 0;

var _debug = _interopRequireDefault(require("debug"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2019 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const debug = (0, _debug.default)('k8s/view/util/selectors');

const selectorToString = selector => {
  if (selector.matchLabels) {
    return selectorToString(selector.matchLabels);
  } else if (selector.matchExpressions) {
    // TODO
    return '';
  }

  const stringified = Object.keys(selector).map(key => `-l ${key}=${selector[key]}`).join(' ');
  debug('selectorToString', stringified, selector);
  return stringified;
};

exports.selectorToString = selectorToString;