import React from 'react';
import { ViewLevel } from '@kui-shell/plugin-client-common';
interface Props {
    className?: string;
}
interface State {
    currentNamespace: string;
    allNamespaces: string[];
    viewLevel: ViewLevel;
}
export default class CurrentNamespace extends React.PureComponent<Props, State> {
    private readonly handler;
    private readonly handlerNotCallingKubectl;
    constructor(props: Props);
    /** @return a short string that we can fit into a context UI widget */
    private renderNamespace;
    /** Avoid recomputation for a flurry of events */
    private last;
    private debounce;
    private reportCurrentNamespace;
    private getCurrentNamespaceFromTab;
    /**
     * Once we have mounted, we immediately check the current branch,
     * and schedule an update based on standard REPL events.
     *
     */
    componentDidMount(): void;
    /** Bye! */
    componentWillUnmount(): void;
    private listNamespace;
    private popoverHeader;
    private switchNamespaceDescription;
    /** @return the options model for the given namespace named `ns` */
    private optionFor;
    private switchNamespace;
    private popoverBody;
    private popover;
    render(): JSX.Element;
}
export {};
