# Change Log

All notable changes to this project will be documented in this file.
See [Conventional Commits](https://conventionalcommits.org) for commit guidelines.

## [10.3.27](https://github.com/IBM/kui/compare/v10.3.26...v10.3.27) (2021-06-30)

### Bug Fixes

- **plugins/plugin-kubectl:** kubectl watchers stop receiving push notifications when context is changed ([e487170](https://github.com/IBM/kui/commit/e487170))

## [10.3.26](https://github.com/IBM/kui/compare/v10.3.25...v10.3.26) (2021-06-29)

### Bug Fixes

- **plugins/plugin-kubectl:** CurrentContext does not respond to new contexts ([ca869a1](https://github.com/IBM/kui/commit/ca869a1)), closes [#7741](https://github.com/IBM/kui/issues/7741)
- **plugins/plugin-kubectl:** oc login does not switch kube proxy in browser clients ([f63d734](https://github.com/IBM/kui/commit/f63d734)), closes [#7742](https://github.com/IBM/kui/issues/7742)

## [10.3.25](https://github.com/IBM/kui/compare/v10.3.24...v10.3.25) (2021-06-29)

### Bug Fixes

- **plugins/plugin-kubectl:** in browser clients, switching kui tabs can yield stale kube responses ([585504d](https://github.com/IBM/kui/commit/585504d)), closes [#7737](https://github.com/IBM/kui/issues/7737)
- **plugins/plugin-kubectl:** kubectl direct get may pass through kubeproxy 404s to user ([be1046b](https://github.com/IBM/kui/commit/be1046b)), closes [#7731](https://github.com/IBM/kui/issues/7731)

## [10.3.24](https://github.com/IBM/kui/compare/v10.3.23...v10.3.24) (2021-06-24)

**Note:** Version bump only for package @kui-shell/plugin-kubectl

## [10.3.23](https://github.com/IBM/kui/compare/v10.3.22...v10.3.23) (2021-06-18)

### Bug Fixes

- **plugins/plugin-kubectl:** in browser clients, CurrentContext/Namespace widgets may get stuck ([eb389b4](https://github.com/IBM/kui/commit/eb389b4)), closes [#7656](https://github.com/IBM/kui/issues/7656)

## [10.3.22](https://github.com/IBM/kui/compare/v10.3.21...v10.3.22) (2021-06-15)

### Bug Fixes

- **plugins/plugin-kubectl:** CurrentContext/CurrentNamespace widgets show nothing while loading ([3453fb2](https://github.com/IBM/kui/commit/3453fb2)), closes [#7629](https://github.com/IBM/kui/issues/7629)

## [10.3.21](https://github.com/IBM/kui/compare/v10.3.20...v10.3.21) (2021-06-14)

### Bug Fixes

- CurrentContext and CurrentNamespace widgets double-fetch onLoad ([39ba4db](https://github.com/IBM/kui/commit/39ba4db)), closes [#7624](https://github.com/IBM/kui/issues/7624)

## [10.3.20](https://github.com/IBM/kui/compare/v10.3.19...v10.3.20) (2021-06-10)

**Note:** Version bump only for package @kui-shell/plugin-kubectl

## [10.3.19](https://github.com/IBM/kui/compare/v10.3.18...v10.3.19) (2021-06-10)

**Note:** Version bump only for package @kui-shell/plugin-kubectl

## [10.3.18](https://github.com/IBM/kui/compare/v10.3.17...v10.3.18) (2021-06-08)

### Bug Fixes

- sidecar toolbar buttons use different tooltip style than split close/clear buttons ([ef90713](https://github.com/IBM/kui/commit/ef90713)), closes [#7568](https://github.com/IBM/kui/issues/7568)

## [10.3.17](https://github.com/IBM/kui/compare/v10.3.16...v10.3.17) (2021-06-07)

**Note:** Version bump only for package @kui-shell/plugin-kubectl

## [10.3.16](https://github.com/IBM/kui/compare/v10.3.15...v10.3.16) (2021-06-07)

**Note:** Version bump only for package @kui-shell/plugin-kubectl

## [10.3.15](https://github.com/IBM/kui/compare/v10.3.14...v10.3.15) (2021-06-04)

**Note:** Version bump only for package @kui-shell/plugin-kubectl

## [10.3.14](https://github.com/IBM/kui/compare/v10.3.13...v10.3.14) (2021-06-04)

**Note:** Version bump only for package @kui-shell/plugin-kubectl

## [10.3.13](https://github.com/IBM/kui/compare/v10.3.12...v10.3.13) (2021-06-02)

**Note:** Version bump only for package @kui-shell/plugin-kubectl

## [10.3.12](https://github.com/IBM/kui/compare/v10.3.11...v10.3.12) (2021-06-01)

**Note:** Version bump only for package @kui-shell/plugin-kubectl

## [10.3.11](https://github.com/IBM/kui/compare/v10.3.10...v10.3.11) (2021-06-01)

**Note:** Version bump only for package @kui-shell/plugin-kubectl

## [10.3.10](https://github.com/IBM/kui/compare/v10.3.9...v10.3.10) (2021-06-01)

**Note:** Version bump only for package @kui-shell/plugin-kubectl

## [10.3.9](https://github.com/IBM/kui/compare/v10.3.8...v10.3.9) (2021-06-01)

**Note:** Version bump only for package @kui-shell/plugin-kubectl

## [10.3.8](https://github.com/IBM/kui/compare/v10.3.7...v10.3.8) (2021-06-01)

**Note:** Version bump only for package @kui-shell/plugin-kubectl

## [10.3.7](https://github.com/IBM/kui/compare/v10.3.6...v10.3.7) (2021-06-01)

**Note:** Version bump only for package @kui-shell/plugin-kubectl

## [10.3.6](https://github.com/IBM/kui/compare/v10.3.5...v10.3.6) (2021-05-28)

### Bug Fixes

- **plugins/plugin-kubectl:** getDirect try/catch does not handle errors with no code ([27a6fe0](https://github.com/IBM/kui/commit/27a6fe0)), closes [#7239](https://github.com/IBM/kui/issues/7239)
- PTY jobs are not resizable ([b4c9cbc](https://github.com/IBM/kui/commit/b4c9cbc)), closes [#7473](https://github.com/IBM/kui/issues/7473)
- **plugins/plugin-kubectl:** tab-state transition optimization ([d13f1cf](https://github.com/IBM/kui/commit/d13f1cf))

### Features

- **plugins/plugin-kubectl:** Provide search capability on pod details Logs tab ([9b15a23](https://github.com/IBM/kui/commit/9b15a23)), closes [#5570](https://github.com/IBM/kui/issues/5570)

## [10.3.5](https://github.com/IBM/kui/compare/v10.3.4...v10.3.5) (2021-05-27)

**Note:** Version bump only for package @kui-shell/plugin-kubectl

## [10.3.4](https://github.com/IBM/kui/compare/v10.3.3...v10.3.4) (2021-05-24)

### Bug Fixes

- **plugins/plugin-kubectl:** kubectl create --dry-run | kubectl apply -f - does not work ([2eeabf7](https://github.com/IBM/kui/commit/2eeabf7)), closes [#7443](https://github.com/IBM/kui/issues/7443)
- **plugins/plugin-kubectl:** plugin-kubectl should expose Secret type ([23f2dee](https://github.com/IBM/kui/commit/23f2dee)), closes [#7441](https://github.com/IBM/kui/issues/7441)

## [10.3.3](https://github.com/IBM/kui/compare/v10.3.2...v10.3.3) (2021-05-22)

### Bug Fixes

- **plugins/plugin-kubectl:** tab state manager shoud not log "command not found" errors for systems without kubectl ([603da4f](https://github.com/IBM/kui/commit/603da4f))

## [10.3.2](https://github.com/IBM/kui/compare/v10.3.1...v10.3.2) (2021-05-20)

### Bug Fixes

- **plugins/plugin-kubectl:** --kubeconfig path in commands are not always expanded ([79e9594](https://github.com/IBM/kui/commit/79e9594))
- **plugins/plugin-kubectl:** "get ingress" failed with resource type not found ([1d3c1da](https://github.com/IBM/kui/commit/1d3c1da))
- **plugins/plugin-kubectl:** direct get fails when user specifies fully/partially qualified name of a crd ([e4357ad](https://github.com/IBM/kui/commit/e4357ad))
- **plugins/plugin-kubectl:** regular namespace list includes a number of openshift namespaces ([49d17e0](https://github.com/IBM/kui/commit/49d17e0))

## [10.3.1](https://github.com/IBM/kui/compare/v10.3.0...v10.3.1) (2021-05-18)

### Bug Fixes

- **plugins/plugin-kubectl:** redirection of output on a get resource command is ignored ([976027b](https://github.com/IBM/kui/commit/976027b))

### Features

- **plugins/plugin-kubectl:** allow for pinning a Kubernetes Context or Namespace to a tab ([91507c5](https://github.com/IBM/kui/commit/91507c5))

# [10.3.0](https://github.com/IBM/kui/compare/v4.5.0...v10.3.0) (2021-05-11)

### Bug Fixes

- invoking a non-popup window from headless kui will have incorrect uuid for splits ([f068b39](https://github.com/IBM/kui/commit/f068b39))
- kubectl direct/get does not specify that get tables have the `onclickIdempotent` property ([31361ec](https://github.com/IBM/kui/commit/31361ec)), closes [#6778](https://github.com/IBM/kui/issues/6778)
- remove kubeui command prefix ([e2539cb](https://github.com/IBM/kui/commit/e2539cb)), closes [#7314](https://github.com/IBM/kui/issues/7314)
- **plugins/plugin-client-common:** clicking the split button may cause the current processing block to disappear ([aa2b40c](https://github.com/IBM/kui/commit/aa2b40c)), closes [#5703](https://github.com/IBM/kui/issues/5703)
- **plugins/plugin-client-common:** don't offer Grid option for 1-row tables ([a2a6f8d](https://github.com/IBM/kui/commit/a2a6f8d)), closes [#5474](https://github.com/IBM/kui/issues/5474)
- **plugins/plugin-client-common:** improve display of empty watch tables ([4cc16be](https://github.com/IBM/kui/commit/4cc16be)), closes [#5176](https://github.com/IBM/kui/issues/5176)
- **plugins/plugin-client-common:** onclick handlers for ls should respond only to clicking on text ([8477386](https://github.com/IBM/kui/commit/8477386)), closes [#6567](https://github.com/IBM/kui/issues/6567)
- **plugins/plugin-client-common:** show table click result in a new split ([fd1b3a1](https://github.com/IBM/kui/commit/fd1b3a1)), closes [#6477](https://github.com/IBM/kui/issues/6477)
- **plugins/plugin-client-common:** Table onclick handlers applied to every cell ([d5a9c3a](https://github.com/IBM/kui/commit/d5a9c3a)), closes [#6792](https://github.com/IBM/kui/issues/6792)
- **plugins/plugin-kubectl:** `k get all` with direct/get doesn't fail back to the old impl of get ([bdc3446](https://github.com/IBM/kui/commit/bdc3446)), closes [#6643](https://github.com/IBM/kui/issues/6643)
- **plugins/plugin-kubectl:** `k get all` with direct/get doesn't fail back to the old impl of get ([a2c0c2b](https://github.com/IBM/kui/commit/a2c0c2b)), closes [#6643](https://github.com/IBM/kui/issues/6643)
- **plugins/plugin-kubectl:** `oc login` does not invalidate the kubectl proxy ([3105e9a](https://github.com/IBM/kui/commit/3105e9a)), closes [#6955](https://github.com/IBM/kui/issues/6955)
- **plugins/plugin-kubectl:** allow clients to define a default kubectl CLI ([1c8341d](https://github.com/IBM/kui/commit/1c8341d)), closes [#7051](https://github.com/IBM/kui/issues/7051)
- **plugins/plugin-kubectl:** avoid loading view-utilization plugin in headless mode ([8cc760a](https://github.com/IBM/kui/commit/8cc760a))
- **plugins/plugin-kubectl:** CLI-based kubectl watcher does not restart in the case of preamture exit of the pty process ([32b0386](https://github.com/IBM/kui/commit/32b0386)), closes [#7105](https://github.com/IBM/kui/issues/7105)
- **plugins/plugin-kubectl:** clicking a namespace row will issue command with --ns undefined ([7b33c3d](https://github.com/IBM/kui/commit/7b33c3d)), closes [#7149](https://github.com/IBM/kui/issues/7149)
- **plugins/plugin-kubectl:** client can't modify the styles of CurrentNamespace and CurrentContext widget via classname ([4a1c145](https://github.com/IBM/kui/commit/4a1c145))
- **plugins/plugin-kubectl:** direct operations fail if err.message is not JSON ([c5dc825](https://github.com/IBM/kui/commit/c5dc825)), closes [#6653](https://github.com/IBM/kui/issues/6653)
- **plugins/plugin-kubectl:** direct tables in splits are not hiding columns correctly ([5cc6cfc](https://github.com/IBM/kui/commit/5cc6cfc)), closes [#6484](https://github.com/IBM/kui/issues/6484)
- **plugins/plugin-kubectl:** direct watcher improperly formats event url ([d9717ff](https://github.com/IBM/kui/commit/d9717ff)), closes [#6593](https://github.com/IBM/kui/issues/6593)
- **plugins/plugin-kubectl:** direct/watch may update rows in a wrong order ([c0e5e17](https://github.com/IBM/kui/commit/c0e5e17)), closes [#6642](https://github.com/IBM/kui/issues/6642)
- **plugins/plugin-kubectl:** don't retry file fetches so many times in headless mode ([ab23935](https://github.com/IBM/kui/commit/ab23935))
- **plugins/plugin-kubectl:** event watcher doesn't render well in minisplit ([56176de](https://github.com/IBM/kui/commit/56176de)), closes [#6772](https://github.com/IBM/kui/issues/6772)
- **plugins/plugin-kubectl:** events watching returns an empty table with just a streaming events footer ([fbeae76](https://github.com/IBM/kui/commit/fbeae76)), closes [#2771](https://github.com/IBM/kui/issues/2771)
- **plugins/plugin-kubectl:** fetchFileString aggressively calls toString on all objects ([027b279](https://github.com/IBM/kui/commit/027b279)), closes [#6941](https://github.com/IBM/kui/issues/6941)
- **plugins/plugin-kubectl:** get without kind doesn't fail back to the old get impl ([e85af25](https://github.com/IBM/kui/commit/e85af25)), closes [#6719](https://github.com/IBM/kui/issues/6719)
- **plugins/plugin-kubectl:** get-direct does not support field-selectors ([85b849c](https://github.com/IBM/kui/commit/85b849c)), closes [#6473](https://github.com/IBM/kui/issues/6473)
- **plugins/plugin-kubectl:** get-watch doesn't update the watcher status when limit is reached ([9c58a1c](https://github.com/IBM/kui/commit/9c58a1c)), closes [#7107](https://github.com/IBM/kui/issues/7107)
- **plugins/plugin-kubectl:** heterogeneous apply tables lack a breadcrumb ([ee0bd2b](https://github.com/IBM/kui/commit/ee0bd2b)), closes [#6512](https://github.com/IBM/kui/issues/6512)
- **plugins/plugin-kubectl:** heterogeneous get unifies table incorrectly when some resources have label ([a5dab2e](https://github.com/IBM/kui/commit/a5dab2e)), closes [#6672](https://github.com/IBM/kui/issues/6672) [#6676](https://github.com/IBM/kui/issues/6676)
- **plugins/plugin-kubectl:** improve cpu consumption of CLI-based watching ([afd0890](https://github.com/IBM/kui/commit/afd0890)), closes [#7135](https://github.com/IBM/kui/issues/7135) [#7135](https://github.com/IBM/kui/issues/7135)
- **plugins/plugin-kubectl:** k api-resources | grep events has odd error message ([338ae2f](https://github.com/IBM/kui/commit/338ae2f)), closes [#6838](https://github.com/IBM/kui/issues/6838)
- **plugins/plugin-kubectl:** k get resourcequota fails badly if your cluster has no quotas ([2259a48](https://github.com/IBM/kui/commit/2259a48)), closes [#7143](https://github.com/IBM/kui/issues/7143)
- **plugins/plugin-kubectl:** k logs has bad error message ([d1afe30](https://github.com/IBM/kui/commit/d1afe30)), closes [#6740](https://github.com/IBM/kui/issues/6740)
- **plugins/plugin-kubectl:** kubectl CLI invocations should retry on TLS handshake timeout? ([884f9a9](https://github.com/IBM/kui/commit/884f9a9)), closes [#7141](https://github.com/IBM/kui/issues/7141)
- **plugins/plugin-kubectl:** kubectl direct status watcher can get stuck ([2346ce2](https://github.com/IBM/kui/commit/2346ce2)), closes [#6514](https://github.com/IBM/kui/issues/6514)
- **plugins/plugin-kubectl:** kubectl get events -o wide shows incorrect Last Seen column ([b24990b](https://github.com/IBM/kui/commit/b24990b)), closes [#6796](https://github.com/IBM/kui/issues/6796)
- **plugins/plugin-kubectl:** kubectl get-all-namespaces test is unreliable ([a0e44a3](https://github.com/IBM/kui/commit/a0e44a3)), closes [#6561](https://github.com/IBM/kui/issues/6561)
- **plugins/plugin-kubectl:** kubectl logs command does not support drilldowns ([2c0d466](https://github.com/IBM/kui/commit/2c0d466)), closes [#7187](https://github.com/IBM/kui/issues/7187)
- **plugins/plugin-kubectl:** kubectl sourceRef fetching is expensive ([f6539c5](https://github.com/IBM/kui/commit/f6539c5)), closes [#6662](https://github.com/IBM/kui/issues/6662)
- **plugins/plugin-kubectl:** lazily load jsonpath npm ([f8e9100](https://github.com/IBM/kui/commit/f8e9100))
- `kubectl create ns 1` fails with status/direct ([e3d4a9c](https://github.com/IBM/kui/commit/e3d4a9c)), closes [#7016](https://github.com/IBM/kui/issues/7016)
- kui fails to show numeric namespace for kubectl config commands ([f424b5e](https://github.com/IBM/kui/commit/f424b5e)), closes [#7032](https://github.com/IBM/kui/issues/7032)
- kui may try to open files of unbounded size in monaco-editor ([00197a5](https://github.com/IBM/kui/commit/00197a5)), closes [#7091](https://github.com/IBM/kui/issues/7091)
- LivePaginatedTable may drop updates ([4f8f510](https://github.com/IBM/kui/commit/4f8f510)), closes [#7137](https://github.com/IBM/kui/issues/7137)
- LivePaginatedTable.setBody can be very slow ([82acb4f](https://github.com/IBM/kui/commit/82acb4f)), closes [#7191](https://github.com/IBM/kui/issues/7191)
- **plugins/plugin-kubectl:** kubectl Logs tab does not handle Idle state ([ec3e216](https://github.com/IBM/kui/commit/ec3e216)), closes [#7103](https://github.com/IBM/kui/issues/7103)
- **plugins/plugin-kubectl:** kubectl watch commands that are sent to the CLI don't watch ([d4ea65b](https://github.com/IBM/kui/commit/d4ea65b)), closes [#7025](https://github.com/IBM/kui/issues/7025)
- **plugins/plugin-kubectl:** kubernetes test input pod.yaml has a container named "name" ([6ac5210](https://github.com/IBM/kui/commit/6ac5210)), closes [#6907](https://github.com/IBM/kui/issues/6907)
- **plugins/plugin-kubectl:** Kui fetches wrong content when command line specifies --context or --kubeconfig ([7d7d273](https://github.com/IBM/kui/commit/7d7d273)), closes [#7023](https://github.com/IBM/kui/issues/7023)
- **plugins/plugin-kubectl:** Kui should fall back to Kubectl CLI when kubernetes direct accesss fails ([82d842f](https://github.com/IBM/kui/commit/82d842f)), closes [#7050](https://github.com/IBM/kui/issues/7050)
- **plugins/plugin-kubectl:** make sure to pick the last specified label selector ([7d44bcb](https://github.com/IBM/kui/commit/7d44bcb)), closes [#6840](https://github.com/IBM/kui/issues/6840)
- **plugins/plugin-kubectl:** multikind table isn't unified correctly when some rows are offline ([dd02cde](https://github.com/IBM/kui/commit/dd02cde)), closes [#6865](https://github.com/IBM/kui/issues/6865)
- **plugins/plugin-kubectl:** Remove unused css from plugin-kubectl ([4d65051](https://github.com/IBM/kui/commit/4d65051)), closes [#6902](https://github.com/IBM/kui/issues/6902)
- **plugins/plugin-kubectl:** replace Sidecar Events Mode with a toolbar button to show events table in REPL ([ccc47d0](https://github.com/IBM/kui/commit/ccc47d0)), closes [#6847](https://github.com/IBM/kui/issues/6847)
- **plugins/plugin-kubectl:** show SourceRef when creating heterogeneous resources ([adb21c5](https://github.com/IBM/kui/commit/adb21c5)), closes [#6640](https://github.com/IBM/kui/issues/6640)
- kubectl direct streaming fails to register a stream.on('error') ([fd9fbf6](https://github.com/IBM/kui/commit/fd9fbf6)), closes [#6616](https://github.com/IBM/kui/issues/6616)
- kubectl kustomize can have bogus output ([8bf8ebe](https://github.com/IBM/kui/commit/8bf8ebe)), closes [#6114](https://github.com/IBM/kui/issues/6114)
- kubectl Terminal tab test is flakey ([5e28860](https://github.com/IBM/kui/commit/5e28860)), closes [#6636](https://github.com/IBM/kui/issues/6636)
- **plugins/plugin-kubectl:** kubectl delete ns m1 m2 m3 m4 results in a one-row table ([97a33a4](https://github.com/IBM/kui/commit/97a33a4)), closes [#5694](https://github.com/IBM/kui/issues/5694)
- **plugins/plugin-kubectl:** kubectl delete poller may get stuck Green ([c1d7662](https://github.com/IBM/kui/commit/c1d7662)), closes [#6436](https://github.com/IBM/kui/issues/6436)
- **plugins/plugin-kubectl:** kubectl direct streaming fails to register a stream.on('error') ([44a6038](https://github.com/IBM/kui/commit/44a6038)), closes [#6616](https://github.com/IBM/kui/issues/6616)
- **plugins/plugin-kubectl:** kubectl direct watcher does not properly filter events and resource updates ([be9e308](https://github.com/IBM/kui/commit/be9e308)), closes [#6599](https://github.com/IBM/kui/issues/6599)
- **plugins/plugin-kubectl:** kubectl proxy manager may create a new proxy too often ([72d9d5d](https://github.com/IBM/kui/commit/72d9d5d)), closes [#6462](https://github.com/IBM/kui/issues/6462)
- **plugins/plugin-kubectl:** kubectl watch commands without resource names won't show Added updates ([64442b3](https://github.com/IBM/kui/commit/64442b3)), closes [#6630](https://github.com/IBM/kui/issues/6630)
- compilation failures due perhaps to typescript 4.1.3 upgrade?? ([d06824b](https://github.com/IBM/kui/commit/d06824b)), closes [#6432](https://github.com/IBM/kui/issues/6432)
- kubectl get -f --watch doesn't watch ([e45e8ee](https://github.com/IBM/kui/commit/e45e8ee)), closes [#6588](https://github.com/IBM/kui/issues/6588)
- **plugins/plugin-kubectl:** plugin-kubectl's fetch-file, when using electron, does not have error handling ([b45a818](https://github.com/IBM/kui/commit/b45a818)), closes [#6426](https://github.com/IBM/kui/issues/6426)
- **plugins/plugin-kubectl:** Switching from kubectl logs tab to another tab causes uncaught exception ([d3f6770](https://github.com/IBM/kui/commit/d3f6770)), closes [#6585](https://github.com/IBM/kui/issues/6585)
- don't show "Created a split" when clicking on the New Split button ([80192d5](https://github.com/IBM/kui/commit/80192d5)), closes [#6001](https://github.com/IBM/kui/issues/6001)
- drilldown from an undeployed application in tree will issue a kubectl get with 404 ([309a9a0](https://github.com/IBM/kui/commit/309a9a0)), closes [#6331](https://github.com/IBM/kui/issues/6331)
- kubectl watcher should auto-terminate, if given a bound up front ([1a94094](https://github.com/IBM/kui/commit/1a94094)), closes [#6417](https://github.com/IBM/kui/issues/6417)
- remove TreeResponse and PatternFly Tree Component ([e539a53](https://github.com/IBM/kui/commit/e539a53)), closes [#6581](https://github.com/IBM/kui/issues/6581) [#6328](https://github.com/IBM/kui/issues/6328)
- **plugins/plugin-kubectl:** kubernetes namespace list does not update after namespace deletion ([c28c800](https://github.com/IBM/kui/commit/c28c800)), closes [#6521](https://github.com/IBM/kui/issues/6521)
- kubectl contexts table has odd CURRENT column ([f6d0a98](https://github.com/IBM/kui/commit/f6d0a98)), closes [#6523](https://github.com/IBM/kui/issues/6523)
- **plugins/plugin-kubectl:** new kubectl direct logic does not properly handle ECONNREFUSED ([96eefdb](https://github.com/IBM/kui/commit/96eefdb)), closes [#6476](https://github.com/IBM/kui/issues/6476)
- **plugins/plugin-kubectl:** new kubectl event watching logic may drop events ([d46f591](https://github.com/IBM/kui/commit/d46f591)), closes [#6451](https://github.com/IBM/kui/issues/6451)
- s3 job watcher sometimes fails due to startup issues ([8851d50](https://github.com/IBM/kui/commit/8851d50)), closes [#6411](https://github.com/IBM/kui/issues/6411)
- **plugins/plugin-kubectl:** helm test can fail due to helm release name exceeding 63 characters ([a9903ea](https://github.com/IBM/kui/commit/a9903ea)), closes [#6377](https://github.com/IBM/kui/issues/6377)
- **plugins/plugin-kubectl:** kubectl kustomize does not handle ~ home directory expansion ([f124b1d](https://github.com/IBM/kui/commit/f124b1d)), closes [#6115](https://github.com/IBM/kui/issues/6115)
- **plugins/plugin-kubectl:** kubernetes CurrentContext widget may display as empty ([640263c](https://github.com/IBM/kui/commit/640263c)), closes [#6392](https://github.com/IBM/kui/issues/6392)
- events in tree are presented out of temporal order ([b3ba61e](https://github.com/IBM/kui/commit/b3ba61e)), closes [#6168](https://github.com/IBM/kui/issues/6168)
- improve existing notebooks for v1 ([1af5cc2](https://github.com/IBM/kui/commit/1af5cc2)), closes [#5858](https://github.com/IBM/kui/issues/5858)
- monaco diff view colors are not themed ([eed2527](https://github.com/IBM/kui/commit/eed2527)), closes [#6232](https://github.com/IBM/kui/issues/6232)
- refine tree label categoriazation of kubectl ([1973a43](https://github.com/IBM/kui/commit/1973a43)), closes [#6185](https://github.com/IBM/kui/issues/6185)
- snapshot and replay of table clicks for Notebook v1 ([1a87dbf](https://github.com/IBM/kui/commit/1a87dbf)), closes [#5821](https://github.com/IBM/kui/issues/5821)
- tree should support leaf node drilling down ([006b881](https://github.com/IBM/kui/commit/006b881)), closes [#6293](https://github.com/IBM/kui/issues/6293)
- tweak the toolbar text and button label of `k get -f` tree ([ad476c5](https://github.com/IBM/kui/commit/ad476c5)), closes [#6303](https://github.com/IBM/kui/issues/6303)
- UI glitches of Tree ([fc5af7a](https://github.com/IBM/kui/commit/fc5af7a)), closes [#6138](https://github.com/IBM/kui/issues/6138)
- update kubectl/notebooks/deploy-applications for the Mode Toolbar change ([164244e](https://github.com/IBM/kui/commit/164244e)), closes [#6385](https://github.com/IBM/kui/issues/6385)
- **plugins/plugin-client-common:** isReplay bit on Blocks is not set for snapshots ([c6d1633](https://github.com/IBM/kui/commit/c6d1633)), closes [#5868](https://github.com/IBM/kui/issues/5868)
- **plugins/plugin-client-common:** update welcome.json to describe kui, not just notebooks ([96330c4](https://github.com/IBM/kui/commit/96330c4)), closes [#5878](https://github.com/IBM/kui/issues/5878)
- **plugins/plugin-kubectl:** "logs dashC follow via table" test is unreliable after electron 10 update ([72c50ab](https://github.com/IBM/kui/commit/72c50ab)), closes [#6152](https://github.com/IBM/kui/issues/6152)
- **plugins/plugin-kubectl:** isReplicaSet needs to be updated to handle "apps/v1" apiVersion ([6887a0d](https://github.com/IBM/kui/commit/6887a0d)), closes [#6003](https://github.com/IBM/kui/issues/6003)
- **plugins/plugin-kubectl:** k8s table should display status Propagated and Subscribed as green ([0787b4b](https://github.com/IBM/kui/commit/0787b4b)), closes [#5818](https://github.com/IBM/kui/issues/5818)
- **plugins/plugin-kubectl:** kubectl Deployment summary does not handle `undefined` fields ([0f65c3c](https://github.com/IBM/kui/commit/0f65c3c)), closes [#6028](https://github.com/IBM/kui/issues/6028)
- **plugins/plugin-kubectl:** kubectl status table does not register onclickIdempotent ([6ae296c](https://github.com/IBM/kui/commit/6ae296c)), closes [#5788](https://github.com/IBM/kui/issues/5788)
- **plugins/plugin-kubectl:** kubectl table should show PropagationFailed status as offline ([a44b70c](https://github.com/IBM/kui/commit/a44b70c)), closes [#5821](https://github.com/IBM/kui/issues/5821)
- **plugins/plugin-kubectl:** kui semi-ignores --dry-run for kubectl apply ([90c329f](https://github.com/IBM/kui/commit/90c329f)), closes [#6106](https://github.com/IBM/kui/issues/6106)
- **plugins/plugin-kubectl:** the Deploy Applications notebook has some typos ([817f9b7](https://github.com/IBM/kui/commit/817f9b7)), closes [#6256](https://github.com/IBM/kui/issues/6256)
- **plugins/plugin-kubectl:** typos in Tree Toolbar text ([0d9a6be](https://github.com/IBM/kui/commit/0d9a6be)), closes [#6514](https://github.com/IBM/kui/issues/6514)
- **plugins/plugin-kubectl:** unlabeled resources shouldn’t have badge for children's count ([4e1fea6](https://github.com/IBM/kui/commit/4e1fea6)), closes [#6243](https://github.com/IBM/kui/issues/6243)
- **plugins/plugin-kubectl:** Update list-resources notebook to use splits ([1f54515](https://github.com/IBM/kui/commit/1f54515)), closes [#5770](https://github.com/IBM/kui/issues/5770)
- **Plugins/plugin-kubectl:** Logs tab may become stale when switching away/back ([fcfdaba](https://github.com/IBM/kui/commit/fcfdaba)), closes [#6024](https://github.com/IBM/kui/issues/6024)
- avoid excessive status stripe overheads when replaying Notebooks ([58de9c0](https://github.com/IBM/kui/commit/58de9c0)), closes [#5635](https://github.com/IBM/kui/issues/5635)
- grid colors are sometimes off ([e66f56f](https://github.com/IBM/kui/commit/e66f56f)), closes [#5422](https://github.com/IBM/kui/issues/5422)
- improve the discoverability of repl-block action buttons ([470da34](https://github.com/IBM/kui/commit/470da34)), closes [#5604](https://github.com/IBM/kui/issues/5604)
- improve the replayability of terminal splitting ([67811cd](https://github.com/IBM/kui/commit/67811cd)), closes [#5564](https://github.com/IBM/kui/issues/5564)
- JS console may contain xtermjs error messages when sidecar is minimized ([a568528](https://github.com/IBM/kui/commit/a568528)), closes [#5454](https://github.com/IBM/kui/issues/5454)
- RadioTables are not replayable ([d0dd00e](https://github.com/IBM/kui/commit/d0dd00e)), closes [#5599](https://github.com/IBM/kui/issues/5599)
- sidecar shouldn't be opened automatically when replay ([8d4cf8c](https://github.com/IBM/kui/commit/8d4cf8c)), closes [#5730](https://github.com/IBM/kui/issues/5730)
- store the commentary text result to the command when editing is done ([5a3f5e8](https://github.com/IBM/kui/commit/5a3f5e8)), closes [#5916](https://github.com/IBM/kui/issues/5916) [#5672](https://github.com/IBM/kui/issues/5672)
- **plugins/plugin-client-common:** for now, switch interval chart to duration chart ([ea21221](https://github.com/IBM/kui/commit/ea21221)), closes [#5340](https://github.com/IBM/kui/issues/5340)
- **plugins/plugin-client-common:** Grid regression: grid colors not right ([d1aa46d](https://github.com/IBM/kui/commit/d1aa46d)), closes [#5285](https://github.com/IBM/kui/issues/5285)
- **plugins/plugin-client-common:** kubectl watch is broken for server versions >= 1.17 ([2d595b7](https://github.com/IBM/kui/commit/2d595b7)), closes [#5360](https://github.com/IBM/kui/issues/5360)
- **plugins/plugin-client-common:** SequenceDiagram UI refinements ([5d8c3f7](https://github.com/IBM/kui/commit/5d8c3f7)), closes [#5557](https://github.com/IBM/kui/issues/5557)
- **plugins/plugin-kubectl:** `oc get namespaces` doesn't produce a RadioTable ([6ea6131](https://github.com/IBM/kui/commit/6ea6131)), closes [#5227](https://github.com/IBM/kui/issues/5227)
- **plugins/plugin-kubectl:** add traffic light colors for OOMKilled and UnexpectedAdmissionError ([4262409](https://github.com/IBM/kui/commit/4262409)), closes [#5345](https://github.com/IBM/kui/issues/5345)
- **plugins/plugin-kubectl:** Fail should be TrafficLight.Red and Succeeded should be TrafficLight.Green ([54737b6](https://github.com/IBM/kui/commit/54737b6)), closes [#5351](https://github.com/IBM/kui/issues/5351)
- **plugins/plugin-kubectl:** kubectl watcher needs to pass through kubeconfig in its call to kubectl version ([a5d83a3](https://github.com/IBM/kui/commit/a5d83a3)), closes [#5368](https://github.com/IBM/kui/issues/5368)
- **plugins/plugin-kubectl:** regenerate kubernetes notebooks to show new Source Reference feature ([8324567](https://github.com/IBM/kui/commit/8324567)), closes [#5520](https://github.com/IBM/kui/issues/5520)
- vfs fixes for multi-source copying and for s3 globbing ([893902e](https://github.com/IBM/kui/commit/893902e)), closes [#5511](https://github.com/IBM/kui/issues/5511)
- **plugins/plugin-kubectl:** header-only tables improperly parsed ([f56841b](https://github.com/IBM/kui/commit/f56841b)), closes [#5382](https://github.com/IBM/kui/issues/5382)
- **plugins/plugin-kubectl:** wordsmithing to list-resources notebook ([7255a98](https://github.com/IBM/kui/commit/7255a98)), closes [#5504](https://github.com/IBM/kui/issues/5504)
- restore status stripe to default behavior on terminal clear ([128ec92](https://github.com/IBM/kui/commit/128ec92)), closes [#5495](https://github.com/IBM/kui/issues/5495)
- **plugins/plugin-kubectl:** add Summary impl for kubernetes Jobs ([b0f3809](https://github.com/IBM/kui/commit/b0f3809)), closes [#5481](https://github.com/IBM/kui/issues/5481)
- **plugins/plugin-kubectl:** kubectl get -f can show undefined in table title ([eb34d1c](https://github.com/IBM/kui/commit/eb34d1c)), closes [#5469](https://github.com/IBM/kui/issues/5469)
- snapshot command fails at `k get -o yaml` ([fe53fb0](https://github.com/IBM/kui/commit/fe53fb0)), closes [#5458](https://github.com/IBM/kui/issues/5458)
- snapshot command throws errors when capturing watch responses ([600f049](https://github.com/IBM/kui/commit/600f049)), closes [#5452](https://github.com/IBM/kui/issues/5452)
- **plugins/plugin-client-common:** make Close a top-level button in watch panes ([3c14da5](https://github.com/IBM/kui/commit/3c14da5)), closes [#4945](https://github.com/IBM/kui/issues/4945)
- **plugins/plugin-kubectl:** certain filepath options to kubectl were not tilde-expanded ([9e7f858](https://github.com/IBM/kui/commit/9e7f858)), closes [#5415](https://github.com/IBM/kui/issues/5415)
- **plugins/plugin-kubectl:** changing ns via oc does not update ns widget, in browser clients ([5eaa625](https://github.com/IBM/kui/commit/5eaa625)), closes [#4953](https://github.com/IBM/kui/issues/4953)
- **plugins/plugin-kubectl:** CurrentNamespace/Context widgets not live ([93ac829](https://github.com/IBM/kui/commit/93ac829)), closes [#5144](https://github.com/IBM/kui/issues/5144)
- **plugins/plugin-kubectl:** drilldown command of resources in watch --all-namespace table doesn't have '-o yaml' ([1e4f558](https://github.com/IBM/kui/commit/1e4f558)), closes [#5208](https://github.com/IBM/kui/issues/5208)
- **plugins/plugin-kubectl:** event footer watching should also support named resources ([e3a842b](https://github.com/IBM/kui/commit/e3a842b)), closes [#5180](https://github.com/IBM/kui/issues/5180)
- **plugins/plugin-kubectl:** events in table appear to be in random order ([034dc06](https://github.com/IBM/kui/commit/034dc06)), closes [#5212](https://github.com/IBM/kui/issues/5212)
- **plugins/plugin-kubectl:** Pod summary impl fails for pods with no containerStatuses ([66b21b5](https://github.com/IBM/kui/commit/66b21b5)), closes [#5192](https://github.com/IBM/kui/issues/5192)
- (plugins/plugin-kubectl): kubectl get pod -w --all-namespaces behaves oddly ([12e578a](https://github.com/IBM/kui/commit/12e578a)), closes [#5169](https://github.com/IBM/kui/issues/5169)
- **plugins/plugin-kubectl:** kubectl apply -f may not abort the event watcher ([c8df222](https://github.com/IBM/kui/commit/c8df222)), closes [#5149](https://github.com/IBM/kui/issues/5149)
- **plugins/plugin-kubectl:** kubectl explain subfields ([8fee2bc](https://github.com/IBM/kui/commit/8fee2bc)), closes [#4921](https://github.com/IBM/kui/issues/4921)
- **plugins/plugin-kubectl:** nil and negative timestamps display as "0ms ago" ([641a599](https://github.com/IBM/kui/commit/641a599)), closes [#5136](https://github.com/IBM/kui/issues/5136)
- **plugins/plugin-kubectl:** oc get ns does not present a RadioTable ([9e28eec](https://github.com/IBM/kui/commit/9e28eec)), closes [#5106](https://github.com/IBM/kui/issues/5106)
- avoid using kui-custom command for switching kubectl namespace ([43863f2](https://github.com/IBM/kui/commit/43863f2)), closes [#4806](https://github.com/IBM/kui/issues/4806)
- CurrentContext and CurrentNamespace widgets may have stale data inBrowser ([ab77c20](https://github.com/IBM/kui/commit/ab77c20)), closes [#5097](https://github.com/IBM/kui/issues/5097)
- don't blink yellow forever for kubectl events ([a59ee86](https://github.com/IBM/kui/commit/a59ee86)), closes [#4869](https://github.com/IBM/kui/issues/4869)
- empty watch tables/grids should show 'No resources' ([c0bfe99](https://github.com/IBM/kui/commit/c0bfe99)), closes [#4884](https://github.com/IBM/kui/issues/4884)
- multiple issues with tab switching versus status stripe widgets ([8c8a6ec](https://github.com/IBM/kui/commit/8c8a6ec)), closes [#5101](https://github.com/IBM/kui/issues/5101)
- **plugins/plugin-kubectl:** auto-pause logs when user scrolls ([94b85e6](https://github.com/IBM/kui/commit/94b85e6)), closes [#4668](https://github.com/IBM/kui/issues/4668)
- **plugins/plugin-kubectl:** automatically abort idle PTYs ([2638a65](https://github.com/IBM/kui/commit/2638a65)), closes [#4742](https://github.com/IBM/kui/issues/4742)
- **plugins/plugin-kubectl:** get-namespace table sometimes doens't show the correct selected namespace ([af66aa4](https://github.com/IBM/kui/commit/af66aa4)), closes [#4812](https://github.com/IBM/kui/issues/4812)
- **plugins/plugin-kubectl:** helm help parsed usage incorrectly ([b222da2](https://github.com/IBM/kui/commit/b222da2)), closes [#4692](https://github.com/IBM/kui/issues/4692)
- **plugins/plugin-kubectl:** i18n for No log data message ([589a4cd](https://github.com/IBM/kui/commit/589a4cd)), closes [#4656](https://github.com/IBM/kui/issues/4656)
- **plugins/plugin-kubectl:** improve kubectl tab completion ([734f9e5](https://github.com/IBM/kui/commit/734f9e5)), closes [#4704](https://github.com/IBM/kui/issues/4704)
- **plugins/plugin-kubectl:** improve kubectl top node display with open sidecar ([6f99581](https://github.com/IBM/kui/commit/6f99581)), closes [#4737](https://github.com/IBM/kui/issues/4737)
- **plugins/plugin-kubectl:** k edit -h does not open in sidecar ([b6f68f8](https://github.com/IBM/kui/commit/b6f68f8)), closes [#4661](https://github.com/IBM/kui/issues/4661)
- **plugins/plugin-kubectl:** kubectl api-resources table should hide APIGROUP column with open sidecar ([ee347fa](https://github.com/IBM/kui/commit/ee347fa)), closes [#4728](https://github.com/IBM/kui/issues/4728)
- **plugins/plugin-kubectl:** kubectl logs -l with no matches yields internal error ([ed0374f](https://github.com/IBM/kui/commit/ed0374f)), closes [#4811](https://github.com/IBM/kui/issues/4811)
- **plugins/plugin-kubectl:** Logs tab should have a default tail limit ([d4cf08c](https://github.com/IBM/kui/commit/d4cf08c)), closes [#4810](https://github.com/IBM/kui/issues/4810) [#4818](https://github.com/IBM/kui/issues/4818)
- allow user to disable table title by feature flags, and disable table pagination ([5450512](https://github.com/IBM/kui/commit/5450512)), closes [#4640](https://github.com/IBM/kui/issues/4640) [#4655](https://github.com/IBM/kui/issues/4655)
- Input element throws react error ([e6bb21b](https://github.com/IBM/kui/commit/e6bb21b)), closes [#4765](https://github.com/IBM/kui/issues/4765)
- kubectl edit apply twice does not work ([1976134](https://github.com/IBM/kui/commit/1976134)), closes [#4797](https://github.com/IBM/kui/issues/4797)
- **plugins/plugin-kubectl:** kubectl logs tab has bad interleaving and cpu issues ([1c7cf17](https://github.com/IBM/kui/commit/1c7cf17)), closes [#4664](https://github.com/IBM/kui/issues/4664) [#4665](https://github.com/IBM/kui/issues/4665)
- **plugins/plugin-kubectl:** remove kubectl edit cancel button ([83179e8](https://github.com/IBM/kui/commit/83179e8)), closes [#4695](https://github.com/IBM/kui/issues/4695)
- **plugins/plugin-kubectl:** status shows as Containercreating when it should be ContainerCreating ([2c4a3b6](https://github.com/IBM/kui/commit/2c4a3b6)), closes [#4798](https://github.com/IBM/kui/issues/4798)
- **plugins/plugin-kubectl:** Terminal tab test incorrectly verifies k exec output ([20ab362](https://github.com/IBM/kui/commit/20ab362)), closes [#4802](https://github.com/IBM/kui/issues/4802)
- **plugins/plugin-kubectl:** tolerate helm 3.0 and 3.1 help custom ascii art tables ([79f8640](https://github.com/IBM/kui/commit/79f8640)), closes [#5085](https://github.com/IBM/kui/issues/5085)
- avoid recomputing tabs when switching back and forth ([cf5e41f](https://github.com/IBM/kui/commit/cf5e41f)), closes [#4666](https://github.com/IBM/kui/issues/4666)
- container filter of logs tab shows accumulated logs from previous selection ([08903b4](https://github.com/IBM/kui/commit/08903b4)), closes [#4644](https://github.com/IBM/kui/issues/4644) [#4658](https://github.com/IBM/kui/issues/4658)
- eliminate assumptions that "default" is the default kube namespace ([4eb392d](https://github.com/IBM/kui/commit/4eb392d)), closes [#4764](https://github.com/IBM/kui/issues/4764)
- improve error reporting for kubectl apply ([fe21671](https://github.com/IBM/kui/commit/fe21671)), closes [#4605](https://github.com/IBM/kui/issues/4605)
- kubectl api-resources has duplicate rows and odd pagination behavior ([e740270](https://github.com/IBM/kui/commit/e740270)), closes [#4626](https://github.com/IBM/kui/issues/4626)
- kubectl edit in sidecar doesn't show success message when a resource is applied ([cc59503](https://github.com/IBM/kui/commit/cc59503)), closes [#4691](https://github.com/IBM/kui/issues/4691)
- kubectl help misformats helm help tables ([ff36755](https://github.com/IBM/kui/commit/ff36755)), closes [#5080](https://github.com/IBM/kui/issues/5080)
- **plugins/plugin-kubectl:** kubectl apply/create/delete tables still have ALLCAPS headers ([90d72ce](https://github.com/IBM/kui/commit/90d72ce)), closes [#5068](https://github.com/IBM/kui/issues/5068)
- improve hover effect for status stripe buttons ([50ced8f](https://github.com/IBM/kui/commit/50ced8f)), closes [#4896](https://github.com/IBM/kui/issues/4896)
- kubectl Logs tab should use an xterm ([9aa0176](https://github.com/IBM/kui/commit/9aa0176)), closes [#4750](https://github.com/IBM/kui/issues/4750) [#4747](https://github.com/IBM/kui/issues/4747)
- logs tab toolbar doesn't signify when pods are 404 ([135e1be](https://github.com/IBM/kui/commit/135e1be)), closes [#4646](https://github.com/IBM/kui/issues/4646)
- pexecs serviced by now-removed splits fail ([f6176a1](https://github.com/IBM/kui/commit/f6176a1)), closes [#4875](https://github.com/IBM/kui/issues/4875)
- place namespace breadcrumb first ([5d3b2e4](https://github.com/IBM/kui/commit/5d3b2e4)), closes [#4699](https://github.com/IBM/kui/issues/4699)
- reduce custom CSS rules for table UI ([56f69cb](https://github.com/IBM/kui/commit/56f69cb)), closes [#5024](https://github.com/IBM/kui/issues/5024)
- sidecar toolbar can't due justice to longer error messages ([e67e0c9](https://github.com/IBM/kui/commit/e67e0c9)), closes [#4789](https://github.com/IBM/kui/issues/4789)
- xterm alt buffer mode behaves oddly for clients that do not enable splitTerminals ([f1bc709](https://github.com/IBM/kui/commit/f1bc709)), closes [#5003](https://github.com/IBM/kui/issues/5003)
- **plugins/plugin-kubectl:** kubectl apply edit-last-applied freezes in kui ([24a67da](https://github.com/IBM/kui/commit/24a67da)), closes [#4808](https://github.com/IBM/kui/issues/4808)
- **plugins/plugin-kubectl:** kubectl apply set-last-applied does not work ([9553907](https://github.com/IBM/kui/commit/9553907)), closes [#4844](https://github.com/IBM/kui/issues/4844)
- **plugins/plugin-kubectl:** kubectl watch tables may lack namespace breadcrumb ([a0616c2](https://github.com/IBM/kui/commit/a0616c2)), closes [#4870](https://github.com/IBM/kui/issues/4870)
- **plugins/plugin-kubectl:** oc get projects does not allow user selection ([3749371](https://github.com/IBM/kui/commit/3749371)), closes [#4805](https://github.com/IBM/kui/issues/4805)
- **plugins/plugin-kubectl:** oc logs does not work ([f0808a2](https://github.com/IBM/kui/commit/f0808a2)), closes [#4965](https://github.com/IBM/kui/issues/4965)
- **plugins/plugin-kubectl:** singleton breadcrumbs in kubectl help should not be clickable ([7815464](https://github.com/IBM/kui/commit/7815464)), closes [#4961](https://github.com/IBM/kui/issues/4961)
- avoid hard-coded use of /tmp in kubectl edit ([8e4cb70](https://github.com/IBM/kui/commit/8e4cb70)), closes [#4928](https://github.com/IBM/kui/issues/4928)
- **plugins/plugin-kubectl:** windows powershell fails to get default namespace ([a5fb2e1](https://github.com/IBM/kui/commit/a5fb2e1)), closes [#4912](https://github.com/IBM/kui/issues/4912)
- remove augmentModuleLoadPath API ([47dfcdf](https://github.com/IBM/kui/commit/47dfcdf)), closes [#4839](https://github.com/IBM/kui/issues/4839)
- summary tab is not read-only for kubectl edit command ([9f7ff82](https://github.com/IBM/kui/commit/9f7ff82)), closes [#4809](https://github.com/IBM/kui/issues/4809)
- the Logs/Terminal retry button should be visible on any exit code ([3366327](https://github.com/IBM/kui/commit/3366327)), closes [#4769](https://github.com/IBM/kui/issues/4769)
- TopNavSidecar tabs should auto-pause and auto-focus when switching ([2b00dd9](https://github.com/IBM/kui/commit/2b00dd9)), closes [#4741](https://github.com/IBM/kui/issues/4741) [#4748](https://github.com/IBM/kui/issues/4748)
- **plugins/plugin-kubectl:** ExecIntoPod's terminal is not theme-aligned ([067cda3](https://github.com/IBM/kui/commit/067cda3)), closes [#4722](https://github.com/IBM/kui/issues/4722)
- **plugins/plugin-kubectl:** ImagePullBackoff should be considered a "red" state ([198100d](https://github.com/IBM/kui/commit/198100d)), closes [#4734](https://github.com/IBM/kui/issues/4734)
- **plugins/plugin-kubectl:** k edit deploy has mysterious Pod tab ([914df36](https://github.com/IBM/kui/commit/914df36)), closes [#4703](https://github.com/IBM/kui/issues/4703)
- **plugins/plugin-kubectl:** remove Conditions tab ([eac3705](https://github.com/IBM/kui/commit/eac3705)), closes [#4606](https://github.com/IBM/kui/issues/4606)
- reduce No log data followed by log data behavior in kube logs ([e1c0624](https://github.com/IBM/kui/commit/e1c0624)), closes [#4624](https://github.com/IBM/kui/issues/4624)
- **plugin-kubectl:** k get pods --all-namespaces has a title with "default" as the namespace ([2f95129](https://github.com/IBM/kui/commit/2f95129)), closes [#4466](https://github.com/IBM/kui/issues/4466)
- **plugin-kubectl:** kubectl get error-type -w doesn't fail fast ([4ccb733](https://github.com/IBM/kui/commit/4ccb733)), closes [#4491](https://github.com/IBM/kui/issues/4491)
- **plugins/plugin-kubectl:** add missing test for get with not found ([3e77689](https://github.com/IBM/kui/commit/3e77689)), closes [#4492](https://github.com/IBM/kui/issues/4492)
- **plugins/plugin-kubectl:** cache kind canonicalization lookup ([e351a5f](https://github.com/IBM/kui/commit/e351a5f)), closes [#4489](https://github.com/IBM/kui/issues/4489)
- **plugins/plugin-kubectl:** CurrentContext widget shows "default" for openshift clusters ([59712c0](https://github.com/IBM/kui/commit/59712c0)), closes [#4347](https://github.com/IBM/kui/issues/4347)
- **plugins/plugin-kubectl:** inconsistent capitalization of breadcrumbs ([963b166](https://github.com/IBM/kui/commit/963b166)), closes [#4607](https://github.com/IBM/kui/issues/4607)
- **plugins/plugin-kubectl:** k get events -w bombs ([20c2caf](https://github.com/IBM/kui/commit/20c2caf)), closes [#4557](https://github.com/IBM/kui/issues/4557)
- **plugins/plugin-kubectl:** kubectl create secret hangs yellow ([e11dbb8](https://github.com/IBM/kui/commit/e11dbb8)), closes [#4571](https://github.com/IBM/kui/issues/4571)
- **plugins/plugin-kubectl:** kubectl describe -h has old bold text ([b31d066](https://github.com/IBM/kui/commit/b31d066)), closes [#4568](https://github.com/IBM/kui/issues/4568)
- **plugins/plugin-kubectl:** kubectl edit should support editing a list of resources ([4cd4d43](https://github.com/IBM/kui/commit/4cd4d43)), closes [#4555](https://github.com/IBM/kui/issues/4555)
- **plugins/plugin-kubectl:** kubectl get --all-namespaces --watch does not update ([663a972](https://github.com/IBM/kui/commit/663a972)), closes [#4581](https://github.com/IBM/kui/issues/4581)
- **plugins/plugin-kubectl:** kubectl Show Events query not precise enough ([eda6b38](https://github.com/IBM/kui/commit/eda6b38)), closes [#4572](https://github.com/IBM/kui/issues/4572)
- **plugins/plugin-kubectl:** remove Show Logs registration ([382c685](https://github.com/IBM/kui/commit/382c685)), closes [#4603](https://github.com/IBM/kui/issues/4603)
- add support for hiding elements at higher zoom levels ([7d2a7e0](https://github.com/IBM/kui/commit/7d2a7e0)), closes [#4232](https://github.com/IBM/kui/issues/4232)
- clicking on certain links in kubectl help result in odd behavior ([035894b](https://github.com/IBM/kui/commit/035894b)), closes [#4473](https://github.com/IBM/kui/issues/4473)
- clicking on container name in details sidecar should add -c to logs command ([61c7c08](https://github.com/IBM/kui/commit/61c7c08)), closes [#4498](https://github.com/IBM/kui/issues/4498)
- ibmcloud plugin list does not list unofficial plugins ([303fa00](https://github.com/IBM/kui/commit/303fa00)), closes [#4339](https://github.com/IBM/kui/issues/4339)
- kubectl top node should show % text ([f861b76](https://github.com/IBM/kui/commit/f861b76)), closes [#4598](https://github.com/IBM/kui/issues/4598)
- make inBrowserOk the default ([2a3c811](https://github.com/IBM/kui/commit/2a3c811)), closes [#4275](https://github.com/IBM/kui/issues/4275)
- multiple kubectl help/usage bugs ([ebba36e](https://github.com/IBM/kui/commit/ebba36e)), closes [#4342](https://github.com/IBM/kui/issues/4342)
- multiple tab completion bugs ([5513712](https://github.com/IBM/kui/commit/5513712)), closes [#4281](https://github.com/IBM/kui/issues/4281)
- optimize kubectl watch load on apiserver ([3f7a32f](https://github.com/IBM/kui/commit/3f7a32f)), closes [#4494](https://github.com/IBM/kui/issues/4494)
- PaginatedTable fails at distinguishing the rowKeys of `k get --all-namespaces` table ([6658729](https://github.com/IBM/kui/commit/6658729)), closes [#4579](https://github.com/IBM/kui/issues/4579)
- replace Containers with Logs tab ([00e8786](https://github.com/IBM/kui/commit/00e8786)), closes [#4603](https://github.com/IBM/kui/issues/4603)
- **plugins/plugin-kubectl:** kubectl get table with mix of existing and non-existing ([8d98d15](https://github.com/IBM/kui/commit/8d98d15)), closes [#4492](https://github.com/IBM/kui/issues/4492)
- **plugins/plugin-kubectl:** revert to editor-based Summary tab ([3ecd638](https://github.com/IBM/kui/commit/3ecd638)), closes [#4594](https://github.com/IBM/kui/issues/4594)
- sidecar views do not respect tab-specificity ([5a1cae2](https://github.com/IBM/kui/commit/5a1cae2)), closes [#4362](https://github.com/IBM/kui/issues/4362)
- TopNavSidecar does not always show updates ([251e5c4](https://github.com/IBM/kui/commit/251e5c4)), closes [#4524](https://github.com/IBM/kui/issues/4524)
- **plugins/plugin-kubectl:** avoid use of /s regexp ([9468304](https://github.com/IBM/kui/commit/9468304)), closes [#4259](https://github.com/IBM/kui/issues/4259)
- **plugins/plugin-kubectl:** kubectl explain -h should render as usage in sidecar ([8e00c3f](https://github.com/IBM/kui/commit/8e00c3f)), closes [#4211](https://github.com/IBM/kui/issues/4211)
- eliminate complex nesting of NavResponse model ([e849ae7](https://github.com/IBM/kui/commit/e849ae7)), closes [#4205](https://github.com/IBM/kui/issues/4205)
- **plugins/plugin-kubectl:** ensure Show Owner button appears near end of toolbar buttons ([224c586](https://github.com/IBM/kui/commit/224c586)), closes [#4124](https://github.com/IBM/kui/issues/4124)
- **plugins/plugin-kubectl:** firefox does not support the /s flag to RegExp ([5b661a6](https://github.com/IBM/kui/commit/5b661a6)), closes [#4206](https://github.com/IBM/kui/issues/4206)
- **plugins/plugin-kubectl:** kubectl top nodes can present "NaN" ([30df3dd](https://github.com/IBM/kui/commit/30df3dd)), closes [#4189](https://github.com/IBM/kui/issues/4189)
- the colors of status badges: Error, ImagePullBackOff and ErrImagePull are incorrect ([fd206f6](https://github.com/IBM/kui/commit/fd206f6)), closes [#4171](https://github.com/IBM/kui/issues/4171)
- **plugins/plugin-kubectl:** in kube namespace table, selected namespace should float to top ([f0e597f](https://github.com/IBM/kui/commit/f0e597f)), closes [#4129](https://github.com/IBM/kui/issues/4129)
- **plugins/plugin-kubectl:** kubectl api-resources table shows 'unknown' in title ([0461710](https://github.com/IBM/kui/commit/0461710)), closes [#4145](https://github.com/IBM/kui/issues/4145)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- **plugins/plugin-kubectl:** more refinements to Form layout heuristics ([e92327d](https://github.com/IBM/kui/commit/e92327d)), closes [#4118](https://github.com/IBM/kui/issues/4118)
- **plugins/plugin-kubectl:** watch table doesn't have breadcrumbs title ([43fbe6a](https://github.com/IBM/kui/commit/43fbe6a)), closes [#4135](https://github.com/IBM/kui/issues/4135)
- **plugins/plugin-kubectl:** watcher table disappears when kui is launched as kubectl plugin ([167eabc](https://github.com/IBM/kui/commit/167eabc)), closes [#4120](https://github.com/IBM/kui/issues/4120) [#4123](https://github.com/IBM/kui/issues/4123)
- ensure kubectl Delete toolbar button appears at far right ([9eb3079](https://github.com/IBM/kui/commit/9eb3079)), closes [#4116](https://github.com/IBM/kui/issues/4116)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- kubectl summary Form TextInputs can be cropped ([3becaf9](https://github.com/IBM/kui/commit/3becaf9)), closes [#4077](https://github.com/IBM/kui/issues/4077)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- tekton Step nodes show with hashed background ([8428d72](https://github.com/IBM/kui/commit/8428d72)), closes [#4114](https://github.com/IBM/kui/issues/4114)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)
- **plugins/plugin-kubectl:** kubectl describe (--help) fails ([10b8e8a](https://github.com/IBM/kui/commit/10b8e8a)), closes [#4012](https://github.com/IBM/kui/issues/4012)
- **plugins/plugin-kubectl:** kubectl explain Overview tab not formatted as expected ([ffa9183](https://github.com/IBM/kui/commit/ffa9183)), closes [#4304](https://github.com/IBM/kui/issues/4304)
- **plugins/plugin-kubectl:** kubectl Logs/Events/Terminal tabs do not reflow on sidecar maximize ([6dbcbe8](https://github.com/IBM/kui/commit/6dbcbe8)), closes [#5417](https://github.com/IBM/kui/issues/5417)
- **plugins/plugin-kubectl:** kubectl tab completion does not let me tab-complete some filepaths ([e42daa7](https://github.com/IBM/kui/commit/e42daa7)), closes [#5413](https://github.com/IBM/kui/issues/5413)
- **plugins/plugin-kubectl:** kubernetes contexts table renders poorly ([e2ed7d8](https://github.com/IBM/kui/commit/e2ed7d8)), closes [#5230](https://github.com/IBM/kui/issues/5230)
- **plugins/plugin-kubectl:** Kui may invoke kubectl with duplicate command line options ([39c9d31](https://github.com/IBM/kui/commit/39c9d31)), closes [#5330](https://github.com/IBM/kui/issues/5330)
- **plugins/plugin-kubectl:** leftover debug printfs in table-watch ([407855a](https://github.com/IBM/kui/commit/407855a)), closes [#5317](https://github.com/IBM/kui/issues/5317)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- **plugins/plugin-kubectl:** oc describe fails ([4f4de4e](https://github.com/IBM/kui/commit/4f4de4e)), closes [#4008](https://github.com/IBM/kui/issues/4008)
- **plugins/plugin-kubectl:** update deprecated import of uuid ([5de8d4d](https://github.com/IBM/kui/commit/5de8d4d)), closes [#4316](https://github.com/IBM/kui/issues/4316)
- **plugins/plugin-kubectl:** update jobs notebook to latest SequenceDiagram ([8e70862](https://github.com/IBM/kui/commit/8e70862)), closes [#5862](https://github.com/IBM/kui/issues/5862)
- **plugins/plugin-kubectl:** use PaginatedTable instead of RadioTable for `contexts` and `get namespaces` commands ([20f0737](https://github.com/IBM/kui/commit/20f0737)), closes [#6517](https://github.com/IBM/kui/issues/6517)
- **plugins/plugin-kubectl:** we shouldn't render namespace widget when the namespace is empty in kube config ([98a9406](https://github.com/IBM/kui/commit/98a9406)), closes [#4274](https://github.com/IBM/kui/issues/4274)

### Features

- **plugins/plugin-kubectl:** Namespace Summary should summarize namespace resourecequota, if existing ([009583e](https://github.com/IBM/kui/commit/009583e)), closes [#7144](https://github.com/IBM/kui/issues/7144)
- **plugins/plugin-kubectl:** plugin-kubectl should export `isWatchRequest` ([f825935](https://github.com/IBM/kui/commit/f825935)), closes [#7117](https://github.com/IBM/kui/issues/7117)
- add typeahead to kubernetes context and namespace select widget ([ff9d273](https://github.com/IBM/kui/commit/ff9d273)), closes [#7034](https://github.com/IBM/kui/issues/7034)
- group namespaces by internal/regular in CurrentNamespace ([be2d98f](https://github.com/IBM/kui/commit/be2d98f)), closes [#7058](https://github.com/IBM/kui/issues/7058)
- **plugins/plugin-kubectl:** add explain fastpath for events ([a16e75f](https://github.com/IBM/kui/commit/a16e75f)), closes [#6836](https://github.com/IBM/kui/issues/6836)
- **plugins/plugin-kubectl:** add explain fastpaths for \*.v1.apps ([0b0e82a](https://github.com/IBM/kui/commit/0b0e82a)), closes [#6862](https://github.com/IBM/kui/issues/6862)
- **plugins/plugin-kubectl:** add Secret explain and Summary fastpaths ([90bbd89](https://github.com/IBM/kui/commit/90bbd89)), closes [#6868](https://github.com/IBM/kui/issues/6868)
- **plugins/plugin-kubectl:** Add simple kubectl delete to the list of direct optimizations ([d4fb765](https://github.com/IBM/kui/commit/d4fb765)), closes [#6468](https://github.com/IBM/kui/issues/6468)
- **plugins/plugin-kubectl:** Add Summary impl for Events ([74f4e55](https://github.com/IBM/kui/commit/74f4e55)), closes [#6839](https://github.com/IBM/kui/issues/6839)
- **plugins/plugin-kubectl:** apply/delete -f can use new direct/status watcher for homogeneous use cases ([08e471e](https://github.com/IBM/kui/commit/08e471e)), closes [#6498](https://github.com/IBM/kui/issues/6498)
- **plugins/plugin-kubectl:** CLI-based kubectl polling does not allow for flexible overrides of the command prefix ([1e3d60f](https://github.com/IBM/kui/commit/1e3d60f)), closes [#7042](https://github.com/IBM/kui/issues/7042)
- **plugins/plugin-kubectl:** Enhance kubectl direct get to support custom columns ([4762dd8](https://github.com/IBM/kui/commit/4762dd8)), closes [#7014](https://github.com/IBM/kui/issues/7014)
- **plugins/plugin-kubectl:** popeye dashboard ([6dd4d01](https://github.com/IBM/kui/commit/6dd4d01)), closes [#6949](https://github.com/IBM/kui/issues/6949)
- **plugins/plugin-kubectl:** Port kubectl pollers to use push, for homogeneous deletes ([82448d7](https://github.com/IBM/kui/commit/82448d7)), closes [#6481](https://github.com/IBM/kui/issues/6481) [#6486](https://github.com/IBM/kui/issues/6486)
- **plugins/plugin-kubectl:** use `oc proxy` when talking to openshift clusters ([c07e5a0](https://github.com/IBM/kui/commit/c07e5a0)), closes [#7048](https://github.com/IBM/kui/issues/7048)
- add a prefer-re-execution option to snapshot ([af7b98b](https://github.com/IBM/kui/commit/af7b98b)), closes [#5622](https://github.com/IBM/kui/issues/5622)
- add delta summary to Tree ([95a0b4a](https://github.com/IBM/kui/commit/95a0b4a)), closes [#6329](https://github.com/IBM/kui/issues/6329)
- add events to sidecar tree ([dd4d552](https://github.com/IBM/kui/commit/dd4d552)), closes [#6140](https://github.com/IBM/kui/issues/6140)
- add Kubernetes Dashboard Notebook ([9f62b63](https://github.com/IBM/kui/commit/9f62b63)), closes [#5617](https://github.com/IBM/kui/issues/5617) [#6915](https://github.com/IBM/kui/issues/6915) [#6917](https://github.com/IBM/kui/issues/6917)
- Add simple kubectl create namespace to the list of direct optimizations ([2aaaac6](https://github.com/IBM/kui/commit/2aaaac6)), closes [#6470](https://github.com/IBM/kui/issues/6470)
- allow controllers to control the color of the status stripe ([708570c](https://github.com/IBM/kui/commit/708570c)), closes [#5490](https://github.com/IBM/kui/issues/5490)
- allow for limiting the number of kubectl table rows ([62588f2](https://github.com/IBM/kui/commit/62588f2)), closes [#5358](https://github.com/IBM/kui/issues/5358)
- background new tabs ([be9f986](https://github.com/IBM/kui/commit/be9f986)), closes [#5550](https://github.com/IBM/kui/issues/5550)
- cold start delays ([83abd14](https://github.com/IBM/kui/commit/83abd14)), closes [#5356](https://github.com/IBM/kui/issues/5356)
- custom tab titles ([fd780df](https://github.com/IBM/kui/commit/fd780df)), closes [#5525](https://github.com/IBM/kui/issues/5525)
- Expand kubectl direct watching to support heterogeneous use cases ([8df1ad3](https://github.com/IBM/kui/commit/8df1ad3)), closes [#6504](https://github.com/IBM/kui/issues/6504)
- Extend kubectl optimizations to table watching ([9a2bc74](https://github.com/IBM/kui/commit/9a2bc74)), closes [#6449](https://github.com/IBM/kui/issues/6449)
- generalized kuberctl get with limit ([d40ee07](https://github.com/IBM/kui/commit/d40ee07)), closes [#5361](https://github.com/IBM/kui/issues/5361)
- in `kubectl get -f` tree, use Monaco DiffEditor show the preview of dry-run changes ([99266e8](https://github.com/IBM/kui/commit/99266e8)), closes [#6181](https://github.com/IBM/kui/issues/6181) [#6154](https://github.com/IBM/kui/issues/6154)
- initial support for using a kubectl proxy ([47b26be](https://github.com/IBM/kui/commit/47b26be)), closes [#6440](https://github.com/IBM/kui/issues/6440)
- Kui implementation of `watch` ([2cb3f98](https://github.com/IBM/kui/commit/2cb3f98)), closes [#6379](https://github.com/IBM/kui/issues/6379)
- pause and resume watchable jobs ([5d3f719](https://github.com/IBM/kui/commit/5d3f719)), closes [#1747](https://github.com/IBM/kui/issues/1747)
- preserve changes of table view state in Notebook ([a2efb8a](https://github.com/IBM/kui/commit/a2efb8a)), closes [#5399](https://github.com/IBM/kui/issues/5399)
- revive "app" and "tier" columns from deprecated kubectl tree view ([cd642d9](https://github.com/IBM/kui/commit/cd642d9)), closes [#6591](https://github.com/IBM/kui/issues/6591)
- show buttons of related resources in sidecar footer ([e10f7f2](https://github.com/IBM/kui/commit/e10f7f2)), closes [#6856](https://github.com/IBM/kui/issues/6856)
- use Select Component for Kubernetes Context and Namespace status stripe widgets ([0e1c25e](https://github.com/IBM/kui/commit/0e1c25e)), closes [#6920](https://github.com/IBM/kui/issues/6920)
- **packages/core:** allow controller to opt in/out recording table row onclicks when snapshot ([cc83ce7](https://github.com/IBM/kui/commit/cc83ce7)), closes [#5565](https://github.com/IBM/kui/issues/5565)
- **plugins/plugin-client-common:** improved SequenceDiagram view ([1e2fb41](https://github.com/IBM/kui/commit/1e2fb41)), closes [#5342](https://github.com/IBM/kui/issues/5342)
- **plugins/plugin-kubectl:** add status column to kube deployment table ([1d35040](https://github.com/IBM/kui/commit/1d35040)), closes [#5476](https://github.com/IBM/kui/issues/5476)
- **plugins/plugin-kubectl:** flesh out explain fastpath for more apps/v1 types ([6f68a98](https://github.com/IBM/kui/commit/6f68a98)), closes [#6854](https://github.com/IBM/kui/issues/6854)
- **plugins/plugin-kubectl:** improve the performance of kubectl explain for common cases ([d016971](https://github.com/IBM/kui/commit/d016971)), closes [#6700](https://github.com/IBM/kui/issues/6700)
- **plugins/plugin-kubectl:** initial `kubectl job list` improvement for visualizing Job execution ([06030b0](https://github.com/IBM/kui/commit/06030b0)), closes [#5397](https://github.com/IBM/kui/issues/5397)
- **plugins/plugin-kubectl:** initial labs for listing k8s resources and creating jobs ([2e9d002](https://github.com/IBM/kui/commit/2e9d002)), closes [#5475](https://github.com/IBM/kui/issues/5475)
- **plugins/plugin-kubectl:** static get -f should show sourceRef ([fb0fc40](https://github.com/IBM/kui/commit/fb0fc40)), closes [#6680](https://github.com/IBM/kui/issues/6680)
- **plugins/plugin-kubectl:** update get -f to use direct/status and show a table ([16bdbb6](https://github.com/IBM/kui/commit/16bdbb6)), closes [#6566](https://github.com/IBM/kui/issues/6566) [#6532](https://github.com/IBM/kui/issues/6532)
- initial support for capturing input files and showing them in the UI ([5744bf4](https://github.com/IBM/kui/commit/5744bf4)), closes [#5513](https://github.com/IBM/kui/issues/5513)
- initial typeahead for commands ([7ba313a](https://github.com/IBM/kui/commit/7ba313a)), closes [#5437](https://github.com/IBM/kui/issues/5437)
- inline sidecar ([2c3afeb](https://github.com/IBM/kui/commit/2c3afeb)), closes [#6007](https://github.com/IBM/kui/issues/6007)
- Move in OpenWhisk plugin from the external repo ([b9c5867](https://github.com/IBM/kui/commit/b9c5867)), closes [#6109](https://github.com/IBM/kui/issues/6109)
- notebook client ([4b64133](https://github.com/IBM/kui/commit/4b64133)), closes [#5501](https://github.com/IBM/kui/issues/5501)
- s3 plugin, and vfs ([970ba6e](https://github.com/IBM/kui/commit/970ba6e)), closes [#5319](https://github.com/IBM/kui/issues/5319)
- tutorial VFS ([6f2330e](https://github.com/IBM/kui/commit/6f2330e)), closes [#5441](https://github.com/IBM/kui/issues/5441)
- update CurrentContext widget to use Dropdown ([9520e5d](https://github.com/IBM/kui/commit/9520e5d)), closes [#6354](https://github.com/IBM/kui/issues/6354)
- use Monaco DiffEditor `kubectl diff` ([3157393](https://github.com/IBM/kui/commit/3157393))
- use new Dropdown status stripe for CurrentNamespace widget ([0f7648c](https://github.com/IBM/kui/commit/0f7648c)), closes [#6351](https://github.com/IBM/kui/issues/6351)
- UX: Use Dropdown for theme switcher ([6cc6a47](https://github.com/IBM/kui/commit/6cc6a47)), closes [#6347](https://github.com/IBM/kui/issues/6347)
- **plugins/plugin-ibmcloud:** initial CodeEngine support ([677faca](https://github.com/IBM/kui/commit/677faca)), closes [#5302](https://github.com/IBM/kui/issues/5302) [#5303](https://github.com/IBM/kui/issues/5303)
- **plugins/plugin-kubectl:** kubectl get -f can use Tree to present structured result ([f94a22f](https://github.com/IBM/kui/commit/f94a22f)), closes [#6136](https://github.com/IBM/kui/issues/6136)
- **plugins/plugin-kubectl:** Namespace Summary impl ([2d69d67](https://github.com/IBM/kui/commit/2d69d67)), closes [#5790](https://github.com/IBM/kui/issues/5790)
- add button to WatchPane to show table back in terminal ([dc22591](https://github.com/IBM/kui/commit/dc22591)), closes [#4530](https://github.com/IBM/kui/issues/4530)
- add capability to show welcome widget to new users in Terminal ([0c33e6e](https://github.com/IBM/kui/commit/0c33e6e)), closes [#4990](https://github.com/IBM/kui/issues/4990) [#5007](https://github.com/IBM/kui/issues/5007)
- add isSelected and Divider to log container selection menu ([59bdaa5](https://github.com/IBM/kui/commit/59bdaa5)), closes [#4647](https://github.com/IBM/kui/issues/4647)
- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Patternfly Breadcrumb support ([91e0504](https://github.com/IBM/kui/commit/91e0504)), closes [#4381](https://github.com/IBM/kui/issues/4381)
- add Retry button to sidecar toolbar when log streaming stopped abnormally ([47872f4](https://github.com/IBM/kui/commit/47872f4)), closes [#4755](https://github.com/IBM/kui/issues/4755)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add Stop Watching capability to WatchPane ([09043c1](https://github.com/IBM/kui/commit/09043c1)), closes [#4554](https://github.com/IBM/kui/issues/4554)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- allow users to select container in kubectl Logs ([f4304c5](https://github.com/IBM/kui/commit/f4304c5)), closes [#4627](https://github.com/IBM/kui/issues/4627)
- commands should be able to separate resource model fetch from view transformation functions ([e903bc7](https://github.com/IBM/kui/commit/e903bc7)), closes [#4437](https://github.com/IBM/kui/issues/4437)
- ibmcloud plugin ([aa0f72f](https://github.com/IBM/kui/commit/aa0f72f)), closes [#4353](https://github.com/IBM/kui/issues/4353)
- improve kubectl edit experience ([4c4a1c9](https://github.com/IBM/kui/commit/4c4a1c9)), closes [#4783](https://github.com/IBM/kui/issues/4783)
- improve rendering of kubectl subcommand help ([e36ed29](https://github.com/IBM/kui/commit/e36ed29)), closes [#4824](https://github.com/IBM/kui/issues/4824)
- initial popeye support ([9d62eeb](https://github.com/IBM/kui/commit/9d62eeb)), closes [#5265](https://github.com/IBM/kui/issues/5265)
- **plugins/plugin-git:** git branch should respond with RadioTable ([59a9213](https://github.com/IBM/kui/commit/59a9213)), closes [#5256](https://github.com/IBM/kui/issues/5256)
- clicking on events in watch table should drill down to events ([c6dc99f](https://github.com/IBM/kui/commit/c6dc99f)), closes [#5173](https://github.com/IBM/kui/issues/5173)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- initial odo catalog list enhancements ([8534267](https://github.com/IBM/kui/commit/8534267)), closes [#4485](https://github.com/IBM/kui/issues/4485)
- kubectl apply view-last-applied ([6d601ef](https://github.com/IBM/kui/commit/6d601ef)), closes [#4822](https://github.com/IBM/kui/issues/4822)
- kubectl edit via kui's editor ([414e813](https://github.com/IBM/kui/commit/414e813)), closes [#762](https://github.com/IBM/kui/issues/762)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- line highlights on editor save, used for k edit apply errors ([3efa6a5](https://github.com/IBM/kui/commit/3efa6a5)), closes [#4795](https://github.com/IBM/kui/issues/4795)
- MiniSplits ([70b8441](https://github.com/IBM/kui/commit/70b8441)), closes [#5112](https://github.com/IBM/kui/issues/5112)
- only enable WatchPane based on a feature flag ([eb80d0e](https://github.com/IBM/kui/commit/eb80d0e)), closes [#4678](https://github.com/IBM/kui/issues/4678) [#4604](https://github.com/IBM/kui/issues/4604)
- pin a watchable terminal response in a split pane ([662f413](https://github.com/IBM/kui/commit/662f413)), closes [#4865](https://github.com/IBM/kui/issues/4865) [#4573](https://github.com/IBM/kui/issues/4573) [#4885](https://github.com/IBM/kui/issues/4885) [#4894](https://github.com/IBM/kui/issues/4894)
- refine kubectl contexts table; add support for RadioTable row titles ([11bb074](https://github.com/IBM/kui/commit/11bb074)), closes [#5131](https://github.com/IBM/kui/issues/5131)
- show resource version in toolbar text ([1a6e335](https://github.com/IBM/kui/commit/1a6e335)), closes [#4790](https://github.com/IBM/kui/issues/4790)
- split screen Terminal ([3a6b422](https://github.com/IBM/kui/commit/3a6b422)), closes [#4814](https://github.com/IBM/kui/issues/4814) [#4821](https://github.com/IBM/kui/issues/4821)
- support for events in crud table footer ([0b90ead](https://github.com/IBM/kui/commit/0b90ead)), closes [#5125](https://github.com/IBM/kui/issues/5125)
- support for events in table footer ([51669af](https://github.com/IBM/kui/commit/51669af)), closes [#5115](https://github.com/IBM/kui/issues/5115)
- **plugins/plugin-kubectl:** add Show Node button for kubectl pods ([04e29d2](https://github.com/IBM/kui/commit/04e29d2)), closes [#4214](https://github.com/IBM/kui/issues/4214)
- **plugins/plugin-kubectl:** add support for kustomize apply/delete/create ([b95cbdb](https://github.com/IBM/kui/commit/b95cbdb)), closes [#4203](https://github.com/IBM/kui/issues/4203)
- **plugins/plugin-kubectl:** configmap summary should show data ([50c7e10](https://github.com/IBM/kui/commit/50c7e10)), closes [#4025](https://github.com/IBM/kui/issues/4025)
- **plugins/plugin-kubectl:** enhance odo project list as RadioTable ([62272e6](https://github.com/IBM/kui/commit/62272e6)), closes [#4517](https://github.com/IBM/kui/issues/4517)
- **plugins/plugin-kubectl:** improve odo usage experience ([639ca32](https://github.com/IBM/kui/commit/639ca32)), closes [#4345](https://github.com/IBM/kui/issues/4345)
- **plugins/plugin-kubectl:** kubectl events tab ([2d71f24](https://github.com/IBM/kui/commit/2d71f24)), closes [#4706](https://github.com/IBM/kui/issues/4706)
- **plugins/plugin-kubectl:** namespace onclick should drill down to sidecar ([e74f66d](https://github.com/IBM/kui/commit/e74f66d)), closes [#4714](https://github.com/IBM/kui/issues/4714)
- **plugins/plugin-kubectl:** optimize rendering of kubectl Summary tab ([7c6480d](https://github.com/IBM/kui/commit/7c6480d)), closes [#4725](https://github.com/IBM/kui/issues/4725)
- **plugins/plugin-kubectl:** optimizing Node summary impl ([8ac11b9](https://github.com/IBM/kui/commit/8ac11b9)), closes [#4833](https://github.com/IBM/kui/issues/4833)
- **plugins/plugin-kubectl:** port kubectl contexts table to RadioTable ([3cb4dcb](https://github.com/IBM/kui/commit/3cb4dcb)), closes [#4513](https://github.com/IBM/kui/issues/4513)
- **plugins/plugin-kubectl:** Show Previous option for Logs tab ([2307d2f](https://github.com/IBM/kui/commit/2307d2f)), closes [#4864](https://github.com/IBM/kui/issues/4864)
- patternfly4 themes ([5f58f71](https://github.com/IBM/kui/commit/5f58f71)), closes [#4364](https://github.com/IBM/kui/issues/4364)
- simplified co-hosting of client and proxy in a container ([00af4b4](https://github.com/IBM/kui/commit/00af4b4)), closes [#4213](https://github.com/IBM/kui/issues/4213)
- SPI for icons ([3d034e3](https://github.com/IBM/kui/commit/3d034e3)), closes [#4441](https://github.com/IBM/kui/issues/4441) [#4364](https://github.com/IBM/kui/issues/4364)
- target kubectl logs and kubectl exec to Logs and Terminal tabs ([409e632](https://github.com/IBM/kui/commit/409e632)), closes [#4762](https://github.com/IBM/kui/issues/4762)
- **plugins/plugin-kubectl:** Terminal tab for Pod kubernetes resources ([c47e432](https://github.com/IBM/kui/commit/c47e432)), closes [#4639](https://github.com/IBM/kui/issues/4639)
- port kubectl get ns to RadioTable ([be0eabf](https://github.com/IBM/kui/commit/be0eabf)), closes [#4510](https://github.com/IBM/kui/issues/4510) [#4511](https://github.com/IBM/kui/issues/4511)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- top tab buttons ([ff8cfba](https://github.com/IBM/kui/commit/ff8cfba)), closes [#4434](https://github.com/IBM/kui/issues/4434)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)
- watcher panel for open-ended watch jobs ([6dfe7df](https://github.com/IBM/kui/commit/6dfe7df)), closes [#4503](https://github.com/IBM/kui/issues/4503)
- **plugins/plugin-kubectl:** ReplicaSet should have Pods tab ([42cd286](https://github.com/IBM/kui/commit/42cd286)), closes [#4110](https://github.com/IBM/kui/issues/4110)
- **plugins/plugin-kubectl:** restore Show Logs button for kubectl ([6b17dbd](https://github.com/IBM/kui/commit/6b17dbd)), closes [#4089](https://github.com/IBM/kui/issues/4089)

### BREAKING CHANGES

- removes support for inBrowserOk

# [10.2.0](https://github.com/IBM/kui/compare/v10.1.1-dev-20210223-062039...v10.2.0) (2021-02-24)

**Note:** Version bump only for package @kui-shell/plugin-kubectl

## [10.1.1-dev-20210223-062039](https://github.com/IBM/kui/compare/v10.1.1-dev-20210221-141404...v10.1.1-dev-20210223-062039) (2021-02-23)

**Note:** Version bump only for package @kui-shell/plugin-kubectl

## [10.1.1-dev-20210221-141404](https://github.com/IBM/kui/compare/v10.1.1-dev-20210219-194602...v10.1.1-dev-20210221-141404) (2021-02-21)

### Features

- group namespaces by internal/regular in CurrentNamespace ([be2d98f](https://github.com/IBM/kui/commit/be2d98f)), closes [#7058](https://github.com/IBM/kui/issues/7058)

## [10.1.1-dev-20210219-194602](https://github.com/IBM/kui/compare/v10.1.1-dev-20210218-202429...v10.1.1-dev-20210219-194602) (2021-02-20)

### Bug Fixes

- **plugins/plugin-kubectl:** Kui should fall back to Kubectl CLI when kubernetes direct accesss fails ([82d842f](https://github.com/IBM/kui/commit/82d842f)), closes [#7050](https://github.com/IBM/kui/issues/7050)

### Features

- **plugins/plugin-kubectl:** use `oc proxy` when talking to openshift clusters ([c07e5a0](https://github.com/IBM/kui/commit/c07e5a0)), closes [#7048](https://github.com/IBM/kui/issues/7048)

## [10.1.1-dev-20210218-202429](https://github.com/IBM/kui/compare/v10.1.1-dev-20210218-164854...v10.1.1-dev-20210218-202429) (2021-02-19)

**Note:** Version bump only for package @kui-shell/plugin-kubectl

## [10.1.1-dev-20210218-164854](https://github.com/IBM/kui/compare/v10.1.1-dev-20210218-131731...v10.1.1-dev-20210218-164854) (2021-02-18)

### Bug Fixes

- kui fails to show numeric namespace for kubectl config commands ([f424b5e](https://github.com/IBM/kui/commit/f424b5e)), closes [#7032](https://github.com/IBM/kui/issues/7032)

### Features

- **plugins/plugin-kubectl:** CLI-based kubectl polling does not allow for flexible overrides of the command prefix ([1e3d60f](https://github.com/IBM/kui/commit/1e3d60f)), closes [#7042](https://github.com/IBM/kui/issues/7042)

## [10.1.1-dev-20210218-131731](https://github.com/IBM/kui/compare/v10.1.1-dev-20210216-094031...v10.1.1-dev-20210218-131731) (2021-02-18)

### Bug Fixes

- `kubectl create ns 1` fails with status/direct ([e3d4a9c](https://github.com/IBM/kui/commit/e3d4a9c)), closes [#7016](https://github.com/IBM/kui/issues/7016)

### Features

- add typeahead to kubernetes context and namespace select widget ([ff9d273](https://github.com/IBM/kui/commit/ff9d273)), closes [#7034](https://github.com/IBM/kui/issues/7034)
- use Select Component for Kubernetes Context and Namespace status stripe widgets ([0e1c25e](https://github.com/IBM/kui/commit/0e1c25e)), closes [#6920](https://github.com/IBM/kui/issues/6920)

## [10.1.1-dev-20210216-094031](https://github.com/IBM/kui/compare/v10.1.1-dev-20210215-213847...v10.1.1-dev-20210216-094031) (2021-02-16)

### Bug Fixes

- **plugins/plugin-kubectl:** kubectl watch commands that are sent to the CLI don't watch ([d4ea65b](https://github.com/IBM/kui/commit/d4ea65b)), closes [#7025](https://github.com/IBM/kui/issues/7025)

## [10.1.1-dev-20210215-213847](https://github.com/IBM/kui/compare/v10.1.1-dev-20210215-184959...v10.1.1-dev-20210215-213847) (2021-02-16)

### Bug Fixes

- **plugins/plugin-kubectl:** Kui fetches wrong content when command line specifies --context or --kubeconfig ([7d7d273](https://github.com/IBM/kui/commit/7d7d273)), closes [#7023](https://github.com/IBM/kui/issues/7023)

## [10.1.1-dev-20210215-184959](https://github.com/IBM/kui/compare/v10.1.1-dev-20210215-161454...v10.1.1-dev-20210215-184959) (2021-02-15)

**Note:** Version bump only for package @kui-shell/plugin-kubectl

## [10.1.1-dev-20210215-161454](https://github.com/IBM/kui/compare/v10.1.1-dev-20210211-145439...v10.1.1-dev-20210215-161454) (2021-02-15)

### Features

- **plugins/plugin-kubectl:** Enhance kubectl direct get to support custom columns ([4762dd8](https://github.com/IBM/kui/commit/4762dd8)), closes [#7014](https://github.com/IBM/kui/issues/7014)

## [10.1.1-dev-20210211-145439](https://github.com/IBM/kui/compare/v4.5.0...v10.1.1-dev-20210211-145439) (2021-02-11)

### Bug Fixes

- **plugins/plugin-client-common:** onclick handlers for ls should respond only to clicking on text ([8477386](https://github.com/IBM/kui/commit/8477386)), closes [#6567](https://github.com/IBM/kui/issues/6567)
- **plugins/plugin-client-common:** show table click result in a new split ([fd1b3a1](https://github.com/IBM/kui/commit/fd1b3a1)), closes [#6477](https://github.com/IBM/kui/issues/6477)
- **plugins/plugin-client-common:** Table onclick handlers applied to every cell ([d5a9c3a](https://github.com/IBM/kui/commit/d5a9c3a)), closes [#6792](https://github.com/IBM/kui/issues/6792)
- **plugins/plugin-kubectl:** `k get all` with direct/get doesn't fail back to the old impl of get ([bdc3446](https://github.com/IBM/kui/commit/bdc3446)), closes [#6643](https://github.com/IBM/kui/issues/6643)
- **plugins/plugin-kubectl:** `k get all` with direct/get doesn't fail back to the old impl of get ([a2c0c2b](https://github.com/IBM/kui/commit/a2c0c2b)), closes [#6643](https://github.com/IBM/kui/issues/6643)
- **plugins/plugin-kubectl:** `oc login` does not invalidate the kubectl proxy ([3105e9a](https://github.com/IBM/kui/commit/3105e9a)), closes [#6955](https://github.com/IBM/kui/issues/6955)
- **plugins/plugin-kubectl:** direct operations fail if err.message is not JSON ([c5dc825](https://github.com/IBM/kui/commit/c5dc825)), closes [#6653](https://github.com/IBM/kui/issues/6653)
- **plugins/plugin-kubectl:** direct tables in splits are not hiding columns correctly ([5cc6cfc](https://github.com/IBM/kui/commit/5cc6cfc)), closes [#6484](https://github.com/IBM/kui/issues/6484)
- **plugins/plugin-kubectl:** direct watcher improperly formats event url ([d9717ff](https://github.com/IBM/kui/commit/d9717ff)), closes [#6593](https://github.com/IBM/kui/issues/6593)
- **plugins/plugin-kubectl:** direct/watch may update rows in a wrong order ([c0e5e17](https://github.com/IBM/kui/commit/c0e5e17)), closes [#6642](https://github.com/IBM/kui/issues/6642)
- **plugins/plugin-kubectl:** event watcher doesn't render well in minisplit ([56176de](https://github.com/IBM/kui/commit/56176de)), closes [#6772](https://github.com/IBM/kui/issues/6772)
- **plugins/plugin-kubectl:** events watching returns an empty table with just a streaming events footer ([fbeae76](https://github.com/IBM/kui/commit/fbeae76)), closes [#2771](https://github.com/IBM/kui/issues/2771)
- **plugins/plugin-kubectl:** fetchFileString aggressively calls toString on all objects ([027b279](https://github.com/IBM/kui/commit/027b279)), closes [#6941](https://github.com/IBM/kui/issues/6941)
- **plugins/plugin-kubectl:** get without kind doesn't fail back to the old get impl ([e85af25](https://github.com/IBM/kui/commit/e85af25)), closes [#6719](https://github.com/IBM/kui/issues/6719)
- **plugins/plugin-kubectl:** get-direct does not support field-selectors ([85b849c](https://github.com/IBM/kui/commit/85b849c)), closes [#6473](https://github.com/IBM/kui/issues/6473)
- **plugins/plugin-kubectl:** helm test can fail due to helm release name exceeding 63 characters ([a9903ea](https://github.com/IBM/kui/commit/a9903ea)), closes [#6377](https://github.com/IBM/kui/issues/6377)
- **plugins/plugin-kubectl:** heterogeneous apply tables lack a breadcrumb ([ee0bd2b](https://github.com/IBM/kui/commit/ee0bd2b)), closes [#6512](https://github.com/IBM/kui/issues/6512)
- **plugins/plugin-kubectl:** heterogeneous get unifies table incorrectly when some resources have label ([a5dab2e](https://github.com/IBM/kui/commit/a5dab2e)), closes [#6672](https://github.com/IBM/kui/issues/6672) [#6676](https://github.com/IBM/kui/issues/6676)
- **plugins/plugin-kubectl:** k api-resources | grep events has odd error message ([338ae2f](https://github.com/IBM/kui/commit/338ae2f)), closes [#6838](https://github.com/IBM/kui/issues/6838)
- **plugins/plugin-kubectl:** k logs has bad error message ([d1afe30](https://github.com/IBM/kui/commit/d1afe30)), closes [#6740](https://github.com/IBM/kui/issues/6740)
- **plugins/plugin-kubectl:** kubectl delete poller may get stuck Green ([c1d7662](https://github.com/IBM/kui/commit/c1d7662)), closes [#6436](https://github.com/IBM/kui/issues/6436)
- **plugins/plugin-kubectl:** kubectl direct status watcher can get stuck ([2346ce2](https://github.com/IBM/kui/commit/2346ce2)), closes [#6514](https://github.com/IBM/kui/issues/6514)
- **plugins/plugin-kubectl:** kubectl direct streaming fails to register a stream.on('error') ([44a6038](https://github.com/IBM/kui/commit/44a6038)), closes [#6616](https://github.com/IBM/kui/issues/6616)
- **plugins/plugin-kubectl:** kubectl direct watcher does not properly filter events and resource updates ([be9e308](https://github.com/IBM/kui/commit/be9e308)), closes [#6599](https://github.com/IBM/kui/issues/6599)
- **plugins/plugin-kubectl:** kubectl get events -o wide shows incorrect Last Seen column ([b24990b](https://github.com/IBM/kui/commit/b24990b)), closes [#6796](https://github.com/IBM/kui/issues/6796)
- **plugins/plugin-kubectl:** kubectl kustomize does not handle ~ home directory expansion ([f124b1d](https://github.com/IBM/kui/commit/f124b1d)), closes [#6115](https://github.com/IBM/kui/issues/6115)
- **plugins/plugin-kubectl:** kubectl sourceRef fetching is expensive ([f6539c5](https://github.com/IBM/kui/commit/f6539c5)), closes [#6662](https://github.com/IBM/kui/issues/6662)
- **plugins/plugin-kubectl:** kubectl watch commands without resource names won't show Added updates ([64442b3](https://github.com/IBM/kui/commit/64442b3)), closes [#6630](https://github.com/IBM/kui/issues/6630)
- **plugins/plugin-kubectl:** kubernetes test input pod.yaml has a container named "name" ([6ac5210](https://github.com/IBM/kui/commit/6ac5210)), closes [#6907](https://github.com/IBM/kui/issues/6907)
- **plugins/plugin-kubectl:** make sure to pick the last specified label selector ([7d44bcb](https://github.com/IBM/kui/commit/7d44bcb)), closes [#6840](https://github.com/IBM/kui/issues/6840)
- **plugins/plugin-kubectl:** multikind table isn't unified correctly when some rows are offline ([dd02cde](https://github.com/IBM/kui/commit/dd02cde)), closes [#6865](https://github.com/IBM/kui/issues/6865)
- **plugins/plugin-kubectl:** new kubectl event watching logic may drop events ([d46f591](https://github.com/IBM/kui/commit/d46f591)), closes [#6451](https://github.com/IBM/kui/issues/6451)
- **plugins/plugin-kubectl:** Remove unused css from plugin-kubectl ([4d65051](https://github.com/IBM/kui/commit/4d65051)), closes [#6902](https://github.com/IBM/kui/issues/6902)
- **plugins/plugin-kubectl:** replace Sidecar Events Mode with a toolbar button to show events table in REPL ([ccc47d0](https://github.com/IBM/kui/commit/ccc47d0)), closes [#6847](https://github.com/IBM/kui/issues/6847)
- drilldown from an undeployed application in tree will issue a kubectl get with 404 ([309a9a0](https://github.com/IBM/kui/commit/309a9a0)), closes [#6331](https://github.com/IBM/kui/issues/6331)
- kubectl contexts table has odd CURRENT column ([f6d0a98](https://github.com/IBM/kui/commit/f6d0a98)), closes [#6523](https://github.com/IBM/kui/issues/6523)
- kubectl direct streaming fails to register a stream.on('error') ([fd9fbf6](https://github.com/IBM/kui/commit/fd9fbf6)), closes [#6616](https://github.com/IBM/kui/issues/6616)
- kubectl direct/get does not specify that get tables have the `onclickIdempotent` property ([31361ec](https://github.com/IBM/kui/commit/31361ec)), closes [#6778](https://github.com/IBM/kui/issues/6778)
- **plugins/plugin-kubectl:** plugin-kubectl's fetch-file, when using electron, does not have error handling ([b45a818](https://github.com/IBM/kui/commit/b45a818)), closes [#6426](https://github.com/IBM/kui/issues/6426)
- **plugins/plugin-kubectl:** show SourceRef when creating heterogeneous resources ([adb21c5](https://github.com/IBM/kui/commit/adb21c5)), closes [#6640](https://github.com/IBM/kui/issues/6640)
- kubectl get -f --watch doesn't watch ([e45e8ee](https://github.com/IBM/kui/commit/e45e8ee)), closes [#6588](https://github.com/IBM/kui/issues/6588)
- kubectl kustomize can have bogus output ([8bf8ebe](https://github.com/IBM/kui/commit/8bf8ebe)), closes [#6114](https://github.com/IBM/kui/issues/6114)
- kubectl Terminal tab test is flakey ([5e28860](https://github.com/IBM/kui/commit/5e28860)), closes [#6636](https://github.com/IBM/kui/issues/6636)
- **plugins/plugin-kubectl:** kubectl get-all-namespaces test is unreliable ([a0e44a3](https://github.com/IBM/kui/commit/a0e44a3)), closes [#6561](https://github.com/IBM/kui/issues/6561)
- **plugins/plugin-kubectl:** kubectl proxy manager may create a new proxy too often ([72d9d5d](https://github.com/IBM/kui/commit/72d9d5d)), closes [#6462](https://github.com/IBM/kui/issues/6462)
- **plugins/plugin-kubectl:** kubernetes namespace list does not update after namespace deletion ([c28c800](https://github.com/IBM/kui/commit/c28c800)), closes [#6521](https://github.com/IBM/kui/issues/6521)
- **plugins/plugin-kubectl:** Switching from kubectl logs tab to another tab causes uncaught exception ([d3f6770](https://github.com/IBM/kui/commit/d3f6770)), closes [#6585](https://github.com/IBM/kui/issues/6585)
- remove TreeResponse and PatternFly Tree Component ([e539a53](https://github.com/IBM/kui/commit/e539a53)), closes [#6581](https://github.com/IBM/kui/issues/6581) [#6328](https://github.com/IBM/kui/issues/6328)
- **plugins/plugin-kubectl:** new kubectl direct logic does not properly handle ECONNREFUSED ([96eefdb](https://github.com/IBM/kui/commit/96eefdb)), closes [#6476](https://github.com/IBM/kui/issues/6476)
- **plugins/plugin-kubectl:** use PaginatedTable instead of RadioTable for `contexts` and `get namespaces` commands ([20f0737](https://github.com/IBM/kui/commit/20f0737)), closes [#6517](https://github.com/IBM/kui/issues/6517)
- compilation failures due perhaps to typescript 4.1.3 upgrade?? ([d06824b](https://github.com/IBM/kui/commit/d06824b)), closes [#6432](https://github.com/IBM/kui/issues/6432)
- events in tree are presented out of temporal order ([b3ba61e](https://github.com/IBM/kui/commit/b3ba61e)), closes [#6168](https://github.com/IBM/kui/issues/6168)
- kubectl watcher should auto-terminate, if given a bound up front ([1a94094](https://github.com/IBM/kui/commit/1a94094)), closes [#6417](https://github.com/IBM/kui/issues/6417)
- monaco diff view colors are not themed ([eed2527](https://github.com/IBM/kui/commit/eed2527)), closes [#6232](https://github.com/IBM/kui/issues/6232)
- refine tree label categoriazation of kubectl ([1973a43](https://github.com/IBM/kui/commit/1973a43)), closes [#6185](https://github.com/IBM/kui/issues/6185)
- s3 job watcher sometimes fails due to startup issues ([8851d50](https://github.com/IBM/kui/commit/8851d50)), closes [#6411](https://github.com/IBM/kui/issues/6411)
- **plugins/plugin-client-common:** clicking the split button may cause the current processing block to disappear ([aa2b40c](https://github.com/IBM/kui/commit/aa2b40c)), closes [#5703](https://github.com/IBM/kui/issues/5703)
- **plugins/plugin-client-common:** don't offer Grid option for 1-row tables ([a2a6f8d](https://github.com/IBM/kui/commit/a2a6f8d)), closes [#5474](https://github.com/IBM/kui/issues/5474)
- **plugins/plugin-client-common:** isReplay bit on Blocks is not set for snapshots ([c6d1633](https://github.com/IBM/kui/commit/c6d1633)), closes [#5868](https://github.com/IBM/kui/issues/5868)
- **plugins/plugin-client-common:** SequenceDiagram UI refinements ([5d8c3f7](https://github.com/IBM/kui/commit/5d8c3f7)), closes [#5557](https://github.com/IBM/kui/issues/5557)
- **plugins/plugin-client-common:** update welcome.json to describe kui, not just notebooks ([96330c4](https://github.com/IBM/kui/commit/96330c4)), closes [#5878](https://github.com/IBM/kui/issues/5878)
- **plugins/plugin-kubectl:** "logs dashC follow via table" test is unreliable after electron 10 update ([72c50ab](https://github.com/IBM/kui/commit/72c50ab)), closes [#6152](https://github.com/IBM/kui/issues/6152)
- **plugins/plugin-kubectl:** isReplicaSet needs to be updated to handle "apps/v1" apiVersion ([6887a0d](https://github.com/IBM/kui/commit/6887a0d)), closes [#6003](https://github.com/IBM/kui/issues/6003)
- **plugins/plugin-kubectl:** k8s table should display status Propagated and Subscribed as green ([0787b4b](https://github.com/IBM/kui/commit/0787b4b)), closes [#5818](https://github.com/IBM/kui/issues/5818)
- **plugins/plugin-kubectl:** kubectl delete ns m1 m2 m3 m4 results in a one-row table ([97a33a4](https://github.com/IBM/kui/commit/97a33a4)), closes [#5694](https://github.com/IBM/kui/issues/5694)
- **plugins/plugin-kubectl:** kubectl Deployment summary does not handle `undefined` fields ([0f65c3c](https://github.com/IBM/kui/commit/0f65c3c)), closes [#6028](https://github.com/IBM/kui/issues/6028)
- **plugins/plugin-kubectl:** kubectl status table does not register onclickIdempotent ([6ae296c](https://github.com/IBM/kui/commit/6ae296c)), closes [#5788](https://github.com/IBM/kui/issues/5788)
- **plugins/plugin-kubectl:** kubectl table should show PropagationFailed status as offline ([a44b70c](https://github.com/IBM/kui/commit/a44b70c)), closes [#5821](https://github.com/IBM/kui/issues/5821)
- **plugins/plugin-kubectl:** kubernetes CurrentContext widget may display as empty ([640263c](https://github.com/IBM/kui/commit/640263c)), closes [#6392](https://github.com/IBM/kui/issues/6392)
- tree should support leaf node drilling down ([006b881](https://github.com/IBM/kui/commit/006b881)), closes [#6293](https://github.com/IBM/kui/issues/6293)
- tweak the toolbar text and button label of `k get -f` tree ([ad476c5](https://github.com/IBM/kui/commit/ad476c5)), closes [#6303](https://github.com/IBM/kui/issues/6303)
- update kubectl/notebooks/deploy-applications for the Mode Toolbar change ([164244e](https://github.com/IBM/kui/commit/164244e)), closes [#6385](https://github.com/IBM/kui/issues/6385)
- **plugins/plugin-kubectl:** kui semi-ignores --dry-run for kubectl apply ([90c329f](https://github.com/IBM/kui/commit/90c329f)), closes [#6106](https://github.com/IBM/kui/issues/6106)
- **plugins/plugin-kubectl:** regenerate kubernetes notebooks to show new Source Reference feature ([8324567](https://github.com/IBM/kui/commit/8324567)), closes [#5520](https://github.com/IBM/kui/issues/5520)
- **plugins/plugin-kubectl:** the Deploy Applications notebook has some typos ([817f9b7](https://github.com/IBM/kui/commit/817f9b7)), closes [#6256](https://github.com/IBM/kui/issues/6256)
- **plugins/plugin-kubectl:** typos in Tree Toolbar text ([0d9a6be](https://github.com/IBM/kui/commit/0d9a6be)), closes [#6514](https://github.com/IBM/kui/issues/6514)
- (plugins/plugin-kubectl): kubectl get pod -w --all-namespaces behaves oddly ([12e578a](https://github.com/IBM/kui/commit/12e578a)), closes [#5169](https://github.com/IBM/kui/issues/5169)
- avoid excessive status stripe overheads when replaying Notebooks ([58de9c0](https://github.com/IBM/kui/commit/58de9c0)), closes [#5635](https://github.com/IBM/kui/issues/5635)
- don't show "Created a split" when clicking on the New Split button ([80192d5](https://github.com/IBM/kui/commit/80192d5)), closes [#6001](https://github.com/IBM/kui/issues/6001)
- grid colors are sometimes off ([e66f56f](https://github.com/IBM/kui/commit/e66f56f)), closes [#5422](https://github.com/IBM/kui/issues/5422)
- improve existing notebooks for v1 ([1af5cc2](https://github.com/IBM/kui/commit/1af5cc2)), closes [#5858](https://github.com/IBM/kui/issues/5858)
- improve the discoverability of repl-block action buttons ([470da34](https://github.com/IBM/kui/commit/470da34)), closes [#5604](https://github.com/IBM/kui/issues/5604)
- improve the replayability of terminal splitting ([67811cd](https://github.com/IBM/kui/commit/67811cd)), closes [#5564](https://github.com/IBM/kui/issues/5564)
- JS console may contain xtermjs error messages when sidecar is minimized ([a568528](https://github.com/IBM/kui/commit/a568528)), closes [#5454](https://github.com/IBM/kui/issues/5454)
- RadioTables are not replayable ([d0dd00e](https://github.com/IBM/kui/commit/d0dd00e)), closes [#5599](https://github.com/IBM/kui/issues/5599)
- restore status stripe to default behavior on terminal clear ([128ec92](https://github.com/IBM/kui/commit/128ec92)), closes [#5495](https://github.com/IBM/kui/issues/5495)
- sidecar shouldn't be opened automatically when replay ([8d4cf8c](https://github.com/IBM/kui/commit/8d4cf8c)), closes [#5730](https://github.com/IBM/kui/issues/5730)
- snapshot and replay of table clicks for Notebook v1 ([1a87dbf](https://github.com/IBM/kui/commit/1a87dbf)), closes [#5821](https://github.com/IBM/kui/issues/5821)
- snapshot command fails at `k get -o yaml` ([fe53fb0](https://github.com/IBM/kui/commit/fe53fb0)), closes [#5458](https://github.com/IBM/kui/issues/5458)
- snapshot command throws errors when capturing watch responses ([600f049](https://github.com/IBM/kui/commit/600f049)), closes [#5452](https://github.com/IBM/kui/issues/5452)
- store the commentary text result to the command when editing is done ([5a3f5e8](https://github.com/IBM/kui/commit/5a3f5e8)), closes [#5916](https://github.com/IBM/kui/issues/5916) [#5672](https://github.com/IBM/kui/issues/5672)
- UI glitches of Tree ([fc5af7a](https://github.com/IBM/kui/commit/fc5af7a)), closes [#6138](https://github.com/IBM/kui/issues/6138)
- **plugins/plugin-client-common:** for now, switch interval chart to duration chart ([ea21221](https://github.com/IBM/kui/commit/ea21221)), closes [#5340](https://github.com/IBM/kui/issues/5340)
- **plugins/plugin-client-common:** Grid regression: grid colors not right ([d1aa46d](https://github.com/IBM/kui/commit/d1aa46d)), closes [#5285](https://github.com/IBM/kui/issues/5285)
- **plugins/plugin-client-common:** improve display of empty watch tables ([4cc16be](https://github.com/IBM/kui/commit/4cc16be)), closes [#5176](https://github.com/IBM/kui/issues/5176)
- **plugins/plugin-client-common:** kubectl watch is broken for server versions >= 1.17 ([2d595b7](https://github.com/IBM/kui/commit/2d595b7)), closes [#5360](https://github.com/IBM/kui/issues/5360)
- **plugins/plugin-kubectl:** `oc get namespaces` doesn't produce a RadioTable ([6ea6131](https://github.com/IBM/kui/commit/6ea6131)), closes [#5227](https://github.com/IBM/kui/issues/5227)
- **plugins/plugin-kubectl:** add Summary impl for kubernetes Jobs ([b0f3809](https://github.com/IBM/kui/commit/b0f3809)), closes [#5481](https://github.com/IBM/kui/issues/5481)
- **plugins/plugin-kubectl:** add traffic light colors for OOMKilled and UnexpectedAdmissionError ([4262409](https://github.com/IBM/kui/commit/4262409)), closes [#5345](https://github.com/IBM/kui/issues/5345)
- **plugins/plugin-kubectl:** certain filepath options to kubectl were not tilde-expanded ([9e7f858](https://github.com/IBM/kui/commit/9e7f858)), closes [#5415](https://github.com/IBM/kui/issues/5415)
- **plugins/plugin-kubectl:** CurrentNamespace/Context widgets not live ([93ac829](https://github.com/IBM/kui/commit/93ac829)), closes [#5144](https://github.com/IBM/kui/issues/5144)
- **plugins/plugin-kubectl:** drilldown command of resources in watch --all-namespace table doesn't have '-o yaml' ([1e4f558](https://github.com/IBM/kui/commit/1e4f558)), closes [#5208](https://github.com/IBM/kui/issues/5208)
- **plugins/plugin-kubectl:** event footer watching should also support named resources ([e3a842b](https://github.com/IBM/kui/commit/e3a842b)), closes [#5180](https://github.com/IBM/kui/issues/5180)
- **plugins/plugin-kubectl:** events in table appear to be in random order ([034dc06](https://github.com/IBM/kui/commit/034dc06)), closes [#5212](https://github.com/IBM/kui/issues/5212)
- **plugins/plugin-kubectl:** Fail should be TrafficLight.Red and Succeeded should be TrafficLight.Green ([54737b6](https://github.com/IBM/kui/commit/54737b6)), closes [#5351](https://github.com/IBM/kui/issues/5351)
- **plugins/plugin-kubectl:** header-only tables improperly parsed ([f56841b](https://github.com/IBM/kui/commit/f56841b)), closes [#5382](https://github.com/IBM/kui/issues/5382)
- **plugins/plugin-kubectl:** kubectl apply -f may not abort the event watcher ([c8df222](https://github.com/IBM/kui/commit/c8df222)), closes [#5149](https://github.com/IBM/kui/issues/5149)
- **plugins/plugin-kubectl:** kubectl get -f can show undefined in table title ([eb34d1c](https://github.com/IBM/kui/commit/eb34d1c)), closes [#5469](https://github.com/IBM/kui/issues/5469)
- **plugins/plugin-kubectl:** kubectl Logs/Events/Terminal tabs do not reflow on sidecar maximize ([6dbcbe8](https://github.com/IBM/kui/commit/6dbcbe8)), closes [#5417](https://github.com/IBM/kui/issues/5417)
- **plugins/plugin-kubectl:** kubectl tab completion does not let me tab-complete some filepaths ([e42daa7](https://github.com/IBM/kui/commit/e42daa7)), closes [#5413](https://github.com/IBM/kui/issues/5413)
- **plugins/plugin-kubectl:** kubectl watcher needs to pass through kubeconfig in its call to kubectl version ([a5d83a3](https://github.com/IBM/kui/commit/a5d83a3)), closes [#5368](https://github.com/IBM/kui/issues/5368)
- **plugins/plugin-kubectl:** kubernetes contexts table renders poorly ([e2ed7d8](https://github.com/IBM/kui/commit/e2ed7d8)), closes [#5230](https://github.com/IBM/kui/issues/5230)
- **plugins/plugin-kubectl:** Kui may invoke kubectl with duplicate command line options ([39c9d31](https://github.com/IBM/kui/commit/39c9d31)), closes [#5330](https://github.com/IBM/kui/issues/5330)
- **plugins/plugin-kubectl:** leftover debug printfs in table-watch ([407855a](https://github.com/IBM/kui/commit/407855a)), closes [#5317](https://github.com/IBM/kui/issues/5317)
- **plugins/plugin-kubectl:** nil and negative timestamps display as "0ms ago" ([641a599](https://github.com/IBM/kui/commit/641a599)), closes [#5136](https://github.com/IBM/kui/issues/5136)
- **plugins/plugin-kubectl:** oc get ns does not present a RadioTable ([9e28eec](https://github.com/IBM/kui/commit/9e28eec)), closes [#5106](https://github.com/IBM/kui/issues/5106)
- **plugins/plugin-kubectl:** Pod summary impl fails for pods with no containerStatuses ([66b21b5](https://github.com/IBM/kui/commit/66b21b5)), closes [#5192](https://github.com/IBM/kui/issues/5192)
- **plugins/plugin-kubectl:** unlabeled resources shouldn’t have badge for children's count ([4e1fea6](https://github.com/IBM/kui/commit/4e1fea6)), closes [#6243](https://github.com/IBM/kui/issues/6243)
- **plugins/plugin-kubectl:** update jobs notebook to latest SequenceDiagram ([8e70862](https://github.com/IBM/kui/commit/8e70862)), closes [#5862](https://github.com/IBM/kui/issues/5862)
- **plugins/plugin-kubectl:** Update list-resources notebook to use splits ([1f54515](https://github.com/IBM/kui/commit/1f54515)), closes [#5770](https://github.com/IBM/kui/issues/5770)
- **Plugins/plugin-kubectl:** Logs tab may become stale when switching away/back ([fcfdaba](https://github.com/IBM/kui/commit/fcfdaba)), closes [#6024](https://github.com/IBM/kui/issues/6024)
- CurrentContext and CurrentNamespace widgets may have stale data inBrowser ([ab77c20](https://github.com/IBM/kui/commit/ab77c20)), closes [#5097](https://github.com/IBM/kui/issues/5097)
- kubectl help misformats helm help tables ([ff36755](https://github.com/IBM/kui/commit/ff36755)), closes [#5080](https://github.com/IBM/kui/issues/5080)
- multiple issues with tab switching versus status stripe widgets ([8c8a6ec](https://github.com/IBM/kui/commit/8c8a6ec)), closes [#5101](https://github.com/IBM/kui/issues/5101)
- vfs fixes for multi-source copying and for s3 globbing ([893902e](https://github.com/IBM/kui/commit/893902e)), closes [#5511](https://github.com/IBM/kui/issues/5511)
- **plugins/plugin-client-common:** make Close a top-level button in watch panes ([3c14da5](https://github.com/IBM/kui/commit/3c14da5)), closes [#4945](https://github.com/IBM/kui/issues/4945)
- **plugins/plugin-kubectl:** changing ns via oc does not update ns widget, in browser clients ([5eaa625](https://github.com/IBM/kui/commit/5eaa625)), closes [#4953](https://github.com/IBM/kui/issues/4953)
- **plugins/plugin-kubectl:** kubectl apply/create/delete tables still have ALLCAPS headers ([90d72ce](https://github.com/IBM/kui/commit/90d72ce)), closes [#5068](https://github.com/IBM/kui/issues/5068)
- **plugins/plugin-kubectl:** kubectl explain subfields ([8fee2bc](https://github.com/IBM/kui/commit/8fee2bc)), closes [#4921](https://github.com/IBM/kui/issues/4921)
- **plugins/plugin-kubectl:** kubectl watch tables may lack namespace breadcrumb ([a0616c2](https://github.com/IBM/kui/commit/a0616c2)), closes [#4870](https://github.com/IBM/kui/issues/4870)
- **plugins/plugin-kubectl:** tolerate helm 3.0 and 3.1 help custom ascii art tables ([79f8640](https://github.com/IBM/kui/commit/79f8640)), closes [#5085](https://github.com/IBM/kui/issues/5085)
- allow user to disable table title by feature flags, and disable table pagination ([5450512](https://github.com/IBM/kui/commit/5450512)), closes [#4640](https://github.com/IBM/kui/issues/4640) [#4655](https://github.com/IBM/kui/issues/4655)
- avoid hard-coded use of /tmp in kubectl edit ([8e4cb70](https://github.com/IBM/kui/commit/8e4cb70)), closes [#4928](https://github.com/IBM/kui/issues/4928)
- avoid using kui-custom command for switching kubectl namespace ([43863f2](https://github.com/IBM/kui/commit/43863f2)), closes [#4806](https://github.com/IBM/kui/issues/4806)
- don't blink yellow forever for kubectl events ([a59ee86](https://github.com/IBM/kui/commit/a59ee86)), closes [#4869](https://github.com/IBM/kui/issues/4869)
- eliminate assumptions that "default" is the default kube namespace ([4eb392d](https://github.com/IBM/kui/commit/4eb392d)), closes [#4764](https://github.com/IBM/kui/issues/4764)
- empty watch tables/grids should show 'No resources' ([c0bfe99](https://github.com/IBM/kui/commit/c0bfe99)), closes [#4884](https://github.com/IBM/kui/issues/4884)
- improve hover effect for status stripe buttons ([50ced8f](https://github.com/IBM/kui/commit/50ced8f)), closes [#4896](https://github.com/IBM/kui/issues/4896)
- Input element throws react error ([e6bb21b](https://github.com/IBM/kui/commit/e6bb21b)), closes [#4765](https://github.com/IBM/kui/issues/4765)
- kubectl edit in sidecar doesn't show success message when a resource is applied ([cc59503](https://github.com/IBM/kui/commit/cc59503)), closes [#4691](https://github.com/IBM/kui/issues/4691)
- kubectl Logs tab should use an xterm ([9aa0176](https://github.com/IBM/kui/commit/9aa0176)), closes [#4750](https://github.com/IBM/kui/issues/4750) [#4747](https://github.com/IBM/kui/issues/4747)
- pexecs serviced by now-removed splits fail ([f6176a1](https://github.com/IBM/kui/commit/f6176a1)), closes [#4875](https://github.com/IBM/kui/issues/4875)
- reduce custom CSS rules for table UI ([56f69cb](https://github.com/IBM/kui/commit/56f69cb)), closes [#5024](https://github.com/IBM/kui/issues/5024)
- xterm alt buffer mode behaves oddly for clients that do not enable splitTerminals ([f1bc709](https://github.com/IBM/kui/commit/f1bc709)), closes [#5003](https://github.com/IBM/kui/issues/5003)
- **plugins/plugin-kubectl:** auto-pause logs when user scrolls ([94b85e6](https://github.com/IBM/kui/commit/94b85e6)), closes [#4668](https://github.com/IBM/kui/issues/4668)
- **plugins/plugin-kubectl:** automatically abort idle PTYs ([2638a65](https://github.com/IBM/kui/commit/2638a65)), closes [#4742](https://github.com/IBM/kui/issues/4742)
- **plugins/plugin-kubectl:** ExecIntoPod's terminal is not theme-aligned ([067cda3](https://github.com/IBM/kui/commit/067cda3)), closes [#4722](https://github.com/IBM/kui/issues/4722)
- **plugins/plugin-kubectl:** get-namespace table sometimes doens't show the correct selected namespace ([af66aa4](https://github.com/IBM/kui/commit/af66aa4)), closes [#4812](https://github.com/IBM/kui/issues/4812)
- **plugins/plugin-kubectl:** helm help parsed usage incorrectly ([b222da2](https://github.com/IBM/kui/commit/b222da2)), closes [#4692](https://github.com/IBM/kui/issues/4692)
- **plugins/plugin-kubectl:** i18n for No log data message ([589a4cd](https://github.com/IBM/kui/commit/589a4cd)), closes [#4656](https://github.com/IBM/kui/issues/4656)
- **plugins/plugin-kubectl:** ImagePullBackoff should be considered a "red" state ([198100d](https://github.com/IBM/kui/commit/198100d)), closes [#4734](https://github.com/IBM/kui/issues/4734)
- **plugins/plugin-kubectl:** improve kubectl tab completion ([734f9e5](https://github.com/IBM/kui/commit/734f9e5)), closes [#4704](https://github.com/IBM/kui/issues/4704)
- **plugins/plugin-kubectl:** improve kubectl top node display with open sidecar ([6f99581](https://github.com/IBM/kui/commit/6f99581)), closes [#4737](https://github.com/IBM/kui/issues/4737)
- **plugins/plugin-kubectl:** k edit -h does not open in sidecar ([b6f68f8](https://github.com/IBM/kui/commit/b6f68f8)), closes [#4661](https://github.com/IBM/kui/issues/4661)
- **plugins/plugin-kubectl:** k edit deploy has mysterious Pod tab ([914df36](https://github.com/IBM/kui/commit/914df36)), closes [#4703](https://github.com/IBM/kui/issues/4703)
- **plugins/plugin-kubectl:** kubectl api-resources table should hide APIGROUP column with open sidecar ([ee347fa](https://github.com/IBM/kui/commit/ee347fa)), closes [#4728](https://github.com/IBM/kui/issues/4728)
- **plugins/plugin-kubectl:** kubectl apply edit-last-applied freezes in kui ([24a67da](https://github.com/IBM/kui/commit/24a67da)), closes [#4808](https://github.com/IBM/kui/issues/4808)
- **plugins/plugin-kubectl:** kubectl apply set-last-applied does not work ([9553907](https://github.com/IBM/kui/commit/9553907)), closes [#4844](https://github.com/IBM/kui/issues/4844)
- **plugins/plugin-kubectl:** kubectl logs -l with no matches yields internal error ([ed0374f](https://github.com/IBM/kui/commit/ed0374f)), closes [#4811](https://github.com/IBM/kui/issues/4811)
- **plugins/plugin-kubectl:** kubectl logs tab has bad interleaving and cpu issues ([1c7cf17](https://github.com/IBM/kui/commit/1c7cf17)), closes [#4664](https://github.com/IBM/kui/issues/4664) [#4665](https://github.com/IBM/kui/issues/4665)
- **plugins/plugin-kubectl:** Logs tab should have a default tail limit ([d4cf08c](https://github.com/IBM/kui/commit/d4cf08c)), closes [#4810](https://github.com/IBM/kui/issues/4810) [#4818](https://github.com/IBM/kui/issues/4818)
- **plugins/plugin-kubectl:** oc get projects does not allow user selection ([3749371](https://github.com/IBM/kui/commit/3749371)), closes [#4805](https://github.com/IBM/kui/issues/4805)
- **plugins/plugin-kubectl:** oc logs does not work ([f0808a2](https://github.com/IBM/kui/commit/f0808a2)), closes [#4965](https://github.com/IBM/kui/issues/4965)
- **plugins/plugin-kubectl:** singleton breadcrumbs in kubectl help should not be clickable ([7815464](https://github.com/IBM/kui/commit/7815464)), closes [#4961](https://github.com/IBM/kui/issues/4961)
- **plugins/plugin-kubectl:** windows powershell fails to get default namespace ([a5fb2e1](https://github.com/IBM/kui/commit/a5fb2e1)), closes [#4912](https://github.com/IBM/kui/issues/4912)
- avoid recomputing tabs when switching back and forth ([cf5e41f](https://github.com/IBM/kui/commit/cf5e41f)), closes [#4666](https://github.com/IBM/kui/issues/4666)
- container filter of logs tab shows accumulated logs from previous selection ([08903b4](https://github.com/IBM/kui/commit/08903b4)), closes [#4644](https://github.com/IBM/kui/issues/4644) [#4658](https://github.com/IBM/kui/issues/4658)
- improve error reporting for kubectl apply ([fe21671](https://github.com/IBM/kui/commit/fe21671)), closes [#4605](https://github.com/IBM/kui/issues/4605)
- kubectl api-resources has duplicate rows and odd pagination behavior ([e740270](https://github.com/IBM/kui/commit/e740270)), closes [#4626](https://github.com/IBM/kui/issues/4626)
- kubectl edit apply twice does not work ([1976134](https://github.com/IBM/kui/commit/1976134)), closes [#4797](https://github.com/IBM/kui/issues/4797)
- logs tab toolbar doesn't signify when pods are 404 ([135e1be](https://github.com/IBM/kui/commit/135e1be)), closes [#4646](https://github.com/IBM/kui/issues/4646)
- place namespace breadcrumb first ([5d3b2e4](https://github.com/IBM/kui/commit/5d3b2e4)), closes [#4699](https://github.com/IBM/kui/issues/4699)
- reduce No log data followed by log data behavior in kube logs ([e1c0624](https://github.com/IBM/kui/commit/e1c0624)), closes [#4624](https://github.com/IBM/kui/issues/4624)
- remove augmentModuleLoadPath API ([47dfcdf](https://github.com/IBM/kui/commit/47dfcdf)), closes [#4839](https://github.com/IBM/kui/issues/4839)
- sidecar toolbar can't due justice to longer error messages ([e67e0c9](https://github.com/IBM/kui/commit/e67e0c9)), closes [#4789](https://github.com/IBM/kui/issues/4789)
- summary tab is not read-only for kubectl edit command ([9f7ff82](https://github.com/IBM/kui/commit/9f7ff82)), closes [#4809](https://github.com/IBM/kui/issues/4809)
- **plugins/plugin-kubectl:** remove Conditions tab ([eac3705](https://github.com/IBM/kui/commit/eac3705)), closes [#4606](https://github.com/IBM/kui/issues/4606)
- **plugins/plugin-kubectl:** remove kubectl edit cancel button ([83179e8](https://github.com/IBM/kui/commit/83179e8)), closes [#4695](https://github.com/IBM/kui/issues/4695)
- **plugins/plugin-kubectl:** remove Show Logs registration ([382c685](https://github.com/IBM/kui/commit/382c685)), closes [#4603](https://github.com/IBM/kui/issues/4603)
- **plugins/plugin-kubectl:** status shows as Containercreating when it should be ContainerCreating ([2c4a3b6](https://github.com/IBM/kui/commit/2c4a3b6)), closes [#4798](https://github.com/IBM/kui/issues/4798)
- **plugins/plugin-kubectl:** Terminal tab test incorrectly verifies k exec output ([20ab362](https://github.com/IBM/kui/commit/20ab362)), closes [#4802](https://github.com/IBM/kui/issues/4802)
- kubectl top node should show % text ([f861b76](https://github.com/IBM/kui/commit/f861b76)), closes [#4598](https://github.com/IBM/kui/issues/4598)
- replace Containers with Logs tab ([00e8786](https://github.com/IBM/kui/commit/00e8786)), closes [#4603](https://github.com/IBM/kui/issues/4603)
- the Logs/Terminal retry button should be visible on any exit code ([3366327](https://github.com/IBM/kui/commit/3366327)), closes [#4769](https://github.com/IBM/kui/issues/4769)
- **plugin-kubectl:** k get pods --all-namespaces has a title with "default" as the namespace ([2f95129](https://github.com/IBM/kui/commit/2f95129)), closes [#4466](https://github.com/IBM/kui/issues/4466)
- **plugin-kubectl:** kubectl get error-type -w doesn't fail fast ([4ccb733](https://github.com/IBM/kui/commit/4ccb733)), closes [#4491](https://github.com/IBM/kui/issues/4491)
- **plugins/plugin-kubectl:** add missing test for get with not found ([3e77689](https://github.com/IBM/kui/commit/3e77689)), closes [#4492](https://github.com/IBM/kui/issues/4492)
- **plugins/plugin-kubectl:** avoid use of /s regexp ([9468304](https://github.com/IBM/kui/commit/9468304)), closes [#4259](https://github.com/IBM/kui/issues/4259)
- **plugins/plugin-kubectl:** cache kind canonicalization lookup ([e351a5f](https://github.com/IBM/kui/commit/e351a5f)), closes [#4489](https://github.com/IBM/kui/issues/4489)
- **plugins/plugin-kubectl:** CurrentContext widget shows "default" for openshift clusters ([59712c0](https://github.com/IBM/kui/commit/59712c0)), closes [#4347](https://github.com/IBM/kui/issues/4347)
- **plugins/plugin-kubectl:** ensure Show Owner button appears near end of toolbar buttons ([224c586](https://github.com/IBM/kui/commit/224c586)), closes [#4124](https://github.com/IBM/kui/issues/4124)
- **plugins/plugin-kubectl:** firefox does not support the /s flag to RegExp ([5b661a6](https://github.com/IBM/kui/commit/5b661a6)), closes [#4206](https://github.com/IBM/kui/issues/4206)
- **plugins/plugin-kubectl:** in kube namespace table, selected namespace should float to top ([f0e597f](https://github.com/IBM/kui/commit/f0e597f)), closes [#4129](https://github.com/IBM/kui/issues/4129)
- **plugins/plugin-kubectl:** inconsistent capitalization of breadcrumbs ([963b166](https://github.com/IBM/kui/commit/963b166)), closes [#4607](https://github.com/IBM/kui/issues/4607)
- **plugins/plugin-kubectl:** k get events -w bombs ([20c2caf](https://github.com/IBM/kui/commit/20c2caf)), closes [#4557](https://github.com/IBM/kui/issues/4557)
- **plugins/plugin-kubectl:** kubectl api-resources table shows 'unknown' in title ([0461710](https://github.com/IBM/kui/commit/0461710)), closes [#4145](https://github.com/IBM/kui/issues/4145)
- **plugins/plugin-kubectl:** kubectl create secret hangs yellow ([e11dbb8](https://github.com/IBM/kui/commit/e11dbb8)), closes [#4571](https://github.com/IBM/kui/issues/4571)
- **plugins/plugin-kubectl:** kubectl describe -h has old bold text ([b31d066](https://github.com/IBM/kui/commit/b31d066)), closes [#4568](https://github.com/IBM/kui/issues/4568)
- **plugins/plugin-kubectl:** kubectl edit should support editing a list of resources ([4cd4d43](https://github.com/IBM/kui/commit/4cd4d43)), closes [#4555](https://github.com/IBM/kui/issues/4555)
- **plugins/plugin-kubectl:** kubectl explain -h should render as usage in sidecar ([8e00c3f](https://github.com/IBM/kui/commit/8e00c3f)), closes [#4211](https://github.com/IBM/kui/issues/4211)
- **plugins/plugin-kubectl:** kubectl explain Overview tab not formatted as expected ([ffa9183](https://github.com/IBM/kui/commit/ffa9183)), closes [#4304](https://github.com/IBM/kui/issues/4304)
- **plugins/plugin-kubectl:** kubectl get --all-namespaces --watch does not update ([663a972](https://github.com/IBM/kui/commit/663a972)), closes [#4581](https://github.com/IBM/kui/issues/4581)
- **plugins/plugin-kubectl:** kubectl Show Events query not precise enough ([eda6b38](https://github.com/IBM/kui/commit/eda6b38)), closes [#4572](https://github.com/IBM/kui/issues/4572)
- **plugins/plugin-kubectl:** revert to editor-based Summary tab ([3ecd638](https://github.com/IBM/kui/commit/3ecd638)), closes [#4594](https://github.com/IBM/kui/issues/4594)
- add support for hiding elements at higher zoom levels ([7d2a7e0](https://github.com/IBM/kui/commit/7d2a7e0)), closes [#4232](https://github.com/IBM/kui/issues/4232)
- clicking on certain links in kubectl help result in odd behavior ([035894b](https://github.com/IBM/kui/commit/035894b)), closes [#4473](https://github.com/IBM/kui/issues/4473)
- clicking on container name in details sidecar should add -c to logs command ([61c7c08](https://github.com/IBM/kui/commit/61c7c08)), closes [#4498](https://github.com/IBM/kui/issues/4498)
- eliminate complex nesting of NavResponse model ([e849ae7](https://github.com/IBM/kui/commit/e849ae7)), closes [#4205](https://github.com/IBM/kui/issues/4205)
- ensure kubectl Delete toolbar button appears at far right ([9eb3079](https://github.com/IBM/kui/commit/9eb3079)), closes [#4116](https://github.com/IBM/kui/issues/4116)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- ibmcloud plugin list does not list unofficial plugins ([303fa00](https://github.com/IBM/kui/commit/303fa00)), closes [#4339](https://github.com/IBM/kui/issues/4339)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- kubectl summary Form TextInputs can be cropped ([3becaf9](https://github.com/IBM/kui/commit/3becaf9)), closes [#4077](https://github.com/IBM/kui/issues/4077)
- make inBrowserOk the default ([2a3c811](https://github.com/IBM/kui/commit/2a3c811)), closes [#4275](https://github.com/IBM/kui/issues/4275)
- multiple kubectl help/usage bugs ([ebba36e](https://github.com/IBM/kui/commit/ebba36e)), closes [#4342](https://github.com/IBM/kui/issues/4342)
- multiple tab completion bugs ([5513712](https://github.com/IBM/kui/commit/5513712)), closes [#4281](https://github.com/IBM/kui/issues/4281)
- optimize kubectl watch load on apiserver ([3f7a32f](https://github.com/IBM/kui/commit/3f7a32f)), closes [#4494](https://github.com/IBM/kui/issues/4494)
- PaginatedTable fails at distinguishing the rowKeys of `k get --all-namespaces` table ([6658729](https://github.com/IBM/kui/commit/6658729)), closes [#4579](https://github.com/IBM/kui/issues/4579)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- sidecar views do not respect tab-specificity ([5a1cae2](https://github.com/IBM/kui/commit/5a1cae2)), closes [#4362](https://github.com/IBM/kui/issues/4362)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- TopNavSidecar does not always show updates ([251e5c4](https://github.com/IBM/kui/commit/251e5c4)), closes [#4524](https://github.com/IBM/kui/issues/4524)
- **plugins/plugin-kubectl:** kubectl describe (--help) fails ([10b8e8a](https://github.com/IBM/kui/commit/10b8e8a)), closes [#4012](https://github.com/IBM/kui/issues/4012)
- **plugins/plugin-kubectl:** kubectl get table with mix of existing and non-existing ([8d98d15](https://github.com/IBM/kui/commit/8d98d15)), closes [#4492](https://github.com/IBM/kui/issues/4492)
- **plugins/plugin-kubectl:** kubectl top nodes can present "NaN" ([30df3dd](https://github.com/IBM/kui/commit/30df3dd)), closes [#4189](https://github.com/IBM/kui/issues/4189)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- **plugins/plugin-kubectl:** more refinements to Form layout heuristics ([e92327d](https://github.com/IBM/kui/commit/e92327d)), closes [#4118](https://github.com/IBM/kui/issues/4118)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- **plugins/plugin-kubectl:** update deprecated import of uuid ([5de8d4d](https://github.com/IBM/kui/commit/5de8d4d)), closes [#4316](https://github.com/IBM/kui/issues/4316)
- **plugins/plugin-kubectl:** watch table doesn't have breadcrumbs title ([43fbe6a](https://github.com/IBM/kui/commit/43fbe6a)), closes [#4135](https://github.com/IBM/kui/issues/4135)
- **plugins/plugin-kubectl:** watcher table disappears when kui is launched as kubectl plugin ([167eabc](https://github.com/IBM/kui/commit/167eabc)), closes [#4120](https://github.com/IBM/kui/issues/4120) [#4123](https://github.com/IBM/kui/issues/4123)
- **plugins/plugin-kubectl:** we shouldn't render namespace widget when the namespace is empty in kube config ([98a9406](https://github.com/IBM/kui/commit/98a9406)), closes [#4274](https://github.com/IBM/kui/issues/4274)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- tekton Step nodes show with hashed background ([8428d72](https://github.com/IBM/kui/commit/8428d72)), closes [#4114](https://github.com/IBM/kui/issues/4114)
- the colors of status badges: Error, ImagePullBackOff and ErrImagePull are incorrect ([fd206f6](https://github.com/IBM/kui/commit/fd206f6)), closes [#4171](https://github.com/IBM/kui/issues/4171)
- TopNavSidecar tabs should auto-pause and auto-focus when switching ([2b00dd9](https://github.com/IBM/kui/commit/2b00dd9)), closes [#4741](https://github.com/IBM/kui/issues/4741) [#4748](https://github.com/IBM/kui/issues/4748)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)
- **plugins/plugin-kubectl:** oc describe fails ([4f4de4e](https://github.com/IBM/kui/commit/4f4de4e)), closes [#4008](https://github.com/IBM/kui/issues/4008)
- **plugins/plugin-kubectl:** wordsmithing to list-resources notebook ([7255a98](https://github.com/IBM/kui/commit/7255a98)), closes [#5504](https://github.com/IBM/kui/issues/5504)

### Features

- **plugins/plugin-kubectl:** popeye dashboard ([6dd4d01](https://github.com/IBM/kui/commit/6dd4d01)), closes [#6949](https://github.com/IBM/kui/issues/6949)
- add Kubernetes Dashboard Notebook ([9f62b63](https://github.com/IBM/kui/commit/9f62b63)), closes [#5617](https://github.com/IBM/kui/issues/5617) [#6915](https://github.com/IBM/kui/issues/6915) [#6917](https://github.com/IBM/kui/issues/6917)
- Add simple kubectl create namespace to the list of direct optimizations ([2aaaac6](https://github.com/IBM/kui/commit/2aaaac6)), closes [#6470](https://github.com/IBM/kui/issues/6470)
- Expand kubectl direct watching to support heterogeneous use cases ([8df1ad3](https://github.com/IBM/kui/commit/8df1ad3)), closes [#6504](https://github.com/IBM/kui/issues/6504)
- Extend kubectl optimizations to table watching ([9a2bc74](https://github.com/IBM/kui/commit/9a2bc74)), closes [#6449](https://github.com/IBM/kui/issues/6449)
- initial popeye support ([9d62eeb](https://github.com/IBM/kui/commit/9d62eeb)), closes [#5265](https://github.com/IBM/kui/issues/5265)
- initial support for using a kubectl proxy ([47b26be](https://github.com/IBM/kui/commit/47b26be)), closes [#6440](https://github.com/IBM/kui/issues/6440)
- pause and resume watchable jobs ([5d3f719](https://github.com/IBM/kui/commit/5d3f719)), closes [#1747](https://github.com/IBM/kui/issues/1747)
- preserve changes of table view state in Notebook ([a2efb8a](https://github.com/IBM/kui/commit/a2efb8a)), closes [#5399](https://github.com/IBM/kui/issues/5399)
- **packages/core:** allow controller to opt in/out recording table row onclicks when snapshot ([cc83ce7](https://github.com/IBM/kui/commit/cc83ce7)), closes [#5565](https://github.com/IBM/kui/issues/5565)
- **plugins/plugin-kubectl:** add explain fastpath for events ([a16e75f](https://github.com/IBM/kui/commit/a16e75f)), closes [#6836](https://github.com/IBM/kui/issues/6836)
- **plugins/plugin-kubectl:** add explain fastpaths for \*.v1.apps ([0b0e82a](https://github.com/IBM/kui/commit/0b0e82a)), closes [#6862](https://github.com/IBM/kui/issues/6862)
- **plugins/plugin-kubectl:** add Secret explain and Summary fastpaths ([90bbd89](https://github.com/IBM/kui/commit/90bbd89)), closes [#6868](https://github.com/IBM/kui/issues/6868)
- show buttons of related resources in sidecar footer ([e10f7f2](https://github.com/IBM/kui/commit/e10f7f2)), closes [#6856](https://github.com/IBM/kui/issues/6856)
- **plugins/plugin-kubectl:** Add simple kubectl delete to the list of direct optimizations ([d4fb765](https://github.com/IBM/kui/commit/d4fb765)), closes [#6468](https://github.com/IBM/kui/issues/6468)
- **plugins/plugin-kubectl:** Add Summary impl for Events ([74f4e55](https://github.com/IBM/kui/commit/74f4e55)), closes [#6839](https://github.com/IBM/kui/issues/6839)
- **plugins/plugin-kubectl:** apply/delete -f can use new direct/status watcher for homogeneous use cases ([08e471e](https://github.com/IBM/kui/commit/08e471e)), closes [#6498](https://github.com/IBM/kui/issues/6498)
- **plugins/plugin-kubectl:** flesh out explain fastpath for more apps/v1 types ([6f68a98](https://github.com/IBM/kui/commit/6f68a98)), closes [#6854](https://github.com/IBM/kui/issues/6854)
- **plugins/plugin-kubectl:** improve the performance of kubectl explain for common cases ([d016971](https://github.com/IBM/kui/commit/d016971)), closes [#6700](https://github.com/IBM/kui/issues/6700)
- **plugins/plugin-kubectl:** static get -f should show sourceRef ([fb0fc40](https://github.com/IBM/kui/commit/fb0fc40)), closes [#6680](https://github.com/IBM/kui/issues/6680)
- allow controllers to control the color of the status stripe ([708570c](https://github.com/IBM/kui/commit/708570c)), closes [#5490](https://github.com/IBM/kui/issues/5490)
- allow for limiting the number of kubectl table rows ([62588f2](https://github.com/IBM/kui/commit/62588f2)), closes [#5358](https://github.com/IBM/kui/issues/5358)
- cold start delays ([83abd14](https://github.com/IBM/kui/commit/83abd14)), closes [#5356](https://github.com/IBM/kui/issues/5356)
- generalized kuberctl get with limit ([d40ee07](https://github.com/IBM/kui/commit/d40ee07)), closes [#5361](https://github.com/IBM/kui/issues/5361)
- initial typeahead for commands ([7ba313a](https://github.com/IBM/kui/commit/7ba313a)), closes [#5437](https://github.com/IBM/kui/issues/5437)
- notebook client ([4b64133](https://github.com/IBM/kui/commit/4b64133)), closes [#5501](https://github.com/IBM/kui/issues/5501)
- revive "app" and "tier" columns from deprecated kubectl tree view ([cd642d9](https://github.com/IBM/kui/commit/cd642d9)), closes [#6591](https://github.com/IBM/kui/issues/6591)
- **plugins/plugin-kubectl:** Port kubectl pollers to use push, for homogeneous deletes ([82448d7](https://github.com/IBM/kui/commit/82448d7)), closes [#6481](https://github.com/IBM/kui/issues/6481) [#6486](https://github.com/IBM/kui/issues/6486)
- **plugins/plugin-kubectl:** update get -f to use direct/status and show a table ([16bdbb6](https://github.com/IBM/kui/commit/16bdbb6)), closes [#6566](https://github.com/IBM/kui/issues/6566) [#6532](https://github.com/IBM/kui/issues/6532)
- add a prefer-re-execution option to snapshot ([af7b98b](https://github.com/IBM/kui/commit/af7b98b)), closes [#5622](https://github.com/IBM/kui/issues/5622)
- add delta summary to Tree ([95a0b4a](https://github.com/IBM/kui/commit/95a0b4a)), closes [#6329](https://github.com/IBM/kui/issues/6329)
- add events to sidecar tree ([dd4d552](https://github.com/IBM/kui/commit/dd4d552)), closes [#6140](https://github.com/IBM/kui/issues/6140)
- background new tabs ([be9f986](https://github.com/IBM/kui/commit/be9f986)), closes [#5550](https://github.com/IBM/kui/issues/5550)
- custom tab titles ([fd780df](https://github.com/IBM/kui/commit/fd780df)), closes [#5525](https://github.com/IBM/kui/issues/5525)
- in `kubectl get -f` tree, use Monaco DiffEditor show the preview of dry-run changes ([99266e8](https://github.com/IBM/kui/commit/99266e8)), closes [#6181](https://github.com/IBM/kui/issues/6181) [#6154](https://github.com/IBM/kui/issues/6154)
- initial support for capturing input files and showing them in the UI ([5744bf4](https://github.com/IBM/kui/commit/5744bf4)), closes [#5513](https://github.com/IBM/kui/issues/5513)
- inline sidecar ([2c3afeb](https://github.com/IBM/kui/commit/2c3afeb)), closes [#6007](https://github.com/IBM/kui/issues/6007)
- Kui implementation of `watch` ([2cb3f98](https://github.com/IBM/kui/commit/2cb3f98)), closes [#6379](https://github.com/IBM/kui/issues/6379)
- Move in OpenWhisk plugin from the external repo ([b9c5867](https://github.com/IBM/kui/commit/b9c5867)), closes [#6109](https://github.com/IBM/kui/issues/6109)
- tutorial VFS ([6f2330e](https://github.com/IBM/kui/commit/6f2330e)), closes [#5441](https://github.com/IBM/kui/issues/5441)
- update CurrentContext widget to use Dropdown ([9520e5d](https://github.com/IBM/kui/commit/9520e5d)), closes [#6354](https://github.com/IBM/kui/issues/6354)
- use Monaco DiffEditor `kubectl diff` ([3157393](https://github.com/IBM/kui/commit/3157393))
- use new Dropdown status stripe for CurrentNamespace widget ([0f7648c](https://github.com/IBM/kui/commit/0f7648c)), closes [#6351](https://github.com/IBM/kui/issues/6351)
- UX: Use Dropdown for theme switcher ([6cc6a47](https://github.com/IBM/kui/commit/6cc6a47)), closes [#6347](https://github.com/IBM/kui/issues/6347)
- **plugins/plugin-client-common:** improved SequenceDiagram view ([1e2fb41](https://github.com/IBM/kui/commit/1e2fb41)), closes [#5342](https://github.com/IBM/kui/issues/5342)
- **plugins/plugin-git:** git branch should respond with RadioTable ([59a9213](https://github.com/IBM/kui/commit/59a9213)), closes [#5256](https://github.com/IBM/kui/issues/5256)
- **plugins/plugin-ibmcloud:** initial CodeEngine support ([677faca](https://github.com/IBM/kui/commit/677faca)), closes [#5302](https://github.com/IBM/kui/issues/5302) [#5303](https://github.com/IBM/kui/issues/5303)
- **plugins/plugin-kubectl:** add status column to kube deployment table ([1d35040](https://github.com/IBM/kui/commit/1d35040)), closes [#5476](https://github.com/IBM/kui/issues/5476)
- **plugins/plugin-kubectl:** initial `kubectl job list` improvement for visualizing Job execution ([06030b0](https://github.com/IBM/kui/commit/06030b0)), closes [#5397](https://github.com/IBM/kui/issues/5397)
- **plugins/plugin-kubectl:** initial labs for listing k8s resources and creating jobs ([2e9d002](https://github.com/IBM/kui/commit/2e9d002)), closes [#5475](https://github.com/IBM/kui/issues/5475)
- **plugins/plugin-kubectl:** kubectl get -f can use Tree to present structured result ([f94a22f](https://github.com/IBM/kui/commit/f94a22f)), closes [#6136](https://github.com/IBM/kui/issues/6136)
- **plugins/plugin-kubectl:** Namespace Summary impl ([2d69d67](https://github.com/IBM/kui/commit/2d69d67)), closes [#5790](https://github.com/IBM/kui/issues/5790)
- add button to WatchPane to show table back in terminal ([dc22591](https://github.com/IBM/kui/commit/dc22591)), closes [#4530](https://github.com/IBM/kui/issues/4530)
- add capability to show welcome widget to new users in Terminal ([0c33e6e](https://github.com/IBM/kui/commit/0c33e6e)), closes [#4990](https://github.com/IBM/kui/issues/4990) [#5007](https://github.com/IBM/kui/issues/5007)
- add isSelected and Divider to log container selection menu ([59bdaa5](https://github.com/IBM/kui/commit/59bdaa5)), closes [#4647](https://github.com/IBM/kui/issues/4647)
- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Patternfly Breadcrumb support ([91e0504](https://github.com/IBM/kui/commit/91e0504)), closes [#4381](https://github.com/IBM/kui/issues/4381)
- add Retry button to sidecar toolbar when log streaming stopped abnormally ([47872f4](https://github.com/IBM/kui/commit/47872f4)), closes [#4755](https://github.com/IBM/kui/issues/4755)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add Stop Watching capability to WatchPane ([09043c1](https://github.com/IBM/kui/commit/09043c1)), closes [#4554](https://github.com/IBM/kui/issues/4554)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- allow users to select container in kubectl Logs ([f4304c5](https://github.com/IBM/kui/commit/f4304c5)), closes [#4627](https://github.com/IBM/kui/issues/4627)
- clicking on events in watch table should drill down to events ([c6dc99f](https://github.com/IBM/kui/commit/c6dc99f)), closes [#5173](https://github.com/IBM/kui/issues/5173)
- commands should be able to separate resource model fetch from view transformation functions ([e903bc7](https://github.com/IBM/kui/commit/e903bc7)), closes [#4437](https://github.com/IBM/kui/issues/4437)
- ibmcloud plugin ([aa0f72f](https://github.com/IBM/kui/commit/aa0f72f)), closes [#4353](https://github.com/IBM/kui/issues/4353)
- improve kubectl edit experience ([4c4a1c9](https://github.com/IBM/kui/commit/4c4a1c9)), closes [#4783](https://github.com/IBM/kui/issues/4783)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- improve rendering of kubectl subcommand help ([e36ed29](https://github.com/IBM/kui/commit/e36ed29)), closes [#4824](https://github.com/IBM/kui/issues/4824)
- initial odo catalog list enhancements ([8534267](https://github.com/IBM/kui/commit/8534267)), closes [#4485](https://github.com/IBM/kui/issues/4485)
- kubectl apply view-last-applied ([6d601ef](https://github.com/IBM/kui/commit/6d601ef)), closes [#4822](https://github.com/IBM/kui/issues/4822)
- kubectl edit via kui's editor ([414e813](https://github.com/IBM/kui/commit/414e813)), closes [#762](https://github.com/IBM/kui/issues/762)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- line highlights on editor save, used for k edit apply errors ([3efa6a5](https://github.com/IBM/kui/commit/3efa6a5)), closes [#4795](https://github.com/IBM/kui/issues/4795)
- MiniSplits ([70b8441](https://github.com/IBM/kui/commit/70b8441)), closes [#5112](https://github.com/IBM/kui/issues/5112)
- only enable WatchPane based on a feature flag ([eb80d0e](https://github.com/IBM/kui/commit/eb80d0e)), closes [#4678](https://github.com/IBM/kui/issues/4678) [#4604](https://github.com/IBM/kui/issues/4604)
- patternfly4 themes ([5f58f71](https://github.com/IBM/kui/commit/5f58f71)), closes [#4364](https://github.com/IBM/kui/issues/4364)
- pin a watchable terminal response in a split pane ([662f413](https://github.com/IBM/kui/commit/662f413)), closes [#4865](https://github.com/IBM/kui/issues/4865) [#4573](https://github.com/IBM/kui/issues/4573) [#4885](https://github.com/IBM/kui/issues/4885) [#4894](https://github.com/IBM/kui/issues/4894)
- port kubectl get ns to RadioTable ([be0eabf](https://github.com/IBM/kui/commit/be0eabf)), closes [#4510](https://github.com/IBM/kui/issues/4510) [#4511](https://github.com/IBM/kui/issues/4511)
- refine kubectl contexts table; add support for RadioTable row titles ([11bb074](https://github.com/IBM/kui/commit/11bb074)), closes [#5131](https://github.com/IBM/kui/issues/5131)
- s3 plugin, and vfs ([970ba6e](https://github.com/IBM/kui/commit/970ba6e)), closes [#5319](https://github.com/IBM/kui/issues/5319)
- show resource version in toolbar text ([1a6e335](https://github.com/IBM/kui/commit/1a6e335)), closes [#4790](https://github.com/IBM/kui/issues/4790)
- split screen Terminal ([3a6b422](https://github.com/IBM/kui/commit/3a6b422)), closes [#4814](https://github.com/IBM/kui/issues/4814) [#4821](https://github.com/IBM/kui/issues/4821)
- support for events in crud table footer ([0b90ead](https://github.com/IBM/kui/commit/0b90ead)), closes [#5125](https://github.com/IBM/kui/issues/5125)
- support for events in table footer ([51669af](https://github.com/IBM/kui/commit/51669af)), closes [#5115](https://github.com/IBM/kui/issues/5115)
- **plugins/plugin-kubectl:** add Show Node button for kubectl pods ([04e29d2](https://github.com/IBM/kui/commit/04e29d2)), closes [#4214](https://github.com/IBM/kui/issues/4214)
- **plugins/plugin-kubectl:** add support for kustomize apply/delete/create ([b95cbdb](https://github.com/IBM/kui/commit/b95cbdb)), closes [#4203](https://github.com/IBM/kui/issues/4203)
- **plugins/plugin-kubectl:** configmap summary should show data ([50c7e10](https://github.com/IBM/kui/commit/50c7e10)), closes [#4025](https://github.com/IBM/kui/issues/4025)
- **plugins/plugin-kubectl:** enhance odo project list as RadioTable ([62272e6](https://github.com/IBM/kui/commit/62272e6)), closes [#4517](https://github.com/IBM/kui/issues/4517)
- **plugins/plugin-kubectl:** improve odo usage experience ([639ca32](https://github.com/IBM/kui/commit/639ca32)), closes [#4345](https://github.com/IBM/kui/issues/4345)
- **plugins/plugin-kubectl:** kubectl events tab ([2d71f24](https://github.com/IBM/kui/commit/2d71f24)), closes [#4706](https://github.com/IBM/kui/issues/4706)
- **plugins/plugin-kubectl:** namespace onclick should drill down to sidecar ([e74f66d](https://github.com/IBM/kui/commit/e74f66d)), closes [#4714](https://github.com/IBM/kui/issues/4714)
- **plugins/plugin-kubectl:** optimize rendering of kubectl Summary tab ([7c6480d](https://github.com/IBM/kui/commit/7c6480d)), closes [#4725](https://github.com/IBM/kui/issues/4725)
- **plugins/plugin-kubectl:** optimizing Node summary impl ([8ac11b9](https://github.com/IBM/kui/commit/8ac11b9)), closes [#4833](https://github.com/IBM/kui/issues/4833)
- **plugins/plugin-kubectl:** Show Previous option for Logs tab ([2307d2f](https://github.com/IBM/kui/commit/2307d2f)), closes [#4864](https://github.com/IBM/kui/issues/4864)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- simplified co-hosting of client and proxy in a container ([00af4b4](https://github.com/IBM/kui/commit/00af4b4)), closes [#4213](https://github.com/IBM/kui/issues/4213)
- SPI for icons ([3d034e3](https://github.com/IBM/kui/commit/3d034e3)), closes [#4441](https://github.com/IBM/kui/issues/4441) [#4364](https://github.com/IBM/kui/issues/4364)
- target kubectl logs and kubectl exec to Logs and Terminal tabs ([409e632](https://github.com/IBM/kui/commit/409e632)), closes [#4762](https://github.com/IBM/kui/issues/4762)
- **plugins/plugin-kubectl:** Terminal tab for Pod kubernetes resources ([c47e432](https://github.com/IBM/kui/commit/c47e432)), closes [#4639](https://github.com/IBM/kui/issues/4639)
- top tab buttons ([ff8cfba](https://github.com/IBM/kui/commit/ff8cfba)), closes [#4434](https://github.com/IBM/kui/issues/4434)
- watcher panel for open-ended watch jobs ([6dfe7df](https://github.com/IBM/kui/commit/6dfe7df)), closes [#4503](https://github.com/IBM/kui/issues/4503)
- **plugins/plugin-kubectl:** port kubectl contexts table to RadioTable ([3cb4dcb](https://github.com/IBM/kui/commit/3cb4dcb)), closes [#4513](https://github.com/IBM/kui/issues/4513)
- **plugins/plugin-kubectl:** ReplicaSet should have Pods tab ([42cd286](https://github.com/IBM/kui/commit/42cd286)), closes [#4110](https://github.com/IBM/kui/issues/4110)
- **plugins/plugin-kubectl:** restore Show Logs button for kubectl ([6b17dbd](https://github.com/IBM/kui/commit/6b17dbd)), closes [#4089](https://github.com/IBM/kui/issues/4089)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)

### BREAKING CHANGES

- removes support for inBrowserOk

## [10.0.1](https://github.com/IBM/kui/compare/v4.5.0...v10.0.1) (2021-02-01)

### Bug Fixes

- **plugins/plugin-client-common:** onclick handlers for ls should respond only to clicking on text ([8477386](https://github.com/IBM/kui/commit/8477386)), closes [#6567](https://github.com/IBM/kui/issues/6567)
- **plugins/plugin-client-common:** show table click result in a new split ([fd1b3a1](https://github.com/IBM/kui/commit/fd1b3a1)), closes [#6477](https://github.com/IBM/kui/issues/6477)
- **plugins/plugin-client-common:** Table onclick handlers applied to every cell ([d5a9c3a](https://github.com/IBM/kui/commit/d5a9c3a)), closes [#6792](https://github.com/IBM/kui/issues/6792)
- **plugins/plugin-kubectl:** "logs dashC follow via table" test is unreliable after electron 10 update ([72c50ab](https://github.com/IBM/kui/commit/72c50ab)), closes [#6152](https://github.com/IBM/kui/issues/6152)
- **plugins/plugin-kubectl:** `k get all` with direct/get doesn't fail back to the old impl of get ([bdc3446](https://github.com/IBM/kui/commit/bdc3446)), closes [#6643](https://github.com/IBM/kui/issues/6643)
- **plugins/plugin-kubectl:** `k get all` with direct/get doesn't fail back to the old impl of get ([a2c0c2b](https://github.com/IBM/kui/commit/a2c0c2b)), closes [#6643](https://github.com/IBM/kui/issues/6643)
- **plugins/plugin-kubectl:** direct operations fail if err.message is not JSON ([c5dc825](https://github.com/IBM/kui/commit/c5dc825)), closes [#6653](https://github.com/IBM/kui/issues/6653)
- **plugins/plugin-kubectl:** direct tables in splits are not hiding columns correctly ([5cc6cfc](https://github.com/IBM/kui/commit/5cc6cfc)), closes [#6484](https://github.com/IBM/kui/issues/6484)
- **plugins/plugin-kubectl:** direct watcher improperly formats event url ([d9717ff](https://github.com/IBM/kui/commit/d9717ff)), closes [#6593](https://github.com/IBM/kui/issues/6593)
- **plugins/plugin-kubectl:** direct/watch may update rows in a wrong order ([c0e5e17](https://github.com/IBM/kui/commit/c0e5e17)), closes [#6642](https://github.com/IBM/kui/issues/6642)
- **plugins/plugin-kubectl:** event watcher doesn't render well in minisplit ([56176de](https://github.com/IBM/kui/commit/56176de)), closes [#6772](https://github.com/IBM/kui/issues/6772)
- **plugins/plugin-kubectl:** events watching returns an empty table with just a streaming events footer ([fbeae76](https://github.com/IBM/kui/commit/fbeae76)), closes [#2771](https://github.com/IBM/kui/issues/2771)
- **plugins/plugin-kubectl:** get without kind doesn't fail back to the old get impl ([e85af25](https://github.com/IBM/kui/commit/e85af25)), closes [#6719](https://github.com/IBM/kui/issues/6719)
- **plugins/plugin-kubectl:** get-direct does not support field-selectors ([85b849c](https://github.com/IBM/kui/commit/85b849c)), closes [#6473](https://github.com/IBM/kui/issues/6473)
- **plugins/plugin-kubectl:** helm test can fail due to helm release name exceeding 63 characters ([a9903ea](https://github.com/IBM/kui/commit/a9903ea)), closes [#6377](https://github.com/IBM/kui/issues/6377)
- **plugins/plugin-kubectl:** heterogeneous apply tables lack a breadcrumb ([ee0bd2b](https://github.com/IBM/kui/commit/ee0bd2b)), closes [#6512](https://github.com/IBM/kui/issues/6512)
- **plugins/plugin-kubectl:** heterogeneous get unifies table incorrectly when some resources have label ([a5dab2e](https://github.com/IBM/kui/commit/a5dab2e)), closes [#6672](https://github.com/IBM/kui/issues/6672) [#6676](https://github.com/IBM/kui/issues/6676)
- **plugins/plugin-kubectl:** k api-resources | grep events has odd error message ([338ae2f](https://github.com/IBM/kui/commit/338ae2f)), closes [#6838](https://github.com/IBM/kui/issues/6838)
- **plugins/plugin-kubectl:** k logs has bad error message ([d1afe30](https://github.com/IBM/kui/commit/d1afe30)), closes [#6740](https://github.com/IBM/kui/issues/6740)
- **plugins/plugin-kubectl:** kubectl delete poller may get stuck Green ([c1d7662](https://github.com/IBM/kui/commit/c1d7662)), closes [#6436](https://github.com/IBM/kui/issues/6436)
- **plugins/plugin-kubectl:** kubectl direct status watcher can get stuck ([2346ce2](https://github.com/IBM/kui/commit/2346ce2)), closes [#6514](https://github.com/IBM/kui/issues/6514)
- **plugins/plugin-kubectl:** kubectl direct streaming fails to register a stream.on('error') ([44a6038](https://github.com/IBM/kui/commit/44a6038)), closes [#6616](https://github.com/IBM/kui/issues/6616)
- **plugins/plugin-kubectl:** kubectl direct watcher does not properly filter events and resource updates ([be9e308](https://github.com/IBM/kui/commit/be9e308)), closes [#6599](https://github.com/IBM/kui/issues/6599)
- **plugins/plugin-kubectl:** kubectl get events -o wide shows incorrect Last Seen column ([b24990b](https://github.com/IBM/kui/commit/b24990b)), closes [#6796](https://github.com/IBM/kui/issues/6796)
- **plugins/plugin-kubectl:** kubectl kustomize does not handle ~ home directory expansion ([f124b1d](https://github.com/IBM/kui/commit/f124b1d)), closes [#6115](https://github.com/IBM/kui/issues/6115)
- **plugins/plugin-kubectl:** kubectl proxy manager may create a new proxy too often ([72d9d5d](https://github.com/IBM/kui/commit/72d9d5d)), closes [#6462](https://github.com/IBM/kui/issues/6462)
- **plugins/plugin-kubectl:** kubectl sourceRef fetching is expensive ([f6539c5](https://github.com/IBM/kui/commit/f6539c5)), closes [#6662](https://github.com/IBM/kui/issues/6662)
- **plugins/plugin-kubectl:** kubectl watch commands without resource names won't show Added updates ([64442b3](https://github.com/IBM/kui/commit/64442b3)), closes [#6630](https://github.com/IBM/kui/issues/6630)
- **plugins/plugin-kubectl:** kubernetes namespace list does not update after namespace deletion ([c28c800](https://github.com/IBM/kui/commit/c28c800)), closes [#6521](https://github.com/IBM/kui/issues/6521)
- **plugins/plugin-kubectl:** kubernetes test input pod.yaml has a container named "name" ([6ac5210](https://github.com/IBM/kui/commit/6ac5210)), closes [#6907](https://github.com/IBM/kui/issues/6907)
- **plugins/plugin-kubectl:** make sure to pick the last specified label selector ([7d44bcb](https://github.com/IBM/kui/commit/7d44bcb)), closes [#6840](https://github.com/IBM/kui/issues/6840)
- **plugins/plugin-kubectl:** multikind table isn't unified correctly when some rows are offline ([dd02cde](https://github.com/IBM/kui/commit/dd02cde)), closes [#6865](https://github.com/IBM/kui/issues/6865)
- **plugins/plugin-kubectl:** new kubectl direct logic does not properly handle ECONNREFUSED ([96eefdb](https://github.com/IBM/kui/commit/96eefdb)), closes [#6476](https://github.com/IBM/kui/issues/6476)
- **plugins/plugin-kubectl:** new kubectl event watching logic may drop events ([d46f591](https://github.com/IBM/kui/commit/d46f591)), closes [#6451](https://github.com/IBM/kui/issues/6451)
- **plugins/plugin-kubectl:** Remove unused css from plugin-kubectl ([4d65051](https://github.com/IBM/kui/commit/4d65051)), closes [#6902](https://github.com/IBM/kui/issues/6902)
- **plugins/plugin-kubectl:** replace Sidecar Events Mode with a toolbar button to show events table in REPL ([ccc47d0](https://github.com/IBM/kui/commit/ccc47d0)), closes [#6847](https://github.com/IBM/kui/issues/6847)
- compilation failures due perhaps to typescript 4.1.3 upgrade?? ([d06824b](https://github.com/IBM/kui/commit/d06824b)), closes [#6432](https://github.com/IBM/kui/issues/6432)
- kubectl direct/get does not specify that get tables have the `onclickIdempotent` property ([31361ec](https://github.com/IBM/kui/commit/31361ec)), closes [#6778](https://github.com/IBM/kui/issues/6778)
- **plugins/plugin-kubectl:** show SourceRef when creating heterogeneous resources ([adb21c5](https://github.com/IBM/kui/commit/adb21c5)), closes [#6640](https://github.com/IBM/kui/issues/6640)
- drilldown from an undeployed application in tree will issue a kubectl get with 404 ([309a9a0](https://github.com/IBM/kui/commit/309a9a0)), closes [#6331](https://github.com/IBM/kui/issues/6331)
- kubectl contexts table has odd CURRENT column ([f6d0a98](https://github.com/IBM/kui/commit/f6d0a98)), closes [#6523](https://github.com/IBM/kui/issues/6523)
- kubectl direct streaming fails to register a stream.on('error') ([fd9fbf6](https://github.com/IBM/kui/commit/fd9fbf6)), closes [#6616](https://github.com/IBM/kui/issues/6616)
- kubectl get -f --watch doesn't watch ([e45e8ee](https://github.com/IBM/kui/commit/e45e8ee)), closes [#6588](https://github.com/IBM/kui/issues/6588)
- kubectl kustomize can have bogus output ([8bf8ebe](https://github.com/IBM/kui/commit/8bf8ebe)), closes [#6114](https://github.com/IBM/kui/issues/6114)
- kubectl Terminal tab test is flakey ([5e28860](https://github.com/IBM/kui/commit/5e28860)), closes [#6636](https://github.com/IBM/kui/issues/6636)
- **plugins/plugin-kubectl:** kubectl get-all-namespaces test is unreliable ([a0e44a3](https://github.com/IBM/kui/commit/a0e44a3)), closes [#6561](https://github.com/IBM/kui/issues/6561)
- **plugins/plugin-kubectl:** kubernetes CurrentContext widget may display as empty ([640263c](https://github.com/IBM/kui/commit/640263c)), closes [#6392](https://github.com/IBM/kui/issues/6392)
- **plugins/plugin-kubectl:** Switching from kubectl logs tab to another tab causes uncaught exception ([d3f6770](https://github.com/IBM/kui/commit/d3f6770)), closes [#6585](https://github.com/IBM/kui/issues/6585)
- remove TreeResponse and PatternFly Tree Component ([e539a53](https://github.com/IBM/kui/commit/e539a53)), closes [#6581](https://github.com/IBM/kui/issues/6581) [#6328](https://github.com/IBM/kui/issues/6328)
- **plugins/plugin-kubectl:** plugin-kubectl's fetch-file, when using electron, does not have error handling ([b45a818](https://github.com/IBM/kui/commit/b45a818)), closes [#6426](https://github.com/IBM/kui/issues/6426)
- **plugins/plugin-kubectl:** unlabeled resources shouldn’t have badge for children's count ([4e1fea6](https://github.com/IBM/kui/commit/4e1fea6)), closes [#6243](https://github.com/IBM/kui/issues/6243)
- **plugins/plugin-kubectl:** use PaginatedTable instead of RadioTable for `contexts` and `get namespaces` commands ([20f0737](https://github.com/IBM/kui/commit/20f0737)), closes [#6517](https://github.com/IBM/kui/issues/6517)
- events in tree are presented out of temporal order ([b3ba61e](https://github.com/IBM/kui/commit/b3ba61e)), closes [#6168](https://github.com/IBM/kui/issues/6168)
- kubectl watcher should auto-terminate, if given a bound up front ([1a94094](https://github.com/IBM/kui/commit/1a94094)), closes [#6417](https://github.com/IBM/kui/issues/6417)
- monaco diff view colors are not themed ([eed2527](https://github.com/IBM/kui/commit/eed2527)), closes [#6232](https://github.com/IBM/kui/issues/6232)
- refine tree label categoriazation of kubectl ([1973a43](https://github.com/IBM/kui/commit/1973a43)), closes [#6185](https://github.com/IBM/kui/issues/6185)
- s3 job watcher sometimes fails due to startup issues ([8851d50](https://github.com/IBM/kui/commit/8851d50)), closes [#6411](https://github.com/IBM/kui/issues/6411)
- tree should support leaf node drilling down ([006b881](https://github.com/IBM/kui/commit/006b881)), closes [#6293](https://github.com/IBM/kui/issues/6293)
- tweak the toolbar text and button label of `k get -f` tree ([ad476c5](https://github.com/IBM/kui/commit/ad476c5)), closes [#6303](https://github.com/IBM/kui/issues/6303)
- update kubectl/notebooks/deploy-applications for the Mode Toolbar change ([164244e](https://github.com/IBM/kui/commit/164244e)), closes [#6385](https://github.com/IBM/kui/issues/6385)
- **plugins/plugin-kubectl:** the Deploy Applications notebook has some typos ([817f9b7](https://github.com/IBM/kui/commit/817f9b7)), closes [#6256](https://github.com/IBM/kui/issues/6256)
- **plugins/plugin-kubectl:** typos in Tree Toolbar text ([0d9a6be](https://github.com/IBM/kui/commit/0d9a6be)), closes [#6514](https://github.com/IBM/kui/issues/6514)
- UI glitches of Tree ([fc5af7a](https://github.com/IBM/kui/commit/fc5af7a)), closes [#6138](https://github.com/IBM/kui/issues/6138)
- **plugins/plugin-client-common:** clicking the split button may cause the current processing block to disappear ([aa2b40c](https://github.com/IBM/kui/commit/aa2b40c)), closes [#5703](https://github.com/IBM/kui/issues/5703)
- **plugins/plugin-client-common:** don't offer Grid option for 1-row tables ([a2a6f8d](https://github.com/IBM/kui/commit/a2a6f8d)), closes [#5474](https://github.com/IBM/kui/issues/5474)
- **plugins/plugin-client-common:** SequenceDiagram UI refinements ([5d8c3f7](https://github.com/IBM/kui/commit/5d8c3f7)), closes [#5557](https://github.com/IBM/kui/issues/5557)
- **plugins/plugin-client-common:** update welcome.json to describe kui, not just notebooks ([96330c4](https://github.com/IBM/kui/commit/96330c4)), closes [#5878](https://github.com/IBM/kui/issues/5878)
- **plugins/plugin-kubectl:** add Summary impl for kubernetes Jobs ([b0f3809](https://github.com/IBM/kui/commit/b0f3809)), closes [#5481](https://github.com/IBM/kui/issues/5481)
- **plugins/plugin-kubectl:** k8s table should display status Propagated and Subscribed as green ([0787b4b](https://github.com/IBM/kui/commit/0787b4b)), closes [#5818](https://github.com/IBM/kui/issues/5818)
- **plugins/plugin-kubectl:** kubectl get -f can show undefined in table title ([eb34d1c](https://github.com/IBM/kui/commit/eb34d1c)), closes [#5469](https://github.com/IBM/kui/issues/5469)
- **plugins/plugin-kubectl:** kui semi-ignores --dry-run for kubectl apply ([90c329f](https://github.com/IBM/kui/commit/90c329f)), closes [#6106](https://github.com/IBM/kui/issues/6106)
- don't show "Created a split" when clicking on the New Split button ([80192d5](https://github.com/IBM/kui/commit/80192d5)), closes [#6001](https://github.com/IBM/kui/issues/6001)
- **plugins/plugin-client-common:** isReplay bit on Blocks is not set for snapshots ([c6d1633](https://github.com/IBM/kui/commit/c6d1633)), closes [#5868](https://github.com/IBM/kui/issues/5868)
- **plugins/plugin-kubectl:** isReplicaSet needs to be updated to handle "apps/v1" apiVersion ([6887a0d](https://github.com/IBM/kui/commit/6887a0d)), closes [#6003](https://github.com/IBM/kui/issues/6003)
- **plugins/plugin-kubectl:** kubectl delete ns m1 m2 m3 m4 results in a one-row table ([97a33a4](https://github.com/IBM/kui/commit/97a33a4)), closes [#5694](https://github.com/IBM/kui/issues/5694)
- **plugins/plugin-kubectl:** kubectl Deployment summary does not handle `undefined` fields ([0f65c3c](https://github.com/IBM/kui/commit/0f65c3c)), closes [#6028](https://github.com/IBM/kui/issues/6028)
- **plugins/plugin-kubectl:** regenerate kubernetes notebooks to show new Source Reference feature ([8324567](https://github.com/IBM/kui/commit/8324567)), closes [#5520](https://github.com/IBM/kui/issues/5520)
- **plugins/plugin-kubectl:** update jobs notebook to latest SequenceDiagram ([8e70862](https://github.com/IBM/kui/commit/8e70862)), closes [#5862](https://github.com/IBM/kui/issues/5862)
- **Plugins/plugin-kubectl:** Logs tab may become stale when switching away/back ([fcfdaba](https://github.com/IBM/kui/commit/fcfdaba)), closes [#6024](https://github.com/IBM/kui/issues/6024)
- (plugins/plugin-kubectl): kubectl get pod -w --all-namespaces behaves oddly ([12e578a](https://github.com/IBM/kui/commit/12e578a)), closes [#5169](https://github.com/IBM/kui/issues/5169)
- avoid excessive status stripe overheads when replaying Notebooks ([58de9c0](https://github.com/IBM/kui/commit/58de9c0)), closes [#5635](https://github.com/IBM/kui/issues/5635)
- grid colors are sometimes off ([e66f56f](https://github.com/IBM/kui/commit/e66f56f)), closes [#5422](https://github.com/IBM/kui/issues/5422)
- improve existing notebooks for v1 ([1af5cc2](https://github.com/IBM/kui/commit/1af5cc2)), closes [#5858](https://github.com/IBM/kui/issues/5858)
- improve the discoverability of repl-block action buttons ([470da34](https://github.com/IBM/kui/commit/470da34)), closes [#5604](https://github.com/IBM/kui/issues/5604)
- improve the replayability of terminal splitting ([67811cd](https://github.com/IBM/kui/commit/67811cd)), closes [#5564](https://github.com/IBM/kui/issues/5564)
- JS console may contain xtermjs error messages when sidecar is minimized ([a568528](https://github.com/IBM/kui/commit/a568528)), closes [#5454](https://github.com/IBM/kui/issues/5454)
- RadioTables are not replayable ([d0dd00e](https://github.com/IBM/kui/commit/d0dd00e)), closes [#5599](https://github.com/IBM/kui/issues/5599)
- restore status stripe to default behavior on terminal clear ([128ec92](https://github.com/IBM/kui/commit/128ec92)), closes [#5495](https://github.com/IBM/kui/issues/5495)
- sidecar shouldn't be opened automatically when replay ([8d4cf8c](https://github.com/IBM/kui/commit/8d4cf8c)), closes [#5730](https://github.com/IBM/kui/issues/5730)
- snapshot and replay of table clicks for Notebook v1 ([1a87dbf](https://github.com/IBM/kui/commit/1a87dbf)), closes [#5821](https://github.com/IBM/kui/issues/5821)
- store the commentary text result to the command when editing is done ([5a3f5e8](https://github.com/IBM/kui/commit/5a3f5e8)), closes [#5916](https://github.com/IBM/kui/issues/5916) [#5672](https://github.com/IBM/kui/issues/5672)
- **plugins/plugin-client-common:** for now, switch interval chart to duration chart ([ea21221](https://github.com/IBM/kui/commit/ea21221)), closes [#5340](https://github.com/IBM/kui/issues/5340)
- **plugins/plugin-client-common:** Grid regression: grid colors not right ([d1aa46d](https://github.com/IBM/kui/commit/d1aa46d)), closes [#5285](https://github.com/IBM/kui/issues/5285)
- **plugins/plugin-client-common:** improve display of empty watch tables ([4cc16be](https://github.com/IBM/kui/commit/4cc16be)), closes [#5176](https://github.com/IBM/kui/issues/5176)
- **plugins/plugin-client-common:** kubectl watch is broken for server versions >= 1.17 ([2d595b7](https://github.com/IBM/kui/commit/2d595b7)), closes [#5360](https://github.com/IBM/kui/issues/5360)
- **plugins/plugin-kubectl:** `oc get namespaces` doesn't produce a RadioTable ([6ea6131](https://github.com/IBM/kui/commit/6ea6131)), closes [#5227](https://github.com/IBM/kui/issues/5227)
- **plugins/plugin-kubectl:** add traffic light colors for OOMKilled and UnexpectedAdmissionError ([4262409](https://github.com/IBM/kui/commit/4262409)), closes [#5345](https://github.com/IBM/kui/issues/5345)
- **plugins/plugin-kubectl:** CurrentNamespace/Context widgets not live ([93ac829](https://github.com/IBM/kui/commit/93ac829)), closes [#5144](https://github.com/IBM/kui/issues/5144)
- **plugins/plugin-kubectl:** drilldown command of resources in watch --all-namespace table doesn't have '-o yaml' ([1e4f558](https://github.com/IBM/kui/commit/1e4f558)), closes [#5208](https://github.com/IBM/kui/issues/5208)
- **plugins/plugin-kubectl:** event footer watching should also support named resources ([e3a842b](https://github.com/IBM/kui/commit/e3a842b)), closes [#5180](https://github.com/IBM/kui/issues/5180)
- **plugins/plugin-kubectl:** events in table appear to be in random order ([034dc06](https://github.com/IBM/kui/commit/034dc06)), closes [#5212](https://github.com/IBM/kui/issues/5212)
- **plugins/plugin-kubectl:** Fail should be TrafficLight.Red and Succeeded should be TrafficLight.Green ([54737b6](https://github.com/IBM/kui/commit/54737b6)), closes [#5351](https://github.com/IBM/kui/issues/5351)
- **plugins/plugin-kubectl:** header-only tables improperly parsed ([f56841b](https://github.com/IBM/kui/commit/f56841b)), closes [#5382](https://github.com/IBM/kui/issues/5382)
- **plugins/plugin-kubectl:** kubectl apply -f may not abort the event watcher ([c8df222](https://github.com/IBM/kui/commit/c8df222)), closes [#5149](https://github.com/IBM/kui/issues/5149)
- **plugins/plugin-kubectl:** kubectl status table does not register onclickIdempotent ([6ae296c](https://github.com/IBM/kui/commit/6ae296c)), closes [#5788](https://github.com/IBM/kui/issues/5788)
- **plugins/plugin-kubectl:** kubectl table should show PropagationFailed status as offline ([a44b70c](https://github.com/IBM/kui/commit/a44b70c)), closes [#5821](https://github.com/IBM/kui/issues/5821)
- **plugins/plugin-kubectl:** Update list-resources notebook to use splits ([1f54515](https://github.com/IBM/kui/commit/1f54515)), closes [#5770](https://github.com/IBM/kui/issues/5770)
- CurrentContext and CurrentNamespace widgets may have stale data inBrowser ([ab77c20](https://github.com/IBM/kui/commit/ab77c20)), closes [#5097](https://github.com/IBM/kui/issues/5097)
- snapshot command fails at `k get -o yaml` ([fe53fb0](https://github.com/IBM/kui/commit/fe53fb0)), closes [#5458](https://github.com/IBM/kui/issues/5458)
- snapshot command throws errors when capturing watch responses ([600f049](https://github.com/IBM/kui/commit/600f049)), closes [#5452](https://github.com/IBM/kui/issues/5452)
- vfs fixes for multi-source copying and for s3 globbing ([893902e](https://github.com/IBM/kui/commit/893902e)), closes [#5511](https://github.com/IBM/kui/issues/5511)
- **plugins/plugin-client-common:** make Close a top-level button in watch panes ([3c14da5](https://github.com/IBM/kui/commit/3c14da5)), closes [#4945](https://github.com/IBM/kui/issues/4945)
- **plugins/plugin-kubectl:** certain filepath options to kubectl were not tilde-expanded ([9e7f858](https://github.com/IBM/kui/commit/9e7f858)), closes [#5415](https://github.com/IBM/kui/issues/5415)
- **plugins/plugin-kubectl:** changing ns via oc does not update ns widget, in browser clients ([5eaa625](https://github.com/IBM/kui/commit/5eaa625)), closes [#4953](https://github.com/IBM/kui/issues/4953)
- **plugins/plugin-kubectl:** kubectl Logs/Events/Terminal tabs do not reflow on sidecar maximize ([6dbcbe8](https://github.com/IBM/kui/commit/6dbcbe8)), closes [#5417](https://github.com/IBM/kui/issues/5417)
- **plugins/plugin-kubectl:** kubectl tab completion does not let me tab-complete some filepaths ([e42daa7](https://github.com/IBM/kui/commit/e42daa7)), closes [#5413](https://github.com/IBM/kui/issues/5413)
- **plugins/plugin-kubectl:** kubectl watcher needs to pass through kubeconfig in its call to kubectl version ([a5d83a3](https://github.com/IBM/kui/commit/a5d83a3)), closes [#5368](https://github.com/IBM/kui/issues/5368)
- **plugins/plugin-kubectl:** kubernetes contexts table renders poorly ([e2ed7d8](https://github.com/IBM/kui/commit/e2ed7d8)), closes [#5230](https://github.com/IBM/kui/issues/5230)
- **plugins/plugin-kubectl:** Kui may invoke kubectl with duplicate command line options ([39c9d31](https://github.com/IBM/kui/commit/39c9d31)), closes [#5330](https://github.com/IBM/kui/issues/5330)
- **plugins/plugin-kubectl:** leftover debug printfs in table-watch ([407855a](https://github.com/IBM/kui/commit/407855a)), closes [#5317](https://github.com/IBM/kui/issues/5317)
- **plugins/plugin-kubectl:** nil and negative timestamps display as "0ms ago" ([641a599](https://github.com/IBM/kui/commit/641a599)), closes [#5136](https://github.com/IBM/kui/issues/5136)
- **plugins/plugin-kubectl:** oc get ns does not present a RadioTable ([9e28eec](https://github.com/IBM/kui/commit/9e28eec)), closes [#5106](https://github.com/IBM/kui/issues/5106)
- **plugins/plugin-kubectl:** Pod summary impl fails for pods with no containerStatuses ([66b21b5](https://github.com/IBM/kui/commit/66b21b5)), closes [#5192](https://github.com/IBM/kui/issues/5192)
- **plugins/plugin-kubectl:** wordsmithing to list-resources notebook ([7255a98](https://github.com/IBM/kui/commit/7255a98)), closes [#5504](https://github.com/IBM/kui/issues/5504)
- multiple issues with tab switching versus status stripe widgets ([8c8a6ec](https://github.com/IBM/kui/commit/8c8a6ec)), closes [#5101](https://github.com/IBM/kui/issues/5101)
- **plugins/plugin-kubectl:** tolerate helm 3.0 and 3.1 help custom ascii art tables ([79f8640](https://github.com/IBM/kui/commit/79f8640)), closes [#5085](https://github.com/IBM/kui/issues/5085)
- allow user to disable table title by feature flags, and disable table pagination ([5450512](https://github.com/IBM/kui/commit/5450512)), closes [#4640](https://github.com/IBM/kui/issues/4640) [#4655](https://github.com/IBM/kui/issues/4655)
- avoid using kui-custom command for switching kubectl namespace ([43863f2](https://github.com/IBM/kui/commit/43863f2)), closes [#4806](https://github.com/IBM/kui/issues/4806)
- don't blink yellow forever for kubectl events ([a59ee86](https://github.com/IBM/kui/commit/a59ee86)), closes [#4869](https://github.com/IBM/kui/issues/4869)
- eliminate assumptions that "default" is the default kube namespace ([4eb392d](https://github.com/IBM/kui/commit/4eb392d)), closes [#4764](https://github.com/IBM/kui/issues/4764)
- Input element throws react error ([e6bb21b](https://github.com/IBM/kui/commit/e6bb21b)), closes [#4765](https://github.com/IBM/kui/issues/4765)
- kubectl edit apply twice does not work ([1976134](https://github.com/IBM/kui/commit/1976134)), closes [#4797](https://github.com/IBM/kui/issues/4797)
- kubectl help misformats helm help tables ([ff36755](https://github.com/IBM/kui/commit/ff36755)), closes [#5080](https://github.com/IBM/kui/issues/5080)
- **plugins/plugin-kubectl:** auto-pause logs when user scrolls ([94b85e6](https://github.com/IBM/kui/commit/94b85e6)), closes [#4668](https://github.com/IBM/kui/issues/4668)
- **plugins/plugin-kubectl:** kubectl apply/create/delete tables still have ALLCAPS headers ([90d72ce](https://github.com/IBM/kui/commit/90d72ce)), closes [#5068](https://github.com/IBM/kui/issues/5068)
- empty watch tables/grids should show 'No resources' ([c0bfe99](https://github.com/IBM/kui/commit/c0bfe99)), closes [#4884](https://github.com/IBM/kui/issues/4884)
- improve hover effect for status stripe buttons ([50ced8f](https://github.com/IBM/kui/commit/50ced8f)), closes [#4896](https://github.com/IBM/kui/issues/4896)
- kubectl edit in sidecar doesn't show success message when a resource is applied ([cc59503](https://github.com/IBM/kui/commit/cc59503)), closes [#4691](https://github.com/IBM/kui/issues/4691)
- kubectl Logs tab should use an xterm ([9aa0176](https://github.com/IBM/kui/commit/9aa0176)), closes [#4750](https://github.com/IBM/kui/issues/4750) [#4747](https://github.com/IBM/kui/issues/4747)
- reduce custom CSS rules for table UI ([56f69cb](https://github.com/IBM/kui/commit/56f69cb)), closes [#5024](https://github.com/IBM/kui/issues/5024)
- remove augmentModuleLoadPath API ([47dfcdf](https://github.com/IBM/kui/commit/47dfcdf)), closes [#4839](https://github.com/IBM/kui/issues/4839)
- sidecar toolbar can't due justice to longer error messages ([e67e0c9](https://github.com/IBM/kui/commit/e67e0c9)), closes [#4789](https://github.com/IBM/kui/issues/4789)
- summary tab is not read-only for kubectl edit command ([9f7ff82](https://github.com/IBM/kui/commit/9f7ff82)), closes [#4809](https://github.com/IBM/kui/issues/4809)
- xterm alt buffer mode behaves oddly for clients that do not enable splitTerminals ([f1bc709](https://github.com/IBM/kui/commit/f1bc709)), closes [#5003](https://github.com/IBM/kui/issues/5003)
- **plugins/plugin-kubectl:** automatically abort idle PTYs ([2638a65](https://github.com/IBM/kui/commit/2638a65)), closes [#4742](https://github.com/IBM/kui/issues/4742)
- **plugins/plugin-kubectl:** ExecIntoPod's terminal is not theme-aligned ([067cda3](https://github.com/IBM/kui/commit/067cda3)), closes [#4722](https://github.com/IBM/kui/issues/4722)
- **plugins/plugin-kubectl:** get-namespace table sometimes doens't show the correct selected namespace ([af66aa4](https://github.com/IBM/kui/commit/af66aa4)), closes [#4812](https://github.com/IBM/kui/issues/4812)
- **plugins/plugin-kubectl:** helm help parsed usage incorrectly ([b222da2](https://github.com/IBM/kui/commit/b222da2)), closes [#4692](https://github.com/IBM/kui/issues/4692)
- **plugins/plugin-kubectl:** i18n for No log data message ([589a4cd](https://github.com/IBM/kui/commit/589a4cd)), closes [#4656](https://github.com/IBM/kui/issues/4656)
- **plugins/plugin-kubectl:** ImagePullBackoff should be considered a "red" state ([198100d](https://github.com/IBM/kui/commit/198100d)), closes [#4734](https://github.com/IBM/kui/issues/4734)
- **plugins/plugin-kubectl:** improve kubectl tab completion ([734f9e5](https://github.com/IBM/kui/commit/734f9e5)), closes [#4704](https://github.com/IBM/kui/issues/4704)
- **plugins/plugin-kubectl:** improve kubectl top node display with open sidecar ([6f99581](https://github.com/IBM/kui/commit/6f99581)), closes [#4737](https://github.com/IBM/kui/issues/4737)
- **plugins/plugin-kubectl:** k edit -h does not open in sidecar ([b6f68f8](https://github.com/IBM/kui/commit/b6f68f8)), closes [#4661](https://github.com/IBM/kui/issues/4661)
- **plugins/plugin-kubectl:** k edit deploy has mysterious Pod tab ([914df36](https://github.com/IBM/kui/commit/914df36)), closes [#4703](https://github.com/IBM/kui/issues/4703)
- **plugins/plugin-kubectl:** kubectl api-resources table should hide APIGROUP column with open sidecar ([ee347fa](https://github.com/IBM/kui/commit/ee347fa)), closes [#4728](https://github.com/IBM/kui/issues/4728)
- **plugins/plugin-kubectl:** kubectl apply edit-last-applied freezes in kui ([24a67da](https://github.com/IBM/kui/commit/24a67da)), closes [#4808](https://github.com/IBM/kui/issues/4808)
- **plugins/plugin-kubectl:** kubectl apply set-last-applied does not work ([9553907](https://github.com/IBM/kui/commit/9553907)), closes [#4844](https://github.com/IBM/kui/issues/4844)
- **plugins/plugin-kubectl:** kubectl explain subfields ([8fee2bc](https://github.com/IBM/kui/commit/8fee2bc)), closes [#4921](https://github.com/IBM/kui/issues/4921)
- **plugins/plugin-kubectl:** kubectl logs -l with no matches yields internal error ([ed0374f](https://github.com/IBM/kui/commit/ed0374f)), closes [#4811](https://github.com/IBM/kui/issues/4811)
- **plugins/plugin-kubectl:** kubectl logs tab has bad interleaving and cpu issues ([1c7cf17](https://github.com/IBM/kui/commit/1c7cf17)), closes [#4664](https://github.com/IBM/kui/issues/4664) [#4665](https://github.com/IBM/kui/issues/4665)
- **plugins/plugin-kubectl:** kubectl watch tables may lack namespace breadcrumb ([a0616c2](https://github.com/IBM/kui/commit/a0616c2)), closes [#4870](https://github.com/IBM/kui/issues/4870)
- **plugins/plugin-kubectl:** Logs tab should have a default tail limit ([d4cf08c](https://github.com/IBM/kui/commit/d4cf08c)), closes [#4810](https://github.com/IBM/kui/issues/4810) [#4818](https://github.com/IBM/kui/issues/4818)
- **plugins/plugin-kubectl:** oc get projects does not allow user selection ([3749371](https://github.com/IBM/kui/commit/3749371)), closes [#4805](https://github.com/IBM/kui/issues/4805)
- **plugins/plugin-kubectl:** oc logs does not work ([f0808a2](https://github.com/IBM/kui/commit/f0808a2)), closes [#4965](https://github.com/IBM/kui/issues/4965)
- **plugins/plugin-kubectl:** remove Conditions tab ([eac3705](https://github.com/IBM/kui/commit/eac3705)), closes [#4606](https://github.com/IBM/kui/issues/4606)
- **plugins/plugin-kubectl:** remove kubectl edit cancel button ([83179e8](https://github.com/IBM/kui/commit/83179e8)), closes [#4695](https://github.com/IBM/kui/issues/4695)
- **plugins/plugin-kubectl:** remove Show Logs registration ([382c685](https://github.com/IBM/kui/commit/382c685)), closes [#4603](https://github.com/IBM/kui/issues/4603)
- **plugins/plugin-kubectl:** singleton breadcrumbs in kubectl help should not be clickable ([7815464](https://github.com/IBM/kui/commit/7815464)), closes [#4961](https://github.com/IBM/kui/issues/4961)
- avoid hard-coded use of /tmp in kubectl edit ([8e4cb70](https://github.com/IBM/kui/commit/8e4cb70)), closes [#4928](https://github.com/IBM/kui/issues/4928)
- **plugins/plugin-kubectl:** status shows as Containercreating when it should be ContainerCreating ([2c4a3b6](https://github.com/IBM/kui/commit/2c4a3b6)), closes [#4798](https://github.com/IBM/kui/issues/4798)
- **plugins/plugin-kubectl:** windows powershell fails to get default namespace ([a5fb2e1](https://github.com/IBM/kui/commit/a5fb2e1)), closes [#4912](https://github.com/IBM/kui/issues/4912)
- container filter of logs tab shows accumulated logs from previous selection ([08903b4](https://github.com/IBM/kui/commit/08903b4)), closes [#4644](https://github.com/IBM/kui/issues/4644) [#4658](https://github.com/IBM/kui/issues/4658)
- improve error reporting for kubectl apply ([fe21671](https://github.com/IBM/kui/commit/fe21671)), closes [#4605](https://github.com/IBM/kui/issues/4605)
- kubectl api-resources has duplicate rows and odd pagination behavior ([e740270](https://github.com/IBM/kui/commit/e740270)), closes [#4626](https://github.com/IBM/kui/issues/4626)
- logs tab toolbar doesn't signify when pods are 404 ([135e1be](https://github.com/IBM/kui/commit/135e1be)), closes [#4646](https://github.com/IBM/kui/issues/4646)
- pexecs serviced by now-removed splits fail ([f6176a1](https://github.com/IBM/kui/commit/f6176a1)), closes [#4875](https://github.com/IBM/kui/issues/4875)
- **plugins/plugin-kubectl:** Terminal tab test incorrectly verifies k exec output ([20ab362](https://github.com/IBM/kui/commit/20ab362)), closes [#4802](https://github.com/IBM/kui/issues/4802)
- avoid recomputing tabs when switching back and forth ([cf5e41f](https://github.com/IBM/kui/commit/cf5e41f)), closes [#4666](https://github.com/IBM/kui/issues/4666)
- kubectl top node should show % text ([f861b76](https://github.com/IBM/kui/commit/f861b76)), closes [#4598](https://github.com/IBM/kui/issues/4598)
- place namespace breadcrumb first ([5d3b2e4](https://github.com/IBM/kui/commit/5d3b2e4)), closes [#4699](https://github.com/IBM/kui/issues/4699)
- reduce No log data followed by log data behavior in kube logs ([e1c0624](https://github.com/IBM/kui/commit/e1c0624)), closes [#4624](https://github.com/IBM/kui/issues/4624)
- replace Containers with Logs tab ([00e8786](https://github.com/IBM/kui/commit/00e8786)), closes [#4603](https://github.com/IBM/kui/issues/4603)
- the Logs/Terminal retry button should be visible on any exit code ([3366327](https://github.com/IBM/kui/commit/3366327)), closes [#4769](https://github.com/IBM/kui/issues/4769)
- **plugin-kubectl:** k get pods --all-namespaces has a title with "default" as the namespace ([2f95129](https://github.com/IBM/kui/commit/2f95129)), closes [#4466](https://github.com/IBM/kui/issues/4466)
- **plugin-kubectl:** kubectl get error-type -w doesn't fail fast ([4ccb733](https://github.com/IBM/kui/commit/4ccb733)), closes [#4491](https://github.com/IBM/kui/issues/4491)
- **plugins/plugin-kubectl:** add missing test for get with not found ([3e77689](https://github.com/IBM/kui/commit/3e77689)), closes [#4492](https://github.com/IBM/kui/issues/4492)
- **plugins/plugin-kubectl:** avoid use of /s regexp ([9468304](https://github.com/IBM/kui/commit/9468304)), closes [#4259](https://github.com/IBM/kui/issues/4259)
- **plugins/plugin-kubectl:** cache kind canonicalization lookup ([e351a5f](https://github.com/IBM/kui/commit/e351a5f)), closes [#4489](https://github.com/IBM/kui/issues/4489)
- **plugins/plugin-kubectl:** CurrentContext widget shows "default" for openshift clusters ([59712c0](https://github.com/IBM/kui/commit/59712c0)), closes [#4347](https://github.com/IBM/kui/issues/4347)
- **plugins/plugin-kubectl:** ensure Show Owner button appears near end of toolbar buttons ([224c586](https://github.com/IBM/kui/commit/224c586)), closes [#4124](https://github.com/IBM/kui/issues/4124)
- **plugins/plugin-kubectl:** firefox does not support the /s flag to RegExp ([5b661a6](https://github.com/IBM/kui/commit/5b661a6)), closes [#4206](https://github.com/IBM/kui/issues/4206)
- **plugins/plugin-kubectl:** in kube namespace table, selected namespace should float to top ([f0e597f](https://github.com/IBM/kui/commit/f0e597f)), closes [#4129](https://github.com/IBM/kui/issues/4129)
- **plugins/plugin-kubectl:** inconsistent capitalization of breadcrumbs ([963b166](https://github.com/IBM/kui/commit/963b166)), closes [#4607](https://github.com/IBM/kui/issues/4607)
- **plugins/plugin-kubectl:** k get events -w bombs ([20c2caf](https://github.com/IBM/kui/commit/20c2caf)), closes [#4557](https://github.com/IBM/kui/issues/4557)
- **plugins/plugin-kubectl:** kubectl api-resources table shows 'unknown' in title ([0461710](https://github.com/IBM/kui/commit/0461710)), closes [#4145](https://github.com/IBM/kui/issues/4145)
- **plugins/plugin-kubectl:** kubectl create secret hangs yellow ([e11dbb8](https://github.com/IBM/kui/commit/e11dbb8)), closes [#4571](https://github.com/IBM/kui/issues/4571)
- **plugins/plugin-kubectl:** kubectl describe -h has old bold text ([b31d066](https://github.com/IBM/kui/commit/b31d066)), closes [#4568](https://github.com/IBM/kui/issues/4568)
- **plugins/plugin-kubectl:** kubectl edit should support editing a list of resources ([4cd4d43](https://github.com/IBM/kui/commit/4cd4d43)), closes [#4555](https://github.com/IBM/kui/issues/4555)
- **plugins/plugin-kubectl:** kubectl explain -h should render as usage in sidecar ([8e00c3f](https://github.com/IBM/kui/commit/8e00c3f)), closes [#4211](https://github.com/IBM/kui/issues/4211)
- **plugins/plugin-kubectl:** kubectl explain Overview tab not formatted as expected ([ffa9183](https://github.com/IBM/kui/commit/ffa9183)), closes [#4304](https://github.com/IBM/kui/issues/4304)
- **plugins/plugin-kubectl:** kubectl get --all-namespaces --watch does not update ([663a972](https://github.com/IBM/kui/commit/663a972)), closes [#4581](https://github.com/IBM/kui/issues/4581)
- **plugins/plugin-kubectl:** kubectl Show Events query not precise enough ([eda6b38](https://github.com/IBM/kui/commit/eda6b38)), closes [#4572](https://github.com/IBM/kui/issues/4572)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- **plugins/plugin-kubectl:** revert to editor-based Summary tab ([3ecd638](https://github.com/IBM/kui/commit/3ecd638)), closes [#4594](https://github.com/IBM/kui/issues/4594)
- add support for hiding elements at higher zoom levels ([7d2a7e0](https://github.com/IBM/kui/commit/7d2a7e0)), closes [#4232](https://github.com/IBM/kui/issues/4232)
- clicking on certain links in kubectl help result in odd behavior ([035894b](https://github.com/IBM/kui/commit/035894b)), closes [#4473](https://github.com/IBM/kui/issues/4473)
- clicking on container name in details sidecar should add -c to logs command ([61c7c08](https://github.com/IBM/kui/commit/61c7c08)), closes [#4498](https://github.com/IBM/kui/issues/4498)
- eliminate complex nesting of NavResponse model ([e849ae7](https://github.com/IBM/kui/commit/e849ae7)), closes [#4205](https://github.com/IBM/kui/issues/4205)
- ensure kubectl Delete toolbar button appears at far right ([9eb3079](https://github.com/IBM/kui/commit/9eb3079)), closes [#4116](https://github.com/IBM/kui/issues/4116)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- ibmcloud plugin list does not list unofficial plugins ([303fa00](https://github.com/IBM/kui/commit/303fa00)), closes [#4339](https://github.com/IBM/kui/issues/4339)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- kubectl summary Form TextInputs can be cropped ([3becaf9](https://github.com/IBM/kui/commit/3becaf9)), closes [#4077](https://github.com/IBM/kui/issues/4077)
- make inBrowserOk the default ([2a3c811](https://github.com/IBM/kui/commit/2a3c811)), closes [#4275](https://github.com/IBM/kui/issues/4275)
- multiple kubectl help/usage bugs ([ebba36e](https://github.com/IBM/kui/commit/ebba36e)), closes [#4342](https://github.com/IBM/kui/issues/4342)
- multiple tab completion bugs ([5513712](https://github.com/IBM/kui/commit/5513712)), closes [#4281](https://github.com/IBM/kui/issues/4281)
- optimize kubectl watch load on apiserver ([3f7a32f](https://github.com/IBM/kui/commit/3f7a32f)), closes [#4494](https://github.com/IBM/kui/issues/4494)
- PaginatedTable fails at distinguishing the rowKeys of `k get --all-namespaces` table ([6658729](https://github.com/IBM/kui/commit/6658729)), closes [#4579](https://github.com/IBM/kui/issues/4579)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- sidecar views do not respect tab-specificity ([5a1cae2](https://github.com/IBM/kui/commit/5a1cae2)), closes [#4362](https://github.com/IBM/kui/issues/4362)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- TopNavSidecar does not always show updates ([251e5c4](https://github.com/IBM/kui/commit/251e5c4)), closes [#4524](https://github.com/IBM/kui/issues/4524)
- **plugins/plugin-kubectl:** kubectl describe (--help) fails ([10b8e8a](https://github.com/IBM/kui/commit/10b8e8a)), closes [#4012](https://github.com/IBM/kui/issues/4012)
- **plugins/plugin-kubectl:** kubectl get table with mix of existing and non-existing ([8d98d15](https://github.com/IBM/kui/commit/8d98d15)), closes [#4492](https://github.com/IBM/kui/issues/4492)
- **plugins/plugin-kubectl:** kubectl top nodes can present "NaN" ([30df3dd](https://github.com/IBM/kui/commit/30df3dd)), closes [#4189](https://github.com/IBM/kui/issues/4189)
- **plugins/plugin-kubectl:** more refinements to Form layout heuristics ([e92327d](https://github.com/IBM/kui/commit/e92327d)), closes [#4118](https://github.com/IBM/kui/issues/4118)
- **plugins/plugin-kubectl:** oc describe fails ([4f4de4e](https://github.com/IBM/kui/commit/4f4de4e)), closes [#4008](https://github.com/IBM/kui/issues/4008)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- **plugins/plugin-kubectl:** update deprecated import of uuid ([5de8d4d](https://github.com/IBM/kui/commit/5de8d4d)), closes [#4316](https://github.com/IBM/kui/issues/4316)
- **plugins/plugin-kubectl:** watch table doesn't have breadcrumbs title ([43fbe6a](https://github.com/IBM/kui/commit/43fbe6a)), closes [#4135](https://github.com/IBM/kui/issues/4135)
- **plugins/plugin-kubectl:** watcher table disappears when kui is launched as kubectl plugin ([167eabc](https://github.com/IBM/kui/commit/167eabc)), closes [#4120](https://github.com/IBM/kui/issues/4120) [#4123](https://github.com/IBM/kui/issues/4123)
- **plugins/plugin-kubectl:** we shouldn't render namespace widget when the namespace is empty in kube config ([98a9406](https://github.com/IBM/kui/commit/98a9406)), closes [#4274](https://github.com/IBM/kui/issues/4274)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- tekton Step nodes show with hashed background ([8428d72](https://github.com/IBM/kui/commit/8428d72)), closes [#4114](https://github.com/IBM/kui/issues/4114)
- the colors of status badges: Error, ImagePullBackOff and ErrImagePull are incorrect ([fd206f6](https://github.com/IBM/kui/commit/fd206f6)), closes [#4171](https://github.com/IBM/kui/issues/4171)
- TopNavSidecar tabs should auto-pause and auto-focus when switching ([2b00dd9](https://github.com/IBM/kui/commit/2b00dd9)), closes [#4741](https://github.com/IBM/kui/issues/4741) [#4748](https://github.com/IBM/kui/issues/4748)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)

### Features

- **plugins/plugin-kubectl:** add explain fastpaths for \*.v1.apps ([0b0e82a](https://github.com/IBM/kui/commit/0b0e82a)), closes [#6862](https://github.com/IBM/kui/issues/6862)
- **plugins/plugin-kubectl:** add Secret explain and Summary fastpaths ([90bbd89](https://github.com/IBM/kui/commit/90bbd89)), closes [#6868](https://github.com/IBM/kui/issues/6868)
- show buttons of related resources in sidecar footer ([e10f7f2](https://github.com/IBM/kui/commit/e10f7f2)), closes [#6856](https://github.com/IBM/kui/issues/6856)
- **plugins/plugin-kubectl:** add explain fastpath for events ([a16e75f](https://github.com/IBM/kui/commit/a16e75f)), closes [#6836](https://github.com/IBM/kui/issues/6836)
- **plugins/plugin-kubectl:** Add simple kubectl delete to the list of direct optimizations ([d4fb765](https://github.com/IBM/kui/commit/d4fb765)), closes [#6468](https://github.com/IBM/kui/issues/6468)
- **plugins/plugin-kubectl:** Add Summary impl for Events ([74f4e55](https://github.com/IBM/kui/commit/74f4e55)), closes [#6839](https://github.com/IBM/kui/issues/6839)
- **plugins/plugin-kubectl:** apply/delete -f can use new direct/status watcher for homogeneous use cases ([08e471e](https://github.com/IBM/kui/commit/08e471e)), closes [#6498](https://github.com/IBM/kui/issues/6498)
- **plugins/plugin-kubectl:** flesh out explain fastpath for more apps/v1 types ([6f68a98](https://github.com/IBM/kui/commit/6f68a98)), closes [#6854](https://github.com/IBM/kui/issues/6854)
- **plugins/plugin-kubectl:** improve the performance of kubectl explain for common cases ([d016971](https://github.com/IBM/kui/commit/d016971)), closes [#6700](https://github.com/IBM/kui/issues/6700)
- **plugins/plugin-kubectl:** static get -f should show sourceRef ([fb0fc40](https://github.com/IBM/kui/commit/fb0fc40)), closes [#6680](https://github.com/IBM/kui/issues/6680)
- add a prefer-re-execution option to snapshot ([af7b98b](https://github.com/IBM/kui/commit/af7b98b)), closes [#5622](https://github.com/IBM/kui/issues/5622)
- add delta summary to Tree ([95a0b4a](https://github.com/IBM/kui/commit/95a0b4a)), closes [#6329](https://github.com/IBM/kui/issues/6329)
- add events to sidecar tree ([dd4d552](https://github.com/IBM/kui/commit/dd4d552)), closes [#6140](https://github.com/IBM/kui/issues/6140)
- Add simple kubectl create namespace to the list of direct optimizations ([2aaaac6](https://github.com/IBM/kui/commit/2aaaac6)), closes [#6470](https://github.com/IBM/kui/issues/6470)
- allow controllers to control the color of the status stripe ([708570c](https://github.com/IBM/kui/commit/708570c)), closes [#5490](https://github.com/IBM/kui/issues/5490)
- allow for limiting the number of kubectl table rows ([62588f2](https://github.com/IBM/kui/commit/62588f2)), closes [#5358](https://github.com/IBM/kui/issues/5358)
- background new tabs ([be9f986](https://github.com/IBM/kui/commit/be9f986)), closes [#5550](https://github.com/IBM/kui/issues/5550)
- clicking on events in watch table should drill down to events ([c6dc99f](https://github.com/IBM/kui/commit/c6dc99f)), closes [#5173](https://github.com/IBM/kui/issues/5173)
- cold start delays ([83abd14](https://github.com/IBM/kui/commit/83abd14)), closes [#5356](https://github.com/IBM/kui/issues/5356)
- custom tab titles ([fd780df](https://github.com/IBM/kui/commit/fd780df)), closes [#5525](https://github.com/IBM/kui/issues/5525)
- Expand kubectl direct watching to support heterogeneous use cases ([8df1ad3](https://github.com/IBM/kui/commit/8df1ad3)), closes [#6504](https://github.com/IBM/kui/issues/6504)
- generalized kuberctl get with limit ([d40ee07](https://github.com/IBM/kui/commit/d40ee07)), closes [#5361](https://github.com/IBM/kui/issues/5361)
- initial popeye support ([9d62eeb](https://github.com/IBM/kui/commit/9d62eeb)), closes [#5265](https://github.com/IBM/kui/issues/5265)
- initial support for using a kubectl proxy ([47b26be](https://github.com/IBM/kui/commit/47b26be)), closes [#6440](https://github.com/IBM/kui/issues/6440)
- initial typeahead for commands ([7ba313a](https://github.com/IBM/kui/commit/7ba313a)), closes [#5437](https://github.com/IBM/kui/issues/5437)
- Kui implementation of `watch` ([2cb3f98](https://github.com/IBM/kui/commit/2cb3f98)), closes [#6379](https://github.com/IBM/kui/issues/6379)
- revive "app" and "tier" columns from deprecated kubectl tree view ([cd642d9](https://github.com/IBM/kui/commit/cd642d9)), closes [#6591](https://github.com/IBM/kui/issues/6591)
- **plugins/plugin-kubectl:** Port kubectl pollers to use push, for homogeneous deletes ([82448d7](https://github.com/IBM/kui/commit/82448d7)), closes [#6481](https://github.com/IBM/kui/issues/6481) [#6486](https://github.com/IBM/kui/issues/6486)
- **plugins/plugin-kubectl:** update get -f to use direct/status and show a table ([16bdbb6](https://github.com/IBM/kui/commit/16bdbb6)), closes [#6566](https://github.com/IBM/kui/issues/6566) [#6532](https://github.com/IBM/kui/issues/6532)
- Extend kubectl optimizations to table watching ([9a2bc74](https://github.com/IBM/kui/commit/9a2bc74)), closes [#6449](https://github.com/IBM/kui/issues/6449)
- in `kubectl get -f` tree, use Monaco DiffEditor show the preview of dry-run changes ([99266e8](https://github.com/IBM/kui/commit/99266e8)), closes [#6181](https://github.com/IBM/kui/issues/6181) [#6154](https://github.com/IBM/kui/issues/6154)
- initial support for capturing input files and showing them in the UI ([5744bf4](https://github.com/IBM/kui/commit/5744bf4)), closes [#5513](https://github.com/IBM/kui/issues/5513)
- inline sidecar ([2c3afeb](https://github.com/IBM/kui/commit/2c3afeb)), closes [#6007](https://github.com/IBM/kui/issues/6007)
- Move in OpenWhisk plugin from the external repo ([b9c5867](https://github.com/IBM/kui/commit/b9c5867)), closes [#6109](https://github.com/IBM/kui/issues/6109)
- notebook client ([4b64133](https://github.com/IBM/kui/commit/4b64133)), closes [#5501](https://github.com/IBM/kui/issues/5501)
- refine kubectl contexts table; add support for RadioTable row titles ([11bb074](https://github.com/IBM/kui/commit/11bb074)), closes [#5131](https://github.com/IBM/kui/issues/5131)
- s3 plugin, and vfs ([970ba6e](https://github.com/IBM/kui/commit/970ba6e)), closes [#5319](https://github.com/IBM/kui/issues/5319)
- tutorial VFS ([6f2330e](https://github.com/IBM/kui/commit/6f2330e)), closes [#5441](https://github.com/IBM/kui/issues/5441)
- update CurrentContext widget to use Dropdown ([9520e5d](https://github.com/IBM/kui/commit/9520e5d)), closes [#6354](https://github.com/IBM/kui/issues/6354)
- use Monaco DiffEditor `kubectl diff` ([3157393](https://github.com/IBM/kui/commit/3157393))
- use new Dropdown status stripe for CurrentNamespace widget ([0f7648c](https://github.com/IBM/kui/commit/0f7648c)), closes [#6351](https://github.com/IBM/kui/issues/6351)
- UX: Use Dropdown for theme switcher ([6cc6a47](https://github.com/IBM/kui/commit/6cc6a47)), closes [#6347](https://github.com/IBM/kui/issues/6347)
- **packages/core:** allow controller to opt in/out recording table row onclicks when snapshot ([cc83ce7](https://github.com/IBM/kui/commit/cc83ce7)), closes [#5565](https://github.com/IBM/kui/issues/5565)
- **plugins/plugin-client-common:** improved SequenceDiagram view ([1e2fb41](https://github.com/IBM/kui/commit/1e2fb41)), closes [#5342](https://github.com/IBM/kui/issues/5342)
- **plugins/plugin-git:** git branch should respond with RadioTable ([59a9213](https://github.com/IBM/kui/commit/59a9213)), closes [#5256](https://github.com/IBM/kui/issues/5256)
- **plugins/plugin-ibmcloud:** initial CodeEngine support ([677faca](https://github.com/IBM/kui/commit/677faca)), closes [#5302](https://github.com/IBM/kui/issues/5302) [#5303](https://github.com/IBM/kui/issues/5303)
- add button to WatchPane to show table back in terminal ([dc22591](https://github.com/IBM/kui/commit/dc22591)), closes [#4530](https://github.com/IBM/kui/issues/4530)
- add capability to show welcome widget to new users in Terminal ([0c33e6e](https://github.com/IBM/kui/commit/0c33e6e)), closes [#4990](https://github.com/IBM/kui/issues/4990) [#5007](https://github.com/IBM/kui/issues/5007)
- add isSelected and Divider to log container selection menu ([59bdaa5](https://github.com/IBM/kui/commit/59bdaa5)), closes [#4647](https://github.com/IBM/kui/issues/4647)
- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Patternfly Breadcrumb support ([91e0504](https://github.com/IBM/kui/commit/91e0504)), closes [#4381](https://github.com/IBM/kui/issues/4381)
- add Retry button to sidecar toolbar when log streaming stopped abnormally ([47872f4](https://github.com/IBM/kui/commit/47872f4)), closes [#4755](https://github.com/IBM/kui/issues/4755)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add Stop Watching capability to WatchPane ([09043c1](https://github.com/IBM/kui/commit/09043c1)), closes [#4554](https://github.com/IBM/kui/issues/4554)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- allow users to select container in kubectl Logs ([f4304c5](https://github.com/IBM/kui/commit/f4304c5)), closes [#4627](https://github.com/IBM/kui/issues/4627)
- commands should be able to separate resource model fetch from view transformation functions ([e903bc7](https://github.com/IBM/kui/commit/e903bc7)), closes [#4437](https://github.com/IBM/kui/issues/4437)
- ibmcloud plugin ([aa0f72f](https://github.com/IBM/kui/commit/aa0f72f)), closes [#4353](https://github.com/IBM/kui/issues/4353)
- improve kubectl edit experience ([4c4a1c9](https://github.com/IBM/kui/commit/4c4a1c9)), closes [#4783](https://github.com/IBM/kui/issues/4783)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- improve rendering of kubectl subcommand help ([e36ed29](https://github.com/IBM/kui/commit/e36ed29)), closes [#4824](https://github.com/IBM/kui/issues/4824)
- initial odo catalog list enhancements ([8534267](https://github.com/IBM/kui/commit/8534267)), closes [#4485](https://github.com/IBM/kui/issues/4485)
- kubectl apply view-last-applied ([6d601ef](https://github.com/IBM/kui/commit/6d601ef)), closes [#4822](https://github.com/IBM/kui/issues/4822)
- kubectl edit via kui's editor ([414e813](https://github.com/IBM/kui/commit/414e813)), closes [#762](https://github.com/IBM/kui/issues/762)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- line highlights on editor save, used for k edit apply errors ([3efa6a5](https://github.com/IBM/kui/commit/3efa6a5)), closes [#4795](https://github.com/IBM/kui/issues/4795)
- MiniSplits ([70b8441](https://github.com/IBM/kui/commit/70b8441)), closes [#5112](https://github.com/IBM/kui/issues/5112)
- only enable WatchPane based on a feature flag ([eb80d0e](https://github.com/IBM/kui/commit/eb80d0e)), closes [#4678](https://github.com/IBM/kui/issues/4678) [#4604](https://github.com/IBM/kui/issues/4604)
- patternfly4 themes ([5f58f71](https://github.com/IBM/kui/commit/5f58f71)), closes [#4364](https://github.com/IBM/kui/issues/4364)
- pin a watchable terminal response in a split pane ([662f413](https://github.com/IBM/kui/commit/662f413)), closes [#4865](https://github.com/IBM/kui/issues/4865) [#4573](https://github.com/IBM/kui/issues/4573) [#4885](https://github.com/IBM/kui/issues/4885) [#4894](https://github.com/IBM/kui/issues/4894)
- port kubectl get ns to RadioTable ([be0eabf](https://github.com/IBM/kui/commit/be0eabf)), closes [#4510](https://github.com/IBM/kui/issues/4510) [#4511](https://github.com/IBM/kui/issues/4511)
- show resource version in toolbar text ([1a6e335](https://github.com/IBM/kui/commit/1a6e335)), closes [#4790](https://github.com/IBM/kui/issues/4790)
- split screen Terminal ([3a6b422](https://github.com/IBM/kui/commit/3a6b422)), closes [#4814](https://github.com/IBM/kui/issues/4814) [#4821](https://github.com/IBM/kui/issues/4821)
- support for events in crud table footer ([0b90ead](https://github.com/IBM/kui/commit/0b90ead)), closes [#5125](https://github.com/IBM/kui/issues/5125)
- support for events in table footer ([51669af](https://github.com/IBM/kui/commit/51669af)), closes [#5115](https://github.com/IBM/kui/issues/5115)
- **plugins/plugin-kubectl:** add Show Node button for kubectl pods ([04e29d2](https://github.com/IBM/kui/commit/04e29d2)), closes [#4214](https://github.com/IBM/kui/issues/4214)
- **plugins/plugin-kubectl:** add status column to kube deployment table ([1d35040](https://github.com/IBM/kui/commit/1d35040)), closes [#5476](https://github.com/IBM/kui/issues/5476)
- **plugins/plugin-kubectl:** add support for kustomize apply/delete/create ([b95cbdb](https://github.com/IBM/kui/commit/b95cbdb)), closes [#4203](https://github.com/IBM/kui/issues/4203)
- **plugins/plugin-kubectl:** configmap summary should show data ([50c7e10](https://github.com/IBM/kui/commit/50c7e10)), closes [#4025](https://github.com/IBM/kui/issues/4025)
- **plugins/plugin-kubectl:** enhance odo project list as RadioTable ([62272e6](https://github.com/IBM/kui/commit/62272e6)), closes [#4517](https://github.com/IBM/kui/issues/4517)
- **plugins/plugin-kubectl:** improve odo usage experience ([639ca32](https://github.com/IBM/kui/commit/639ca32)), closes [#4345](https://github.com/IBM/kui/issues/4345)
- **plugins/plugin-kubectl:** initial `kubectl job list` improvement for visualizing Job execution ([06030b0](https://github.com/IBM/kui/commit/06030b0)), closes [#5397](https://github.com/IBM/kui/issues/5397)
- **plugins/plugin-kubectl:** initial labs for listing k8s resources and creating jobs ([2e9d002](https://github.com/IBM/kui/commit/2e9d002)), closes [#5475](https://github.com/IBM/kui/issues/5475)
- **plugins/plugin-kubectl:** kubectl events tab ([2d71f24](https://github.com/IBM/kui/commit/2d71f24)), closes [#4706](https://github.com/IBM/kui/issues/4706)
- **plugins/plugin-kubectl:** kubectl get -f can use Tree to present structured result ([f94a22f](https://github.com/IBM/kui/commit/f94a22f)), closes [#6136](https://github.com/IBM/kui/issues/6136)
- **plugins/plugin-kubectl:** namespace onclick should drill down to sidecar ([e74f66d](https://github.com/IBM/kui/commit/e74f66d)), closes [#4714](https://github.com/IBM/kui/issues/4714)
- **plugins/plugin-kubectl:** Namespace Summary impl ([2d69d67](https://github.com/IBM/kui/commit/2d69d67)), closes [#5790](https://github.com/IBM/kui/issues/5790)
- **plugins/plugin-kubectl:** optimize rendering of kubectl Summary tab ([7c6480d](https://github.com/IBM/kui/commit/7c6480d)), closes [#4725](https://github.com/IBM/kui/issues/4725)
- **plugins/plugin-kubectl:** optimizing Node summary impl ([8ac11b9](https://github.com/IBM/kui/commit/8ac11b9)), closes [#4833](https://github.com/IBM/kui/issues/4833)
- **plugins/plugin-kubectl:** ReplicaSet should have Pods tab ([42cd286](https://github.com/IBM/kui/commit/42cd286)), closes [#4110](https://github.com/IBM/kui/issues/4110)
- **plugins/plugin-kubectl:** restore Show Logs button for kubectl ([6b17dbd](https://github.com/IBM/kui/commit/6b17dbd)), closes [#4089](https://github.com/IBM/kui/issues/4089)
- **plugins/plugin-kubectl:** Show Previous option for Logs tab ([2307d2f](https://github.com/IBM/kui/commit/2307d2f)), closes [#4864](https://github.com/IBM/kui/issues/4864)
- simplified co-hosting of client and proxy in a container ([00af4b4](https://github.com/IBM/kui/commit/00af4b4)), closes [#4213](https://github.com/IBM/kui/issues/4213)
- target kubectl logs and kubectl exec to Logs and Terminal tabs ([409e632](https://github.com/IBM/kui/commit/409e632)), closes [#4762](https://github.com/IBM/kui/issues/4762)
- **plugins/plugin-kubectl:** Terminal tab for Pod kubernetes resources ([c47e432](https://github.com/IBM/kui/commit/c47e432)), closes [#4639](https://github.com/IBM/kui/issues/4639)
- watcher panel for open-ended watch jobs ([6dfe7df](https://github.com/IBM/kui/commit/6dfe7df)), closes [#4503](https://github.com/IBM/kui/issues/4503)
- **plugins/plugin-kubectl:** port kubectl contexts table to RadioTable ([3cb4dcb](https://github.com/IBM/kui/commit/3cb4dcb)), closes [#4513](https://github.com/IBM/kui/issues/4513)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- SPI for icons ([3d034e3](https://github.com/IBM/kui/commit/3d034e3)), closes [#4441](https://github.com/IBM/kui/issues/4441) [#4364](https://github.com/IBM/kui/issues/4364)
- top tab buttons ([ff8cfba](https://github.com/IBM/kui/commit/ff8cfba)), closes [#4434](https://github.com/IBM/kui/issues/4434)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)

### BREAKING CHANGES

- removes support for inBrowserOk

# [9.3.0](https://github.com/IBM/kui/compare/v4.5.0...v9.3.0) (2020-12-11)

### Bug Fixes

- drilldown from an undeployed application in tree will issue a kubectl get with 404 ([309a9a0](https://github.com/IBM/kui/commit/309a9a0)), closes [#6331](https://github.com/IBM/kui/issues/6331)
- update kubectl/notebooks/deploy-applications for the Mode Toolbar change ([164244e](https://github.com/IBM/kui/commit/164244e)), closes [#6385](https://github.com/IBM/kui/issues/6385)
- **plugins/plugin-kubectl:** helm test can fail due to helm release name exceeding 63 characters ([a9903ea](https://github.com/IBM/kui/commit/a9903ea)), closes [#6377](https://github.com/IBM/kui/issues/6377)
- **plugins/plugin-kubectl:** kubectl kustomize does not handle ~ home directory expansion ([f124b1d](https://github.com/IBM/kui/commit/f124b1d)), closes [#6115](https://github.com/IBM/kui/issues/6115)
- don't show "Created a split" when clicking on the New Split button ([80192d5](https://github.com/IBM/kui/commit/80192d5)), closes [#6001](https://github.com/IBM/kui/issues/6001)
- events in tree are presented out of temporal order ([b3ba61e](https://github.com/IBM/kui/commit/b3ba61e)), closes [#6168](https://github.com/IBM/kui/issues/6168)
- monaco diff view colors are not themed ([eed2527](https://github.com/IBM/kui/commit/eed2527)), closes [#6232](https://github.com/IBM/kui/issues/6232)
- tree should support leaf node drilling down ([006b881](https://github.com/IBM/kui/commit/006b881)), closes [#6293](https://github.com/IBM/kui/issues/6293)
- tweak the toolbar text and button label of `k get -f` tree ([ad476c5](https://github.com/IBM/kui/commit/ad476c5)), closes [#6303](https://github.com/IBM/kui/issues/6303)
- **plugins/plugin-client-common:** clicking the split button may cause the current processing block to disappear ([aa2b40c](https://github.com/IBM/kui/commit/aa2b40c)), closes [#5703](https://github.com/IBM/kui/issues/5703)
- **plugins/plugin-client-common:** don't offer Grid option for 1-row tables ([a2a6f8d](https://github.com/IBM/kui/commit/a2a6f8d)), closes [#5474](https://github.com/IBM/kui/issues/5474)
- **plugins/plugin-client-common:** isReplay bit on Blocks is not set for snapshots ([c6d1633](https://github.com/IBM/kui/commit/c6d1633)), closes [#5868](https://github.com/IBM/kui/issues/5868)
- **plugins/plugin-client-common:** SequenceDiagram UI refinements ([5d8c3f7](https://github.com/IBM/kui/commit/5d8c3f7)), closes [#5557](https://github.com/IBM/kui/issues/5557)
- **plugins/plugin-client-common:** update welcome.json to describe kui, not just notebooks ([96330c4](https://github.com/IBM/kui/commit/96330c4)), closes [#5878](https://github.com/IBM/kui/issues/5878)
- **plugins/plugin-kubectl:** "logs dashC follow via table" test is unreliable after electron 10 update ([72c50ab](https://github.com/IBM/kui/commit/72c50ab)), closes [#6152](https://github.com/IBM/kui/issues/6152)
- **plugins/plugin-kubectl:** add Summary impl for kubernetes Jobs ([b0f3809](https://github.com/IBM/kui/commit/b0f3809)), closes [#5481](https://github.com/IBM/kui/issues/5481)
- **plugins/plugin-kubectl:** k8s table should display status Propagated and Subscribed as green ([0787b4b](https://github.com/IBM/kui/commit/0787b4b)), closes [#5818](https://github.com/IBM/kui/issues/5818)
- **plugins/plugin-kubectl:** kubectl delete ns m1 m2 m3 m4 results in a one-row table ([97a33a4](https://github.com/IBM/kui/commit/97a33a4)), closes [#5694](https://github.com/IBM/kui/issues/5694)
- **plugins/plugin-kubectl:** kubectl get -f can show undefined in table title ([eb34d1c](https://github.com/IBM/kui/commit/eb34d1c)), closes [#5469](https://github.com/IBM/kui/issues/5469)
- **plugins/plugin-kubectl:** kubectl status table does not register onclickIdempotent ([6ae296c](https://github.com/IBM/kui/commit/6ae296c)), closes [#5788](https://github.com/IBM/kui/issues/5788)
- **plugins/plugin-kubectl:** kubectl table should show PropagationFailed status as offline ([a44b70c](https://github.com/IBM/kui/commit/a44b70c)), closes [#5821](https://github.com/IBM/kui/issues/5821)
- **plugins/plugin-kubectl:** regenerate kubernetes notebooks to show new Source Reference feature ([8324567](https://github.com/IBM/kui/commit/8324567)), closes [#5520](https://github.com/IBM/kui/issues/5520)
- **plugins/plugin-kubectl:** the Deploy Applications notebook has some typos ([817f9b7](https://github.com/IBM/kui/commit/817f9b7)), closes [#6256](https://github.com/IBM/kui/issues/6256)
- **plugins/plugin-kubectl:** unlabeled resources shouldn’t have badge for children's count ([4e1fea6](https://github.com/IBM/kui/commit/4e1fea6)), closes [#6243](https://github.com/IBM/kui/issues/6243)
- avoid excessive status stripe overheads when replaying Notebooks ([58de9c0](https://github.com/IBM/kui/commit/58de9c0)), closes [#5635](https://github.com/IBM/kui/issues/5635)
- grid colors are sometimes off ([e66f56f](https://github.com/IBM/kui/commit/e66f56f)), closes [#5422](https://github.com/IBM/kui/issues/5422)
- improve existing notebooks for v1 ([1af5cc2](https://github.com/IBM/kui/commit/1af5cc2)), closes [#5858](https://github.com/IBM/kui/issues/5858)
- improve the discoverability of repl-block action buttons ([470da34](https://github.com/IBM/kui/commit/470da34)), closes [#5604](https://github.com/IBM/kui/issues/5604)
- improve the replayability of terminal splitting ([67811cd](https://github.com/IBM/kui/commit/67811cd)), closes [#5564](https://github.com/IBM/kui/issues/5564)
- JS console may contain xtermjs error messages when sidecar is minimized ([a568528](https://github.com/IBM/kui/commit/a568528)), closes [#5454](https://github.com/IBM/kui/issues/5454)
- refine tree label categoriazation of kubectl ([1973a43](https://github.com/IBM/kui/commit/1973a43)), closes [#6185](https://github.com/IBM/kui/issues/6185)
- **plugins/plugin-kubectl:** typos in Tree Toolbar text ([0d9a6be](https://github.com/IBM/kui/commit/0d9a6be)), closes [#6514](https://github.com/IBM/kui/issues/6514)
- RadioTables are not replayable ([d0dd00e](https://github.com/IBM/kui/commit/d0dd00e)), closes [#5599](https://github.com/IBM/kui/issues/5599)
- restore status stripe to default behavior on terminal clear ([128ec92](https://github.com/IBM/kui/commit/128ec92)), closes [#5495](https://github.com/IBM/kui/issues/5495)
- sidecar shouldn't be opened automatically when replay ([8d4cf8c](https://github.com/IBM/kui/commit/8d4cf8c)), closes [#5730](https://github.com/IBM/kui/issues/5730)
- snapshot and replay of table clicks for Notebook v1 ([1a87dbf](https://github.com/IBM/kui/commit/1a87dbf)), closes [#5821](https://github.com/IBM/kui/issues/5821)
- snapshot command throws errors when capturing watch responses ([600f049](https://github.com/IBM/kui/commit/600f049)), closes [#5452](https://github.com/IBM/kui/issues/5452)
- store the commentary text result to the command when editing is done ([5a3f5e8](https://github.com/IBM/kui/commit/5a3f5e8)), closes [#5916](https://github.com/IBM/kui/issues/5916) [#5672](https://github.com/IBM/kui/issues/5672)
- UI glitches of Tree ([fc5af7a](https://github.com/IBM/kui/commit/fc5af7a)), closes [#6138](https://github.com/IBM/kui/issues/6138)
- **plugins/plugin-client-common:** for now, switch interval chart to duration chart ([ea21221](https://github.com/IBM/kui/commit/ea21221)), closes [#5340](https://github.com/IBM/kui/issues/5340)
- **plugins/plugin-client-common:** Grid regression: grid colors not right ([d1aa46d](https://github.com/IBM/kui/commit/d1aa46d)), closes [#5285](https://github.com/IBM/kui/issues/5285)
- **plugins/plugin-client-common:** improve display of empty watch tables ([4cc16be](https://github.com/IBM/kui/commit/4cc16be)), closes [#5176](https://github.com/IBM/kui/issues/5176)
- **plugins/plugin-client-common:** kubectl watch is broken for server versions >= 1.17 ([2d595b7](https://github.com/IBM/kui/commit/2d595b7)), closes [#5360](https://github.com/IBM/kui/issues/5360)
- **plugins/plugin-client-common:** make Close a top-level button in watch panes ([3c14da5](https://github.com/IBM/kui/commit/3c14da5)), closes [#4945](https://github.com/IBM/kui/issues/4945)
- **plugins/plugin-kubectl:** `oc get namespaces` doesn't produce a RadioTable ([6ea6131](https://github.com/IBM/kui/commit/6ea6131)), closes [#5227](https://github.com/IBM/kui/issues/5227)
- **plugins/plugin-kubectl:** add traffic light colors for OOMKilled and UnexpectedAdmissionError ([4262409](https://github.com/IBM/kui/commit/4262409)), closes [#5345](https://github.com/IBM/kui/issues/5345)
- **plugins/plugin-kubectl:** certain filepath options to kubectl were not tilde-expanded ([9e7f858](https://github.com/IBM/kui/commit/9e7f858)), closes [#5415](https://github.com/IBM/kui/issues/5415)
- **plugins/plugin-kubectl:** changing ns via oc does not update ns widget, in browser clients ([5eaa625](https://github.com/IBM/kui/commit/5eaa625)), closes [#4953](https://github.com/IBM/kui/issues/4953)
- **plugins/plugin-kubectl:** CurrentNamespace/Context widgets not live ([93ac829](https://github.com/IBM/kui/commit/93ac829)), closes [#5144](https://github.com/IBM/kui/issues/5144)
- **plugins/plugin-kubectl:** drilldown command of resources in watch --all-namespace table doesn't have '-o yaml' ([1e4f558](https://github.com/IBM/kui/commit/1e4f558)), closes [#5208](https://github.com/IBM/kui/issues/5208)
- **plugins/plugin-kubectl:** event footer watching should also support named resources ([e3a842b](https://github.com/IBM/kui/commit/e3a842b)), closes [#5180](https://github.com/IBM/kui/issues/5180)
- **plugins/plugin-kubectl:** events in table appear to be in random order ([034dc06](https://github.com/IBM/kui/commit/034dc06)), closes [#5212](https://github.com/IBM/kui/issues/5212)
- **plugins/plugin-kubectl:** Fail should be TrafficLight.Red and Succeeded should be TrafficLight.Green ([54737b6](https://github.com/IBM/kui/commit/54737b6)), closes [#5351](https://github.com/IBM/kui/issues/5351)
- **plugins/plugin-kubectl:** header-only tables improperly parsed ([f56841b](https://github.com/IBM/kui/commit/f56841b)), closes [#5382](https://github.com/IBM/kui/issues/5382)
- **plugins/plugin-kubectl:** isReplicaSet needs to be updated to handle "apps/v1" apiVersion ([6887a0d](https://github.com/IBM/kui/commit/6887a0d)), closes [#6003](https://github.com/IBM/kui/issues/6003)
- **plugins/plugin-kubectl:** kubectl apply -f may not abort the event watcher ([c8df222](https://github.com/IBM/kui/commit/c8df222)), closes [#5149](https://github.com/IBM/kui/issues/5149)
- **plugins/plugin-kubectl:** kubectl apply edit-last-applied freezes in kui ([24a67da](https://github.com/IBM/kui/commit/24a67da)), closes [#4808](https://github.com/IBM/kui/issues/4808)
- **plugins/plugin-kubectl:** kubectl apply set-last-applied does not work ([9553907](https://github.com/IBM/kui/commit/9553907)), closes [#4844](https://github.com/IBM/kui/issues/4844)
- **plugins/plugin-kubectl:** kubectl apply/create/delete tables still have ALLCAPS headers ([90d72ce](https://github.com/IBM/kui/commit/90d72ce)), closes [#5068](https://github.com/IBM/kui/issues/5068)
- **plugins/plugin-kubectl:** kubectl Deployment summary does not handle `undefined` fields ([0f65c3c](https://github.com/IBM/kui/commit/0f65c3c)), closes [#6028](https://github.com/IBM/kui/issues/6028)
- **plugins/plugin-kubectl:** kubectl explain subfields ([8fee2bc](https://github.com/IBM/kui/commit/8fee2bc)), closes [#4921](https://github.com/IBM/kui/issues/4921)
- **plugins/plugin-kubectl:** kubectl logs -l with no matches yields internal error ([ed0374f](https://github.com/IBM/kui/commit/ed0374f)), closes [#4811](https://github.com/IBM/kui/issues/4811)
- **plugins/plugin-kubectl:** kubectl Logs/Events/Terminal tabs do not reflow on sidecar maximize ([6dbcbe8](https://github.com/IBM/kui/commit/6dbcbe8)), closes [#5417](https://github.com/IBM/kui/issues/5417)
- **plugins/plugin-kubectl:** kubectl tab completion does not let me tab-complete some filepaths ([e42daa7](https://github.com/IBM/kui/commit/e42daa7)), closes [#5413](https://github.com/IBM/kui/issues/5413)
- **plugins/plugin-kubectl:** kubectl watch tables may lack namespace breadcrumb ([a0616c2](https://github.com/IBM/kui/commit/a0616c2)), closes [#4870](https://github.com/IBM/kui/issues/4870)
- **plugins/plugin-kubectl:** kubectl watcher needs to pass through kubeconfig in its call to kubectl version ([a5d83a3](https://github.com/IBM/kui/commit/a5d83a3)), closes [#5368](https://github.com/IBM/kui/issues/5368)
- **plugins/plugin-kubectl:** kubernetes contexts table renders poorly ([e2ed7d8](https://github.com/IBM/kui/commit/e2ed7d8)), closes [#5230](https://github.com/IBM/kui/issues/5230)
- **plugins/plugin-kubectl:** Kui may invoke kubectl with duplicate command line options ([39c9d31](https://github.com/IBM/kui/commit/39c9d31)), closes [#5330](https://github.com/IBM/kui/issues/5330)
- **plugins/plugin-kubectl:** kui semi-ignores --dry-run for kubectl apply ([90c329f](https://github.com/IBM/kui/commit/90c329f)), closes [#6106](https://github.com/IBM/kui/issues/6106)
- **plugins/plugin-kubectl:** leftover debug printfs in table-watch ([407855a](https://github.com/IBM/kui/commit/407855a)), closes [#5317](https://github.com/IBM/kui/issues/5317)
- **plugins/plugin-kubectl:** nil and negative timestamps display as "0ms ago" ([641a599](https://github.com/IBM/kui/commit/641a599)), closes [#5136](https://github.com/IBM/kui/issues/5136)
- **plugins/plugin-kubectl:** oc get ns does not present a RadioTable ([9e28eec](https://github.com/IBM/kui/commit/9e28eec)), closes [#5106](https://github.com/IBM/kui/issues/5106)
- **plugins/plugin-kubectl:** Pod summary impl fails for pods with no containerStatuses ([66b21b5](https://github.com/IBM/kui/commit/66b21b5)), closes [#5192](https://github.com/IBM/kui/issues/5192)
- (plugins/plugin-kubectl): kubectl get pod -w --all-namespaces behaves oddly ([12e578a](https://github.com/IBM/kui/commit/12e578a)), closes [#5169](https://github.com/IBM/kui/issues/5169)
- avoid hard-coded use of /tmp in kubectl edit ([8e4cb70](https://github.com/IBM/kui/commit/8e4cb70)), closes [#4928](https://github.com/IBM/kui/issues/4928)
- CurrentContext and CurrentNamespace widgets may have stale data inBrowser ([ab77c20](https://github.com/IBM/kui/commit/ab77c20)), closes [#5097](https://github.com/IBM/kui/issues/5097)
- don't blink yellow forever for kubectl events ([a59ee86](https://github.com/IBM/kui/commit/a59ee86)), closes [#4869](https://github.com/IBM/kui/issues/4869)
- empty watch tables/grids should show 'No resources' ([c0bfe99](https://github.com/IBM/kui/commit/c0bfe99)), closes [#4884](https://github.com/IBM/kui/issues/4884)
- multiple issues with tab switching versus status stripe widgets ([8c8a6ec](https://github.com/IBM/kui/commit/8c8a6ec)), closes [#5101](https://github.com/IBM/kui/issues/5101)
- **plugins/plugin-kubectl:** tolerate helm 3.0 and 3.1 help custom ascii art tables ([79f8640](https://github.com/IBM/kui/commit/79f8640)), closes [#5085](https://github.com/IBM/kui/issues/5085)
- **plugins/plugin-kubectl:** update jobs notebook to latest SequenceDiagram ([8e70862](https://github.com/IBM/kui/commit/8e70862)), closes [#5862](https://github.com/IBM/kui/issues/5862)
- **plugins/plugin-kubectl:** Update list-resources notebook to use splits ([1f54515](https://github.com/IBM/kui/commit/1f54515)), closes [#5770](https://github.com/IBM/kui/issues/5770)
- **plugins/plugin-kubectl:** wordsmithing to list-resources notebook ([7255a98](https://github.com/IBM/kui/commit/7255a98)), closes [#5504](https://github.com/IBM/kui/issues/5504)
- **Plugins/plugin-kubectl:** Logs tab may become stale when switching away/back ([fcfdaba](https://github.com/IBM/kui/commit/fcfdaba)), closes [#6024](https://github.com/IBM/kui/issues/6024)
- avoid using kui-custom command for switching kubectl namespace ([43863f2](https://github.com/IBM/kui/commit/43863f2)), closes [#4806](https://github.com/IBM/kui/issues/4806)
- **plugin-kubectl:** k get pods --all-namespaces has a title with "default" as the namespace ([2f95129](https://github.com/IBM/kui/commit/2f95129)), closes [#4466](https://github.com/IBM/kui/issues/4466)
- **plugins/plugin-kubectl:** get-namespace table sometimes doens't show the correct selected namespace ([af66aa4](https://github.com/IBM/kui/commit/af66aa4)), closes [#4812](https://github.com/IBM/kui/issues/4812)
- **plugins/plugin-kubectl:** Logs tab should have a default tail limit ([d4cf08c](https://github.com/IBM/kui/commit/d4cf08c)), closes [#4810](https://github.com/IBM/kui/issues/4810) [#4818](https://github.com/IBM/kui/issues/4818)
- Input element throws react error ([e6bb21b](https://github.com/IBM/kui/commit/e6bb21b)), closes [#4765](https://github.com/IBM/kui/issues/4765)
- kubectl edit apply twice does not work ([1976134](https://github.com/IBM/kui/commit/1976134)), closes [#4797](https://github.com/IBM/kui/issues/4797)
- **plugins/plugin-kubectl:** auto-pause logs when user scrolls ([94b85e6](https://github.com/IBM/kui/commit/94b85e6)), closes [#4668](https://github.com/IBM/kui/issues/4668)
- **plugins/plugin-kubectl:** ExecIntoPod's terminal is not theme-aligned ([067cda3](https://github.com/IBM/kui/commit/067cda3)), closes [#4722](https://github.com/IBM/kui/issues/4722)
- **plugins/plugin-kubectl:** i18n for No log data message ([589a4cd](https://github.com/IBM/kui/commit/589a4cd)), closes [#4656](https://github.com/IBM/kui/issues/4656)
- **plugins/plugin-kubectl:** inconsistent capitalization of breadcrumbs ([963b166](https://github.com/IBM/kui/commit/963b166)), closes [#4607](https://github.com/IBM/kui/issues/4607)
- **plugins/plugin-kubectl:** k edit -h does not open in sidecar ([b6f68f8](https://github.com/IBM/kui/commit/b6f68f8)), closes [#4661](https://github.com/IBM/kui/issues/4661)
- **plugins/plugin-kubectl:** k get events -w bombs ([20c2caf](https://github.com/IBM/kui/commit/20c2caf)), closes [#4557](https://github.com/IBM/kui/issues/4557)
- **plugins/plugin-kubectl:** kubectl api-resources table should hide APIGROUP column with open sidecar ([ee347fa](https://github.com/IBM/kui/commit/ee347fa)), closes [#4728](https://github.com/IBM/kui/issues/4728)
- **plugins/plugin-kubectl:** kubectl create secret hangs yellow ([e11dbb8](https://github.com/IBM/kui/commit/e11dbb8)), closes [#4571](https://github.com/IBM/kui/issues/4571)
- **plugins/plugin-kubectl:** Terminal tab test incorrectly verifies k exec output ([20ab362](https://github.com/IBM/kui/commit/20ab362)), closes [#4802](https://github.com/IBM/kui/issues/4802)
- kubectl edit in sidecar doesn't show success message when a resource is applied ([cc59503](https://github.com/IBM/kui/commit/cc59503)), closes [#4691](https://github.com/IBM/kui/issues/4691)
- sidecar toolbar can't due justice to longer error messages ([e67e0c9](https://github.com/IBM/kui/commit/e67e0c9)), closes [#4789](https://github.com/IBM/kui/issues/4789)
- **plugins/plugin-kubectl:** helm help parsed usage incorrectly ([b222da2](https://github.com/IBM/kui/commit/b222da2)), closes [#4692](https://github.com/IBM/kui/issues/4692)
- **plugins/plugin-kubectl:** improve kubectl tab completion ([734f9e5](https://github.com/IBM/kui/commit/734f9e5)), closes [#4704](https://github.com/IBM/kui/issues/4704)
- **plugins/plugin-kubectl:** improve kubectl top node display with open sidecar ([6f99581](https://github.com/IBM/kui/commit/6f99581)), closes [#4737](https://github.com/IBM/kui/issues/4737)
- **plugins/plugin-kubectl:** kubectl describe -h has old bold text ([b31d066](https://github.com/IBM/kui/commit/b31d066)), closes [#4568](https://github.com/IBM/kui/issues/4568)
- **plugins/plugin-kubectl:** kubectl edit should support editing a list of resources ([4cd4d43](https://github.com/IBM/kui/commit/4cd4d43)), closes [#4555](https://github.com/IBM/kui/issues/4555)
- **plugins/plugin-kubectl:** kubectl get --all-namespaces --watch does not update ([663a972](https://github.com/IBM/kui/commit/663a972)), closes [#4581](https://github.com/IBM/kui/issues/4581)
- **plugins/plugin-kubectl:** kubectl logs tab has bad interleaving and cpu issues ([1c7cf17](https://github.com/IBM/kui/commit/1c7cf17)), closes [#4664](https://github.com/IBM/kui/issues/4664) [#4665](https://github.com/IBM/kui/issues/4665)
- **plugins/plugin-kubectl:** kubectl Show Events query not precise enough ([eda6b38](https://github.com/IBM/kui/commit/eda6b38)), closes [#4572](https://github.com/IBM/kui/issues/4572)
- **plugins/plugin-kubectl:** remove Conditions tab ([eac3705](https://github.com/IBM/kui/commit/eac3705)), closes [#4606](https://github.com/IBM/kui/issues/4606)
- **plugins/plugin-kubectl:** remove Show Logs registration ([382c685](https://github.com/IBM/kui/commit/382c685)), closes [#4603](https://github.com/IBM/kui/issues/4603)
- **plugins/plugin-kubectl:** revert to editor-based Summary tab ([3ecd638](https://github.com/IBM/kui/commit/3ecd638)), closes [#4594](https://github.com/IBM/kui/issues/4594)
- **plugins/plugin-kubectl:** status shows as Containercreating when it should be ContainerCreating ([2c4a3b6](https://github.com/IBM/kui/commit/2c4a3b6)), closes [#4798](https://github.com/IBM/kui/issues/4798)
- allow user to disable table title by feature flags, and disable table pagination ([5450512](https://github.com/IBM/kui/commit/5450512)), closes [#4640](https://github.com/IBM/kui/issues/4640) [#4655](https://github.com/IBM/kui/issues/4655)
- avoid recomputing tabs when switching back and forth ([cf5e41f](https://github.com/IBM/kui/commit/cf5e41f)), closes [#4666](https://github.com/IBM/kui/issues/4666)
- clicking on container name in details sidecar should add -c to logs command ([61c7c08](https://github.com/IBM/kui/commit/61c7c08)), closes [#4498](https://github.com/IBM/kui/issues/4498)
- container filter of logs tab shows accumulated logs from previous selection ([08903b4](https://github.com/IBM/kui/commit/08903b4)), closes [#4644](https://github.com/IBM/kui/issues/4644) [#4658](https://github.com/IBM/kui/issues/4658)
- eliminate assumptions that "default" is the default kube namespace ([4eb392d](https://github.com/IBM/kui/commit/4eb392d)), closes [#4764](https://github.com/IBM/kui/issues/4764)
- improve error reporting for kubectl apply ([fe21671](https://github.com/IBM/kui/commit/fe21671)), closes [#4605](https://github.com/IBM/kui/issues/4605)
- kubectl api-resources has duplicate rows and odd pagination behavior ([e740270](https://github.com/IBM/kui/commit/e740270)), closes [#4626](https://github.com/IBM/kui/issues/4626)
- kubectl Logs tab should use an xterm ([9aa0176](https://github.com/IBM/kui/commit/9aa0176)), closes [#4750](https://github.com/IBM/kui/issues/4750) [#4747](https://github.com/IBM/kui/issues/4747)
- kubectl top node should show % text ([f861b76](https://github.com/IBM/kui/commit/f861b76)), closes [#4598](https://github.com/IBM/kui/issues/4598)
- logs tab toolbar doesn't signify when pods are 404 ([135e1be](https://github.com/IBM/kui/commit/135e1be)), closes [#4646](https://github.com/IBM/kui/issues/4646)
- place namespace breadcrumb first ([5d3b2e4](https://github.com/IBM/kui/commit/5d3b2e4)), closes [#4699](https://github.com/IBM/kui/issues/4699)
- the Logs/Terminal retry button should be visible on any exit code ([3366327](https://github.com/IBM/kui/commit/3366327)), closes [#4769](https://github.com/IBM/kui/issues/4769)
- TopNavSidecar tabs should auto-pause and auto-focus when switching ([2b00dd9](https://github.com/IBM/kui/commit/2b00dd9)), closes [#4741](https://github.com/IBM/kui/issues/4741) [#4748](https://github.com/IBM/kui/issues/4748)
- **plugin-kubectl:** kubectl get error-type -w doesn't fail fast ([4ccb733](https://github.com/IBM/kui/commit/4ccb733)), closes [#4491](https://github.com/IBM/kui/issues/4491)
- **plugins/plugin-kubectl:** add missing test for get with not found ([3e77689](https://github.com/IBM/kui/commit/3e77689)), closes [#4492](https://github.com/IBM/kui/issues/4492)
- **plugins/plugin-kubectl:** automatically abort idle PTYs ([2638a65](https://github.com/IBM/kui/commit/2638a65)), closes [#4742](https://github.com/IBM/kui/issues/4742)
- **plugins/plugin-kubectl:** cache kind canonicalization lookup ([e351a5f](https://github.com/IBM/kui/commit/e351a5f)), closes [#4489](https://github.com/IBM/kui/issues/4489)
- **plugins/plugin-kubectl:** kubectl get table with mix of existing and non-existing ([8d98d15](https://github.com/IBM/kui/commit/8d98d15)), closes [#4492](https://github.com/IBM/kui/issues/4492)
- add support for hiding elements at higher zoom levels ([7d2a7e0](https://github.com/IBM/kui/commit/7d2a7e0)), closes [#4232](https://github.com/IBM/kui/issues/4232)
- clicking on certain links in kubectl help result in odd behavior ([035894b](https://github.com/IBM/kui/commit/035894b)), closes [#4473](https://github.com/IBM/kui/issues/4473)
- eliminate complex nesting of NavResponse model ([e849ae7](https://github.com/IBM/kui/commit/e849ae7)), closes [#4205](https://github.com/IBM/kui/issues/4205)
- ibmcloud plugin list does not list unofficial plugins ([303fa00](https://github.com/IBM/kui/commit/303fa00)), closes [#4339](https://github.com/IBM/kui/issues/4339)
- make inBrowserOk the default ([2a3c811](https://github.com/IBM/kui/commit/2a3c811)), closes [#4275](https://github.com/IBM/kui/issues/4275)
- multiple kubectl help/usage bugs ([ebba36e](https://github.com/IBM/kui/commit/ebba36e)), closes [#4342](https://github.com/IBM/kui/issues/4342)
- sidecar views do not respect tab-specificity ([5a1cae2](https://github.com/IBM/kui/commit/5a1cae2)), closes [#4362](https://github.com/IBM/kui/issues/4362)
- **plugins/plugin-kubectl:** avoid use of /s regexp ([9468304](https://github.com/IBM/kui/commit/9468304)), closes [#4259](https://github.com/IBM/kui/issues/4259)
- **plugins/plugin-kubectl:** CurrentContext widget shows "default" for openshift clusters ([59712c0](https://github.com/IBM/kui/commit/59712c0)), closes [#4347](https://github.com/IBM/kui/issues/4347)
- **plugins/plugin-kubectl:** ensure Show Owner button appears near end of toolbar buttons ([224c586](https://github.com/IBM/kui/commit/224c586)), closes [#4124](https://github.com/IBM/kui/issues/4124)
- **plugins/plugin-kubectl:** firefox does not support the /s flag to RegExp ([5b661a6](https://github.com/IBM/kui/commit/5b661a6)), closes [#4206](https://github.com/IBM/kui/issues/4206)
- **plugins/plugin-kubectl:** ImagePullBackoff should be considered a "red" state ([198100d](https://github.com/IBM/kui/commit/198100d)), closes [#4734](https://github.com/IBM/kui/issues/4734)
- **plugins/plugin-kubectl:** in kube namespace table, selected namespace should float to top ([f0e597f](https://github.com/IBM/kui/commit/f0e597f)), closes [#4129](https://github.com/IBM/kui/issues/4129)
- **plugins/plugin-kubectl:** k edit deploy has mysterious Pod tab ([914df36](https://github.com/IBM/kui/commit/914df36)), closes [#4703](https://github.com/IBM/kui/issues/4703)
- **plugins/plugin-kubectl:** kubectl api-resources table shows 'unknown' in title ([0461710](https://github.com/IBM/kui/commit/0461710)), closes [#4145](https://github.com/IBM/kui/issues/4145)
- **plugins/plugin-kubectl:** kubectl describe (--help) fails ([10b8e8a](https://github.com/IBM/kui/commit/10b8e8a)), closes [#4012](https://github.com/IBM/kui/issues/4012)
- **plugins/plugin-kubectl:** kubectl explain -h should render as usage in sidecar ([8e00c3f](https://github.com/IBM/kui/commit/8e00c3f)), closes [#4211](https://github.com/IBM/kui/issues/4211)
- **plugins/plugin-kubectl:** kubectl explain Overview tab not formatted as expected ([ffa9183](https://github.com/IBM/kui/commit/ffa9183)), closes [#4304](https://github.com/IBM/kui/issues/4304)
- **plugins/plugin-kubectl:** kubectl top nodes can present "NaN" ([30df3dd](https://github.com/IBM/kui/commit/30df3dd)), closes [#4189](https://github.com/IBM/kui/issues/4189)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- **plugins/plugin-kubectl:** more refinements to Form layout heuristics ([e92327d](https://github.com/IBM/kui/commit/e92327d)), closes [#4118](https://github.com/IBM/kui/issues/4118)
- **plugins/plugin-kubectl:** remove kubectl edit cancel button ([83179e8](https://github.com/IBM/kui/commit/83179e8)), closes [#4695](https://github.com/IBM/kui/issues/4695)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- **plugins/plugin-kubectl:** update deprecated import of uuid ([5de8d4d](https://github.com/IBM/kui/commit/5de8d4d)), closes [#4316](https://github.com/IBM/kui/issues/4316)
- **plugins/plugin-kubectl:** watch table doesn't have breadcrumbs title ([43fbe6a](https://github.com/IBM/kui/commit/43fbe6a)), closes [#4135](https://github.com/IBM/kui/issues/4135)
- **plugins/plugin-kubectl:** watcher table disappears when kui is launched as kubectl plugin ([167eabc](https://github.com/IBM/kui/commit/167eabc)), closes [#4120](https://github.com/IBM/kui/issues/4120) [#4123](https://github.com/IBM/kui/issues/4123)
- **plugins/plugin-kubectl:** we shouldn't render namespace widget when the namespace is empty in kube config ([98a9406](https://github.com/IBM/kui/commit/98a9406)), closes [#4274](https://github.com/IBM/kui/issues/4274)
- ensure kubectl Delete toolbar button appears at far right ([9eb3079](https://github.com/IBM/kui/commit/9eb3079)), closes [#4116](https://github.com/IBM/kui/issues/4116)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- improve hover effect for status stripe buttons ([50ced8f](https://github.com/IBM/kui/commit/50ced8f)), closes [#4896](https://github.com/IBM/kui/issues/4896)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- kubectl help misformats helm help tables ([ff36755](https://github.com/IBM/kui/commit/ff36755)), closes [#5080](https://github.com/IBM/kui/issues/5080)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- kubectl summary Form TextInputs can be cropped ([3becaf9](https://github.com/IBM/kui/commit/3becaf9)), closes [#4077](https://github.com/IBM/kui/issues/4077)
- multiple tab completion bugs ([5513712](https://github.com/IBM/kui/commit/5513712)), closes [#4281](https://github.com/IBM/kui/issues/4281)
- optimize kubectl watch load on apiserver ([3f7a32f](https://github.com/IBM/kui/commit/3f7a32f)), closes [#4494](https://github.com/IBM/kui/issues/4494)
- PaginatedTable fails at distinguishing the rowKeys of `k get --all-namespaces` table ([6658729](https://github.com/IBM/kui/commit/6658729)), closes [#4579](https://github.com/IBM/kui/issues/4579)
- pexecs serviced by now-removed splits fail ([f6176a1](https://github.com/IBM/kui/commit/f6176a1)), closes [#4875](https://github.com/IBM/kui/issues/4875)
- reduce custom CSS rules for table UI ([56f69cb](https://github.com/IBM/kui/commit/56f69cb)), closes [#5024](https://github.com/IBM/kui/issues/5024)
- reduce No log data followed by log data behavior in kube logs ([e1c0624](https://github.com/IBM/kui/commit/e1c0624)), closes [#4624](https://github.com/IBM/kui/issues/4624)
- remove augmentModuleLoadPath API ([47dfcdf](https://github.com/IBM/kui/commit/47dfcdf)), closes [#4839](https://github.com/IBM/kui/issues/4839)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- replace Containers with Logs tab ([00e8786](https://github.com/IBM/kui/commit/00e8786)), closes [#4603](https://github.com/IBM/kui/issues/4603)
- snapshot command fails at `k get -o yaml` ([fe53fb0](https://github.com/IBM/kui/commit/fe53fb0)), closes [#5458](https://github.com/IBM/kui/issues/5458)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- summary tab is not read-only for kubectl edit command ([9f7ff82](https://github.com/IBM/kui/commit/9f7ff82)), closes [#4809](https://github.com/IBM/kui/issues/4809)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- tekton Step nodes show with hashed background ([8428d72](https://github.com/IBM/kui/commit/8428d72)), closes [#4114](https://github.com/IBM/kui/issues/4114)
- the colors of status badges: Error, ImagePullBackOff and ErrImagePull are incorrect ([fd206f6](https://github.com/IBM/kui/commit/fd206f6)), closes [#4171](https://github.com/IBM/kui/issues/4171)
- TopNavSidecar does not always show updates ([251e5c4](https://github.com/IBM/kui/commit/251e5c4)), closes [#4524](https://github.com/IBM/kui/issues/4524)
- vfs fixes for multi-source copying and for s3 globbing ([893902e](https://github.com/IBM/kui/commit/893902e)), closes [#5511](https://github.com/IBM/kui/issues/5511)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)
- xterm alt buffer mode behaves oddly for clients that do not enable splitTerminals ([f1bc709](https://github.com/IBM/kui/commit/f1bc709)), closes [#5003](https://github.com/IBM/kui/issues/5003)
- **plugins/plugin-kubectl:** oc describe fails ([4f4de4e](https://github.com/IBM/kui/commit/4f4de4e)), closes [#4008](https://github.com/IBM/kui/issues/4008)
- **plugins/plugin-kubectl:** oc get projects does not allow user selection ([3749371](https://github.com/IBM/kui/commit/3749371)), closes [#4805](https://github.com/IBM/kui/issues/4805)
- **plugins/plugin-kubectl:** oc logs does not work ([f0808a2](https://github.com/IBM/kui/commit/f0808a2)), closes [#4965](https://github.com/IBM/kui/issues/4965)
- **plugins/plugin-kubectl:** singleton breadcrumbs in kubectl help should not be clickable ([7815464](https://github.com/IBM/kui/commit/7815464)), closes [#4961](https://github.com/IBM/kui/issues/4961)
- **plugins/plugin-kubectl:** windows powershell fails to get default namespace ([a5fb2e1](https://github.com/IBM/kui/commit/a5fb2e1)), closes [#4912](https://github.com/IBM/kui/issues/4912)

### Features

- add a prefer-re-execution option to snapshot ([af7b98b](https://github.com/IBM/kui/commit/af7b98b)), closes [#5622](https://github.com/IBM/kui/issues/5622)
- add capability to show welcome widget to new users in Terminal ([0c33e6e](https://github.com/IBM/kui/commit/0c33e6e)), closes [#4990](https://github.com/IBM/kui/issues/4990) [#5007](https://github.com/IBM/kui/issues/5007)
- add delta summary to Tree ([95a0b4a](https://github.com/IBM/kui/commit/95a0b4a)), closes [#6329](https://github.com/IBM/kui/issues/6329)
- add events to sidecar tree ([dd4d552](https://github.com/IBM/kui/commit/dd4d552)), closes [#6140](https://github.com/IBM/kui/issues/6140)
- allow controllers to control the color of the status stripe ([708570c](https://github.com/IBM/kui/commit/708570c)), closes [#5490](https://github.com/IBM/kui/issues/5490)
- allow for limiting the number of kubectl table rows ([62588f2](https://github.com/IBM/kui/commit/62588f2)), closes [#5358](https://github.com/IBM/kui/issues/5358)
- background new tabs ([be9f986](https://github.com/IBM/kui/commit/be9f986)), closes [#5550](https://github.com/IBM/kui/issues/5550)
- clicking on events in watch table should drill down to events ([c6dc99f](https://github.com/IBM/kui/commit/c6dc99f)), closes [#5173](https://github.com/IBM/kui/issues/5173)
- cold start delays ([83abd14](https://github.com/IBM/kui/commit/83abd14)), closes [#5356](https://github.com/IBM/kui/issues/5356)
- custom tab titles ([fd780df](https://github.com/IBM/kui/commit/fd780df)), closes [#5525](https://github.com/IBM/kui/issues/5525)
- generalized kuberctl get with limit ([d40ee07](https://github.com/IBM/kui/commit/d40ee07)), closes [#5361](https://github.com/IBM/kui/issues/5361)
- in `kubectl get -f` tree, use Monaco DiffEditor show the preview of dry-run changes ([99266e8](https://github.com/IBM/kui/commit/99266e8)), closes [#6181](https://github.com/IBM/kui/issues/6181) [#6154](https://github.com/IBM/kui/issues/6154)
- initial popeye support ([9d62eeb](https://github.com/IBM/kui/commit/9d62eeb)), closes [#5265](https://github.com/IBM/kui/issues/5265)
- initial support for capturing input files and showing them in the UI ([5744bf4](https://github.com/IBM/kui/commit/5744bf4)), closes [#5513](https://github.com/IBM/kui/issues/5513)
- initial typeahead for commands ([7ba313a](https://github.com/IBM/kui/commit/7ba313a)), closes [#5437](https://github.com/IBM/kui/issues/5437)
- inline sidecar ([2c3afeb](https://github.com/IBM/kui/commit/2c3afeb)), closes [#6007](https://github.com/IBM/kui/issues/6007)
- Kui implementation of `watch` ([2cb3f98](https://github.com/IBM/kui/commit/2cb3f98)), closes [#6379](https://github.com/IBM/kui/issues/6379)
- line highlights on editor save, used for k edit apply errors ([3efa6a5](https://github.com/IBM/kui/commit/3efa6a5)), closes [#4795](https://github.com/IBM/kui/issues/4795)
- MiniSplits ([70b8441](https://github.com/IBM/kui/commit/70b8441)), closes [#5112](https://github.com/IBM/kui/issues/5112)
- Move in OpenWhisk plugin from the external repo ([b9c5867](https://github.com/IBM/kui/commit/b9c5867)), closes [#6109](https://github.com/IBM/kui/issues/6109)
- notebook client ([4b64133](https://github.com/IBM/kui/commit/4b64133)), closes [#5501](https://github.com/IBM/kui/issues/5501)
- split screen Terminal ([3a6b422](https://github.com/IBM/kui/commit/3a6b422)), closes [#4814](https://github.com/IBM/kui/issues/4814) [#4821](https://github.com/IBM/kui/issues/4821)
- update CurrentContext widget to use Dropdown ([9520e5d](https://github.com/IBM/kui/commit/9520e5d)), closes [#6354](https://github.com/IBM/kui/issues/6354)
- use Monaco DiffEditor `kubectl diff` ([3157393](https://github.com/IBM/kui/commit/3157393))
- use new Dropdown status stripe for CurrentNamespace widget ([0f7648c](https://github.com/IBM/kui/commit/0f7648c)), closes [#6351](https://github.com/IBM/kui/issues/6351)
- UX: Use Dropdown for theme switcher ([6cc6a47](https://github.com/IBM/kui/commit/6cc6a47)), closes [#6347](https://github.com/IBM/kui/issues/6347)
- **packages/core:** allow controller to opt in/out recording table row onclicks when snapshot ([cc83ce7](https://github.com/IBM/kui/commit/cc83ce7)), closes [#5565](https://github.com/IBM/kui/issues/5565)
- **plugins/plugin-client-common:** improved SequenceDiagram view ([1e2fb41](https://github.com/IBM/kui/commit/1e2fb41)), closes [#5342](https://github.com/IBM/kui/issues/5342)
- **plugins/plugin-git:** git branch should respond with RadioTable ([59a9213](https://github.com/IBM/kui/commit/59a9213)), closes [#5256](https://github.com/IBM/kui/issues/5256)
- **plugins/plugin-ibmcloud:** initial CodeEngine support ([677faca](https://github.com/IBM/kui/commit/677faca)), closes [#5302](https://github.com/IBM/kui/issues/5302) [#5303](https://github.com/IBM/kui/issues/5303)
- **plugins/plugin-kubectl:** add status column to kube deployment table ([1d35040](https://github.com/IBM/kui/commit/1d35040)), closes [#5476](https://github.com/IBM/kui/issues/5476)
- **plugins/plugin-kubectl:** initial `kubectl job list` improvement for visualizing Job execution ([06030b0](https://github.com/IBM/kui/commit/06030b0)), closes [#5397](https://github.com/IBM/kui/issues/5397)
- **plugins/plugin-kubectl:** initial labs for listing k8s resources and creating jobs ([2e9d002](https://github.com/IBM/kui/commit/2e9d002)), closes [#5475](https://github.com/IBM/kui/issues/5475)
- **plugins/plugin-kubectl:** kubectl get -f can use Tree to present structured result ([f94a22f](https://github.com/IBM/kui/commit/f94a22f)), closes [#6136](https://github.com/IBM/kui/issues/6136)
- **plugins/plugin-kubectl:** Namespace Summary impl ([2d69d67](https://github.com/IBM/kui/commit/2d69d67)), closes [#5790](https://github.com/IBM/kui/issues/5790)
- add button to WatchPane to show table back in terminal ([dc22591](https://github.com/IBM/kui/commit/dc22591)), closes [#4530](https://github.com/IBM/kui/issues/4530)
- add isSelected and Divider to log container selection menu ([59bdaa5](https://github.com/IBM/kui/commit/59bdaa5)), closes [#4647](https://github.com/IBM/kui/issues/4647)
- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Patternfly Breadcrumb support ([91e0504](https://github.com/IBM/kui/commit/91e0504)), closes [#4381](https://github.com/IBM/kui/issues/4381)
- add Retry button to sidecar toolbar when log streaming stopped abnormally ([47872f4](https://github.com/IBM/kui/commit/47872f4)), closes [#4755](https://github.com/IBM/kui/issues/4755)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add Stop Watching capability to WatchPane ([09043c1](https://github.com/IBM/kui/commit/09043c1)), closes [#4554](https://github.com/IBM/kui/issues/4554)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- allow users to select container in kubectl Logs ([f4304c5](https://github.com/IBM/kui/commit/f4304c5)), closes [#4627](https://github.com/IBM/kui/issues/4627)
- commands should be able to separate resource model fetch from view transformation functions ([e903bc7](https://github.com/IBM/kui/commit/e903bc7)), closes [#4437](https://github.com/IBM/kui/issues/4437)
- ibmcloud plugin ([aa0f72f](https://github.com/IBM/kui/commit/aa0f72f)), closes [#4353](https://github.com/IBM/kui/issues/4353)
- improve kubectl edit experience ([4c4a1c9](https://github.com/IBM/kui/commit/4c4a1c9)), closes [#4783](https://github.com/IBM/kui/issues/4783)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- improve rendering of kubectl subcommand help ([e36ed29](https://github.com/IBM/kui/commit/e36ed29)), closes [#4824](https://github.com/IBM/kui/issues/4824)
- initial odo catalog list enhancements ([8534267](https://github.com/IBM/kui/commit/8534267)), closes [#4485](https://github.com/IBM/kui/issues/4485)
- kubectl apply view-last-applied ([6d601ef](https://github.com/IBM/kui/commit/6d601ef)), closes [#4822](https://github.com/IBM/kui/issues/4822)
- kubectl edit via kui's editor ([414e813](https://github.com/IBM/kui/commit/414e813)), closes [#762](https://github.com/IBM/kui/issues/762)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- only enable WatchPane based on a feature flag ([eb80d0e](https://github.com/IBM/kui/commit/eb80d0e)), closes [#4678](https://github.com/IBM/kui/issues/4678) [#4604](https://github.com/IBM/kui/issues/4604)
- patternfly4 themes ([5f58f71](https://github.com/IBM/kui/commit/5f58f71)), closes [#4364](https://github.com/IBM/kui/issues/4364)
- pin a watchable terminal response in a split pane ([662f413](https://github.com/IBM/kui/commit/662f413)), closes [#4865](https://github.com/IBM/kui/issues/4865) [#4573](https://github.com/IBM/kui/issues/4573) [#4885](https://github.com/IBM/kui/issues/4885) [#4894](https://github.com/IBM/kui/issues/4894)
- port kubectl get ns to RadioTable ([be0eabf](https://github.com/IBM/kui/commit/be0eabf)), closes [#4510](https://github.com/IBM/kui/issues/4510) [#4511](https://github.com/IBM/kui/issues/4511)
- refine kubectl contexts table; add support for RadioTable row titles ([11bb074](https://github.com/IBM/kui/commit/11bb074)), closes [#5131](https://github.com/IBM/kui/issues/5131)
- s3 plugin, and vfs ([970ba6e](https://github.com/IBM/kui/commit/970ba6e)), closes [#5319](https://github.com/IBM/kui/issues/5319)
- show resource version in toolbar text ([1a6e335](https://github.com/IBM/kui/commit/1a6e335)), closes [#4790](https://github.com/IBM/kui/issues/4790)
- support for events in crud table footer ([0b90ead](https://github.com/IBM/kui/commit/0b90ead)), closes [#5125](https://github.com/IBM/kui/issues/5125)
- support for events in table footer ([51669af](https://github.com/IBM/kui/commit/51669af)), closes [#5115](https://github.com/IBM/kui/issues/5115)
- target kubectl logs and kubectl exec to Logs and Terminal tabs ([409e632](https://github.com/IBM/kui/commit/409e632)), closes [#4762](https://github.com/IBM/kui/issues/4762)
- tutorial VFS ([6f2330e](https://github.com/IBM/kui/commit/6f2330e)), closes [#5441](https://github.com/IBM/kui/issues/5441)
- **plugins/plugin-kubectl:** add Show Node button for kubectl pods ([04e29d2](https://github.com/IBM/kui/commit/04e29d2)), closes [#4214](https://github.com/IBM/kui/issues/4214)
- **plugins/plugin-kubectl:** add support for kustomize apply/delete/create ([b95cbdb](https://github.com/IBM/kui/commit/b95cbdb)), closes [#4203](https://github.com/IBM/kui/issues/4203)
- **plugins/plugin-kubectl:** configmap summary should show data ([50c7e10](https://github.com/IBM/kui/commit/50c7e10)), closes [#4025](https://github.com/IBM/kui/issues/4025)
- **plugins/plugin-kubectl:** enhance odo project list as RadioTable ([62272e6](https://github.com/IBM/kui/commit/62272e6)), closes [#4517](https://github.com/IBM/kui/issues/4517)
- **plugins/plugin-kubectl:** improve odo usage experience ([639ca32](https://github.com/IBM/kui/commit/639ca32)), closes [#4345](https://github.com/IBM/kui/issues/4345)
- **plugins/plugin-kubectl:** kubectl events tab ([2d71f24](https://github.com/IBM/kui/commit/2d71f24)), closes [#4706](https://github.com/IBM/kui/issues/4706)
- **plugins/plugin-kubectl:** namespace onclick should drill down to sidecar ([e74f66d](https://github.com/IBM/kui/commit/e74f66d)), closes [#4714](https://github.com/IBM/kui/issues/4714)
- **plugins/plugin-kubectl:** optimize rendering of kubectl Summary tab ([7c6480d](https://github.com/IBM/kui/commit/7c6480d)), closes [#4725](https://github.com/IBM/kui/issues/4725)
- **plugins/plugin-kubectl:** optimizing Node summary impl ([8ac11b9](https://github.com/IBM/kui/commit/8ac11b9)), closes [#4833](https://github.com/IBM/kui/issues/4833)
- **plugins/plugin-kubectl:** port kubectl contexts table to RadioTable ([3cb4dcb](https://github.com/IBM/kui/commit/3cb4dcb)), closes [#4513](https://github.com/IBM/kui/issues/4513)
- **plugins/plugin-kubectl:** Terminal tab for Pod kubernetes resources ([c47e432](https://github.com/IBM/kui/commit/c47e432)), closes [#4639](https://github.com/IBM/kui/issues/4639)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- simplified co-hosting of client and proxy in a container ([00af4b4](https://github.com/IBM/kui/commit/00af4b4)), closes [#4213](https://github.com/IBM/kui/issues/4213)
- SPI for icons ([3d034e3](https://github.com/IBM/kui/commit/3d034e3)), closes [#4441](https://github.com/IBM/kui/issues/4441) [#4364](https://github.com/IBM/kui/issues/4364)
- top tab buttons ([ff8cfba](https://github.com/IBM/kui/commit/ff8cfba)), closes [#4434](https://github.com/IBM/kui/issues/4434)
- watcher panel for open-ended watch jobs ([6dfe7df](https://github.com/IBM/kui/commit/6dfe7df)), closes [#4503](https://github.com/IBM/kui/issues/4503)
- **plugins/plugin-kubectl:** ReplicaSet should have Pods tab ([42cd286](https://github.com/IBM/kui/commit/42cd286)), closes [#4110](https://github.com/IBM/kui/issues/4110)
- **plugins/plugin-kubectl:** restore Show Logs button for kubectl ([6b17dbd](https://github.com/IBM/kui/commit/6b17dbd)), closes [#4089](https://github.com/IBM/kui/issues/4089)
- **plugins/plugin-kubectl:** Show Previous option for Logs tab ([2307d2f](https://github.com/IBM/kui/commit/2307d2f)), closes [#4864](https://github.com/IBM/kui/issues/4864)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)

### BREAKING CHANGES

- removes support for inBrowserOk

# [9.2.0](https://github.com/IBM/kui/compare/v4.5.0...v9.2.0) (2020-11-25)

### Bug Fixes

- events in tree are presented out of temporal order ([b3ba61e](https://github.com/IBM/kui/commit/b3ba61e)), closes [#6168](https://github.com/IBM/kui/issues/6168)
- monaco diff view colors are not themed ([eed2527](https://github.com/IBM/kui/commit/eed2527)), closes [#6232](https://github.com/IBM/kui/issues/6232)
- refine tree label categoriazation of kubectl ([1973a43](https://github.com/IBM/kui/commit/1973a43)), closes [#6185](https://github.com/IBM/kui/issues/6185)
- **plugins/plugin-client-common:** clicking the split button may cause the current processing block to disappear ([aa2b40c](https://github.com/IBM/kui/commit/aa2b40c)), closes [#5703](https://github.com/IBM/kui/issues/5703)
- **plugins/plugin-client-common:** don't offer Grid option for 1-row tables ([a2a6f8d](https://github.com/IBM/kui/commit/a2a6f8d)), closes [#5474](https://github.com/IBM/kui/issues/5474)
- **plugins/plugin-client-common:** for now, switch interval chart to duration chart ([ea21221](https://github.com/IBM/kui/commit/ea21221)), closes [#5340](https://github.com/IBM/kui/issues/5340)
- **plugins/plugin-client-common:** Grid regression: grid colors not right ([d1aa46d](https://github.com/IBM/kui/commit/d1aa46d)), closes [#5285](https://github.com/IBM/kui/issues/5285)
- **plugins/plugin-client-common:** improve display of empty watch tables ([4cc16be](https://github.com/IBM/kui/commit/4cc16be)), closes [#5176](https://github.com/IBM/kui/issues/5176)
- **plugins/plugin-client-common:** isReplay bit on Blocks is not set for snapshots ([c6d1633](https://github.com/IBM/kui/commit/c6d1633)), closes [#5868](https://github.com/IBM/kui/issues/5868)
- **plugins/plugin-client-common:** make Close a top-level button in watch panes ([3c14da5](https://github.com/IBM/kui/commit/3c14da5)), closes [#4945](https://github.com/IBM/kui/issues/4945)
- **plugins/plugin-client-common:** SequenceDiagram UI refinements ([5d8c3f7](https://github.com/IBM/kui/commit/5d8c3f7)), closes [#5557](https://github.com/IBM/kui/issues/5557)
- **plugins/plugin-client-common:** update welcome.json to describe kui, not just notebooks ([96330c4](https://github.com/IBM/kui/commit/96330c4)), closes [#5878](https://github.com/IBM/kui/issues/5878)
- **plugins/plugin-kubectl:** "logs dashC follow via table" test is unreliable after electron 10 update ([72c50ab](https://github.com/IBM/kui/commit/72c50ab)), closes [#6152](https://github.com/IBM/kui/issues/6152)
- **plugins/plugin-kubectl:** `oc get namespaces` doesn't produce a RadioTable ([6ea6131](https://github.com/IBM/kui/commit/6ea6131)), closes [#5227](https://github.com/IBM/kui/issues/5227)
- **plugins/plugin-kubectl:** add traffic light colors for OOMKilled and UnexpectedAdmissionError ([4262409](https://github.com/IBM/kui/commit/4262409)), closes [#5345](https://github.com/IBM/kui/issues/5345)
- **plugins/plugin-kubectl:** changing ns via oc does not update ns widget, in browser clients ([5eaa625](https://github.com/IBM/kui/commit/5eaa625)), closes [#4953](https://github.com/IBM/kui/issues/4953)
- **plugins/plugin-kubectl:** CurrentNamespace/Context widgets not live ([93ac829](https://github.com/IBM/kui/commit/93ac829)), closes [#5144](https://github.com/IBM/kui/issues/5144)
- **plugins/plugin-kubectl:** drilldown command of resources in watch --all-namespace table doesn't have '-o yaml' ([1e4f558](https://github.com/IBM/kui/commit/1e4f558)), closes [#5208](https://github.com/IBM/kui/issues/5208)
- **plugins/plugin-kubectl:** event footer watching should also support named resources ([e3a842b](https://github.com/IBM/kui/commit/e3a842b)), closes [#5180](https://github.com/IBM/kui/issues/5180)
- **plugins/plugin-kubectl:** events in table appear to be in random order ([034dc06](https://github.com/IBM/kui/commit/034dc06)), closes [#5212](https://github.com/IBM/kui/issues/5212)
- **plugins/plugin-kubectl:** get-namespace table sometimes doens't show the correct selected namespace ([af66aa4](https://github.com/IBM/kui/commit/af66aa4)), closes [#4812](https://github.com/IBM/kui/issues/4812)
- **plugins/plugin-kubectl:** isReplicaSet needs to be updated to handle "apps/v1" apiVersion ([6887a0d](https://github.com/IBM/kui/commit/6887a0d)), closes [#6003](https://github.com/IBM/kui/issues/6003)
- **plugins/plugin-kubectl:** k8s table should display status Propagated and Subscribed as green ([0787b4b](https://github.com/IBM/kui/commit/0787b4b)), closes [#5818](https://github.com/IBM/kui/issues/5818)
- **plugins/plugin-kubectl:** kubectl apply -f may not abort the event watcher ([c8df222](https://github.com/IBM/kui/commit/c8df222)), closes [#5149](https://github.com/IBM/kui/issues/5149)
- **plugins/plugin-kubectl:** kubectl apply edit-last-applied freezes in kui ([24a67da](https://github.com/IBM/kui/commit/24a67da)), closes [#4808](https://github.com/IBM/kui/issues/4808)
- **plugins/plugin-kubectl:** kubectl apply set-last-applied does not work ([9553907](https://github.com/IBM/kui/commit/9553907)), closes [#4844](https://github.com/IBM/kui/issues/4844)
- **plugins/plugin-kubectl:** kubectl apply/create/delete tables still have ALLCAPS headers ([90d72ce](https://github.com/IBM/kui/commit/90d72ce)), closes [#5068](https://github.com/IBM/kui/issues/5068)
- **plugins/plugin-kubectl:** kubectl delete ns m1 m2 m3 m4 results in a one-row table ([97a33a4](https://github.com/IBM/kui/commit/97a33a4)), closes [#5694](https://github.com/IBM/kui/issues/5694)
- **plugins/plugin-kubectl:** kubectl Deployment summary does not handle `undefined` fields ([0f65c3c](https://github.com/IBM/kui/commit/0f65c3c)), closes [#6028](https://github.com/IBM/kui/issues/6028)
- **plugins/plugin-kubectl:** kubectl explain subfields ([8fee2bc](https://github.com/IBM/kui/commit/8fee2bc)), closes [#4921](https://github.com/IBM/kui/issues/4921)
- **plugins/plugin-kubectl:** kubectl status table does not register onclickIdempotent ([6ae296c](https://github.com/IBM/kui/commit/6ae296c)), closes [#5788](https://github.com/IBM/kui/issues/5788)
- **plugins/plugin-kubectl:** kubectl table should show PropagationFailed status as offline ([a44b70c](https://github.com/IBM/kui/commit/a44b70c)), closes [#5821](https://github.com/IBM/kui/issues/5821)
- **plugins/plugin-kubectl:** kubectl watch tables may lack namespace breadcrumb ([a0616c2](https://github.com/IBM/kui/commit/a0616c2)), closes [#4870](https://github.com/IBM/kui/issues/4870)
- **plugins/plugin-kubectl:** kubernetes contexts table renders poorly ([e2ed7d8](https://github.com/IBM/kui/commit/e2ed7d8)), closes [#5230](https://github.com/IBM/kui/issues/5230)
- **plugins/plugin-kubectl:** Kui may invoke kubectl with duplicate command line options ([39c9d31](https://github.com/IBM/kui/commit/39c9d31)), closes [#5330](https://github.com/IBM/kui/issues/5330)
- **plugins/plugin-kubectl:** leftover debug printfs in table-watch ([407855a](https://github.com/IBM/kui/commit/407855a)), closes [#5317](https://github.com/IBM/kui/issues/5317)
- **plugins/plugin-kubectl:** Pod summary impl fails for pods with no containerStatuses ([66b21b5](https://github.com/IBM/kui/commit/66b21b5)), closes [#5192](https://github.com/IBM/kui/issues/5192)
- **plugins/plugin-kubectl:** regenerate kubernetes notebooks to show new Source Reference feature ([8324567](https://github.com/IBM/kui/commit/8324567)), closes [#5520](https://github.com/IBM/kui/issues/5520)
- **plugins/plugin-kubectl:** typos in Tree Toolbar text ([0d9a6be](https://github.com/IBM/kui/commit/0d9a6be)), closes [#6514](https://github.com/IBM/kui/issues/6514)
- (plugins/plugin-kubectl): kubectl get pod -w --all-namespaces behaves oddly ([12e578a](https://github.com/IBM/kui/commit/12e578a)), closes [#5169](https://github.com/IBM/kui/issues/5169)
- avoid excessive status stripe overheads when replaying Notebooks ([58de9c0](https://github.com/IBM/kui/commit/58de9c0)), closes [#5635](https://github.com/IBM/kui/issues/5635)
- don't show "Created a split" when clicking on the New Split button ([80192d5](https://github.com/IBM/kui/commit/80192d5)), closes [#6001](https://github.com/IBM/kui/issues/6001)
- grid colors are sometimes off ([e66f56f](https://github.com/IBM/kui/commit/e66f56f)), closes [#5422](https://github.com/IBM/kui/issues/5422)
- improve existing notebooks for v1 ([1af5cc2](https://github.com/IBM/kui/commit/1af5cc2)), closes [#5858](https://github.com/IBM/kui/issues/5858)
- improve the discoverability of repl-block action buttons ([470da34](https://github.com/IBM/kui/commit/470da34)), closes [#5604](https://github.com/IBM/kui/issues/5604)
- improve the replayability of terminal splitting ([67811cd](https://github.com/IBM/kui/commit/67811cd)), closes [#5564](https://github.com/IBM/kui/issues/5564)
- JS console may contain xtermjs error messages when sidecar is minimized ([a568528](https://github.com/IBM/kui/commit/a568528)), closes [#5454](https://github.com/IBM/kui/issues/5454)
- RadioTables are not replayable ([d0dd00e](https://github.com/IBM/kui/commit/d0dd00e)), closes [#5599](https://github.com/IBM/kui/issues/5599)
- restore status stripe to default behavior on terminal clear ([128ec92](https://github.com/IBM/kui/commit/128ec92)), closes [#5495](https://github.com/IBM/kui/issues/5495)
- sidecar shouldn't be opened automatically when replay ([8d4cf8c](https://github.com/IBM/kui/commit/8d4cf8c)), closes [#5730](https://github.com/IBM/kui/issues/5730)
- snapshot and replay of table clicks for Notebook v1 ([1a87dbf](https://github.com/IBM/kui/commit/1a87dbf)), closes [#5821](https://github.com/IBM/kui/issues/5821)
- snapshot command fails at `k get -o yaml` ([fe53fb0](https://github.com/IBM/kui/commit/fe53fb0)), closes [#5458](https://github.com/IBM/kui/issues/5458)
- snapshot command throws errors when capturing watch responses ([600f049](https://github.com/IBM/kui/commit/600f049)), closes [#5452](https://github.com/IBM/kui/issues/5452)
- store the commentary text result to the command when editing is done ([5a3f5e8](https://github.com/IBM/kui/commit/5a3f5e8)), closes [#5916](https://github.com/IBM/kui/issues/5916) [#5672](https://github.com/IBM/kui/issues/5672)
- UI glitches of Tree ([fc5af7a](https://github.com/IBM/kui/commit/fc5af7a)), closes [#6138](https://github.com/IBM/kui/issues/6138)
- **plugins/plugin-client-common:** kubectl watch is broken for server versions >= 1.17 ([2d595b7](https://github.com/IBM/kui/commit/2d595b7)), closes [#5360](https://github.com/IBM/kui/issues/5360)
- **plugins/plugin-kubectl:** add Summary impl for kubernetes Jobs ([b0f3809](https://github.com/IBM/kui/commit/b0f3809)), closes [#5481](https://github.com/IBM/kui/issues/5481)
- **plugins/plugin-kubectl:** certain filepath options to kubectl were not tilde-expanded ([9e7f858](https://github.com/IBM/kui/commit/9e7f858)), closes [#5415](https://github.com/IBM/kui/issues/5415)
- **plugins/plugin-kubectl:** Fail should be TrafficLight.Red and Succeeded should be TrafficLight.Green ([54737b6](https://github.com/IBM/kui/commit/54737b6)), closes [#5351](https://github.com/IBM/kui/issues/5351)
- **plugins/plugin-kubectl:** header-only tables improperly parsed ([f56841b](https://github.com/IBM/kui/commit/f56841b)), closes [#5382](https://github.com/IBM/kui/issues/5382)
- **plugins/plugin-kubectl:** kubectl get -f can show undefined in table title ([eb34d1c](https://github.com/IBM/kui/commit/eb34d1c)), closes [#5469](https://github.com/IBM/kui/issues/5469)
- **plugins/plugin-kubectl:** kubectl Logs/Events/Terminal tabs do not reflow on sidecar maximize ([6dbcbe8](https://github.com/IBM/kui/commit/6dbcbe8)), closes [#5417](https://github.com/IBM/kui/issues/5417)
- **plugins/plugin-kubectl:** kubectl tab completion does not let me tab-complete some filepaths ([e42daa7](https://github.com/IBM/kui/commit/e42daa7)), closes [#5413](https://github.com/IBM/kui/issues/5413)
- **plugins/plugin-kubectl:** kubectl watcher needs to pass through kubeconfig in its call to kubectl version ([a5d83a3](https://github.com/IBM/kui/commit/a5d83a3)), closes [#5368](https://github.com/IBM/kui/issues/5368)
- **plugins/plugin-kubectl:** kui semi-ignores --dry-run for kubectl apply ([90c329f](https://github.com/IBM/kui/commit/90c329f)), closes [#6106](https://github.com/IBM/kui/issues/6106)
- **plugins/plugin-kubectl:** nil and negative timestamps display as "0ms ago" ([641a599](https://github.com/IBM/kui/commit/641a599)), closes [#5136](https://github.com/IBM/kui/issues/5136)
- **plugins/plugin-kubectl:** oc get ns does not present a RadioTable ([9e28eec](https://github.com/IBM/kui/commit/9e28eec)), closes [#5106](https://github.com/IBM/kui/issues/5106)
- **plugins/plugin-kubectl:** update jobs notebook to latest SequenceDiagram ([8e70862](https://github.com/IBM/kui/commit/8e70862)), closes [#5862](https://github.com/IBM/kui/issues/5862)
- **plugins/plugin-kubectl:** Update list-resources notebook to use splits ([1f54515](https://github.com/IBM/kui/commit/1f54515)), closes [#5770](https://github.com/IBM/kui/issues/5770)
- **plugins/plugin-kubectl:** wordsmithing to list-resources notebook ([7255a98](https://github.com/IBM/kui/commit/7255a98)), closes [#5504](https://github.com/IBM/kui/issues/5504)
- **Plugins/plugin-kubectl:** Logs tab may become stale when switching away/back ([fcfdaba](https://github.com/IBM/kui/commit/fcfdaba)), closes [#6024](https://github.com/IBM/kui/issues/6024)
- avoid hard-coded use of /tmp in kubectl edit ([8e4cb70](https://github.com/IBM/kui/commit/8e4cb70)), closes [#4928](https://github.com/IBM/kui/issues/4928)
- CurrentContext and CurrentNamespace widgets may have stale data inBrowser ([ab77c20](https://github.com/IBM/kui/commit/ab77c20)), closes [#5097](https://github.com/IBM/kui/issues/5097)
- don't blink yellow forever for kubectl events ([a59ee86](https://github.com/IBM/kui/commit/a59ee86)), closes [#4869](https://github.com/IBM/kui/issues/4869)
- empty watch tables/grids should show 'No resources' ([c0bfe99](https://github.com/IBM/kui/commit/c0bfe99)), closes [#4884](https://github.com/IBM/kui/issues/4884)
- improve hover effect for status stripe buttons ([50ced8f](https://github.com/IBM/kui/commit/50ced8f)), closes [#4896](https://github.com/IBM/kui/issues/4896)
- kubectl help misformats helm help tables ([ff36755](https://github.com/IBM/kui/commit/ff36755)), closes [#5080](https://github.com/IBM/kui/issues/5080)
- multiple issues with tab switching versus status stripe widgets ([8c8a6ec](https://github.com/IBM/kui/commit/8c8a6ec)), closes [#5101](https://github.com/IBM/kui/issues/5101)
- **plugins/plugin-kubectl:** kubectl logs -l with no matches yields internal error ([ed0374f](https://github.com/IBM/kui/commit/ed0374f)), closes [#4811](https://github.com/IBM/kui/issues/4811)
- **plugins/plugin-kubectl:** Logs tab should have a default tail limit ([d4cf08c](https://github.com/IBM/kui/commit/d4cf08c)), closes [#4810](https://github.com/IBM/kui/issues/4810) [#4818](https://github.com/IBM/kui/issues/4818)
- **plugins/plugin-kubectl:** oc logs does not work ([f0808a2](https://github.com/IBM/kui/commit/f0808a2)), closes [#4965](https://github.com/IBM/kui/issues/4965)
- **plugins/plugin-kubectl:** singleton breadcrumbs in kubectl help should not be clickable ([7815464](https://github.com/IBM/kui/commit/7815464)), closes [#4961](https://github.com/IBM/kui/issues/4961)
- **plugins/plugin-kubectl:** tolerate helm 3.0 and 3.1 help custom ascii art tables ([79f8640](https://github.com/IBM/kui/commit/79f8640)), closes [#5085](https://github.com/IBM/kui/issues/5085)
- avoid using kui-custom command for switching kubectl namespace ([43863f2](https://github.com/IBM/kui/commit/43863f2)), closes [#4806](https://github.com/IBM/kui/issues/4806)
- kubectl edit apply twice does not work ([1976134](https://github.com/IBM/kui/commit/1976134)), closes [#4797](https://github.com/IBM/kui/issues/4797)
- pexecs serviced by now-removed splits fail ([f6176a1](https://github.com/IBM/kui/commit/f6176a1)), closes [#4875](https://github.com/IBM/kui/issues/4875)
- reduce custom CSS rules for table UI ([56f69cb](https://github.com/IBM/kui/commit/56f69cb)), closes [#5024](https://github.com/IBM/kui/issues/5024)
- sidecar toolbar can't due justice to longer error messages ([e67e0c9](https://github.com/IBM/kui/commit/e67e0c9)), closes [#4789](https://github.com/IBM/kui/issues/4789)
- xterm alt buffer mode behaves oddly for clients that do not enable splitTerminals ([f1bc709](https://github.com/IBM/kui/commit/f1bc709)), closes [#5003](https://github.com/IBM/kui/issues/5003)
- **plugins/plugin-kubectl:** oc get projects does not allow user selection ([3749371](https://github.com/IBM/kui/commit/3749371)), closes [#4805](https://github.com/IBM/kui/issues/4805)
- **plugins/plugin-kubectl:** status shows as Containercreating when it should be ContainerCreating ([2c4a3b6](https://github.com/IBM/kui/commit/2c4a3b6)), closes [#4798](https://github.com/IBM/kui/issues/4798)
- **plugins/plugin-kubectl:** windows powershell fails to get default namespace ([a5fb2e1](https://github.com/IBM/kui/commit/a5fb2e1)), closes [#4912](https://github.com/IBM/kui/issues/4912)
- allow user to disable table title by feature flags, and disable table pagination ([5450512](https://github.com/IBM/kui/commit/5450512)), closes [#4640](https://github.com/IBM/kui/issues/4640) [#4655](https://github.com/IBM/kui/issues/4655)
- container filter of logs tab shows accumulated logs from previous selection ([08903b4](https://github.com/IBM/kui/commit/08903b4)), closes [#4644](https://github.com/IBM/kui/issues/4644) [#4658](https://github.com/IBM/kui/issues/4658)
- eliminate assumptions that "default" is the default kube namespace ([4eb392d](https://github.com/IBM/kui/commit/4eb392d)), closes [#4764](https://github.com/IBM/kui/issues/4764)
- Input element throws react error ([e6bb21b](https://github.com/IBM/kui/commit/e6bb21b)), closes [#4765](https://github.com/IBM/kui/issues/4765)
- kubectl edit in sidecar doesn't show success message when a resource is applied ([cc59503](https://github.com/IBM/kui/commit/cc59503)), closes [#4691](https://github.com/IBM/kui/issues/4691)
- remove augmentModuleLoadPath API ([47dfcdf](https://github.com/IBM/kui/commit/47dfcdf)), closes [#4839](https://github.com/IBM/kui/issues/4839)
- summary tab is not read-only for kubectl edit command ([9f7ff82](https://github.com/IBM/kui/commit/9f7ff82)), closes [#4809](https://github.com/IBM/kui/issues/4809)
- the Logs/Terminal retry button should be visible on any exit code ([3366327](https://github.com/IBM/kui/commit/3366327)), closes [#4769](https://github.com/IBM/kui/issues/4769)
- TopNavSidecar tabs should auto-pause and auto-focus when switching ([2b00dd9](https://github.com/IBM/kui/commit/2b00dd9)), closes [#4741](https://github.com/IBM/kui/issues/4741) [#4748](https://github.com/IBM/kui/issues/4748)
- vfs fixes for multi-source copying and for s3 globbing ([893902e](https://github.com/IBM/kui/commit/893902e)), closes [#5511](https://github.com/IBM/kui/issues/5511)
- **plugins/plugin-kubectl:** auto-pause logs when user scrolls ([94b85e6](https://github.com/IBM/kui/commit/94b85e6)), closes [#4668](https://github.com/IBM/kui/issues/4668)
- **plugins/plugin-kubectl:** automatically abort idle PTYs ([2638a65](https://github.com/IBM/kui/commit/2638a65)), closes [#4742](https://github.com/IBM/kui/issues/4742)
- **plugins/plugin-kubectl:** ImagePullBackoff should be considered a "red" state ([198100d](https://github.com/IBM/kui/commit/198100d)), closes [#4734](https://github.com/IBM/kui/issues/4734)
- kubectl Logs tab should use an xterm ([9aa0176](https://github.com/IBM/kui/commit/9aa0176)), closes [#4750](https://github.com/IBM/kui/issues/4750) [#4747](https://github.com/IBM/kui/issues/4747)
- **plugins/plugin-kubectl:** ExecIntoPod's terminal is not theme-aligned ([067cda3](https://github.com/IBM/kui/commit/067cda3)), closes [#4722](https://github.com/IBM/kui/issues/4722)
- **plugins/plugin-kubectl:** helm help parsed usage incorrectly ([b222da2](https://github.com/IBM/kui/commit/b222da2)), closes [#4692](https://github.com/IBM/kui/issues/4692)
- **plugins/plugin-kubectl:** i18n for No log data message ([589a4cd](https://github.com/IBM/kui/commit/589a4cd)), closes [#4656](https://github.com/IBM/kui/issues/4656)
- **plugins/plugin-kubectl:** improve kubectl tab completion ([734f9e5](https://github.com/IBM/kui/commit/734f9e5)), closes [#4704](https://github.com/IBM/kui/issues/4704)
- **plugins/plugin-kubectl:** improve kubectl top node display with open sidecar ([6f99581](https://github.com/IBM/kui/commit/6f99581)), closes [#4737](https://github.com/IBM/kui/issues/4737)
- **plugins/plugin-kubectl:** k edit -h does not open in sidecar ([b6f68f8](https://github.com/IBM/kui/commit/b6f68f8)), closes [#4661](https://github.com/IBM/kui/issues/4661)
- **plugins/plugin-kubectl:** k edit deploy has mysterious Pod tab ([914df36](https://github.com/IBM/kui/commit/914df36)), closes [#4703](https://github.com/IBM/kui/issues/4703)
- **plugins/plugin-kubectl:** k get events -w bombs ([20c2caf](https://github.com/IBM/kui/commit/20c2caf)), closes [#4557](https://github.com/IBM/kui/issues/4557)
- **plugins/plugin-kubectl:** kubectl api-resources table should hide APIGROUP column with open sidecar ([ee347fa](https://github.com/IBM/kui/commit/ee347fa)), closes [#4728](https://github.com/IBM/kui/issues/4728)
- avoid recomputing tabs when switching back and forth ([cf5e41f](https://github.com/IBM/kui/commit/cf5e41f)), closes [#4666](https://github.com/IBM/kui/issues/4666)
- improve error reporting for kubectl apply ([fe21671](https://github.com/IBM/kui/commit/fe21671)), closes [#4605](https://github.com/IBM/kui/issues/4605)
- kubectl api-resources has duplicate rows and odd pagination behavior ([e740270](https://github.com/IBM/kui/commit/e740270)), closes [#4626](https://github.com/IBM/kui/issues/4626)
- kubectl top node should show % text ([f861b76](https://github.com/IBM/kui/commit/f861b76)), closes [#4598](https://github.com/IBM/kui/issues/4598)
- logs tab toolbar doesn't signify when pods are 404 ([135e1be](https://github.com/IBM/kui/commit/135e1be)), closes [#4646](https://github.com/IBM/kui/issues/4646)
- place namespace breadcrumb first ([5d3b2e4](https://github.com/IBM/kui/commit/5d3b2e4)), closes [#4699](https://github.com/IBM/kui/issues/4699)
- **plugin-kubectl:** kubectl get error-type -w doesn't fail fast ([4ccb733](https://github.com/IBM/kui/commit/4ccb733)), closes [#4491](https://github.com/IBM/kui/issues/4491)
- **plugins/plugin-kubectl:** add missing test for get with not found ([3e77689](https://github.com/IBM/kui/commit/3e77689)), closes [#4492](https://github.com/IBM/kui/issues/4492)
- **plugins/plugin-kubectl:** inconsistent capitalization of breadcrumbs ([963b166](https://github.com/IBM/kui/commit/963b166)), closes [#4607](https://github.com/IBM/kui/issues/4607)
- **plugins/plugin-kubectl:** kubectl create secret hangs yellow ([e11dbb8](https://github.com/IBM/kui/commit/e11dbb8)), closes [#4571](https://github.com/IBM/kui/issues/4571)
- **plugins/plugin-kubectl:** kubectl describe -h has old bold text ([b31d066](https://github.com/IBM/kui/commit/b31d066)), closes [#4568](https://github.com/IBM/kui/issues/4568)
- **plugins/plugin-kubectl:** kubectl edit should support editing a list of resources ([4cd4d43](https://github.com/IBM/kui/commit/4cd4d43)), closes [#4555](https://github.com/IBM/kui/issues/4555)
- **plugins/plugin-kubectl:** kubectl get --all-namespaces --watch does not update ([663a972](https://github.com/IBM/kui/commit/663a972)), closes [#4581](https://github.com/IBM/kui/issues/4581)
- **plugins/plugin-kubectl:** kubectl logs tab has bad interleaving and cpu issues ([1c7cf17](https://github.com/IBM/kui/commit/1c7cf17)), closes [#4664](https://github.com/IBM/kui/issues/4664) [#4665](https://github.com/IBM/kui/issues/4665)
- **plugins/plugin-kubectl:** remove Conditions tab ([eac3705](https://github.com/IBM/kui/commit/eac3705)), closes [#4606](https://github.com/IBM/kui/issues/4606)
- **plugins/plugin-kubectl:** remove kubectl edit cancel button ([83179e8](https://github.com/IBM/kui/commit/83179e8)), closes [#4695](https://github.com/IBM/kui/issues/4695)
- reduce No log data followed by log data behavior in kube logs ([e1c0624](https://github.com/IBM/kui/commit/e1c0624)), closes [#4624](https://github.com/IBM/kui/issues/4624)
- **plugins/plugin-kubectl:** remove Show Logs registration ([382c685](https://github.com/IBM/kui/commit/382c685)), closes [#4603](https://github.com/IBM/kui/issues/4603)
- replace Containers with Logs tab ([00e8786](https://github.com/IBM/kui/commit/00e8786)), closes [#4603](https://github.com/IBM/kui/issues/4603)
- **plugins/plugin-kubectl:** kubectl Show Events query not precise enough ([eda6b38](https://github.com/IBM/kui/commit/eda6b38)), closes [#4572](https://github.com/IBM/kui/issues/4572)
- **plugins/plugin-kubectl:** revert to editor-based Summary tab ([3ecd638](https://github.com/IBM/kui/commit/3ecd638)), closes [#4594](https://github.com/IBM/kui/issues/4594)
- clicking on container name in details sidecar should add -c to logs command ([61c7c08](https://github.com/IBM/kui/commit/61c7c08)), closes [#4498](https://github.com/IBM/kui/issues/4498)
- **plugin-kubectl:** k get pods --all-namespaces has a title with "default" as the namespace ([2f95129](https://github.com/IBM/kui/commit/2f95129)), closes [#4466](https://github.com/IBM/kui/issues/4466)
- **plugins/plugin-kubectl:** cache kind canonicalization lookup ([e351a5f](https://github.com/IBM/kui/commit/e351a5f)), closes [#4489](https://github.com/IBM/kui/issues/4489)
- **plugins/plugin-kubectl:** CurrentContext widget shows "default" for openshift clusters ([59712c0](https://github.com/IBM/kui/commit/59712c0)), closes [#4347](https://github.com/IBM/kui/issues/4347)
- **plugins/plugin-kubectl:** kubectl get table with mix of existing and non-existing ([8d98d15](https://github.com/IBM/kui/commit/8d98d15)), closes [#4492](https://github.com/IBM/kui/issues/4492)
- add support for hiding elements at higher zoom levels ([7d2a7e0](https://github.com/IBM/kui/commit/7d2a7e0)), closes [#4232](https://github.com/IBM/kui/issues/4232)
- clicking on certain links in kubectl help result in odd behavior ([035894b](https://github.com/IBM/kui/commit/035894b)), closes [#4473](https://github.com/IBM/kui/issues/4473)
- eliminate complex nesting of NavResponse model ([e849ae7](https://github.com/IBM/kui/commit/e849ae7)), closes [#4205](https://github.com/IBM/kui/issues/4205)
- ibmcloud plugin list does not list unofficial plugins ([303fa00](https://github.com/IBM/kui/commit/303fa00)), closes [#4339](https://github.com/IBM/kui/issues/4339)
- make inBrowserOk the default ([2a3c811](https://github.com/IBM/kui/commit/2a3c811)), closes [#4275](https://github.com/IBM/kui/issues/4275)
- multiple kubectl help/usage bugs ([ebba36e](https://github.com/IBM/kui/commit/ebba36e)), closes [#4342](https://github.com/IBM/kui/issues/4342)
- sidecar views do not respect tab-specificity ([5a1cae2](https://github.com/IBM/kui/commit/5a1cae2)), closes [#4362](https://github.com/IBM/kui/issues/4362)
- **plugins/plugin-kubectl:** avoid use of /s regexp ([9468304](https://github.com/IBM/kui/commit/9468304)), closes [#4259](https://github.com/IBM/kui/issues/4259)
- **plugins/plugin-kubectl:** ensure Show Owner button appears near end of toolbar buttons ([224c586](https://github.com/IBM/kui/commit/224c586)), closes [#4124](https://github.com/IBM/kui/issues/4124)
- **plugins/plugin-kubectl:** firefox does not support the /s flag to RegExp ([5b661a6](https://github.com/IBM/kui/commit/5b661a6)), closes [#4206](https://github.com/IBM/kui/issues/4206)
- **plugins/plugin-kubectl:** in kube namespace table, selected namespace should float to top ([f0e597f](https://github.com/IBM/kui/commit/f0e597f)), closes [#4129](https://github.com/IBM/kui/issues/4129)
- **plugins/plugin-kubectl:** kubectl api-resources table shows 'unknown' in title ([0461710](https://github.com/IBM/kui/commit/0461710)), closes [#4145](https://github.com/IBM/kui/issues/4145)
- **plugins/plugin-kubectl:** kubectl describe (--help) fails ([10b8e8a](https://github.com/IBM/kui/commit/10b8e8a)), closes [#4012](https://github.com/IBM/kui/issues/4012)
- **plugins/plugin-kubectl:** kubectl explain -h should render as usage in sidecar ([8e00c3f](https://github.com/IBM/kui/commit/8e00c3f)), closes [#4211](https://github.com/IBM/kui/issues/4211)
- **plugins/plugin-kubectl:** kubectl explain Overview tab not formatted as expected ([ffa9183](https://github.com/IBM/kui/commit/ffa9183)), closes [#4304](https://github.com/IBM/kui/issues/4304)
- **plugins/plugin-kubectl:** kubectl top nodes can present "NaN" ([30df3dd](https://github.com/IBM/kui/commit/30df3dd)), closes [#4189](https://github.com/IBM/kui/issues/4189)
- **plugins/plugin-kubectl:** more refinements to Form layout heuristics ([e92327d](https://github.com/IBM/kui/commit/e92327d)), closes [#4118](https://github.com/IBM/kui/issues/4118)
- **plugins/plugin-kubectl:** oc describe fails ([4f4de4e](https://github.com/IBM/kui/commit/4f4de4e)), closes [#4008](https://github.com/IBM/kui/issues/4008)
- **plugins/plugin-kubectl:** Terminal tab test incorrectly verifies k exec output ([20ab362](https://github.com/IBM/kui/commit/20ab362)), closes [#4802](https://github.com/IBM/kui/issues/4802)
- **plugins/plugin-kubectl:** update deprecated import of uuid ([5de8d4d](https://github.com/IBM/kui/commit/5de8d4d)), closes [#4316](https://github.com/IBM/kui/issues/4316)
- **plugins/plugin-kubectl:** we shouldn't render namespace widget when the namespace is empty in kube config ([98a9406](https://github.com/IBM/kui/commit/98a9406)), closes [#4274](https://github.com/IBM/kui/issues/4274)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- kubectl summary Form TextInputs can be cropped ([3becaf9](https://github.com/IBM/kui/commit/3becaf9)), closes [#4077](https://github.com/IBM/kui/issues/4077)
- multiple tab completion bugs ([5513712](https://github.com/IBM/kui/commit/5513712)), closes [#4281](https://github.com/IBM/kui/issues/4281)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- the colors of status badges: Error, ImagePullBackOff and ErrImagePull are incorrect ([fd206f6](https://github.com/IBM/kui/commit/fd206f6)), closes [#4171](https://github.com/IBM/kui/issues/4171)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- **plugins/plugin-kubectl:** watch table doesn't have breadcrumbs title ([43fbe6a](https://github.com/IBM/kui/commit/43fbe6a)), closes [#4135](https://github.com/IBM/kui/issues/4135)
- **plugins/plugin-kubectl:** watcher table disappears when kui is launched as kubectl plugin ([167eabc](https://github.com/IBM/kui/commit/167eabc)), closes [#4120](https://github.com/IBM/kui/issues/4120) [#4123](https://github.com/IBM/kui/issues/4123)
- ensure kubectl Delete toolbar button appears at far right ([9eb3079](https://github.com/IBM/kui/commit/9eb3079)), closes [#4116](https://github.com/IBM/kui/issues/4116)
- optimize kubectl watch load on apiserver ([3f7a32f](https://github.com/IBM/kui/commit/3f7a32f)), closes [#4494](https://github.com/IBM/kui/issues/4494)
- PaginatedTable fails at distinguishing the rowKeys of `k get --all-namespaces` table ([6658729](https://github.com/IBM/kui/commit/6658729)), closes [#4579](https://github.com/IBM/kui/issues/4579)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- tekton Step nodes show with hashed background ([8428d72](https://github.com/IBM/kui/commit/8428d72)), closes [#4114](https://github.com/IBM/kui/issues/4114)
- TopNavSidecar does not always show updates ([251e5c4](https://github.com/IBM/kui/commit/251e5c4)), closes [#4524](https://github.com/IBM/kui/issues/4524)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)

### Features

- add a prefer-re-execution option to snapshot ([af7b98b](https://github.com/IBM/kui/commit/af7b98b)), closes [#5622](https://github.com/IBM/kui/issues/5622)
- add events to sidecar tree ([dd4d552](https://github.com/IBM/kui/commit/dd4d552)), closes [#6140](https://github.com/IBM/kui/issues/6140)
- in `kubectl get -f` tree, use Monaco DiffEditor show the preview of dry-run changes ([99266e8](https://github.com/IBM/kui/commit/99266e8)), closes [#6181](https://github.com/IBM/kui/issues/6181) [#6154](https://github.com/IBM/kui/issues/6154)
- **packages/core:** allow controller to opt in/out recording table row onclicks when snapshot ([cc83ce7](https://github.com/IBM/kui/commit/cc83ce7)), closes [#5565](https://github.com/IBM/kui/issues/5565)
- **plugins/plugin-kubectl:** kubectl get -f can use Tree to present structured result ([f94a22f](https://github.com/IBM/kui/commit/f94a22f)), closes [#6136](https://github.com/IBM/kui/issues/6136)
- add capability to show welcome widget to new users in Terminal ([0c33e6e](https://github.com/IBM/kui/commit/0c33e6e)), closes [#4990](https://github.com/IBM/kui/issues/4990) [#5007](https://github.com/IBM/kui/issues/5007)
- add Retry button to sidecar toolbar when log streaming stopped abnormally ([47872f4](https://github.com/IBM/kui/commit/47872f4)), closes [#4755](https://github.com/IBM/kui/issues/4755)
- allow controllers to control the color of the status stripe ([708570c](https://github.com/IBM/kui/commit/708570c)), closes [#5490](https://github.com/IBM/kui/issues/5490)
- allow for limiting the number of kubectl table rows ([62588f2](https://github.com/IBM/kui/commit/62588f2)), closes [#5358](https://github.com/IBM/kui/issues/5358)
- background new tabs ([be9f986](https://github.com/IBM/kui/commit/be9f986)), closes [#5550](https://github.com/IBM/kui/issues/5550)
- clicking on events in watch table should drill down to events ([c6dc99f](https://github.com/IBM/kui/commit/c6dc99f)), closes [#5173](https://github.com/IBM/kui/issues/5173)
- cold start delays ([83abd14](https://github.com/IBM/kui/commit/83abd14)), closes [#5356](https://github.com/IBM/kui/issues/5356)
- custom tab titles ([fd780df](https://github.com/IBM/kui/commit/fd780df)), closes [#5525](https://github.com/IBM/kui/issues/5525)
- generalized kuberctl get with limit ([d40ee07](https://github.com/IBM/kui/commit/d40ee07)), closes [#5361](https://github.com/IBM/kui/issues/5361)
- improve kubectl edit experience ([4c4a1c9](https://github.com/IBM/kui/commit/4c4a1c9)), closes [#4783](https://github.com/IBM/kui/issues/4783)
- improve rendering of kubectl subcommand help ([e36ed29](https://github.com/IBM/kui/commit/e36ed29)), closes [#4824](https://github.com/IBM/kui/issues/4824)
- initial popeye support ([9d62eeb](https://github.com/IBM/kui/commit/9d62eeb)), closes [#5265](https://github.com/IBM/kui/issues/5265)
- initial support for capturing input files and showing them in the UI ([5744bf4](https://github.com/IBM/kui/commit/5744bf4)), closes [#5513](https://github.com/IBM/kui/issues/5513)
- inline sidecar ([2c3afeb](https://github.com/IBM/kui/commit/2c3afeb)), closes [#6007](https://github.com/IBM/kui/issues/6007)
- kubectl apply view-last-applied ([6d601ef](https://github.com/IBM/kui/commit/6d601ef)), closes [#4822](https://github.com/IBM/kui/issues/4822)
- line highlights on editor save, used for k edit apply errors ([3efa6a5](https://github.com/IBM/kui/commit/3efa6a5)), closes [#4795](https://github.com/IBM/kui/issues/4795)
- MiniSplits ([70b8441](https://github.com/IBM/kui/commit/70b8441)), closes [#5112](https://github.com/IBM/kui/issues/5112)
- Move in OpenWhisk plugin from the external repo ([b9c5867](https://github.com/IBM/kui/commit/b9c5867)), closes [#6109](https://github.com/IBM/kui/issues/6109)
- **plugins/plugin-git:** git branch should respond with RadioTable ([59a9213](https://github.com/IBM/kui/commit/59a9213)), closes [#5256](https://github.com/IBM/kui/issues/5256)
- **plugins/plugin-ibmcloud:** initial CodeEngine support ([677faca](https://github.com/IBM/kui/commit/677faca)), closes [#5302](https://github.com/IBM/kui/issues/5302) [#5303](https://github.com/IBM/kui/issues/5303)
- **plugins/plugin-kubectl:** initial labs for listing k8s resources and creating jobs ([2e9d002](https://github.com/IBM/kui/commit/2e9d002)), closes [#5475](https://github.com/IBM/kui/issues/5475)
- **plugins/plugin-kubectl:** Namespace Summary impl ([2d69d67](https://github.com/IBM/kui/commit/2d69d67)), closes [#5790](https://github.com/IBM/kui/issues/5790)
- notebook client ([4b64133](https://github.com/IBM/kui/commit/4b64133)), closes [#5501](https://github.com/IBM/kui/issues/5501)
- **plugins/plugin-kubectl:** add status column to kube deployment table ([1d35040](https://github.com/IBM/kui/commit/1d35040)), closes [#5476](https://github.com/IBM/kui/issues/5476)
- initial typeahead for commands ([7ba313a](https://github.com/IBM/kui/commit/7ba313a)), closes [#5437](https://github.com/IBM/kui/issues/5437)
- tutorial VFS ([6f2330e](https://github.com/IBM/kui/commit/6f2330e)), closes [#5441](https://github.com/IBM/kui/issues/5441)
- **plugins/plugin-client-common:** improved SequenceDiagram view ([1e2fb41](https://github.com/IBM/kui/commit/1e2fb41)), closes [#5342](https://github.com/IBM/kui/issues/5342)
- **plugins/plugin-kubectl:** initial `kubectl job list` improvement for visualizing Job execution ([06030b0](https://github.com/IBM/kui/commit/06030b0)), closes [#5397](https://github.com/IBM/kui/issues/5397)
- pin a watchable terminal response in a split pane ([662f413](https://github.com/IBM/kui/commit/662f413)), closes [#4865](https://github.com/IBM/kui/issues/4865) [#4573](https://github.com/IBM/kui/issues/4573) [#4885](https://github.com/IBM/kui/issues/4885) [#4894](https://github.com/IBM/kui/issues/4894)
- refine kubectl contexts table; add support for RadioTable row titles ([11bb074](https://github.com/IBM/kui/commit/11bb074)), closes [#5131](https://github.com/IBM/kui/issues/5131)
- s3 plugin, and vfs ([970ba6e](https://github.com/IBM/kui/commit/970ba6e)), closes [#5319](https://github.com/IBM/kui/issues/5319)
- show resource version in toolbar text ([1a6e335](https://github.com/IBM/kui/commit/1a6e335)), closes [#4790](https://github.com/IBM/kui/issues/4790)
- split screen Terminal ([3a6b422](https://github.com/IBM/kui/commit/3a6b422)), closes [#4814](https://github.com/IBM/kui/issues/4814) [#4821](https://github.com/IBM/kui/issues/4821)
- support for events in crud table footer ([0b90ead](https://github.com/IBM/kui/commit/0b90ead)), closes [#5125](https://github.com/IBM/kui/issues/5125)
- support for events in table footer ([51669af](https://github.com/IBM/kui/commit/51669af)), closes [#5115](https://github.com/IBM/kui/issues/5115)
- **plugins/plugin-kubectl:** optimizing Node summary impl ([8ac11b9](https://github.com/IBM/kui/commit/8ac11b9)), closes [#4833](https://github.com/IBM/kui/issues/4833)
- **plugins/plugin-kubectl:** Show Previous option for Logs tab ([2307d2f](https://github.com/IBM/kui/commit/2307d2f)), closes [#4864](https://github.com/IBM/kui/issues/4864)
- target kubectl logs and kubectl exec to Logs and Terminal tabs ([409e632](https://github.com/IBM/kui/commit/409e632)), closes [#4762](https://github.com/IBM/kui/issues/4762)
- **plugins/plugin-kubectl:** enhance odo project list as RadioTable ([62272e6](https://github.com/IBM/kui/commit/62272e6)), closes [#4517](https://github.com/IBM/kui/issues/4517)
- **plugins/plugin-kubectl:** kubectl events tab ([2d71f24](https://github.com/IBM/kui/commit/2d71f24)), closes [#4706](https://github.com/IBM/kui/issues/4706)
- **plugins/plugin-kubectl:** namespace onclick should drill down to sidecar ([e74f66d](https://github.com/IBM/kui/commit/e74f66d)), closes [#4714](https://github.com/IBM/kui/issues/4714)
- **plugins/plugin-kubectl:** optimize rendering of kubectl Summary tab ([7c6480d](https://github.com/IBM/kui/commit/7c6480d)), closes [#4725](https://github.com/IBM/kui/issues/4725)
- **plugins/plugin-kubectl:** port kubectl contexts table to RadioTable ([3cb4dcb](https://github.com/IBM/kui/commit/3cb4dcb)), closes [#4513](https://github.com/IBM/kui/issues/4513)
- **plugins/plugin-kubectl:** Terminal tab for Pod kubernetes resources ([c47e432](https://github.com/IBM/kui/commit/c47e432)), closes [#4639](https://github.com/IBM/kui/issues/4639)
- add button to WatchPane to show table back in terminal ([dc22591](https://github.com/IBM/kui/commit/dc22591)), closes [#4530](https://github.com/IBM/kui/issues/4530)
- add isSelected and Divider to log container selection menu ([59bdaa5](https://github.com/IBM/kui/commit/59bdaa5)), closes [#4647](https://github.com/IBM/kui/issues/4647)
- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Patternfly Breadcrumb support ([91e0504](https://github.com/IBM/kui/commit/91e0504)), closes [#4381](https://github.com/IBM/kui/issues/4381)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add Stop Watching capability to WatchPane ([09043c1](https://github.com/IBM/kui/commit/09043c1)), closes [#4554](https://github.com/IBM/kui/issues/4554)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- allow users to select container in kubectl Logs ([f4304c5](https://github.com/IBM/kui/commit/f4304c5)), closes [#4627](https://github.com/IBM/kui/issues/4627)
- commands should be able to separate resource model fetch from view transformation functions ([e903bc7](https://github.com/IBM/kui/commit/e903bc7)), closes [#4437](https://github.com/IBM/kui/issues/4437)
- ibmcloud plugin ([aa0f72f](https://github.com/IBM/kui/commit/aa0f72f)), closes [#4353](https://github.com/IBM/kui/issues/4353)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- initial odo catalog list enhancements ([8534267](https://github.com/IBM/kui/commit/8534267)), closes [#4485](https://github.com/IBM/kui/issues/4485)
- kubectl edit via kui's editor ([414e813](https://github.com/IBM/kui/commit/414e813)), closes [#762](https://github.com/IBM/kui/issues/762)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- only enable WatchPane based on a feature flag ([eb80d0e](https://github.com/IBM/kui/commit/eb80d0e)), closes [#4678](https://github.com/IBM/kui/issues/4678) [#4604](https://github.com/IBM/kui/issues/4604)
- patternfly4 themes ([5f58f71](https://github.com/IBM/kui/commit/5f58f71)), closes [#4364](https://github.com/IBM/kui/issues/4364)
- port kubectl get ns to RadioTable ([be0eabf](https://github.com/IBM/kui/commit/be0eabf)), closes [#4510](https://github.com/IBM/kui/issues/4510) [#4511](https://github.com/IBM/kui/issues/4511)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- simplified co-hosting of client and proxy in a container ([00af4b4](https://github.com/IBM/kui/commit/00af4b4)), closes [#4213](https://github.com/IBM/kui/issues/4213)
- SPI for icons ([3d034e3](https://github.com/IBM/kui/commit/3d034e3)), closes [#4441](https://github.com/IBM/kui/issues/4441) [#4364](https://github.com/IBM/kui/issues/4364)
- top tab buttons ([ff8cfba](https://github.com/IBM/kui/commit/ff8cfba)), closes [#4434](https://github.com/IBM/kui/issues/4434)
- watcher panel for open-ended watch jobs ([6dfe7df](https://github.com/IBM/kui/commit/6dfe7df)), closes [#4503](https://github.com/IBM/kui/issues/4503)
- **plugins/plugin-kubectl:** add Show Node button for kubectl pods ([04e29d2](https://github.com/IBM/kui/commit/04e29d2)), closes [#4214](https://github.com/IBM/kui/issues/4214)
- **plugins/plugin-kubectl:** add support for kustomize apply/delete/create ([b95cbdb](https://github.com/IBM/kui/commit/b95cbdb)), closes [#4203](https://github.com/IBM/kui/issues/4203)
- **plugins/plugin-kubectl:** configmap summary should show data ([50c7e10](https://github.com/IBM/kui/commit/50c7e10)), closes [#4025](https://github.com/IBM/kui/issues/4025)
- **plugins/plugin-kubectl:** improve odo usage experience ([639ca32](https://github.com/IBM/kui/commit/639ca32)), closes [#4345](https://github.com/IBM/kui/issues/4345)
- **plugins/plugin-kubectl:** ReplicaSet should have Pods tab ([42cd286](https://github.com/IBM/kui/commit/42cd286)), closes [#4110](https://github.com/IBM/kui/issues/4110)
- **plugins/plugin-kubectl:** restore Show Logs button for kubectl ([6b17dbd](https://github.com/IBM/kui/commit/6b17dbd)), closes [#4089](https://github.com/IBM/kui/issues/4089)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)

### BREAKING CHANGES

- removes support for inBrowserOk

# [9.1.0](https://github.com/IBM/kui/compare/v4.5.0...v9.1.0) (2020-10-26)

### Bug Fixes

- don't show "Created a split" when clicking on the New Split button ([80192d5](https://github.com/IBM/kui/commit/80192d5)), closes [#6001](https://github.com/IBM/kui/issues/6001)
- **plugins/plugin-client-common:** clicking the split button may cause the current processing block to disappear ([aa2b40c](https://github.com/IBM/kui/commit/aa2b40c)), closes [#5703](https://github.com/IBM/kui/issues/5703)
- **plugins/plugin-client-common:** don't offer Grid option for 1-row tables ([a2a6f8d](https://github.com/IBM/kui/commit/a2a6f8d)), closes [#5474](https://github.com/IBM/kui/issues/5474)
- **plugins/plugin-client-common:** isReplay bit on Blocks is not set for snapshots ([c6d1633](https://github.com/IBM/kui/commit/c6d1633)), closes [#5868](https://github.com/IBM/kui/issues/5868)
- **plugins/plugin-client-common:** SequenceDiagram UI refinements ([5d8c3f7](https://github.com/IBM/kui/commit/5d8c3f7)), closes [#5557](https://github.com/IBM/kui/issues/5557)
- **plugins/plugin-client-common:** update welcome.json to describe kui, not just notebooks ([96330c4](https://github.com/IBM/kui/commit/96330c4)), closes [#5878](https://github.com/IBM/kui/issues/5878)
- **plugins/plugin-kubectl:** add Summary impl for kubernetes Jobs ([b0f3809](https://github.com/IBM/kui/commit/b0f3809)), closes [#5481](https://github.com/IBM/kui/issues/5481)
- **plugins/plugin-kubectl:** isReplicaSet needs to be updated to handle "apps/v1" apiVersion ([6887a0d](https://github.com/IBM/kui/commit/6887a0d)), closes [#6003](https://github.com/IBM/kui/issues/6003)
- **plugins/plugin-kubectl:** k8s table should display status Propagated and Subscribed as green ([0787b4b](https://github.com/IBM/kui/commit/0787b4b)), closes [#5818](https://github.com/IBM/kui/issues/5818)
- **plugins/plugin-kubectl:** kubectl delete ns m1 m2 m3 m4 results in a one-row table ([97a33a4](https://github.com/IBM/kui/commit/97a33a4)), closes [#5694](https://github.com/IBM/kui/issues/5694)
- **plugins/plugin-kubectl:** kubectl Deployment summary does not handle `undefined` fields ([0f65c3c](https://github.com/IBM/kui/commit/0f65c3c)), closes [#6028](https://github.com/IBM/kui/issues/6028)
- **plugins/plugin-kubectl:** kubectl get -f can show undefined in table title ([eb34d1c](https://github.com/IBM/kui/commit/eb34d1c)), closes [#5469](https://github.com/IBM/kui/issues/5469)
- **plugins/plugin-kubectl:** kubectl status table does not register onclickIdempotent ([6ae296c](https://github.com/IBM/kui/commit/6ae296c)), closes [#5788](https://github.com/IBM/kui/issues/5788)
- **plugins/plugin-kubectl:** kubectl table should show PropagationFailed status as offline ([a44b70c](https://github.com/IBM/kui/commit/a44b70c)), closes [#5821](https://github.com/IBM/kui/issues/5821)
- **plugins/plugin-kubectl:** update jobs notebook to latest SequenceDiagram ([8e70862](https://github.com/IBM/kui/commit/8e70862)), closes [#5862](https://github.com/IBM/kui/issues/5862)
- **Plugins/plugin-kubectl:** Logs tab may become stale when switching away/back ([fcfdaba](https://github.com/IBM/kui/commit/fcfdaba)), closes [#6024](https://github.com/IBM/kui/issues/6024)
- avoid excessive status stripe overheads when replaying Notebooks ([58de9c0](https://github.com/IBM/kui/commit/58de9c0)), closes [#5635](https://github.com/IBM/kui/issues/5635)
- grid colors are sometimes off ([e66f56f](https://github.com/IBM/kui/commit/e66f56f)), closes [#5422](https://github.com/IBM/kui/issues/5422)
- improve existing notebooks for v1 ([1af5cc2](https://github.com/IBM/kui/commit/1af5cc2)), closes [#5858](https://github.com/IBM/kui/issues/5858)
- improve the discoverability of repl-block action buttons ([470da34](https://github.com/IBM/kui/commit/470da34)), closes [#5604](https://github.com/IBM/kui/issues/5604)
- improve the replayability of terminal splitting ([67811cd](https://github.com/IBM/kui/commit/67811cd)), closes [#5564](https://github.com/IBM/kui/issues/5564)
- JS console may contain xtermjs error messages when sidecar is minimized ([a568528](https://github.com/IBM/kui/commit/a568528)), closes [#5454](https://github.com/IBM/kui/issues/5454)
- RadioTables are not replayable ([d0dd00e](https://github.com/IBM/kui/commit/d0dd00e)), closes [#5599](https://github.com/IBM/kui/issues/5599)
- restore status stripe to default behavior on terminal clear ([128ec92](https://github.com/IBM/kui/commit/128ec92)), closes [#5495](https://github.com/IBM/kui/issues/5495)
- sidecar shouldn't be opened automatically when replay ([8d4cf8c](https://github.com/IBM/kui/commit/8d4cf8c)), closes [#5730](https://github.com/IBM/kui/issues/5730)
- snapshot and replay of table clicks for Notebook v1 ([1a87dbf](https://github.com/IBM/kui/commit/1a87dbf)), closes [#5821](https://github.com/IBM/kui/issues/5821)
- store the commentary text result to the command when editing is done ([5a3f5e8](https://github.com/IBM/kui/commit/5a3f5e8)), closes [#5916](https://github.com/IBM/kui/issues/5916) [#5672](https://github.com/IBM/kui/issues/5672)
- **plugins/plugin-client-common:** for now, switch interval chart to duration chart ([ea21221](https://github.com/IBM/kui/commit/ea21221)), closes [#5340](https://github.com/IBM/kui/issues/5340)
- **plugins/plugin-client-common:** Grid regression: grid colors not right ([d1aa46d](https://github.com/IBM/kui/commit/d1aa46d)), closes [#5285](https://github.com/IBM/kui/issues/5285)
- **plugins/plugin-client-common:** kubectl watch is broken for server versions >= 1.17 ([2d595b7](https://github.com/IBM/kui/commit/2d595b7)), closes [#5360](https://github.com/IBM/kui/issues/5360)
- **plugins/plugin-kubectl:** add traffic light colors for OOMKilled and UnexpectedAdmissionError ([4262409](https://github.com/IBM/kui/commit/4262409)), closes [#5345](https://github.com/IBM/kui/issues/5345)
- **plugins/plugin-kubectl:** certain filepath options to kubectl were not tilde-expanded ([9e7f858](https://github.com/IBM/kui/commit/9e7f858)), closes [#5415](https://github.com/IBM/kui/issues/5415)
- **plugins/plugin-kubectl:** Fail should be TrafficLight.Red and Succeeded should be TrafficLight.Green ([54737b6](https://github.com/IBM/kui/commit/54737b6)), closes [#5351](https://github.com/IBM/kui/issues/5351)
- **plugins/plugin-kubectl:** header-only tables improperly parsed ([f56841b](https://github.com/IBM/kui/commit/f56841b)), closes [#5382](https://github.com/IBM/kui/issues/5382)
- **plugins/plugin-kubectl:** kubectl tab completion does not let me tab-complete some filepaths ([e42daa7](https://github.com/IBM/kui/commit/e42daa7)), closes [#5413](https://github.com/IBM/kui/issues/5413)
- **plugins/plugin-kubectl:** kubectl watcher needs to pass through kubeconfig in its call to kubectl version ([a5d83a3](https://github.com/IBM/kui/commit/a5d83a3)), closes [#5368](https://github.com/IBM/kui/issues/5368)
- **plugins/plugin-kubectl:** leftover debug printfs in table-watch ([407855a](https://github.com/IBM/kui/commit/407855a)), closes [#5317](https://github.com/IBM/kui/issues/5317)
- **plugins/plugin-kubectl:** regenerate kubernetes notebooks to show new Source Reference feature ([8324567](https://github.com/IBM/kui/commit/8324567)), closes [#5520](https://github.com/IBM/kui/issues/5520)
- **plugins/plugin-kubectl:** Update list-resources notebook to use splits ([1f54515](https://github.com/IBM/kui/commit/1f54515)), closes [#5770](https://github.com/IBM/kui/issues/5770)
- vfs fixes for multi-source copying and for s3 globbing ([893902e](https://github.com/IBM/kui/commit/893902e)), closes [#5511](https://github.com/IBM/kui/issues/5511)
- **plugins/plugin-kubectl:** wordsmithing to list-resources notebook ([7255a98](https://github.com/IBM/kui/commit/7255a98)), closes [#5504](https://github.com/IBM/kui/issues/5504)
- snapshot command fails at `k get -o yaml` ([fe53fb0](https://github.com/IBM/kui/commit/fe53fb0)), closes [#5458](https://github.com/IBM/kui/issues/5458)
- snapshot command throws errors when capturing watch responses ([600f049](https://github.com/IBM/kui/commit/600f049)), closes [#5452](https://github.com/IBM/kui/issues/5452)
- **plugins/plugin-client-common:** improve display of empty watch tables ([4cc16be](https://github.com/IBM/kui/commit/4cc16be)), closes [#5176](https://github.com/IBM/kui/issues/5176)
- **plugins/plugin-client-common:** make Close a top-level button in watch panes ([3c14da5](https://github.com/IBM/kui/commit/3c14da5)), closes [#4945](https://github.com/IBM/kui/issues/4945)
- **plugins/plugin-kubectl:** `oc get namespaces` doesn't produce a RadioTable ([6ea6131](https://github.com/IBM/kui/commit/6ea6131)), closes [#5227](https://github.com/IBM/kui/issues/5227)
- **plugins/plugin-kubectl:** changing ns via oc does not update ns widget, in browser clients ([5eaa625](https://github.com/IBM/kui/commit/5eaa625)), closes [#4953](https://github.com/IBM/kui/issues/4953)
- **plugins/plugin-kubectl:** CurrentNamespace/Context widgets not live ([93ac829](https://github.com/IBM/kui/commit/93ac829)), closes [#5144](https://github.com/IBM/kui/issues/5144)
- **plugins/plugin-kubectl:** drilldown command of resources in watch --all-namespace table doesn't have '-o yaml' ([1e4f558](https://github.com/IBM/kui/commit/1e4f558)), closes [#5208](https://github.com/IBM/kui/issues/5208)
- **plugins/plugin-kubectl:** event footer watching should also support named resources ([e3a842b](https://github.com/IBM/kui/commit/e3a842b)), closes [#5180](https://github.com/IBM/kui/issues/5180)
- **plugins/plugin-kubectl:** events in table appear to be in random order ([034dc06](https://github.com/IBM/kui/commit/034dc06)), closes [#5212](https://github.com/IBM/kui/issues/5212)
- **plugins/plugin-kubectl:** kubectl apply -f may not abort the event watcher ([c8df222](https://github.com/IBM/kui/commit/c8df222)), closes [#5149](https://github.com/IBM/kui/issues/5149)
- **plugins/plugin-kubectl:** kubectl apply edit-last-applied freezes in kui ([24a67da](https://github.com/IBM/kui/commit/24a67da)), closes [#4808](https://github.com/IBM/kui/issues/4808)
- **plugins/plugin-kubectl:** kubectl apply set-last-applied does not work ([9553907](https://github.com/IBM/kui/commit/9553907)), closes [#4844](https://github.com/IBM/kui/issues/4844)
- **plugins/plugin-kubectl:** kubectl apply/create/delete tables still have ALLCAPS headers ([90d72ce](https://github.com/IBM/kui/commit/90d72ce)), closes [#5068](https://github.com/IBM/kui/issues/5068)
- **plugins/plugin-kubectl:** kubectl explain subfields ([8fee2bc](https://github.com/IBM/kui/commit/8fee2bc)), closes [#4921](https://github.com/IBM/kui/issues/4921)
- **plugins/plugin-kubectl:** kubectl Logs/Events/Terminal tabs do not reflow on sidecar maximize ([6dbcbe8](https://github.com/IBM/kui/commit/6dbcbe8)), closes [#5417](https://github.com/IBM/kui/issues/5417)
- **plugins/plugin-kubectl:** kubernetes contexts table renders poorly ([e2ed7d8](https://github.com/IBM/kui/commit/e2ed7d8)), closes [#5230](https://github.com/IBM/kui/issues/5230)
- **plugins/plugin-kubectl:** Kui may invoke kubectl with duplicate command line options ([39c9d31](https://github.com/IBM/kui/commit/39c9d31)), closes [#5330](https://github.com/IBM/kui/issues/5330)
- **plugins/plugin-kubectl:** nil and negative timestamps display as "0ms ago" ([641a599](https://github.com/IBM/kui/commit/641a599)), closes [#5136](https://github.com/IBM/kui/issues/5136)
- **plugins/plugin-kubectl:** Pod summary impl fails for pods with no containerStatuses ([66b21b5](https://github.com/IBM/kui/commit/66b21b5)), closes [#5192](https://github.com/IBM/kui/issues/5192)
- (plugins/plugin-kubectl): kubectl get pod -w --all-namespaces behaves oddly ([12e578a](https://github.com/IBM/kui/commit/12e578a)), closes [#5169](https://github.com/IBM/kui/issues/5169)
- **plugins/plugin-kubectl:** oc get ns does not present a RadioTable ([9e28eec](https://github.com/IBM/kui/commit/9e28eec)), closes [#5106](https://github.com/IBM/kui/issues/5106)
- allow user to disable table title by feature flags, and disable table pagination ([5450512](https://github.com/IBM/kui/commit/5450512)), closes [#4640](https://github.com/IBM/kui/issues/4640) [#4655](https://github.com/IBM/kui/issues/4655)
- avoid hard-coded use of /tmp in kubectl edit ([8e4cb70](https://github.com/IBM/kui/commit/8e4cb70)), closes [#4928](https://github.com/IBM/kui/issues/4928)
- CurrentContext and CurrentNamespace widgets may have stale data inBrowser ([ab77c20](https://github.com/IBM/kui/commit/ab77c20)), closes [#5097](https://github.com/IBM/kui/issues/5097)
- don't blink yellow forever for kubectl events ([a59ee86](https://github.com/IBM/kui/commit/a59ee86)), closes [#4869](https://github.com/IBM/kui/issues/4869)
- kubectl help misformats helm help tables ([ff36755](https://github.com/IBM/kui/commit/ff36755)), closes [#5080](https://github.com/IBM/kui/issues/5080)
- multiple issues with tab switching versus status stripe widgets ([8c8a6ec](https://github.com/IBM/kui/commit/8c8a6ec)), closes [#5101](https://github.com/IBM/kui/issues/5101)
- **plugins/plugin-kubectl:** tolerate helm 3.0 and 3.1 help custom ascii art tables ([79f8640](https://github.com/IBM/kui/commit/79f8640)), closes [#5085](https://github.com/IBM/kui/issues/5085)
- avoid using kui-custom command for switching kubectl namespace ([43863f2](https://github.com/IBM/kui/commit/43863f2)), closes [#4806](https://github.com/IBM/kui/issues/4806)
- pexecs serviced by now-removed splits fail ([f6176a1](https://github.com/IBM/kui/commit/f6176a1)), closes [#4875](https://github.com/IBM/kui/issues/4875)
- reduce custom CSS rules for table UI ([56f69cb](https://github.com/IBM/kui/commit/56f69cb)), closes [#5024](https://github.com/IBM/kui/issues/5024)
- remove augmentModuleLoadPath API ([47dfcdf](https://github.com/IBM/kui/commit/47dfcdf)), closes [#4839](https://github.com/IBM/kui/issues/4839)
- xterm alt buffer mode behaves oddly for clients that do not enable splitTerminals ([f1bc709](https://github.com/IBM/kui/commit/f1bc709)), closes [#5003](https://github.com/IBM/kui/issues/5003)
- **plugins/plugin-kubectl:** get-namespace table sometimes doens't show the correct selected namespace ([af66aa4](https://github.com/IBM/kui/commit/af66aa4)), closes [#4812](https://github.com/IBM/kui/issues/4812)
- **plugins/plugin-kubectl:** kubectl logs -l with no matches yields internal error ([ed0374f](https://github.com/IBM/kui/commit/ed0374f)), closes [#4811](https://github.com/IBM/kui/issues/4811)
- **plugins/plugin-kubectl:** kubectl watch tables may lack namespace breadcrumb ([a0616c2](https://github.com/IBM/kui/commit/a0616c2)), closes [#4870](https://github.com/IBM/kui/issues/4870)
- **plugins/plugin-kubectl:** Logs tab should have a default tail limit ([d4cf08c](https://github.com/IBM/kui/commit/d4cf08c)), closes [#4810](https://github.com/IBM/kui/issues/4810) [#4818](https://github.com/IBM/kui/issues/4818)
- **plugins/plugin-kubectl:** oc get projects does not allow user selection ([3749371](https://github.com/IBM/kui/commit/3749371)), closes [#4805](https://github.com/IBM/kui/issues/4805)
- **plugins/plugin-kubectl:** oc logs does not work ([f0808a2](https://github.com/IBM/kui/commit/f0808a2)), closes [#4965](https://github.com/IBM/kui/issues/4965)
- **plugins/plugin-kubectl:** singleton breadcrumbs in kubectl help should not be clickable ([7815464](https://github.com/IBM/kui/commit/7815464)), closes [#4961](https://github.com/IBM/kui/issues/4961)
- **plugins/plugin-kubectl:** Terminal tab test incorrectly verifies k exec output ([20ab362](https://github.com/IBM/kui/commit/20ab362)), closes [#4802](https://github.com/IBM/kui/issues/4802)
- **plugins/plugin-kubectl:** windows powershell fails to get default namespace ([a5fb2e1](https://github.com/IBM/kui/commit/a5fb2e1)), closes [#4912](https://github.com/IBM/kui/issues/4912)
- eliminate assumptions that "default" is the default kube namespace ([4eb392d](https://github.com/IBM/kui/commit/4eb392d)), closes [#4764](https://github.com/IBM/kui/issues/4764)
- empty watch tables/grids should show 'No resources' ([c0bfe99](https://github.com/IBM/kui/commit/c0bfe99)), closes [#4884](https://github.com/IBM/kui/issues/4884)
- improve hover effect for status stripe buttons ([50ced8f](https://github.com/IBM/kui/commit/50ced8f)), closes [#4896](https://github.com/IBM/kui/issues/4896)
- Input element throws react error ([e6bb21b](https://github.com/IBM/kui/commit/e6bb21b)), closes [#4765](https://github.com/IBM/kui/issues/4765)
- kubectl edit apply twice does not work ([1976134](https://github.com/IBM/kui/commit/1976134)), closes [#4797](https://github.com/IBM/kui/issues/4797)
- kubectl edit in sidecar doesn't show success message when a resource is applied ([cc59503](https://github.com/IBM/kui/commit/cc59503)), closes [#4691](https://github.com/IBM/kui/issues/4691)
- kubectl Logs tab should use an xterm ([9aa0176](https://github.com/IBM/kui/commit/9aa0176)), closes [#4750](https://github.com/IBM/kui/issues/4750) [#4747](https://github.com/IBM/kui/issues/4747)
- sidecar toolbar can't due justice to longer error messages ([e67e0c9](https://github.com/IBM/kui/commit/e67e0c9)), closes [#4789](https://github.com/IBM/kui/issues/4789)
- summary tab is not read-only for kubectl edit command ([9f7ff82](https://github.com/IBM/kui/commit/9f7ff82)), closes [#4809](https://github.com/IBM/kui/issues/4809)
- the Logs/Terminal retry button should be visible on any exit code ([3366327](https://github.com/IBM/kui/commit/3366327)), closes [#4769](https://github.com/IBM/kui/issues/4769)
- TopNavSidecar tabs should auto-pause and auto-focus when switching ([2b00dd9](https://github.com/IBM/kui/commit/2b00dd9)), closes [#4741](https://github.com/IBM/kui/issues/4741) [#4748](https://github.com/IBM/kui/issues/4748)
- **plugin-kubectl:** k get pods --all-namespaces has a title with "default" as the namespace ([2f95129](https://github.com/IBM/kui/commit/2f95129)), closes [#4466](https://github.com/IBM/kui/issues/4466)
- **plugins/plugin-kubectl:** auto-pause logs when user scrolls ([94b85e6](https://github.com/IBM/kui/commit/94b85e6)), closes [#4668](https://github.com/IBM/kui/issues/4668)
- **plugins/plugin-kubectl:** automatically abort idle PTYs ([2638a65](https://github.com/IBM/kui/commit/2638a65)), closes [#4742](https://github.com/IBM/kui/issues/4742)
- **plugins/plugin-kubectl:** cache kind canonicalization lookup ([e351a5f](https://github.com/IBM/kui/commit/e351a5f)), closes [#4489](https://github.com/IBM/kui/issues/4489)
- **plugins/plugin-kubectl:** ExecIntoPod's terminal is not theme-aligned ([067cda3](https://github.com/IBM/kui/commit/067cda3)), closes [#4722](https://github.com/IBM/kui/issues/4722)
- **plugins/plugin-kubectl:** helm help parsed usage incorrectly ([b222da2](https://github.com/IBM/kui/commit/b222da2)), closes [#4692](https://github.com/IBM/kui/issues/4692)
- **plugins/plugin-kubectl:** i18n for No log data message ([589a4cd](https://github.com/IBM/kui/commit/589a4cd)), closes [#4656](https://github.com/IBM/kui/issues/4656)
- **plugins/plugin-kubectl:** ImagePullBackoff should be considered a "red" state ([198100d](https://github.com/IBM/kui/commit/198100d)), closes [#4734](https://github.com/IBM/kui/issues/4734)
- **plugins/plugin-kubectl:** improve kubectl tab completion ([734f9e5](https://github.com/IBM/kui/commit/734f9e5)), closes [#4704](https://github.com/IBM/kui/issues/4704)
- **plugins/plugin-kubectl:** improve kubectl top node display with open sidecar ([6f99581](https://github.com/IBM/kui/commit/6f99581)), closes [#4737](https://github.com/IBM/kui/issues/4737)
- **plugins/plugin-kubectl:** inconsistent capitalization of breadcrumbs ([963b166](https://github.com/IBM/kui/commit/963b166)), closes [#4607](https://github.com/IBM/kui/issues/4607)
- **plugins/plugin-kubectl:** k edit deploy has mysterious Pod tab ([914df36](https://github.com/IBM/kui/commit/914df36)), closes [#4703](https://github.com/IBM/kui/issues/4703)
- **plugins/plugin-kubectl:** kubectl api-resources table should hide APIGROUP column with open sidecar ([ee347fa](https://github.com/IBM/kui/commit/ee347fa)), closes [#4728](https://github.com/IBM/kui/issues/4728)
- add support for hiding elements at higher zoom levels ([7d2a7e0](https://github.com/IBM/kui/commit/7d2a7e0)), closes [#4232](https://github.com/IBM/kui/issues/4232)
- avoid recomputing tabs when switching back and forth ([cf5e41f](https://github.com/IBM/kui/commit/cf5e41f)), closes [#4666](https://github.com/IBM/kui/issues/4666)
- clicking on certain links in kubectl help result in odd behavior ([035894b](https://github.com/IBM/kui/commit/035894b)), closes [#4473](https://github.com/IBM/kui/issues/4473)
- clicking on container name in details sidecar should add -c to logs command ([61c7c08](https://github.com/IBM/kui/commit/61c7c08)), closes [#4498](https://github.com/IBM/kui/issues/4498)
- eliminate complex nesting of NavResponse model ([e849ae7](https://github.com/IBM/kui/commit/e849ae7)), closes [#4205](https://github.com/IBM/kui/issues/4205)
- ibmcloud plugin list does not list unofficial plugins ([303fa00](https://github.com/IBM/kui/commit/303fa00)), closes [#4339](https://github.com/IBM/kui/issues/4339)
- improve error reporting for kubectl apply ([fe21671](https://github.com/IBM/kui/commit/fe21671)), closes [#4605](https://github.com/IBM/kui/issues/4605)
- kubectl api-resources has duplicate rows and odd pagination behavior ([e740270](https://github.com/IBM/kui/commit/e740270)), closes [#4626](https://github.com/IBM/kui/issues/4626)
- logs tab toolbar doesn't signify when pods are 404 ([135e1be](https://github.com/IBM/kui/commit/135e1be)), closes [#4646](https://github.com/IBM/kui/issues/4646)
- place namespace breadcrumb first ([5d3b2e4](https://github.com/IBM/kui/commit/5d3b2e4)), closes [#4699](https://github.com/IBM/kui/issues/4699)
- **plugins/plugin-kubectl:** k edit -h does not open in sidecar ([b6f68f8](https://github.com/IBM/kui/commit/b6f68f8)), closes [#4661](https://github.com/IBM/kui/issues/4661)
- **plugins/plugin-kubectl:** k get events -w bombs ([20c2caf](https://github.com/IBM/kui/commit/20c2caf)), closes [#4557](https://github.com/IBM/kui/issues/4557)
- **plugins/plugin-kubectl:** kubectl create secret hangs yellow ([e11dbb8](https://github.com/IBM/kui/commit/e11dbb8)), closes [#4571](https://github.com/IBM/kui/issues/4571)
- **plugins/plugin-kubectl:** kubectl describe -h has old bold text ([b31d066](https://github.com/IBM/kui/commit/b31d066)), closes [#4568](https://github.com/IBM/kui/issues/4568)
- **plugins/plugin-kubectl:** kubectl edit should support editing a list of resources ([4cd4d43](https://github.com/IBM/kui/commit/4cd4d43)), closes [#4555](https://github.com/IBM/kui/issues/4555)
- **plugins/plugin-kubectl:** kubectl get --all-namespaces --watch does not update ([663a972](https://github.com/IBM/kui/commit/663a972)), closes [#4581](https://github.com/IBM/kui/issues/4581)
- **plugins/plugin-kubectl:** kubectl get table with mix of existing and non-existing ([8d98d15](https://github.com/IBM/kui/commit/8d98d15)), closes [#4492](https://github.com/IBM/kui/issues/4492)
- **plugins/plugin-kubectl:** kubectl logs tab has bad interleaving and cpu issues ([1c7cf17](https://github.com/IBM/kui/commit/1c7cf17)), closes [#4664](https://github.com/IBM/kui/issues/4664) [#4665](https://github.com/IBM/kui/issues/4665)
- **plugins/plugin-kubectl:** kubectl Show Events query not precise enough ([eda6b38](https://github.com/IBM/kui/commit/eda6b38)), closes [#4572](https://github.com/IBM/kui/issues/4572)
- **plugins/plugin-kubectl:** remove kubectl edit cancel button ([83179e8](https://github.com/IBM/kui/commit/83179e8)), closes [#4695](https://github.com/IBM/kui/issues/4695)
- container filter of logs tab shows accumulated logs from previous selection ([08903b4](https://github.com/IBM/kui/commit/08903b4)), closes [#4644](https://github.com/IBM/kui/issues/4644) [#4658](https://github.com/IBM/kui/issues/4658)
- **plugins/plugin-kubectl:** remove Conditions tab ([eac3705](https://github.com/IBM/kui/commit/eac3705)), closes [#4606](https://github.com/IBM/kui/issues/4606)
- kubectl top node should show % text ([f861b76](https://github.com/IBM/kui/commit/f861b76)), closes [#4598](https://github.com/IBM/kui/issues/4598)
- optimize kubectl watch load on apiserver ([3f7a32f](https://github.com/IBM/kui/commit/3f7a32f)), closes [#4494](https://github.com/IBM/kui/issues/4494)
- PaginatedTable fails at distinguishing the rowKeys of `k get --all-namespaces` table ([6658729](https://github.com/IBM/kui/commit/6658729)), closes [#4579](https://github.com/IBM/kui/issues/4579)
- reduce No log data followed by log data behavior in kube logs ([e1c0624](https://github.com/IBM/kui/commit/e1c0624)), closes [#4624](https://github.com/IBM/kui/issues/4624)
- **plugins/plugin-kubectl:** add missing test for get with not found ([3e77689](https://github.com/IBM/kui/commit/3e77689)), closes [#4492](https://github.com/IBM/kui/issues/4492)
- **plugins/plugin-kubectl:** remove Show Logs registration ([382c685](https://github.com/IBM/kui/commit/382c685)), closes [#4603](https://github.com/IBM/kui/issues/4603)
- replace Containers with Logs tab ([00e8786](https://github.com/IBM/kui/commit/00e8786)), closes [#4603](https://github.com/IBM/kui/issues/4603)
- **plugin-kubectl:** kubectl get error-type -w doesn't fail fast ([4ccb733](https://github.com/IBM/kui/commit/4ccb733)), closes [#4491](https://github.com/IBM/kui/issues/4491)
- **plugins/plugin-kubectl:** revert to editor-based Summary tab ([3ecd638](https://github.com/IBM/kui/commit/3ecd638)), closes [#4594](https://github.com/IBM/kui/issues/4594)
- sidecar views do not respect tab-specificity ([5a1cae2](https://github.com/IBM/kui/commit/5a1cae2)), closes [#4362](https://github.com/IBM/kui/issues/4362)
- **plugins/plugin-kubectl:** CurrentContext widget shows "default" for openshift clusters ([59712c0](https://github.com/IBM/kui/commit/59712c0)), closes [#4347](https://github.com/IBM/kui/issues/4347)
- make inBrowserOk the default ([2a3c811](https://github.com/IBM/kui/commit/2a3c811)), closes [#4275](https://github.com/IBM/kui/issues/4275)
- multiple kubectl help/usage bugs ([ebba36e](https://github.com/IBM/kui/commit/ebba36e)), closes [#4342](https://github.com/IBM/kui/issues/4342)
- **plugins/plugin-kubectl:** avoid use of /s regexp ([9468304](https://github.com/IBM/kui/commit/9468304)), closes [#4259](https://github.com/IBM/kui/issues/4259)
- **plugins/plugin-kubectl:** ensure Show Owner button appears near end of toolbar buttons ([224c586](https://github.com/IBM/kui/commit/224c586)), closes [#4124](https://github.com/IBM/kui/issues/4124)
- **plugins/plugin-kubectl:** firefox does not support the /s flag to RegExp ([5b661a6](https://github.com/IBM/kui/commit/5b661a6)), closes [#4206](https://github.com/IBM/kui/issues/4206)
- **plugins/plugin-kubectl:** in kube namespace table, selected namespace should float to top ([f0e597f](https://github.com/IBM/kui/commit/f0e597f)), closes [#4129](https://github.com/IBM/kui/issues/4129)
- **plugins/plugin-kubectl:** kubectl api-resources table shows 'unknown' in title ([0461710](https://github.com/IBM/kui/commit/0461710)), closes [#4145](https://github.com/IBM/kui/issues/4145)
- **plugins/plugin-kubectl:** kubectl describe (--help) fails ([10b8e8a](https://github.com/IBM/kui/commit/10b8e8a)), closes [#4012](https://github.com/IBM/kui/issues/4012)
- **plugins/plugin-kubectl:** kubectl explain -h should render as usage in sidecar ([8e00c3f](https://github.com/IBM/kui/commit/8e00c3f)), closes [#4211](https://github.com/IBM/kui/issues/4211)
- **plugins/plugin-kubectl:** kubectl explain Overview tab not formatted as expected ([ffa9183](https://github.com/IBM/kui/commit/ffa9183)), closes [#4304](https://github.com/IBM/kui/issues/4304)
- **plugins/plugin-kubectl:** kubectl top nodes can present "NaN" ([30df3dd](https://github.com/IBM/kui/commit/30df3dd)), closes [#4189](https://github.com/IBM/kui/issues/4189)
- **plugins/plugin-kubectl:** more refinements to Form layout heuristics ([e92327d](https://github.com/IBM/kui/commit/e92327d)), closes [#4118](https://github.com/IBM/kui/issues/4118)
- **plugins/plugin-kubectl:** oc describe fails ([4f4de4e](https://github.com/IBM/kui/commit/4f4de4e)), closes [#4008](https://github.com/IBM/kui/issues/4008)
- **plugins/plugin-kubectl:** status shows as Containercreating when it should be ContainerCreating ([2c4a3b6](https://github.com/IBM/kui/commit/2c4a3b6)), closes [#4798](https://github.com/IBM/kui/issues/4798)
- **plugins/plugin-kubectl:** update deprecated import of uuid ([5de8d4d](https://github.com/IBM/kui/commit/5de8d4d)), closes [#4316](https://github.com/IBM/kui/issues/4316)
- **plugins/plugin-kubectl:** we shouldn't render namespace widget when the namespace is empty in kube config ([98a9406](https://github.com/IBM/kui/commit/98a9406)), closes [#4274](https://github.com/IBM/kui/issues/4274)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- kubectl summary Form TextInputs can be cropped ([3becaf9](https://github.com/IBM/kui/commit/3becaf9)), closes [#4077](https://github.com/IBM/kui/issues/4077)
- multiple tab completion bugs ([5513712](https://github.com/IBM/kui/commit/5513712)), closes [#4281](https://github.com/IBM/kui/issues/4281)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- the colors of status badges: Error, ImagePullBackOff and ErrImagePull are incorrect ([fd206f6](https://github.com/IBM/kui/commit/fd206f6)), closes [#4171](https://github.com/IBM/kui/issues/4171)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- **plugins/plugin-kubectl:** watch table doesn't have breadcrumbs title ([43fbe6a](https://github.com/IBM/kui/commit/43fbe6a)), closes [#4135](https://github.com/IBM/kui/issues/4135)
- **plugins/plugin-kubectl:** watcher table disappears when kui is launched as kubectl plugin ([167eabc](https://github.com/IBM/kui/commit/167eabc)), closes [#4120](https://github.com/IBM/kui/issues/4120) [#4123](https://github.com/IBM/kui/issues/4123)
- ensure kubectl Delete toolbar button appears at far right ([9eb3079](https://github.com/IBM/kui/commit/9eb3079)), closes [#4116](https://github.com/IBM/kui/issues/4116)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- tekton Step nodes show with hashed background ([8428d72](https://github.com/IBM/kui/commit/8428d72)), closes [#4114](https://github.com/IBM/kui/issues/4114)
- TopNavSidecar does not always show updates ([251e5c4](https://github.com/IBM/kui/commit/251e5c4)), closes [#4524](https://github.com/IBM/kui/issues/4524)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)

### Features

- inline sidecar ([2c3afeb](https://github.com/IBM/kui/commit/2c3afeb)), closes [#6007](https://github.com/IBM/kui/issues/6007)
- **plugins/plugin-kubectl:** Namespace Summary impl ([2d69d67](https://github.com/IBM/kui/commit/2d69d67)), closes [#5790](https://github.com/IBM/kui/issues/5790)
- add a prefer-re-execution option to snapshot ([af7b98b](https://github.com/IBM/kui/commit/af7b98b)), closes [#5622](https://github.com/IBM/kui/issues/5622)
- **packages/core:** allow controller to opt in/out recording table row onclicks when snapshot ([cc83ce7](https://github.com/IBM/kui/commit/cc83ce7)), closes [#5565](https://github.com/IBM/kui/issues/5565)
- add capability to show welcome widget to new users in Terminal ([0c33e6e](https://github.com/IBM/kui/commit/0c33e6e)), closes [#4990](https://github.com/IBM/kui/issues/4990) [#5007](https://github.com/IBM/kui/issues/5007)
- allow controllers to control the color of the status stripe ([708570c](https://github.com/IBM/kui/commit/708570c)), closes [#5490](https://github.com/IBM/kui/issues/5490)
- allow for limiting the number of kubectl table rows ([62588f2](https://github.com/IBM/kui/commit/62588f2)), closes [#5358](https://github.com/IBM/kui/issues/5358)
- background new tabs ([be9f986](https://github.com/IBM/kui/commit/be9f986)), closes [#5550](https://github.com/IBM/kui/issues/5550)
- clicking on events in watch table should drill down to events ([c6dc99f](https://github.com/IBM/kui/commit/c6dc99f)), closes [#5173](https://github.com/IBM/kui/issues/5173)
- cold start delays ([83abd14](https://github.com/IBM/kui/commit/83abd14)), closes [#5356](https://github.com/IBM/kui/issues/5356)
- custom tab titles ([fd780df](https://github.com/IBM/kui/commit/fd780df)), closes [#5525](https://github.com/IBM/kui/issues/5525)
- generalized kuberctl get with limit ([d40ee07](https://github.com/IBM/kui/commit/d40ee07)), closes [#5361](https://github.com/IBM/kui/issues/5361)
- improve kubectl edit experience ([4c4a1c9](https://github.com/IBM/kui/commit/4c4a1c9)), closes [#4783](https://github.com/IBM/kui/issues/4783)
- improve rendering of kubectl subcommand help ([e36ed29](https://github.com/IBM/kui/commit/e36ed29)), closes [#4824](https://github.com/IBM/kui/issues/4824)
- initial popeye support ([9d62eeb](https://github.com/IBM/kui/commit/9d62eeb)), closes [#5265](https://github.com/IBM/kui/issues/5265)
- initial support for capturing input files and showing them in the UI ([5744bf4](https://github.com/IBM/kui/commit/5744bf4)), closes [#5513](https://github.com/IBM/kui/issues/5513)
- kubectl apply view-last-applied ([6d601ef](https://github.com/IBM/kui/commit/6d601ef)), closes [#4822](https://github.com/IBM/kui/issues/4822)
- line highlights on editor save, used for k edit apply errors ([3efa6a5](https://github.com/IBM/kui/commit/3efa6a5)), closes [#4795](https://github.com/IBM/kui/issues/4795)
- MiniSplits ([70b8441](https://github.com/IBM/kui/commit/70b8441)), closes [#5112](https://github.com/IBM/kui/issues/5112)
- notebook client ([4b64133](https://github.com/IBM/kui/commit/4b64133)), closes [#5501](https://github.com/IBM/kui/issues/5501)
- **plugins/plugin-client-common:** improved SequenceDiagram view ([1e2fb41](https://github.com/IBM/kui/commit/1e2fb41)), closes [#5342](https://github.com/IBM/kui/issues/5342)
- **plugins/plugin-git:** git branch should respond with RadioTable ([59a9213](https://github.com/IBM/kui/commit/59a9213)), closes [#5256](https://github.com/IBM/kui/issues/5256)
- **plugins/plugin-ibmcloud:** initial CodeEngine support ([677faca](https://github.com/IBM/kui/commit/677faca)), closes [#5302](https://github.com/IBM/kui/issues/5302) [#5303](https://github.com/IBM/kui/issues/5303)
- **plugins/plugin-kubectl:** add status column to kube deployment table ([1d35040](https://github.com/IBM/kui/commit/1d35040)), closes [#5476](https://github.com/IBM/kui/issues/5476)
- **plugins/plugin-kubectl:** initial `kubectl job list` improvement for visualizing Job execution ([06030b0](https://github.com/IBM/kui/commit/06030b0)), closes [#5397](https://github.com/IBM/kui/issues/5397)
- **plugins/plugin-kubectl:** initial labs for listing k8s resources and creating jobs ([2e9d002](https://github.com/IBM/kui/commit/2e9d002)), closes [#5475](https://github.com/IBM/kui/issues/5475)
- add Retry button to sidecar toolbar when log streaming stopped abnormally ([47872f4](https://github.com/IBM/kui/commit/47872f4)), closes [#4755](https://github.com/IBM/kui/issues/4755)
- **plugins/plugin-kubectl:** kubectl events tab ([2d71f24](https://github.com/IBM/kui/commit/2d71f24)), closes [#4706](https://github.com/IBM/kui/issues/4706)
- **plugins/plugin-kubectl:** namespace onclick should drill down to sidecar ([e74f66d](https://github.com/IBM/kui/commit/e74f66d)), closes [#4714](https://github.com/IBM/kui/issues/4714)
- **plugins/plugin-kubectl:** optimize rendering of kubectl Summary tab ([7c6480d](https://github.com/IBM/kui/commit/7c6480d)), closes [#4725](https://github.com/IBM/kui/issues/4725)
- **plugins/plugin-kubectl:** Terminal tab for Pod kubernetes resources ([c47e432](https://github.com/IBM/kui/commit/c47e432)), closes [#4639](https://github.com/IBM/kui/issues/4639)
- add button to WatchPane to show table back in terminal ([dc22591](https://github.com/IBM/kui/commit/dc22591)), closes [#4530](https://github.com/IBM/kui/issues/4530)
- add isSelected and Divider to log container selection menu ([59bdaa5](https://github.com/IBM/kui/commit/59bdaa5)), closes [#4647](https://github.com/IBM/kui/issues/4647)
- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Patternfly Breadcrumb support ([91e0504](https://github.com/IBM/kui/commit/91e0504)), closes [#4381](https://github.com/IBM/kui/issues/4381)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add Stop Watching capability to WatchPane ([09043c1](https://github.com/IBM/kui/commit/09043c1)), closes [#4554](https://github.com/IBM/kui/issues/4554)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- allow users to select container in kubectl Logs ([f4304c5](https://github.com/IBM/kui/commit/f4304c5)), closes [#4627](https://github.com/IBM/kui/issues/4627)
- commands should be able to separate resource model fetch from view transformation functions ([e903bc7](https://github.com/IBM/kui/commit/e903bc7)), closes [#4437](https://github.com/IBM/kui/issues/4437)
- ibmcloud plugin ([aa0f72f](https://github.com/IBM/kui/commit/aa0f72f)), closes [#4353](https://github.com/IBM/kui/issues/4353)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- initial odo catalog list enhancements ([8534267](https://github.com/IBM/kui/commit/8534267)), closes [#4485](https://github.com/IBM/kui/issues/4485)
- initial typeahead for commands ([7ba313a](https://github.com/IBM/kui/commit/7ba313a)), closes [#5437](https://github.com/IBM/kui/issues/5437)
- kubectl edit via kui's editor ([414e813](https://github.com/IBM/kui/commit/414e813)), closes [#762](https://github.com/IBM/kui/issues/762)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- only enable WatchPane based on a feature flag ([eb80d0e](https://github.com/IBM/kui/commit/eb80d0e)), closes [#4678](https://github.com/IBM/kui/issues/4678) [#4604](https://github.com/IBM/kui/issues/4604)
- patternfly4 themes ([5f58f71](https://github.com/IBM/kui/commit/5f58f71)), closes [#4364](https://github.com/IBM/kui/issues/4364)
- pin a watchable terminal response in a split pane ([662f413](https://github.com/IBM/kui/commit/662f413)), closes [#4865](https://github.com/IBM/kui/issues/4865) [#4573](https://github.com/IBM/kui/issues/4573) [#4885](https://github.com/IBM/kui/issues/4885) [#4894](https://github.com/IBM/kui/issues/4894)
- port kubectl get ns to RadioTable ([be0eabf](https://github.com/IBM/kui/commit/be0eabf)), closes [#4510](https://github.com/IBM/kui/issues/4510) [#4511](https://github.com/IBM/kui/issues/4511)
- refine kubectl contexts table; add support for RadioTable row titles ([11bb074](https://github.com/IBM/kui/commit/11bb074)), closes [#5131](https://github.com/IBM/kui/issues/5131)
- s3 plugin, and vfs ([970ba6e](https://github.com/IBM/kui/commit/970ba6e)), closes [#5319](https://github.com/IBM/kui/issues/5319)
- show resource version in toolbar text ([1a6e335](https://github.com/IBM/kui/commit/1a6e335)), closes [#4790](https://github.com/IBM/kui/issues/4790)
- simplified co-hosting of client and proxy in a container ([00af4b4](https://github.com/IBM/kui/commit/00af4b4)), closes [#4213](https://github.com/IBM/kui/issues/4213)
- top tab buttons ([ff8cfba](https://github.com/IBM/kui/commit/ff8cfba)), closes [#4434](https://github.com/IBM/kui/issues/4434)
- watcher panel for open-ended watch jobs ([6dfe7df](https://github.com/IBM/kui/commit/6dfe7df)), closes [#4503](https://github.com/IBM/kui/issues/4503)
- **plugins/plugin-kubectl:** add Show Node button for kubectl pods ([04e29d2](https://github.com/IBM/kui/commit/04e29d2)), closes [#4214](https://github.com/IBM/kui/issues/4214)
- **plugins/plugin-kubectl:** add support for kustomize apply/delete/create ([b95cbdb](https://github.com/IBM/kui/commit/b95cbdb)), closes [#4203](https://github.com/IBM/kui/issues/4203)
- **plugins/plugin-kubectl:** enhance odo project list as RadioTable ([62272e6](https://github.com/IBM/kui/commit/62272e6)), closes [#4517](https://github.com/IBM/kui/issues/4517)
- **plugins/plugin-kubectl:** improve odo usage experience ([639ca32](https://github.com/IBM/kui/commit/639ca32)), closes [#4345](https://github.com/IBM/kui/issues/4345)
- **plugins/plugin-kubectl:** port kubectl contexts table to RadioTable ([3cb4dcb](https://github.com/IBM/kui/commit/3cb4dcb)), closes [#4513](https://github.com/IBM/kui/issues/4513)
- SPI for icons ([3d034e3](https://github.com/IBM/kui/commit/3d034e3)), closes [#4441](https://github.com/IBM/kui/issues/4441) [#4364](https://github.com/IBM/kui/issues/4364)
- split screen Terminal ([3a6b422](https://github.com/IBM/kui/commit/3a6b422)), closes [#4814](https://github.com/IBM/kui/issues/4814) [#4821](https://github.com/IBM/kui/issues/4821)
- support for events in crud table footer ([0b90ead](https://github.com/IBM/kui/commit/0b90ead)), closes [#5125](https://github.com/IBM/kui/issues/5125)
- support for events in table footer ([51669af](https://github.com/IBM/kui/commit/51669af)), closes [#5115](https://github.com/IBM/kui/issues/5115)
- tutorial VFS ([6f2330e](https://github.com/IBM/kui/commit/6f2330e)), closes [#5441](https://github.com/IBM/kui/issues/5441)
- **plugins/plugin-kubectl:** configmap summary should show data ([50c7e10](https://github.com/IBM/kui/commit/50c7e10)), closes [#4025](https://github.com/IBM/kui/issues/4025)
- **plugins/plugin-kubectl:** optimizing Node summary impl ([8ac11b9](https://github.com/IBM/kui/commit/8ac11b9)), closes [#4833](https://github.com/IBM/kui/issues/4833)
- **plugins/plugin-kubectl:** ReplicaSet should have Pods tab ([42cd286](https://github.com/IBM/kui/commit/42cd286)), closes [#4110](https://github.com/IBM/kui/issues/4110)
- **plugins/plugin-kubectl:** restore Show Logs button for kubectl ([6b17dbd](https://github.com/IBM/kui/commit/6b17dbd)), closes [#4089](https://github.com/IBM/kui/issues/4089)
- **plugins/plugin-kubectl:** Show Previous option for Logs tab ([2307d2f](https://github.com/IBM/kui/commit/2307d2f)), closes [#4864](https://github.com/IBM/kui/issues/4864)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- target kubectl logs and kubectl exec to Logs and Terminal tabs ([409e632](https://github.com/IBM/kui/commit/409e632)), closes [#4762](https://github.com/IBM/kui/issues/4762)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)

### BREAKING CHANGES

- removes support for inBrowserOk

# [9.0.0](https://github.com/IBM/kui/compare/v4.5.0...v9.0.0) (2020-10-08)

### Bug Fixes

- **plugins/plugin-client-common:** clicking the split button may cause the current processing block to disappear ([aa2b40c](https://github.com/IBM/kui/commit/aa2b40c)), closes [#5703](https://github.com/IBM/kui/issues/5703)
- **plugins/plugin-client-common:** don't offer Grid option for 1-row tables ([a2a6f8d](https://github.com/IBM/kui/commit/a2a6f8d)), closes [#5474](https://github.com/IBM/kui/issues/5474)
- **plugins/plugin-client-common:** isReplay bit on Blocks is not set for snapshots ([c6d1633](https://github.com/IBM/kui/commit/c6d1633)), closes [#5868](https://github.com/IBM/kui/issues/5868)
- **plugins/plugin-client-common:** SequenceDiagram UI refinements ([5d8c3f7](https://github.com/IBM/kui/commit/5d8c3f7)), closes [#5557](https://github.com/IBM/kui/issues/5557)
- **plugins/plugin-client-common:** update welcome.json to describe kui, not just notebooks ([96330c4](https://github.com/IBM/kui/commit/96330c4)), closes [#5878](https://github.com/IBM/kui/issues/5878)
- **plugins/plugin-kubectl:** events in table appear to be in random order ([034dc06](https://github.com/IBM/kui/commit/034dc06)), closes [#5212](https://github.com/IBM/kui/issues/5212)
- **plugins/plugin-kubectl:** k8s table should display status Propagated and Subscribed as green ([0787b4b](https://github.com/IBM/kui/commit/0787b4b)), closes [#5818](https://github.com/IBM/kui/issues/5818)
- **plugins/plugin-kubectl:** kubectl delete ns m1 m2 m3 m4 results in a one-row table ([97a33a4](https://github.com/IBM/kui/commit/97a33a4)), closes [#5694](https://github.com/IBM/kui/issues/5694)
- **plugins/plugin-kubectl:** kubectl status table does not register onclickIdempotent ([6ae296c](https://github.com/IBM/kui/commit/6ae296c)), closes [#5788](https://github.com/IBM/kui/issues/5788)
- **plugins/plugin-kubectl:** kubectl table should show PropagationFailed status as offline ([a44b70c](https://github.com/IBM/kui/commit/a44b70c)), closes [#5821](https://github.com/IBM/kui/issues/5821)
- **plugins/plugin-kubectl:** kubernetes contexts table renders poorly ([e2ed7d8](https://github.com/IBM/kui/commit/e2ed7d8)), closes [#5230](https://github.com/IBM/kui/issues/5230)
- **plugins/plugin-kubectl:** regenerate kubernetes notebooks to show new Source Reference feature ([8324567](https://github.com/IBM/kui/commit/8324567)), closes [#5520](https://github.com/IBM/kui/issues/5520)
- **plugins/plugin-kubectl:** update jobs notebook to latest SequenceDiagram ([8e70862](https://github.com/IBM/kui/commit/8e70862)), closes [#5862](https://github.com/IBM/kui/issues/5862)
- avoid excessive status stripe overheads when replaying Notebooks ([58de9c0](https://github.com/IBM/kui/commit/58de9c0)), closes [#5635](https://github.com/IBM/kui/issues/5635)
- clicking on certain links in kubectl help result in odd behavior ([035894b](https://github.com/IBM/kui/commit/035894b)), closes [#4473](https://github.com/IBM/kui/issues/4473)
- grid colors are sometimes off ([e66f56f](https://github.com/IBM/kui/commit/e66f56f)), closes [#5422](https://github.com/IBM/kui/issues/5422)
- improve existing notebooks for v1 ([1af5cc2](https://github.com/IBM/kui/commit/1af5cc2)), closes [#5858](https://github.com/IBM/kui/issues/5858)
- improve the discoverability of repl-block action buttons ([470da34](https://github.com/IBM/kui/commit/470da34)), closes [#5604](https://github.com/IBM/kui/issues/5604)
- improve the replayability of terminal splitting ([67811cd](https://github.com/IBM/kui/commit/67811cd)), closes [#5564](https://github.com/IBM/kui/issues/5564)
- kubectl edit in sidecar doesn't show success message when a resource is applied ([cc59503](https://github.com/IBM/kui/commit/cc59503)), closes [#4691](https://github.com/IBM/kui/issues/4691)
- RadioTables are not replayable ([d0dd00e](https://github.com/IBM/kui/commit/d0dd00e)), closes [#5599](https://github.com/IBM/kui/issues/5599)
- restore status stripe to default behavior on terminal clear ([128ec92](https://github.com/IBM/kui/commit/128ec92)), closes [#5495](https://github.com/IBM/kui/issues/5495)
- sidecar shouldn't be opened automatically when replay ([8d4cf8c](https://github.com/IBM/kui/commit/8d4cf8c)), closes [#5730](https://github.com/IBM/kui/issues/5730)
- snapshot and replay of table clicks for Notebook v1 ([1a87dbf](https://github.com/IBM/kui/commit/1a87dbf)), closes [#5821](https://github.com/IBM/kui/issues/5821)
- **plugins/plugin-kubectl:** Update list-resources notebook to use splits ([1f54515](https://github.com/IBM/kui/commit/1f54515)), closes [#5770](https://github.com/IBM/kui/issues/5770)
- snapshot command throws errors when capturing watch responses ([600f049](https://github.com/IBM/kui/commit/600f049)), closes [#5452](https://github.com/IBM/kui/issues/5452)
- TopNavSidecar tabs should auto-pause and auto-focus when switching ([2b00dd9](https://github.com/IBM/kui/commit/2b00dd9)), closes [#4741](https://github.com/IBM/kui/issues/4741) [#4748](https://github.com/IBM/kui/issues/4748)
- vfs fixes for multi-source copying and for s3 globbing ([893902e](https://github.com/IBM/kui/commit/893902e)), closes [#5511](https://github.com/IBM/kui/issues/5511)
- **plugin-kubectl:** k get pods --all-namespaces has a title with "default" as the namespace ([2f95129](https://github.com/IBM/kui/commit/2f95129)), closes [#4466](https://github.com/IBM/kui/issues/4466)
- **plugin-kubectl:** kubectl get error-type -w doesn't fail fast ([4ccb733](https://github.com/IBM/kui/commit/4ccb733)), closes [#4491](https://github.com/IBM/kui/issues/4491)
- **plugins/plugin-client-common:** for now, switch interval chart to duration chart ([ea21221](https://github.com/IBM/kui/commit/ea21221)), closes [#5340](https://github.com/IBM/kui/issues/5340)
- **plugins/plugin-client-common:** Grid regression: grid colors not right ([d1aa46d](https://github.com/IBM/kui/commit/d1aa46d)), closes [#5285](https://github.com/IBM/kui/issues/5285)
- **plugins/plugin-client-common:** kubectl watch is broken for server versions >= 1.17 ([2d595b7](https://github.com/IBM/kui/commit/2d595b7)), closes [#5360](https://github.com/IBM/kui/issues/5360)
- **plugins/plugin-kubectl:** `oc get namespaces` doesn't produce a RadioTable ([6ea6131](https://github.com/IBM/kui/commit/6ea6131)), closes [#5227](https://github.com/IBM/kui/issues/5227)
- **plugins/plugin-kubectl:** add missing test for get with not found ([3e77689](https://github.com/IBM/kui/commit/3e77689)), closes [#4492](https://github.com/IBM/kui/issues/4492)
- **plugins/plugin-kubectl:** add Summary impl for kubernetes Jobs ([b0f3809](https://github.com/IBM/kui/commit/b0f3809)), closes [#5481](https://github.com/IBM/kui/issues/5481)
- **plugins/plugin-kubectl:** add traffic light colors for OOMKilled and UnexpectedAdmissionError ([4262409](https://github.com/IBM/kui/commit/4262409)), closes [#5345](https://github.com/IBM/kui/issues/5345)
- **plugins/plugin-kubectl:** automatically abort idle PTYs ([2638a65](https://github.com/IBM/kui/commit/2638a65)), closes [#4742](https://github.com/IBM/kui/issues/4742)
- **plugins/plugin-kubectl:** cache kind canonicalization lookup ([e351a5f](https://github.com/IBM/kui/commit/e351a5f)), closes [#4489](https://github.com/IBM/kui/issues/4489)
- **plugins/plugin-kubectl:** certain filepath options to kubectl were not tilde-expanded ([9e7f858](https://github.com/IBM/kui/commit/9e7f858)), closes [#5415](https://github.com/IBM/kui/issues/5415)
- **plugins/plugin-kubectl:** drilldown command of resources in watch --all-namespace table doesn't have '-o yaml' ([1e4f558](https://github.com/IBM/kui/commit/1e4f558)), closes [#5208](https://github.com/IBM/kui/issues/5208)
- **plugins/plugin-kubectl:** ExecIntoPod's terminal is not theme-aligned ([067cda3](https://github.com/IBM/kui/commit/067cda3)), closes [#4722](https://github.com/IBM/kui/issues/4722)
- **plugins/plugin-kubectl:** Fail should be TrafficLight.Red and Succeeded should be TrafficLight.Green ([54737b6](https://github.com/IBM/kui/commit/54737b6)), closes [#5351](https://github.com/IBM/kui/issues/5351)
- **plugins/plugin-kubectl:** header-only tables improperly parsed ([f56841b](https://github.com/IBM/kui/commit/f56841b)), closes [#5382](https://github.com/IBM/kui/issues/5382)
- **plugins/plugin-kubectl:** i18n for No log data message ([589a4cd](https://github.com/IBM/kui/commit/589a4cd)), closes [#4656](https://github.com/IBM/kui/issues/4656)
- **plugins/plugin-kubectl:** ImagePullBackoff should be considered a "red" state ([198100d](https://github.com/IBM/kui/commit/198100d)), closes [#4734](https://github.com/IBM/kui/issues/4734)
- **plugins/plugin-kubectl:** kubectl get -f can show undefined in table title ([eb34d1c](https://github.com/IBM/kui/commit/eb34d1c)), closes [#5469](https://github.com/IBM/kui/issues/5469)
- **plugins/plugin-kubectl:** kubectl Logs/Events/Terminal tabs do not reflow on sidecar maximize ([6dbcbe8](https://github.com/IBM/kui/commit/6dbcbe8)), closes [#5417](https://github.com/IBM/kui/issues/5417)
- **plugins/plugin-kubectl:** kubectl tab completion does not let me tab-complete some filepaths ([e42daa7](https://github.com/IBM/kui/commit/e42daa7)), closes [#5413](https://github.com/IBM/kui/issues/5413)
- **plugins/plugin-kubectl:** Kui may invoke kubectl with duplicate command line options ([39c9d31](https://github.com/IBM/kui/commit/39c9d31)), closes [#5330](https://github.com/IBM/kui/issues/5330)
- **plugins/plugin-kubectl:** leftover debug printfs in table-watch ([407855a](https://github.com/IBM/kui/commit/407855a)), closes [#5317](https://github.com/IBM/kui/issues/5317)
- **plugins/plugin-kubectl:** wordsmithing to list-resources notebook ([7255a98](https://github.com/IBM/kui/commit/7255a98)), closes [#5504](https://github.com/IBM/kui/issues/5504)
- JS console may contain xtermjs error messages when sidecar is minimized ([a568528](https://github.com/IBM/kui/commit/a568528)), closes [#5454](https://github.com/IBM/kui/issues/5454)
- kubectl Logs tab should use an xterm ([9aa0176](https://github.com/IBM/kui/commit/9aa0176)), closes [#4750](https://github.com/IBM/kui/issues/4750) [#4747](https://github.com/IBM/kui/issues/4747)
- snapshot command fails at `k get -o yaml` ([fe53fb0](https://github.com/IBM/kui/commit/fe53fb0)), closes [#5458](https://github.com/IBM/kui/issues/5458)
- **plugins/plugin-kubectl:** auto-pause logs when user scrolls ([94b85e6](https://github.com/IBM/kui/commit/94b85e6)), closes [#4668](https://github.com/IBM/kui/issues/4668)
- **plugins/plugin-kubectl:** helm help parsed usage incorrectly ([b222da2](https://github.com/IBM/kui/commit/b222da2)), closes [#4692](https://github.com/IBM/kui/issues/4692)
- **plugins/plugin-kubectl:** improve kubectl tab completion ([734f9e5](https://github.com/IBM/kui/commit/734f9e5)), closes [#4704](https://github.com/IBM/kui/issues/4704)
- **plugins/plugin-kubectl:** improve kubectl top node display with open sidecar ([6f99581](https://github.com/IBM/kui/commit/6f99581)), closes [#4737](https://github.com/IBM/kui/issues/4737)
- **plugins/plugin-kubectl:** k edit deploy has mysterious Pod tab ([914df36](https://github.com/IBM/kui/commit/914df36)), closes [#4703](https://github.com/IBM/kui/issues/4703)
- **plugins/plugin-kubectl:** kubectl api-resources table should hide APIGROUP column with open sidecar ([ee347fa](https://github.com/IBM/kui/commit/ee347fa)), closes [#4728](https://github.com/IBM/kui/issues/4728)
- **plugins/plugin-kubectl:** kubectl watcher needs to pass through kubeconfig in its call to kubectl version ([a5d83a3](https://github.com/IBM/kui/commit/a5d83a3)), closes [#5368](https://github.com/IBM/kui/issues/5368)
- **plugins/plugin-kubectl:** Pod summary impl fails for pods with no containerStatuses ([66b21b5](https://github.com/IBM/kui/commit/66b21b5)), closes [#5192](https://github.com/IBM/kui/issues/5192)
- (plugins/plugin-kubectl): kubectl get pod -w --all-namespaces behaves oddly ([12e578a](https://github.com/IBM/kui/commit/12e578a)), closes [#5169](https://github.com/IBM/kui/issues/5169)
- **plugins/plugin-client-common:** improve display of empty watch tables ([4cc16be](https://github.com/IBM/kui/commit/4cc16be)), closes [#5176](https://github.com/IBM/kui/issues/5176)
- **plugins/plugin-client-common:** make Close a top-level button in watch panes ([3c14da5](https://github.com/IBM/kui/commit/3c14da5)), closes [#4945](https://github.com/IBM/kui/issues/4945)
- **plugins/plugin-kubectl:** changing ns via oc does not update ns widget, in browser clients ([5eaa625](https://github.com/IBM/kui/commit/5eaa625)), closes [#4953](https://github.com/IBM/kui/issues/4953)
- **plugins/plugin-kubectl:** CurrentNamespace/Context widgets not live ([93ac829](https://github.com/IBM/kui/commit/93ac829)), closes [#5144](https://github.com/IBM/kui/issues/5144)
- **plugins/plugin-kubectl:** event footer watching should also support named resources ([e3a842b](https://github.com/IBM/kui/commit/e3a842b)), closes [#5180](https://github.com/IBM/kui/issues/5180)
- **plugins/plugin-kubectl:** get-namespace table sometimes doens't show the correct selected namespace ([af66aa4](https://github.com/IBM/kui/commit/af66aa4)), closes [#4812](https://github.com/IBM/kui/issues/4812)
- **plugins/plugin-kubectl:** kubectl apply -f may not abort the event watcher ([c8df222](https://github.com/IBM/kui/commit/c8df222)), closes [#5149](https://github.com/IBM/kui/issues/5149)
- **plugins/plugin-kubectl:** kubectl apply set-last-applied does not work ([9553907](https://github.com/IBM/kui/commit/9553907)), closes [#4844](https://github.com/IBM/kui/issues/4844)
- **plugins/plugin-kubectl:** kubectl apply/create/delete tables still have ALLCAPS headers ([90d72ce](https://github.com/IBM/kui/commit/90d72ce)), closes [#5068](https://github.com/IBM/kui/issues/5068)
- **plugins/plugin-kubectl:** kubectl explain subfields ([8fee2bc](https://github.com/IBM/kui/commit/8fee2bc)), closes [#4921](https://github.com/IBM/kui/issues/4921)
- **plugins/plugin-kubectl:** kubectl logs -l with no matches yields internal error ([ed0374f](https://github.com/IBM/kui/commit/ed0374f)), closes [#4811](https://github.com/IBM/kui/issues/4811)
- **plugins/plugin-kubectl:** Logs tab should have a default tail limit ([d4cf08c](https://github.com/IBM/kui/commit/d4cf08c)), closes [#4810](https://github.com/IBM/kui/issues/4810) [#4818](https://github.com/IBM/kui/issues/4818)
- **plugins/plugin-kubectl:** nil and negative timestamps display as "0ms ago" ([641a599](https://github.com/IBM/kui/commit/641a599)), closes [#5136](https://github.com/IBM/kui/issues/5136)
- **plugins/plugin-kubectl:** oc get ns does not present a RadioTable ([9e28eec](https://github.com/IBM/kui/commit/9e28eec)), closes [#5106](https://github.com/IBM/kui/issues/5106)
- CurrentContext and CurrentNamespace widgets may have stale data inBrowser ([ab77c20](https://github.com/IBM/kui/commit/ab77c20)), closes [#5097](https://github.com/IBM/kui/issues/5097)
- multiple issues with tab switching versus status stripe widgets ([8c8a6ec](https://github.com/IBM/kui/commit/8c8a6ec)), closes [#5101](https://github.com/IBM/kui/issues/5101)
- **plugins/plugin-kubectl:** oc get projects does not allow user selection ([3749371](https://github.com/IBM/kui/commit/3749371)), closes [#4805](https://github.com/IBM/kui/issues/4805)
- **plugins/plugin-kubectl:** oc logs does not work ([f0808a2](https://github.com/IBM/kui/commit/f0808a2)), closes [#4965](https://github.com/IBM/kui/issues/4965)
- **plugins/plugin-kubectl:** singleton breadcrumbs in kubectl help should not be clickable ([7815464](https://github.com/IBM/kui/commit/7815464)), closes [#4961](https://github.com/IBM/kui/issues/4961)
- **plugins/plugin-kubectl:** tolerate helm 3.0 and 3.1 help custom ascii art tables ([79f8640](https://github.com/IBM/kui/commit/79f8640)), closes [#5085](https://github.com/IBM/kui/issues/5085)
- allow user to disable table title by feature flags, and disable table pagination ([5450512](https://github.com/IBM/kui/commit/5450512)), closes [#4640](https://github.com/IBM/kui/issues/4640) [#4655](https://github.com/IBM/kui/issues/4655)
- avoid hard-coded use of /tmp in kubectl edit ([8e4cb70](https://github.com/IBM/kui/commit/8e4cb70)), closes [#4928](https://github.com/IBM/kui/issues/4928)
- avoid using kui-custom command for switching kubectl namespace ([43863f2](https://github.com/IBM/kui/commit/43863f2)), closes [#4806](https://github.com/IBM/kui/issues/4806)
- don't blink yellow forever for kubectl events ([a59ee86](https://github.com/IBM/kui/commit/a59ee86)), closes [#4869](https://github.com/IBM/kui/issues/4869)
- eliminate assumptions that "default" is the default kube namespace ([4eb392d](https://github.com/IBM/kui/commit/4eb392d)), closes [#4764](https://github.com/IBM/kui/issues/4764)
- empty watch tables/grids should show 'No resources' ([c0bfe99](https://github.com/IBM/kui/commit/c0bfe99)), closes [#4884](https://github.com/IBM/kui/issues/4884)
- improve hover effect for status stripe buttons ([50ced8f](https://github.com/IBM/kui/commit/50ced8f)), closes [#4896](https://github.com/IBM/kui/issues/4896)
- Input element throws react error ([e6bb21b](https://github.com/IBM/kui/commit/e6bb21b)), closes [#4765](https://github.com/IBM/kui/issues/4765)
- kubectl edit apply twice does not work ([1976134](https://github.com/IBM/kui/commit/1976134)), closes [#4797](https://github.com/IBM/kui/issues/4797)
- kubectl help misformats helm help tables ([ff36755](https://github.com/IBM/kui/commit/ff36755)), closes [#5080](https://github.com/IBM/kui/issues/5080)
- pexecs serviced by now-removed splits fail ([f6176a1](https://github.com/IBM/kui/commit/f6176a1)), closes [#4875](https://github.com/IBM/kui/issues/4875)
- reduce custom CSS rules for table UI ([56f69cb](https://github.com/IBM/kui/commit/56f69cb)), closes [#5024](https://github.com/IBM/kui/issues/5024)
- xterm alt buffer mode behaves oddly for clients that do not enable splitTerminals ([f1bc709](https://github.com/IBM/kui/commit/f1bc709)), closes [#5003](https://github.com/IBM/kui/issues/5003)
- **plugins/plugin-kubectl:** kubectl apply edit-last-applied freezes in kui ([24a67da](https://github.com/IBM/kui/commit/24a67da)), closes [#4808](https://github.com/IBM/kui/issues/4808)
- **plugins/plugin-kubectl:** kubectl watch tables may lack namespace breadcrumb ([a0616c2](https://github.com/IBM/kui/commit/a0616c2)), closes [#4870](https://github.com/IBM/kui/issues/4870)
- **plugins/plugin-kubectl:** status shows as Containercreating when it should be ContainerCreating ([2c4a3b6](https://github.com/IBM/kui/commit/2c4a3b6)), closes [#4798](https://github.com/IBM/kui/issues/4798)
- **plugins/plugin-kubectl:** windows powershell fails to get default namespace ([a5fb2e1](https://github.com/IBM/kui/commit/a5fb2e1)), closes [#4912](https://github.com/IBM/kui/issues/4912)
- kubectl top node should show % text ([f861b76](https://github.com/IBM/kui/commit/f861b76)), closes [#4598](https://github.com/IBM/kui/issues/4598)
- place namespace breadcrumb first ([5d3b2e4](https://github.com/IBM/kui/commit/5d3b2e4)), closes [#4699](https://github.com/IBM/kui/issues/4699)
- remove augmentModuleLoadPath API ([47dfcdf](https://github.com/IBM/kui/commit/47dfcdf)), closes [#4839](https://github.com/IBM/kui/issues/4839)
- sidecar toolbar can't due justice to longer error messages ([e67e0c9](https://github.com/IBM/kui/commit/e67e0c9)), closes [#4789](https://github.com/IBM/kui/issues/4789)
- summary tab is not read-only for kubectl edit command ([9f7ff82](https://github.com/IBM/kui/commit/9f7ff82)), closes [#4809](https://github.com/IBM/kui/issues/4809)
- **plugins/plugin-kubectl:** Terminal tab test incorrectly verifies k exec output ([20ab362](https://github.com/IBM/kui/commit/20ab362)), closes [#4802](https://github.com/IBM/kui/issues/4802)
- the Logs/Terminal retry button should be visible on any exit code ([3366327](https://github.com/IBM/kui/commit/3366327)), closes [#4769](https://github.com/IBM/kui/issues/4769)
- **plugins/plugin-kubectl:** k get events -w bombs ([20c2caf](https://github.com/IBM/kui/commit/20c2caf)), closes [#4557](https://github.com/IBM/kui/issues/4557)
- **plugins/plugin-kubectl:** kubectl create secret hangs yellow ([e11dbb8](https://github.com/IBM/kui/commit/e11dbb8)), closes [#4571](https://github.com/IBM/kui/issues/4571)
- **plugins/plugin-kubectl:** kubectl describe -h has old bold text ([b31d066](https://github.com/IBM/kui/commit/b31d066)), closes [#4568](https://github.com/IBM/kui/issues/4568)
- **plugins/plugin-kubectl:** kubectl edit should support editing a list of resources ([4cd4d43](https://github.com/IBM/kui/commit/4cd4d43)), closes [#4555](https://github.com/IBM/kui/issues/4555)
- **plugins/plugin-kubectl:** remove kubectl edit cancel button ([83179e8](https://github.com/IBM/kui/commit/83179e8)), closes [#4695](https://github.com/IBM/kui/issues/4695)
- avoid recomputing tabs when switching back and forth ([cf5e41f](https://github.com/IBM/kui/commit/cf5e41f)), closes [#4666](https://github.com/IBM/kui/issues/4666)
- container filter of logs tab shows accumulated logs from previous selection ([08903b4](https://github.com/IBM/kui/commit/08903b4)), closes [#4644](https://github.com/IBM/kui/issues/4644) [#4658](https://github.com/IBM/kui/issues/4658)
- logs tab toolbar doesn't signify when pods are 404 ([135e1be](https://github.com/IBM/kui/commit/135e1be)), closes [#4646](https://github.com/IBM/kui/issues/4646)
- **plugins/plugin-kubectl:** inconsistent capitalization of breadcrumbs ([963b166](https://github.com/IBM/kui/commit/963b166)), closes [#4607](https://github.com/IBM/kui/issues/4607)
- **plugins/plugin-kubectl:** k edit -h does not open in sidecar ([b6f68f8](https://github.com/IBM/kui/commit/b6f68f8)), closes [#4661](https://github.com/IBM/kui/issues/4661)
- **plugins/plugin-kubectl:** kubectl logs tab has bad interleaving and cpu issues ([1c7cf17](https://github.com/IBM/kui/commit/1c7cf17)), closes [#4664](https://github.com/IBM/kui/issues/4664) [#4665](https://github.com/IBM/kui/issues/4665)
- clicking on container name in details sidecar should add -c to logs command ([61c7c08](https://github.com/IBM/kui/commit/61c7c08)), closes [#4498](https://github.com/IBM/kui/issues/4498)
- improve error reporting for kubectl apply ([fe21671](https://github.com/IBM/kui/commit/fe21671)), closes [#4605](https://github.com/IBM/kui/issues/4605)
- kubectl api-resources has duplicate rows and odd pagination behavior ([e740270](https://github.com/IBM/kui/commit/e740270)), closes [#4626](https://github.com/IBM/kui/issues/4626)
- **plugins/plugin-kubectl:** kubectl get table with mix of existing and non-existing ([8d98d15](https://github.com/IBM/kui/commit/8d98d15)), closes [#4492](https://github.com/IBM/kui/issues/4492)
- **plugins/plugin-kubectl:** kubectl Show Events query not precise enough ([eda6b38](https://github.com/IBM/kui/commit/eda6b38)), closes [#4572](https://github.com/IBM/kui/issues/4572)
- **plugins/plugin-kubectl:** remove Conditions tab ([eac3705](https://github.com/IBM/kui/commit/eac3705)), closes [#4606](https://github.com/IBM/kui/issues/4606)
- reduce No log data followed by log data behavior in kube logs ([e1c0624](https://github.com/IBM/kui/commit/e1c0624)), closes [#4624](https://github.com/IBM/kui/issues/4624)
- sidecar views do not respect tab-specificity ([5a1cae2](https://github.com/IBM/kui/commit/5a1cae2)), closes [#4362](https://github.com/IBM/kui/issues/4362)
- **plugins/plugin-kubectl:** CurrentContext widget shows "default" for openshift clusters ([59712c0](https://github.com/IBM/kui/commit/59712c0)), closes [#4347](https://github.com/IBM/kui/issues/4347)
- **plugins/plugin-kubectl:** remove Show Logs registration ([382c685](https://github.com/IBM/kui/commit/382c685)), closes [#4603](https://github.com/IBM/kui/issues/4603)
- add support for hiding elements at higher zoom levels ([7d2a7e0](https://github.com/IBM/kui/commit/7d2a7e0)), closes [#4232](https://github.com/IBM/kui/issues/4232)
- eliminate complex nesting of NavResponse model ([e849ae7](https://github.com/IBM/kui/commit/e849ae7)), closes [#4205](https://github.com/IBM/kui/issues/4205)
- ibmcloud plugin list does not list unofficial plugins ([303fa00](https://github.com/IBM/kui/commit/303fa00)), closes [#4339](https://github.com/IBM/kui/issues/4339)
- make inBrowserOk the default ([2a3c811](https://github.com/IBM/kui/commit/2a3c811)), closes [#4275](https://github.com/IBM/kui/issues/4275)
- multiple kubectl help/usage bugs ([ebba36e](https://github.com/IBM/kui/commit/ebba36e)), closes [#4342](https://github.com/IBM/kui/issues/4342)
- replace Containers with Logs tab ([00e8786](https://github.com/IBM/kui/commit/00e8786)), closes [#4603](https://github.com/IBM/kui/issues/4603)
- **plugins/plugin-kubectl:** avoid use of /s regexp ([9468304](https://github.com/IBM/kui/commit/9468304)), closes [#4259](https://github.com/IBM/kui/issues/4259)
- **plugins/plugin-kubectl:** ensure Show Owner button appears near end of toolbar buttons ([224c586](https://github.com/IBM/kui/commit/224c586)), closes [#4124](https://github.com/IBM/kui/issues/4124)
- **plugins/plugin-kubectl:** firefox does not support the /s flag to RegExp ([5b661a6](https://github.com/IBM/kui/commit/5b661a6)), closes [#4206](https://github.com/IBM/kui/issues/4206)
- **plugins/plugin-kubectl:** in kube namespace table, selected namespace should float to top ([f0e597f](https://github.com/IBM/kui/commit/f0e597f)), closes [#4129](https://github.com/IBM/kui/issues/4129)
- **plugins/plugin-kubectl:** kubectl api-resources table shows 'unknown' in title ([0461710](https://github.com/IBM/kui/commit/0461710)), closes [#4145](https://github.com/IBM/kui/issues/4145)
- **plugins/plugin-kubectl:** kubectl describe (--help) fails ([10b8e8a](https://github.com/IBM/kui/commit/10b8e8a)), closes [#4012](https://github.com/IBM/kui/issues/4012)
- **plugins/plugin-kubectl:** kubectl explain -h should render as usage in sidecar ([8e00c3f](https://github.com/IBM/kui/commit/8e00c3f)), closes [#4211](https://github.com/IBM/kui/issues/4211)
- **plugins/plugin-kubectl:** kubectl explain Overview tab not formatted as expected ([ffa9183](https://github.com/IBM/kui/commit/ffa9183)), closes [#4304](https://github.com/IBM/kui/issues/4304)
- **plugins/plugin-kubectl:** kubectl get --all-namespaces --watch does not update ([663a972](https://github.com/IBM/kui/commit/663a972)), closes [#4581](https://github.com/IBM/kui/issues/4581)
- **plugins/plugin-kubectl:** kubectl top nodes can present "NaN" ([30df3dd](https://github.com/IBM/kui/commit/30df3dd)), closes [#4189](https://github.com/IBM/kui/issues/4189)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- **plugins/plugin-kubectl:** more refinements to Form layout heuristics ([e92327d](https://github.com/IBM/kui/commit/e92327d)), closes [#4118](https://github.com/IBM/kui/issues/4118)
- **plugins/plugin-kubectl:** oc describe fails ([4f4de4e](https://github.com/IBM/kui/commit/4f4de4e)), closes [#4008](https://github.com/IBM/kui/issues/4008)
- **plugins/plugin-kubectl:** revert to editor-based Summary tab ([3ecd638](https://github.com/IBM/kui/commit/3ecd638)), closes [#4594](https://github.com/IBM/kui/issues/4594)
- **plugins/plugin-kubectl:** update deprecated import of uuid ([5de8d4d](https://github.com/IBM/kui/commit/5de8d4d)), closes [#4316](https://github.com/IBM/kui/issues/4316)
- **plugins/plugin-kubectl:** we shouldn't render namespace widget when the namespace is empty in kube config ([98a9406](https://github.com/IBM/kui/commit/98a9406)), closes [#4274](https://github.com/IBM/kui/issues/4274)
- ensure kubectl Delete toolbar button appears at far right ([9eb3079](https://github.com/IBM/kui/commit/9eb3079)), closes [#4116](https://github.com/IBM/kui/issues/4116)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- kubectl summary Form TextInputs can be cropped ([3becaf9](https://github.com/IBM/kui/commit/3becaf9)), closes [#4077](https://github.com/IBM/kui/issues/4077)
- multiple tab completion bugs ([5513712](https://github.com/IBM/kui/commit/5513712)), closes [#4281](https://github.com/IBM/kui/issues/4281)
- optimize kubectl watch load on apiserver ([3f7a32f](https://github.com/IBM/kui/commit/3f7a32f)), closes [#4494](https://github.com/IBM/kui/issues/4494)
- PaginatedTable fails at distinguishing the rowKeys of `k get --all-namespaces` table ([6658729](https://github.com/IBM/kui/commit/6658729)), closes [#4579](https://github.com/IBM/kui/issues/4579)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- tekton Step nodes show with hashed background ([8428d72](https://github.com/IBM/kui/commit/8428d72)), closes [#4114](https://github.com/IBM/kui/issues/4114)
- the colors of status badges: Error, ImagePullBackOff and ErrImagePull are incorrect ([fd206f6](https://github.com/IBM/kui/commit/fd206f6)), closes [#4171](https://github.com/IBM/kui/issues/4171)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- **plugins/plugin-kubectl:** watch table doesn't have breadcrumbs title ([43fbe6a](https://github.com/IBM/kui/commit/43fbe6a)), closes [#4135](https://github.com/IBM/kui/issues/4135)
- **plugins/plugin-kubectl:** watcher table disappears when kui is launched as kubectl plugin ([167eabc](https://github.com/IBM/kui/commit/167eabc)), closes [#4120](https://github.com/IBM/kui/issues/4120) [#4123](https://github.com/IBM/kui/issues/4123)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- TopNavSidecar does not always show updates ([251e5c4](https://github.com/IBM/kui/commit/251e5c4)), closes [#4524](https://github.com/IBM/kui/issues/4524)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)

### Features

- **plugins/plugin-kubectl:** Namespace Summary impl ([2d69d67](https://github.com/IBM/kui/commit/2d69d67)), closes [#5790](https://github.com/IBM/kui/issues/5790)
- add a prefer-re-execution option to snapshot ([af7b98b](https://github.com/IBM/kui/commit/af7b98b)), closes [#5622](https://github.com/IBM/kui/issues/5622)
- **packages/core:** allow controller to opt in/out recording table row onclicks when snapshot ([cc83ce7](https://github.com/IBM/kui/commit/cc83ce7)), closes [#5565](https://github.com/IBM/kui/issues/5565)
- add capability to show welcome widget to new users in Terminal ([0c33e6e](https://github.com/IBM/kui/commit/0c33e6e)), closes [#4990](https://github.com/IBM/kui/issues/4990) [#5007](https://github.com/IBM/kui/issues/5007)
- add Retry button to sidecar toolbar when log streaming stopped abnormally ([47872f4](https://github.com/IBM/kui/commit/47872f4)), closes [#4755](https://github.com/IBM/kui/issues/4755)
- allow controllers to control the color of the status stripe ([708570c](https://github.com/IBM/kui/commit/708570c)), closes [#5490](https://github.com/IBM/kui/issues/5490)
- allow for limiting the number of kubectl table rows ([62588f2](https://github.com/IBM/kui/commit/62588f2)), closes [#5358](https://github.com/IBM/kui/issues/5358)
- background new tabs ([be9f986](https://github.com/IBM/kui/commit/be9f986)), closes [#5550](https://github.com/IBM/kui/issues/5550)
- clicking on events in watch table should drill down to events ([c6dc99f](https://github.com/IBM/kui/commit/c6dc99f)), closes [#5173](https://github.com/IBM/kui/issues/5173)
- cold start delays ([83abd14](https://github.com/IBM/kui/commit/83abd14)), closes [#5356](https://github.com/IBM/kui/issues/5356)
- custom tab titles ([fd780df](https://github.com/IBM/kui/commit/fd780df)), closes [#5525](https://github.com/IBM/kui/issues/5525)
- generalized kuberctl get with limit ([d40ee07](https://github.com/IBM/kui/commit/d40ee07)), closes [#5361](https://github.com/IBM/kui/issues/5361)
- initial popeye support ([9d62eeb](https://github.com/IBM/kui/commit/9d62eeb)), closes [#5265](https://github.com/IBM/kui/issues/5265)
- initial support for capturing input files and showing them in the UI ([5744bf4](https://github.com/IBM/kui/commit/5744bf4)), closes [#5513](https://github.com/IBM/kui/issues/5513)
- MiniSplits ([70b8441](https://github.com/IBM/kui/commit/70b8441)), closes [#5112](https://github.com/IBM/kui/issues/5112)
- notebook client ([4b64133](https://github.com/IBM/kui/commit/4b64133)), closes [#5501](https://github.com/IBM/kui/issues/5501)
- **plugins/plugin-client-common:** improved SequenceDiagram view ([1e2fb41](https://github.com/IBM/kui/commit/1e2fb41)), closes [#5342](https://github.com/IBM/kui/issues/5342)
- **plugins/plugin-git:** git branch should respond with RadioTable ([59a9213](https://github.com/IBM/kui/commit/59a9213)), closes [#5256](https://github.com/IBM/kui/issues/5256)
- **plugins/plugin-ibmcloud:** initial CodeEngine support ([677faca](https://github.com/IBM/kui/commit/677faca)), closes [#5302](https://github.com/IBM/kui/issues/5302) [#5303](https://github.com/IBM/kui/issues/5303)
- **plugins/plugin-kubectl:** add status column to kube deployment table ([1d35040](https://github.com/IBM/kui/commit/1d35040)), closes [#5476](https://github.com/IBM/kui/issues/5476)
- **plugins/plugin-kubectl:** initial `kubectl job list` improvement for visualizing Job execution ([06030b0](https://github.com/IBM/kui/commit/06030b0)), closes [#5397](https://github.com/IBM/kui/issues/5397)
- **plugins/plugin-kubectl:** initial labs for listing k8s resources and creating jobs ([2e9d002](https://github.com/IBM/kui/commit/2e9d002)), closes [#5475](https://github.com/IBM/kui/issues/5475)
- improve kubectl edit experience ([4c4a1c9](https://github.com/IBM/kui/commit/4c4a1c9)), closes [#4783](https://github.com/IBM/kui/issues/4783)
- improve rendering of kubectl subcommand help ([e36ed29](https://github.com/IBM/kui/commit/e36ed29)), closes [#4824](https://github.com/IBM/kui/issues/4824)
- initial typeahead for commands ([7ba313a](https://github.com/IBM/kui/commit/7ba313a)), closes [#5437](https://github.com/IBM/kui/issues/5437)
- kubectl apply view-last-applied ([6d601ef](https://github.com/IBM/kui/commit/6d601ef)), closes [#4822](https://github.com/IBM/kui/issues/4822)
- line highlights on editor save, used for k edit apply errors ([3efa6a5](https://github.com/IBM/kui/commit/3efa6a5)), closes [#4795](https://github.com/IBM/kui/issues/4795)
- pin a watchable terminal response in a split pane ([662f413](https://github.com/IBM/kui/commit/662f413)), closes [#4865](https://github.com/IBM/kui/issues/4865) [#4573](https://github.com/IBM/kui/issues/4573) [#4885](https://github.com/IBM/kui/issues/4885) [#4894](https://github.com/IBM/kui/issues/4894)
- refine kubectl contexts table; add support for RadioTable row titles ([11bb074](https://github.com/IBM/kui/commit/11bb074)), closes [#5131](https://github.com/IBM/kui/issues/5131)
- s3 plugin, and vfs ([970ba6e](https://github.com/IBM/kui/commit/970ba6e)), closes [#5319](https://github.com/IBM/kui/issues/5319)
- show resource version in toolbar text ([1a6e335](https://github.com/IBM/kui/commit/1a6e335)), closes [#4790](https://github.com/IBM/kui/issues/4790)
- split screen Terminal ([3a6b422](https://github.com/IBM/kui/commit/3a6b422)), closes [#4814](https://github.com/IBM/kui/issues/4814) [#4821](https://github.com/IBM/kui/issues/4821)
- support for events in crud table footer ([0b90ead](https://github.com/IBM/kui/commit/0b90ead)), closes [#5125](https://github.com/IBM/kui/issues/5125)
- support for events in table footer ([51669af](https://github.com/IBM/kui/commit/51669af)), closes [#5115](https://github.com/IBM/kui/issues/5115)
- tutorial VFS ([6f2330e](https://github.com/IBM/kui/commit/6f2330e)), closes [#5441](https://github.com/IBM/kui/issues/5441)
- **plugins/plugin-kubectl:** kubectl events tab ([2d71f24](https://github.com/IBM/kui/commit/2d71f24)), closes [#4706](https://github.com/IBM/kui/issues/4706)
- **plugins/plugin-kubectl:** namespace onclick should drill down to sidecar ([e74f66d](https://github.com/IBM/kui/commit/e74f66d)), closes [#4714](https://github.com/IBM/kui/issues/4714)
- **plugins/plugin-kubectl:** optimize rendering of kubectl Summary tab ([7c6480d](https://github.com/IBM/kui/commit/7c6480d)), closes [#4725](https://github.com/IBM/kui/issues/4725)
- **plugins/plugin-kubectl:** optimizing Node summary impl ([8ac11b9](https://github.com/IBM/kui/commit/8ac11b9)), closes [#4833](https://github.com/IBM/kui/issues/4833)
- **plugins/plugin-kubectl:** Show Previous option for Logs tab ([2307d2f](https://github.com/IBM/kui/commit/2307d2f)), closes [#4864](https://github.com/IBM/kui/issues/4864)
- target kubectl logs and kubectl exec to Logs and Terminal tabs ([409e632](https://github.com/IBM/kui/commit/409e632)), closes [#4762](https://github.com/IBM/kui/issues/4762)
- **plugins/plugin-kubectl:** Terminal tab for Pod kubernetes resources ([c47e432](https://github.com/IBM/kui/commit/c47e432)), closes [#4639](https://github.com/IBM/kui/issues/4639)
- add button to WatchPane to show table back in terminal ([dc22591](https://github.com/IBM/kui/commit/dc22591)), closes [#4530](https://github.com/IBM/kui/issues/4530)
- add isSelected and Divider to log container selection menu ([59bdaa5](https://github.com/IBM/kui/commit/59bdaa5)), closes [#4647](https://github.com/IBM/kui/issues/4647)
- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Patternfly Breadcrumb support ([91e0504](https://github.com/IBM/kui/commit/91e0504)), closes [#4381](https://github.com/IBM/kui/issues/4381)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add Stop Watching capability to WatchPane ([09043c1](https://github.com/IBM/kui/commit/09043c1)), closes [#4554](https://github.com/IBM/kui/issues/4554)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- allow users to select container in kubectl Logs ([f4304c5](https://github.com/IBM/kui/commit/f4304c5)), closes [#4627](https://github.com/IBM/kui/issues/4627)
- commands should be able to separate resource model fetch from view transformation functions ([e903bc7](https://github.com/IBM/kui/commit/e903bc7)), closes [#4437](https://github.com/IBM/kui/issues/4437)
- ibmcloud plugin ([aa0f72f](https://github.com/IBM/kui/commit/aa0f72f)), closes [#4353](https://github.com/IBM/kui/issues/4353)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- initial odo catalog list enhancements ([8534267](https://github.com/IBM/kui/commit/8534267)), closes [#4485](https://github.com/IBM/kui/issues/4485)
- kubectl edit via kui's editor ([414e813](https://github.com/IBM/kui/commit/414e813)), closes [#762](https://github.com/IBM/kui/issues/762)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- only enable WatchPane based on a feature flag ([eb80d0e](https://github.com/IBM/kui/commit/eb80d0e)), closes [#4678](https://github.com/IBM/kui/issues/4678) [#4604](https://github.com/IBM/kui/issues/4604)
- patternfly4 themes ([5f58f71](https://github.com/IBM/kui/commit/5f58f71)), closes [#4364](https://github.com/IBM/kui/issues/4364)
- port kubectl get ns to RadioTable ([be0eabf](https://github.com/IBM/kui/commit/be0eabf)), closes [#4510](https://github.com/IBM/kui/issues/4510) [#4511](https://github.com/IBM/kui/issues/4511)
- simplified co-hosting of client and proxy in a container ([00af4b4](https://github.com/IBM/kui/commit/00af4b4)), closes [#4213](https://github.com/IBM/kui/issues/4213)
- top tab buttons ([ff8cfba](https://github.com/IBM/kui/commit/ff8cfba)), closes [#4434](https://github.com/IBM/kui/issues/4434)
- watcher panel for open-ended watch jobs ([6dfe7df](https://github.com/IBM/kui/commit/6dfe7df)), closes [#4503](https://github.com/IBM/kui/issues/4503)
- **plugins/plugin-kubectl:** add Show Node button for kubectl pods ([04e29d2](https://github.com/IBM/kui/commit/04e29d2)), closes [#4214](https://github.com/IBM/kui/issues/4214)
- **plugins/plugin-kubectl:** add support for kustomize apply/delete/create ([b95cbdb](https://github.com/IBM/kui/commit/b95cbdb)), closes [#4203](https://github.com/IBM/kui/issues/4203)
- **plugins/plugin-kubectl:** enhance odo project list as RadioTable ([62272e6](https://github.com/IBM/kui/commit/62272e6)), closes [#4517](https://github.com/IBM/kui/issues/4517)
- **plugins/plugin-kubectl:** improve odo usage experience ([639ca32](https://github.com/IBM/kui/commit/639ca32)), closes [#4345](https://github.com/IBM/kui/issues/4345)
- **plugins/plugin-kubectl:** port kubectl contexts table to RadioTable ([3cb4dcb](https://github.com/IBM/kui/commit/3cb4dcb)), closes [#4513](https://github.com/IBM/kui/issues/4513)
- SPI for icons ([3d034e3](https://github.com/IBM/kui/commit/3d034e3)), closes [#4441](https://github.com/IBM/kui/issues/4441) [#4364](https://github.com/IBM/kui/issues/4364)
- **plugins/plugin-kubectl:** configmap summary should show data ([50c7e10](https://github.com/IBM/kui/commit/50c7e10)), closes [#4025](https://github.com/IBM/kui/issues/4025)
- **plugins/plugin-kubectl:** ReplicaSet should have Pods tab ([42cd286](https://github.com/IBM/kui/commit/42cd286)), closes [#4110](https://github.com/IBM/kui/issues/4110)
- **plugins/plugin-kubectl:** restore Show Logs button for kubectl ([6b17dbd](https://github.com/IBM/kui/commit/6b17dbd)), closes [#4089](https://github.com/IBM/kui/issues/4089)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)

### BREAKING CHANGES

- removes support for inBrowserOk

# [8.12.0](https://github.com/IBM/kui/compare/v4.5.0...v8.12.0) (2020-08-20)

### Bug Fixes

- **plugins/plugin-client-common:** for now, switch interval chart to duration chart ([ea21221](https://github.com/IBM/kui/commit/ea21221)), closes [#5340](https://github.com/IBM/kui/issues/5340)
- **plugins/plugin-client-common:** Grid regression: grid colors not right ([d1aa46d](https://github.com/IBM/kui/commit/d1aa46d)), closes [#5285](https://github.com/IBM/kui/issues/5285)
- **plugins/plugin-client-common:** improve display of empty watch tables ([4cc16be](https://github.com/IBM/kui/commit/4cc16be)), closes [#5176](https://github.com/IBM/kui/issues/5176)
- **plugins/plugin-client-common:** kubectl watch is broken for server versions >= 1.17 ([2d595b7](https://github.com/IBM/kui/commit/2d595b7)), closes [#5360](https://github.com/IBM/kui/issues/5360)
- **plugins/plugin-client-common:** make Close a top-level button in watch panes ([3c14da5](https://github.com/IBM/kui/commit/3c14da5)), closes [#4945](https://github.com/IBM/kui/issues/4945)
- **plugins/plugin-kubectl:** `oc get namespaces` doesn't produce a RadioTable ([6ea6131](https://github.com/IBM/kui/commit/6ea6131)), closes [#5227](https://github.com/IBM/kui/issues/5227)
- **plugins/plugin-kubectl:** add traffic light colors for OOMKilled and UnexpectedAdmissionError ([4262409](https://github.com/IBM/kui/commit/4262409)), closes [#5345](https://github.com/IBM/kui/issues/5345)
- **plugins/plugin-kubectl:** changing ns via oc does not update ns widget, in browser clients ([5eaa625](https://github.com/IBM/kui/commit/5eaa625)), closes [#4953](https://github.com/IBM/kui/issues/4953)
- **plugins/plugin-kubectl:** CurrentNamespace/Context widgets not live ([93ac829](https://github.com/IBM/kui/commit/93ac829)), closes [#5144](https://github.com/IBM/kui/issues/5144)
- **plugins/plugin-kubectl:** drilldown command of resources in watch --all-namespace table doesn't have '-o yaml' ([1e4f558](https://github.com/IBM/kui/commit/1e4f558)), closes [#5208](https://github.com/IBM/kui/issues/5208)
- **plugins/plugin-kubectl:** event footer watching should also support named resources ([e3a842b](https://github.com/IBM/kui/commit/e3a842b)), closes [#5180](https://github.com/IBM/kui/issues/5180)
- **plugins/plugin-kubectl:** events in table appear to be in random order ([034dc06](https://github.com/IBM/kui/commit/034dc06)), closes [#5212](https://github.com/IBM/kui/issues/5212)
- **plugins/plugin-kubectl:** Fail should be TrafficLight.Red and Succeeded should be TrafficLight.Green ([54737b6](https://github.com/IBM/kui/commit/54737b6)), closes [#5351](https://github.com/IBM/kui/issues/5351)
- **plugins/plugin-kubectl:** header-only tables improperly parsed ([f56841b](https://github.com/IBM/kui/commit/f56841b)), closes [#5382](https://github.com/IBM/kui/issues/5382)
- **plugins/plugin-kubectl:** kubectl apply -f may not abort the event watcher ([c8df222](https://github.com/IBM/kui/commit/c8df222)), closes [#5149](https://github.com/IBM/kui/issues/5149)
- **plugins/plugin-kubectl:** kubectl apply/create/delete tables still have ALLCAPS headers ([90d72ce](https://github.com/IBM/kui/commit/90d72ce)), closes [#5068](https://github.com/IBM/kui/issues/5068)
- **plugins/plugin-kubectl:** kubectl explain subfields ([8fee2bc](https://github.com/IBM/kui/commit/8fee2bc)), closes [#4921](https://github.com/IBM/kui/issues/4921)
- **plugins/plugin-kubectl:** kubectl watcher needs to pass through kubeconfig in its call to kubectl version ([a5d83a3](https://github.com/IBM/kui/commit/a5d83a3)), closes [#5368](https://github.com/IBM/kui/issues/5368)
- **plugins/plugin-kubectl:** kubernetes contexts table renders poorly ([e2ed7d8](https://github.com/IBM/kui/commit/e2ed7d8)), closes [#5230](https://github.com/IBM/kui/issues/5230)
- **plugins/plugin-kubectl:** Kui may invoke kubectl with duplicate command line options ([39c9d31](https://github.com/IBM/kui/commit/39c9d31)), closes [#5330](https://github.com/IBM/kui/issues/5330)
- **plugins/plugin-kubectl:** leftover debug printfs in table-watch ([407855a](https://github.com/IBM/kui/commit/407855a)), closes [#5317](https://github.com/IBM/kui/issues/5317)
- **plugins/plugin-kubectl:** nil and negative timestamps display as "0ms ago" ([641a599](https://github.com/IBM/kui/commit/641a599)), closes [#5136](https://github.com/IBM/kui/issues/5136)
- **plugins/plugin-kubectl:** oc get ns does not present a RadioTable ([9e28eec](https://github.com/IBM/kui/commit/9e28eec)), closes [#5106](https://github.com/IBM/kui/issues/5106)
- **plugins/plugin-kubectl:** Pod summary impl fails for pods with no containerStatuses ([66b21b5](https://github.com/IBM/kui/commit/66b21b5)), closes [#5192](https://github.com/IBM/kui/issues/5192)
- (plugins/plugin-kubectl): kubectl get pod -w --all-namespaces behaves oddly ([12e578a](https://github.com/IBM/kui/commit/12e578a)), closes [#5169](https://github.com/IBM/kui/issues/5169)
- avoid hard-coded use of /tmp in kubectl edit ([8e4cb70](https://github.com/IBM/kui/commit/8e4cb70)), closes [#4928](https://github.com/IBM/kui/issues/4928)
- CurrentContext and CurrentNamespace widgets may have stale data inBrowser ([ab77c20](https://github.com/IBM/kui/commit/ab77c20)), closes [#5097](https://github.com/IBM/kui/issues/5097)
- empty watch tables/grids should show 'No resources' ([c0bfe99](https://github.com/IBM/kui/commit/c0bfe99)), closes [#4884](https://github.com/IBM/kui/issues/4884)
- multiple issues with tab switching versus status stripe widgets ([8c8a6ec](https://github.com/IBM/kui/commit/8c8a6ec)), closes [#5101](https://github.com/IBM/kui/issues/5101)
- **plugins/plugin-kubectl:** kubectl watch tables may lack namespace breadcrumb ([a0616c2](https://github.com/IBM/kui/commit/a0616c2)), closes [#4870](https://github.com/IBM/kui/issues/4870)
- **plugins/plugin-kubectl:** tolerate helm 3.0 and 3.1 help custom ascii art tables ([79f8640](https://github.com/IBM/kui/commit/79f8640)), closes [#5085](https://github.com/IBM/kui/issues/5085)
- don't blink yellow forever for kubectl events ([a59ee86](https://github.com/IBM/kui/commit/a59ee86)), closes [#4869](https://github.com/IBM/kui/issues/4869)
- improve hover effect for status stripe buttons ([50ced8f](https://github.com/IBM/kui/commit/50ced8f)), closes [#4896](https://github.com/IBM/kui/issues/4896)
- kubectl help misformats helm help tables ([ff36755](https://github.com/IBM/kui/commit/ff36755)), closes [#5080](https://github.com/IBM/kui/issues/5080)
- pexecs serviced by now-removed splits fail ([f6176a1](https://github.com/IBM/kui/commit/f6176a1)), closes [#4875](https://github.com/IBM/kui/issues/4875)
- reduce custom CSS rules for table UI ([56f69cb](https://github.com/IBM/kui/commit/56f69cb)), closes [#5024](https://github.com/IBM/kui/issues/5024)
- xterm alt buffer mode behaves oddly for clients that do not enable splitTerminals ([f1bc709](https://github.com/IBM/kui/commit/f1bc709)), closes [#5003](https://github.com/IBM/kui/issues/5003)
- **plugins/plugin-kubectl:** get-namespace table sometimes doens't show the correct selected namespace ([af66aa4](https://github.com/IBM/kui/commit/af66aa4)), closes [#4812](https://github.com/IBM/kui/issues/4812)
- **plugins/plugin-kubectl:** kubectl apply edit-last-applied freezes in kui ([24a67da](https://github.com/IBM/kui/commit/24a67da)), closes [#4808](https://github.com/IBM/kui/issues/4808)
- **plugins/plugin-kubectl:** kubectl apply set-last-applied does not work ([9553907](https://github.com/IBM/kui/commit/9553907)), closes [#4844](https://github.com/IBM/kui/issues/4844)
- **plugins/plugin-kubectl:** oc get projects does not allow user selection ([3749371](https://github.com/IBM/kui/commit/3749371)), closes [#4805](https://github.com/IBM/kui/issues/4805)
- **plugins/plugin-kubectl:** oc logs does not work ([f0808a2](https://github.com/IBM/kui/commit/f0808a2)), closes [#4965](https://github.com/IBM/kui/issues/4965)
- **plugins/plugin-kubectl:** singleton breadcrumbs in kubectl help should not be clickable ([7815464](https://github.com/IBM/kui/commit/7815464)), closes [#4961](https://github.com/IBM/kui/issues/4961)
- allow user to disable table title by feature flags, and disable table pagination ([5450512](https://github.com/IBM/kui/commit/5450512)), closes [#4640](https://github.com/IBM/kui/issues/4640) [#4655](https://github.com/IBM/kui/issues/4655)
- avoid using kui-custom command for switching kubectl namespace ([43863f2](https://github.com/IBM/kui/commit/43863f2)), closes [#4806](https://github.com/IBM/kui/issues/4806)
- Input element throws react error ([e6bb21b](https://github.com/IBM/kui/commit/e6bb21b)), closes [#4765](https://github.com/IBM/kui/issues/4765)
- kubectl edit apply twice does not work ([1976134](https://github.com/IBM/kui/commit/1976134)), closes [#4797](https://github.com/IBM/kui/issues/4797)
- kubectl Logs tab should use an xterm ([9aa0176](https://github.com/IBM/kui/commit/9aa0176)), closes [#4750](https://github.com/IBM/kui/issues/4750) [#4747](https://github.com/IBM/kui/issues/4747)
- place namespace breadcrumb first ([5d3b2e4](https://github.com/IBM/kui/commit/5d3b2e4)), closes [#4699](https://github.com/IBM/kui/issues/4699)
- remove augmentModuleLoadPath API ([47dfcdf](https://github.com/IBM/kui/commit/47dfcdf)), closes [#4839](https://github.com/IBM/kui/issues/4839)
- sidecar toolbar can't due justice to longer error messages ([e67e0c9](https://github.com/IBM/kui/commit/e67e0c9)), closes [#4789](https://github.com/IBM/kui/issues/4789)
- summary tab is not read-only for kubectl edit command ([9f7ff82](https://github.com/IBM/kui/commit/9f7ff82)), closes [#4809](https://github.com/IBM/kui/issues/4809)
- **plugins/plugin-kubectl:** auto-pause logs when user scrolls ([94b85e6](https://github.com/IBM/kui/commit/94b85e6)), closes [#4668](https://github.com/IBM/kui/issues/4668)
- **plugins/plugin-kubectl:** automatically abort idle PTYs ([2638a65](https://github.com/IBM/kui/commit/2638a65)), closes [#4742](https://github.com/IBM/kui/issues/4742)
- **plugins/plugin-kubectl:** ExecIntoPod's terminal is not theme-aligned ([067cda3](https://github.com/IBM/kui/commit/067cda3)), closes [#4722](https://github.com/IBM/kui/issues/4722)
- **plugins/plugin-kubectl:** helm help parsed usage incorrectly ([b222da2](https://github.com/IBM/kui/commit/b222da2)), closes [#4692](https://github.com/IBM/kui/issues/4692)
- **plugins/plugin-kubectl:** ImagePullBackoff should be considered a "red" state ([198100d](https://github.com/IBM/kui/commit/198100d)), closes [#4734](https://github.com/IBM/kui/issues/4734)
- **plugins/plugin-kubectl:** improve kubectl tab completion ([734f9e5](https://github.com/IBM/kui/commit/734f9e5)), closes [#4704](https://github.com/IBM/kui/issues/4704)
- **plugins/plugin-kubectl:** improve kubectl top node display with open sidecar ([6f99581](https://github.com/IBM/kui/commit/6f99581)), closes [#4737](https://github.com/IBM/kui/issues/4737)
- **plugins/plugin-kubectl:** k edit deploy has mysterious Pod tab ([914df36](https://github.com/IBM/kui/commit/914df36)), closes [#4703](https://github.com/IBM/kui/issues/4703)
- **plugins/plugin-kubectl:** kubectl api-resources table should hide APIGROUP column with open sidecar ([ee347fa](https://github.com/IBM/kui/commit/ee347fa)), closes [#4728](https://github.com/IBM/kui/issues/4728)
- **plugins/plugin-kubectl:** kubectl logs -l with no matches yields internal error ([ed0374f](https://github.com/IBM/kui/commit/ed0374f)), closes [#4811](https://github.com/IBM/kui/issues/4811)
- **plugins/plugin-kubectl:** Logs tab should have a default tail limit ([d4cf08c](https://github.com/IBM/kui/commit/d4cf08c)), closes [#4810](https://github.com/IBM/kui/issues/4810) [#4818](https://github.com/IBM/kui/issues/4818)
- **plugins/plugin-kubectl:** status shows as Containercreating when it should be ContainerCreating ([2c4a3b6](https://github.com/IBM/kui/commit/2c4a3b6)), closes [#4798](https://github.com/IBM/kui/issues/4798)
- **plugins/plugin-kubectl:** Terminal tab test incorrectly verifies k exec output ([20ab362](https://github.com/IBM/kui/commit/20ab362)), closes [#4802](https://github.com/IBM/kui/issues/4802)
- avoid recomputing tabs when switching back and forth ([cf5e41f](https://github.com/IBM/kui/commit/cf5e41f)), closes [#4666](https://github.com/IBM/kui/issues/4666)
- eliminate assumptions that "default" is the default kube namespace ([4eb392d](https://github.com/IBM/kui/commit/4eb392d)), closes [#4764](https://github.com/IBM/kui/issues/4764)
- kubectl edit in sidecar doesn't show success message when a resource is applied ([cc59503](https://github.com/IBM/kui/commit/cc59503)), closes [#4691](https://github.com/IBM/kui/issues/4691)
- logs tab toolbar doesn't signify when pods are 404 ([135e1be](https://github.com/IBM/kui/commit/135e1be)), closes [#4646](https://github.com/IBM/kui/issues/4646)
- the Logs/Terminal retry button should be visible on any exit code ([3366327](https://github.com/IBM/kui/commit/3366327)), closes [#4769](https://github.com/IBM/kui/issues/4769)
- TopNavSidecar tabs should auto-pause and auto-focus when switching ([2b00dd9](https://github.com/IBM/kui/commit/2b00dd9)), closes [#4741](https://github.com/IBM/kui/issues/4741) [#4748](https://github.com/IBM/kui/issues/4748)
- **plugin-kubectl:** k get pods --all-namespaces has a title with "default" as the namespace ([2f95129](https://github.com/IBM/kui/commit/2f95129)), closes [#4466](https://github.com/IBM/kui/issues/4466)
- **plugins/plugin-kubectl:** kubectl logs tab has bad interleaving and cpu issues ([1c7cf17](https://github.com/IBM/kui/commit/1c7cf17)), closes [#4664](https://github.com/IBM/kui/issues/4664) [#4665](https://github.com/IBM/kui/issues/4665)
- **plugins/plugin-kubectl:** remove kubectl edit cancel button ([83179e8](https://github.com/IBM/kui/commit/83179e8)), closes [#4695](https://github.com/IBM/kui/issues/4695)
- container filter of logs tab shows accumulated logs from previous selection ([08903b4](https://github.com/IBM/kui/commit/08903b4)), closes [#4644](https://github.com/IBM/kui/issues/4644) [#4658](https://github.com/IBM/kui/issues/4658)
- **plugins/plugin-kubectl:** i18n for No log data message ([589a4cd](https://github.com/IBM/kui/commit/589a4cd)), closes [#4656](https://github.com/IBM/kui/issues/4656)
- **plugins/plugin-kubectl:** k edit -h does not open in sidecar ([b6f68f8](https://github.com/IBM/kui/commit/b6f68f8)), closes [#4661](https://github.com/IBM/kui/issues/4661)
- improve error reporting for kubectl apply ([fe21671](https://github.com/IBM/kui/commit/fe21671)), closes [#4605](https://github.com/IBM/kui/issues/4605)
- kubectl api-resources has duplicate rows and odd pagination behavior ([e740270](https://github.com/IBM/kui/commit/e740270)), closes [#4626](https://github.com/IBM/kui/issues/4626)
- **plugin-kubectl:** kubectl get error-type -w doesn't fail fast ([4ccb733](https://github.com/IBM/kui/commit/4ccb733)), closes [#4491](https://github.com/IBM/kui/issues/4491)
- **plugins/plugin-kubectl:** add missing test for get with not found ([3e77689](https://github.com/IBM/kui/commit/3e77689)), closes [#4492](https://github.com/IBM/kui/issues/4492)
- **plugins/plugin-kubectl:** avoid use of /s regexp ([9468304](https://github.com/IBM/kui/commit/9468304)), closes [#4259](https://github.com/IBM/kui/issues/4259)
- **plugins/plugin-kubectl:** cache kind canonicalization lookup ([e351a5f](https://github.com/IBM/kui/commit/e351a5f)), closes [#4489](https://github.com/IBM/kui/issues/4489)
- **plugins/plugin-kubectl:** CurrentContext widget shows "default" for openshift clusters ([59712c0](https://github.com/IBM/kui/commit/59712c0)), closes [#4347](https://github.com/IBM/kui/issues/4347)
- **plugins/plugin-kubectl:** ensure Show Owner button appears near end of toolbar buttons ([224c586](https://github.com/IBM/kui/commit/224c586)), closes [#4124](https://github.com/IBM/kui/issues/4124)
- **plugins/plugin-kubectl:** firefox does not support the /s flag to RegExp ([5b661a6](https://github.com/IBM/kui/commit/5b661a6)), closes [#4206](https://github.com/IBM/kui/issues/4206)
- **plugins/plugin-kubectl:** in kube namespace table, selected namespace should float to top ([f0e597f](https://github.com/IBM/kui/commit/f0e597f)), closes [#4129](https://github.com/IBM/kui/issues/4129)
- **plugins/plugin-kubectl:** k get events -w bombs ([20c2caf](https://github.com/IBM/kui/commit/20c2caf)), closes [#4557](https://github.com/IBM/kui/issues/4557)
- **plugins/plugin-kubectl:** kubectl api-resources table shows 'unknown' in title ([0461710](https://github.com/IBM/kui/commit/0461710)), closes [#4145](https://github.com/IBM/kui/issues/4145)
- **plugins/plugin-kubectl:** kubectl create secret hangs yellow ([e11dbb8](https://github.com/IBM/kui/commit/e11dbb8)), closes [#4571](https://github.com/IBM/kui/issues/4571)
- **plugins/plugin-kubectl:** kubectl describe -h has old bold text ([b31d066](https://github.com/IBM/kui/commit/b31d066)), closes [#4568](https://github.com/IBM/kui/issues/4568)
- **plugins/plugin-kubectl:** kubectl edit should support editing a list of resources ([4cd4d43](https://github.com/IBM/kui/commit/4cd4d43)), closes [#4555](https://github.com/IBM/kui/issues/4555)
- **plugins/plugin-kubectl:** kubectl explain -h should render as usage in sidecar ([8e00c3f](https://github.com/IBM/kui/commit/8e00c3f)), closes [#4211](https://github.com/IBM/kui/issues/4211)
- **plugins/plugin-kubectl:** kubectl explain Overview tab not formatted as expected ([ffa9183](https://github.com/IBM/kui/commit/ffa9183)), closes [#4304](https://github.com/IBM/kui/issues/4304)
- **plugins/plugin-kubectl:** kubectl get --all-namespaces --watch does not update ([663a972](https://github.com/IBM/kui/commit/663a972)), closes [#4581](https://github.com/IBM/kui/issues/4581)
- **plugins/plugin-kubectl:** kubectl Show Events query not precise enough ([eda6b38](https://github.com/IBM/kui/commit/eda6b38)), closes [#4572](https://github.com/IBM/kui/issues/4572)
- **plugins/plugin-kubectl:** kubectl top nodes can present "NaN" ([30df3dd](https://github.com/IBM/kui/commit/30df3dd)), closes [#4189](https://github.com/IBM/kui/issues/4189)
- **plugins/plugin-kubectl:** more refinements to Form layout heuristics ([e92327d](https://github.com/IBM/kui/commit/e92327d)), closes [#4118](https://github.com/IBM/kui/issues/4118)
- **plugins/plugin-kubectl:** remove Conditions tab ([eac3705](https://github.com/IBM/kui/commit/eac3705)), closes [#4606](https://github.com/IBM/kui/issues/4606)
- clicking on certain links in kubectl help result in odd behavior ([035894b](https://github.com/IBM/kui/commit/035894b)), closes [#4473](https://github.com/IBM/kui/issues/4473)
- ibmcloud plugin list does not list unofficial plugins ([303fa00](https://github.com/IBM/kui/commit/303fa00)), closes [#4339](https://github.com/IBM/kui/issues/4339)
- kubectl top node should show % text ([f861b76](https://github.com/IBM/kui/commit/f861b76)), closes [#4598](https://github.com/IBM/kui/issues/4598)
- make inBrowserOk the default ([2a3c811](https://github.com/IBM/kui/commit/2a3c811)), closes [#4275](https://github.com/IBM/kui/issues/4275)
- reduce No log data followed by log data behavior in kube logs ([e1c0624](https://github.com/IBM/kui/commit/e1c0624)), closes [#4624](https://github.com/IBM/kui/issues/4624)
- **plugins/plugin-kubectl:** remove Show Logs registration ([382c685](https://github.com/IBM/kui/commit/382c685)), closes [#4603](https://github.com/IBM/kui/issues/4603)
- multiple kubectl help/usage bugs ([ebba36e](https://github.com/IBM/kui/commit/ebba36e)), closes [#4342](https://github.com/IBM/kui/issues/4342)
- optimize kubectl watch load on apiserver ([3f7a32f](https://github.com/IBM/kui/commit/3f7a32f)), closes [#4494](https://github.com/IBM/kui/issues/4494)
- replace Containers with Logs tab ([00e8786](https://github.com/IBM/kui/commit/00e8786)), closes [#4603](https://github.com/IBM/kui/issues/4603)
- **plugins/plugin-kubectl:** inconsistent capitalization of breadcrumbs ([963b166](https://github.com/IBM/kui/commit/963b166)), closes [#4607](https://github.com/IBM/kui/issues/4607)
- **plugins/plugin-kubectl:** revert to editor-based Summary tab ([3ecd638](https://github.com/IBM/kui/commit/3ecd638)), closes [#4594](https://github.com/IBM/kui/issues/4594)
- clicking on container name in details sidecar should add -c to logs command ([61c7c08](https://github.com/IBM/kui/commit/61c7c08)), closes [#4498](https://github.com/IBM/kui/issues/4498)
- PaginatedTable fails at distinguishing the rowKeys of `k get --all-namespaces` table ([6658729](https://github.com/IBM/kui/commit/6658729)), closes [#4579](https://github.com/IBM/kui/issues/4579)
- TopNavSidecar does not always show updates ([251e5c4](https://github.com/IBM/kui/commit/251e5c4)), closes [#4524](https://github.com/IBM/kui/issues/4524)
- **plugins/plugin-kubectl:** kubectl get table with mix of existing and non-existing ([8d98d15](https://github.com/IBM/kui/commit/8d98d15)), closes [#4492](https://github.com/IBM/kui/issues/4492)
- sidecar views do not respect tab-specificity ([5a1cae2](https://github.com/IBM/kui/commit/5a1cae2)), closes [#4362](https://github.com/IBM/kui/issues/4362)
- **plugins/plugin-kubectl:** update deprecated import of uuid ([5de8d4d](https://github.com/IBM/kui/commit/5de8d4d)), closes [#4316](https://github.com/IBM/kui/issues/4316)
- **plugins/plugin-kubectl:** watch table doesn't have breadcrumbs title ([43fbe6a](https://github.com/IBM/kui/commit/43fbe6a)), closes [#4135](https://github.com/IBM/kui/issues/4135)
- **plugins/plugin-kubectl:** we shouldn't render namespace widget when the namespace is empty in kube config ([98a9406](https://github.com/IBM/kui/commit/98a9406)), closes [#4274](https://github.com/IBM/kui/issues/4274)
- add support for hiding elements at higher zoom levels ([7d2a7e0](https://github.com/IBM/kui/commit/7d2a7e0)), closes [#4232](https://github.com/IBM/kui/issues/4232)
- eliminate complex nesting of NavResponse model ([e849ae7](https://github.com/IBM/kui/commit/e849ae7)), closes [#4205](https://github.com/IBM/kui/issues/4205)
- ensure kubectl Delete toolbar button appears at far right ([9eb3079](https://github.com/IBM/kui/commit/9eb3079)), closes [#4116](https://github.com/IBM/kui/issues/4116)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- kubectl summary Form TextInputs can be cropped ([3becaf9](https://github.com/IBM/kui/commit/3becaf9)), closes [#4077](https://github.com/IBM/kui/issues/4077)
- multiple tab completion bugs ([5513712](https://github.com/IBM/kui/commit/5513712)), closes [#4281](https://github.com/IBM/kui/issues/4281)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- the colors of status badges: Error, ImagePullBackOff and ErrImagePull are incorrect ([fd206f6](https://github.com/IBM/kui/commit/fd206f6)), closes [#4171](https://github.com/IBM/kui/issues/4171)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- **plugins/plugin-kubectl:** watcher table disappears when kui is launched as kubectl plugin ([167eabc](https://github.com/IBM/kui/commit/167eabc)), closes [#4120](https://github.com/IBM/kui/issues/4120) [#4123](https://github.com/IBM/kui/issues/4123)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- tekton Step nodes show with hashed background ([8428d72](https://github.com/IBM/kui/commit/8428d72)), closes [#4114](https://github.com/IBM/kui/issues/4114)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)
- **plugins/plugin-kubectl:** kubectl describe (--help) fails ([10b8e8a](https://github.com/IBM/kui/commit/10b8e8a)), closes [#4012](https://github.com/IBM/kui/issues/4012)
- **plugins/plugin-kubectl:** oc describe fails ([4f4de4e](https://github.com/IBM/kui/commit/4f4de4e)), closes [#4008](https://github.com/IBM/kui/issues/4008)
- **plugins/plugin-kubectl:** windows powershell fails to get default namespace ([a5fb2e1](https://github.com/IBM/kui/commit/a5fb2e1)), closes [#4912](https://github.com/IBM/kui/issues/4912)

### Features

- **plugins/plugin-kubectl:** initial `kubectl job list` improvement for visualizing Job execution ([06030b0](https://github.com/IBM/kui/commit/06030b0)), closes [#5397](https://github.com/IBM/kui/issues/5397)
- add capability to show welcome widget to new users in Terminal ([0c33e6e](https://github.com/IBM/kui/commit/0c33e6e)), closes [#4990](https://github.com/IBM/kui/issues/4990) [#5007](https://github.com/IBM/kui/issues/5007)
- add isSelected and Divider to log container selection menu ([59bdaa5](https://github.com/IBM/kui/commit/59bdaa5)), closes [#4647](https://github.com/IBM/kui/issues/4647)
- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Patternfly Breadcrumb support ([91e0504](https://github.com/IBM/kui/commit/91e0504)), closes [#4381](https://github.com/IBM/kui/issues/4381)
- add Retry button to sidecar toolbar when log streaming stopped abnormally ([47872f4](https://github.com/IBM/kui/commit/47872f4)), closes [#4755](https://github.com/IBM/kui/issues/4755)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- allow for limiting the number of kubectl table rows ([62588f2](https://github.com/IBM/kui/commit/62588f2)), closes [#5358](https://github.com/IBM/kui/issues/5358)
- allow users to select container in kubectl Logs ([f4304c5](https://github.com/IBM/kui/commit/f4304c5)), closes [#4627](https://github.com/IBM/kui/issues/4627)
- cold start delays ([83abd14](https://github.com/IBM/kui/commit/83abd14)), closes [#5356](https://github.com/IBM/kui/issues/5356)
- generalized kuberctl get with limit ([d40ee07](https://github.com/IBM/kui/commit/d40ee07)), closes [#5361](https://github.com/IBM/kui/issues/5361)
- **plugins/plugin-client-common:** improved SequenceDiagram view ([1e2fb41](https://github.com/IBM/kui/commit/1e2fb41)), closes [#5342](https://github.com/IBM/kui/issues/5342)
- commands should be able to separate resource model fetch from view transformation functions ([e903bc7](https://github.com/IBM/kui/commit/e903bc7)), closes [#4437](https://github.com/IBM/kui/issues/4437)
- ibmcloud plugin ([aa0f72f](https://github.com/IBM/kui/commit/aa0f72f)), closes [#4353](https://github.com/IBM/kui/issues/4353)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- initial odo catalog list enhancements ([8534267](https://github.com/IBM/kui/commit/8534267)), closes [#4485](https://github.com/IBM/kui/issues/4485)
- initial popeye support ([9d62eeb](https://github.com/IBM/kui/commit/9d62eeb)), closes [#5265](https://github.com/IBM/kui/issues/5265)
- MiniSplits ([70b8441](https://github.com/IBM/kui/commit/70b8441)), closes [#5112](https://github.com/IBM/kui/issues/5112)
- s3 plugin, and vfs ([970ba6e](https://github.com/IBM/kui/commit/970ba6e)), closes [#5319](https://github.com/IBM/kui/issues/5319)
- **plugins/plugin-git:** git branch should respond with RadioTable ([59a9213](https://github.com/IBM/kui/commit/59a9213)), closes [#5256](https://github.com/IBM/kui/issues/5256)
- **plugins/plugin-ibmcloud:** initial CodeEngine support ([677faca](https://github.com/IBM/kui/commit/677faca)), closes [#5302](https://github.com/IBM/kui/issues/5302) [#5303](https://github.com/IBM/kui/issues/5303)
- add button to WatchPane to show table back in terminal ([dc22591](https://github.com/IBM/kui/commit/dc22591)), closes [#4530](https://github.com/IBM/kui/issues/4530)
- add Stop Watching capability to WatchPane ([09043c1](https://github.com/IBM/kui/commit/09043c1)), closes [#4554](https://github.com/IBM/kui/issues/4554)
- clicking on events in watch table should drill down to events ([c6dc99f](https://github.com/IBM/kui/commit/c6dc99f)), closes [#5173](https://github.com/IBM/kui/issues/5173)
- improve kubectl edit experience ([4c4a1c9](https://github.com/IBM/kui/commit/4c4a1c9)), closes [#4783](https://github.com/IBM/kui/issues/4783)
- improve rendering of kubectl subcommand help ([e36ed29](https://github.com/IBM/kui/commit/e36ed29)), closes [#4824](https://github.com/IBM/kui/issues/4824)
- kubectl apply view-last-applied ([6d601ef](https://github.com/IBM/kui/commit/6d601ef)), closes [#4822](https://github.com/IBM/kui/issues/4822)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- line highlights on editor save, used for k edit apply errors ([3efa6a5](https://github.com/IBM/kui/commit/3efa6a5)), closes [#4795](https://github.com/IBM/kui/issues/4795)
- pin a watchable terminal response in a split pane ([662f413](https://github.com/IBM/kui/commit/662f413)), closes [#4865](https://github.com/IBM/kui/issues/4865) [#4573](https://github.com/IBM/kui/issues/4573) [#4885](https://github.com/IBM/kui/issues/4885) [#4894](https://github.com/IBM/kui/issues/4894)
- refine kubectl contexts table; add support for RadioTable row titles ([11bb074](https://github.com/IBM/kui/commit/11bb074)), closes [#5131](https://github.com/IBM/kui/issues/5131)
- show resource version in toolbar text ([1a6e335](https://github.com/IBM/kui/commit/1a6e335)), closes [#4790](https://github.com/IBM/kui/issues/4790)
- split screen Terminal ([3a6b422](https://github.com/IBM/kui/commit/3a6b422)), closes [#4814](https://github.com/IBM/kui/issues/4814) [#4821](https://github.com/IBM/kui/issues/4821)
- support for events in crud table footer ([0b90ead](https://github.com/IBM/kui/commit/0b90ead)), closes [#5125](https://github.com/IBM/kui/issues/5125)
- support for events in table footer ([51669af](https://github.com/IBM/kui/commit/51669af)), closes [#5115](https://github.com/IBM/kui/issues/5115)
- **plugins/plugin-kubectl:** add Show Node button for kubectl pods ([04e29d2](https://github.com/IBM/kui/commit/04e29d2)), closes [#4214](https://github.com/IBM/kui/issues/4214)
- **plugins/plugin-kubectl:** add support for kustomize apply/delete/create ([b95cbdb](https://github.com/IBM/kui/commit/b95cbdb)), closes [#4203](https://github.com/IBM/kui/issues/4203)
- **plugins/plugin-kubectl:** configmap summary should show data ([50c7e10](https://github.com/IBM/kui/commit/50c7e10)), closes [#4025](https://github.com/IBM/kui/issues/4025)
- **plugins/plugin-kubectl:** enhance odo project list as RadioTable ([62272e6](https://github.com/IBM/kui/commit/62272e6)), closes [#4517](https://github.com/IBM/kui/issues/4517)
- **plugins/plugin-kubectl:** improve odo usage experience ([639ca32](https://github.com/IBM/kui/commit/639ca32)), closes [#4345](https://github.com/IBM/kui/issues/4345)
- **plugins/plugin-kubectl:** kubectl events tab ([2d71f24](https://github.com/IBM/kui/commit/2d71f24)), closes [#4706](https://github.com/IBM/kui/issues/4706)
- **plugins/plugin-kubectl:** namespace onclick should drill down to sidecar ([e74f66d](https://github.com/IBM/kui/commit/e74f66d)), closes [#4714](https://github.com/IBM/kui/issues/4714)
- **plugins/plugin-kubectl:** optimize rendering of kubectl Summary tab ([7c6480d](https://github.com/IBM/kui/commit/7c6480d)), closes [#4725](https://github.com/IBM/kui/issues/4725)
- **plugins/plugin-kubectl:** optimizing Node summary impl ([8ac11b9](https://github.com/IBM/kui/commit/8ac11b9)), closes [#4833](https://github.com/IBM/kui/issues/4833)
- **plugins/plugin-kubectl:** Show Previous option for Logs tab ([2307d2f](https://github.com/IBM/kui/commit/2307d2f)), closes [#4864](https://github.com/IBM/kui/issues/4864)
- kubectl edit via kui's editor ([414e813](https://github.com/IBM/kui/commit/414e813)), closes [#762](https://github.com/IBM/kui/issues/762)
- patternfly4 themes ([5f58f71](https://github.com/IBM/kui/commit/5f58f71)), closes [#4364](https://github.com/IBM/kui/issues/4364)
- target kubectl logs and kubectl exec to Logs and Terminal tabs ([409e632](https://github.com/IBM/kui/commit/409e632)), closes [#4762](https://github.com/IBM/kui/issues/4762)
- **plugins/plugin-kubectl:** Terminal tab for Pod kubernetes resources ([c47e432](https://github.com/IBM/kui/commit/c47e432)), closes [#4639](https://github.com/IBM/kui/issues/4639)
- only enable WatchPane based on a feature flag ([eb80d0e](https://github.com/IBM/kui/commit/eb80d0e)), closes [#4678](https://github.com/IBM/kui/issues/4678) [#4604](https://github.com/IBM/kui/issues/4604)
- port kubectl get ns to RadioTable ([be0eabf](https://github.com/IBM/kui/commit/be0eabf)), closes [#4510](https://github.com/IBM/kui/issues/4510) [#4511](https://github.com/IBM/kui/issues/4511)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- simplified co-hosting of client and proxy in a container ([00af4b4](https://github.com/IBM/kui/commit/00af4b4)), closes [#4213](https://github.com/IBM/kui/issues/4213)
- SPI for icons ([3d034e3](https://github.com/IBM/kui/commit/3d034e3)), closes [#4441](https://github.com/IBM/kui/issues/4441) [#4364](https://github.com/IBM/kui/issues/4364)
- top tab buttons ([ff8cfba](https://github.com/IBM/kui/commit/ff8cfba)), closes [#4434](https://github.com/IBM/kui/issues/4434)
- watcher panel for open-ended watch jobs ([6dfe7df](https://github.com/IBM/kui/commit/6dfe7df)), closes [#4503](https://github.com/IBM/kui/issues/4503)
- **plugins/plugin-kubectl:** port kubectl contexts table to RadioTable ([3cb4dcb](https://github.com/IBM/kui/commit/3cb4dcb)), closes [#4513](https://github.com/IBM/kui/issues/4513)
- **plugins/plugin-kubectl:** ReplicaSet should have Pods tab ([42cd286](https://github.com/IBM/kui/commit/42cd286)), closes [#4110](https://github.com/IBM/kui/issues/4110)
- **plugins/plugin-kubectl:** restore Show Logs button for kubectl ([6b17dbd](https://github.com/IBM/kui/commit/6b17dbd)), closes [#4089](https://github.com/IBM/kui/issues/4089)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)

### BREAKING CHANGES

- removes support for inBrowserOk

# [8.11.0](https://github.com/IBM/kui/compare/v4.5.0...v8.11.0) (2020-07-21)

### Bug Fixes

- **plugins/plugin-client-common:** improve display of empty watch tables ([4cc16be](https://github.com/IBM/kui/commit/4cc16be)), closes [#5176](https://github.com/IBM/kui/issues/5176)
- **plugins/plugin-client-common:** make Close a top-level button in watch panes ([3c14da5](https://github.com/IBM/kui/commit/3c14da5)), closes [#4945](https://github.com/IBM/kui/issues/4945)
- **plugins/plugin-kubectl:** changing ns via oc does not update ns widget, in browser clients ([5eaa625](https://github.com/IBM/kui/commit/5eaa625)), closes [#4953](https://github.com/IBM/kui/issues/4953)
- **plugins/plugin-kubectl:** CurrentNamespace/Context widgets not live ([93ac829](https://github.com/IBM/kui/commit/93ac829)), closes [#5144](https://github.com/IBM/kui/issues/5144)
- **plugins/plugin-kubectl:** drilldown command of resources in watch --all-namespace table doesn't have '-o yaml' ([1e4f558](https://github.com/IBM/kui/commit/1e4f558)), closes [#5208](https://github.com/IBM/kui/issues/5208)
- **plugins/plugin-kubectl:** event footer watching should also support named resources ([e3a842b](https://github.com/IBM/kui/commit/e3a842b)), closes [#5180](https://github.com/IBM/kui/issues/5180)
- **plugins/plugin-kubectl:** events in table appear to be in random order ([034dc06](https://github.com/IBM/kui/commit/034dc06)), closes [#5212](https://github.com/IBM/kui/issues/5212)
- **plugins/plugin-kubectl:** Pod summary impl fails for pods with no containerStatuses ([66b21b5](https://github.com/IBM/kui/commit/66b21b5)), closes [#5192](https://github.com/IBM/kui/issues/5192)
- (plugins/plugin-kubectl): kubectl get pod -w --all-namespaces behaves oddly ([12e578a](https://github.com/IBM/kui/commit/12e578a)), closes [#5169](https://github.com/IBM/kui/issues/5169)
- **plugins/plugin-kubectl:** kubectl apply -f may not abort the event watcher ([c8df222](https://github.com/IBM/kui/commit/c8df222)), closes [#5149](https://github.com/IBM/kui/issues/5149)
- **plugins/plugin-kubectl:** kubectl explain subfields ([8fee2bc](https://github.com/IBM/kui/commit/8fee2bc)), closes [#4921](https://github.com/IBM/kui/issues/4921)
- **plugins/plugin-kubectl:** nil and negative timestamps display as "0ms ago" ([641a599](https://github.com/IBM/kui/commit/641a599)), closes [#5136](https://github.com/IBM/kui/issues/5136)
- **plugins/plugin-kubectl:** oc get ns does not present a RadioTable ([9e28eec](https://github.com/IBM/kui/commit/9e28eec)), closes [#5106](https://github.com/IBM/kui/issues/5106)
- avoid using kui-custom command for switching kubectl namespace ([43863f2](https://github.com/IBM/kui/commit/43863f2)), closes [#4806](https://github.com/IBM/kui/issues/4806)
- CurrentContext and CurrentNamespace widgets may have stale data inBrowser ([ab77c20](https://github.com/IBM/kui/commit/ab77c20)), closes [#5097](https://github.com/IBM/kui/issues/5097)
- don't blink yellow forever for kubectl events ([a59ee86](https://github.com/IBM/kui/commit/a59ee86)), closes [#4869](https://github.com/IBM/kui/issues/4869)
- empty watch tables/grids should show 'No resources' ([c0bfe99](https://github.com/IBM/kui/commit/c0bfe99)), closes [#4884](https://github.com/IBM/kui/issues/4884)
- multiple issues with tab switching versus status stripe widgets ([8c8a6ec](https://github.com/IBM/kui/commit/8c8a6ec)), closes [#5101](https://github.com/IBM/kui/issues/5101)
- **plugins/plugin-kubectl:** tolerate helm 3.0 and 3.1 help custom ascii art tables ([79f8640](https://github.com/IBM/kui/commit/79f8640)), closes [#5085](https://github.com/IBM/kui/issues/5085)
- kubectl help misformats helm help tables ([ff36755](https://github.com/IBM/kui/commit/ff36755)), closes [#5080](https://github.com/IBM/kui/issues/5080)
- **plugins/plugin-kubectl:** kubectl apply/create/delete tables still have ALLCAPS headers ([90d72ce](https://github.com/IBM/kui/commit/90d72ce)), closes [#5068](https://github.com/IBM/kui/issues/5068)
- improve hover effect for status stripe buttons ([50ced8f](https://github.com/IBM/kui/commit/50ced8f)), closes [#4896](https://github.com/IBM/kui/issues/4896)
- pexecs serviced by now-removed splits fail ([f6176a1](https://github.com/IBM/kui/commit/f6176a1)), closes [#4875](https://github.com/IBM/kui/issues/4875)
- reduce custom CSS rules for table UI ([56f69cb](https://github.com/IBM/kui/commit/56f69cb)), closes [#5024](https://github.com/IBM/kui/issues/5024)
- summary tab is not read-only for kubectl edit command ([9f7ff82](https://github.com/IBM/kui/commit/9f7ff82)), closes [#4809](https://github.com/IBM/kui/issues/4809)
- xterm alt buffer mode behaves oddly for clients that do not enable splitTerminals ([f1bc709](https://github.com/IBM/kui/commit/f1bc709)), closes [#5003](https://github.com/IBM/kui/issues/5003)
- **plugins/plugin-kubectl:** auto-pause logs when user scrolls ([94b85e6](https://github.com/IBM/kui/commit/94b85e6)), closes [#4668](https://github.com/IBM/kui/issues/4668)
- **plugins/plugin-kubectl:** ExecIntoPod's terminal is not theme-aligned ([067cda3](https://github.com/IBM/kui/commit/067cda3)), closes [#4722](https://github.com/IBM/kui/issues/4722)
- **plugins/plugin-kubectl:** get-namespace table sometimes doens't show the correct selected namespace ([af66aa4](https://github.com/IBM/kui/commit/af66aa4)), closes [#4812](https://github.com/IBM/kui/issues/4812)
- **plugins/plugin-kubectl:** helm help parsed usage incorrectly ([b222da2](https://github.com/IBM/kui/commit/b222da2)), closes [#4692](https://github.com/IBM/kui/issues/4692)
- **plugins/plugin-kubectl:** i18n for No log data message ([589a4cd](https://github.com/IBM/kui/commit/589a4cd)), closes [#4656](https://github.com/IBM/kui/issues/4656)
- **plugins/plugin-kubectl:** ImagePullBackoff should be considered a "red" state ([198100d](https://github.com/IBM/kui/commit/198100d)), closes [#4734](https://github.com/IBM/kui/issues/4734)
- **plugins/plugin-kubectl:** improve kubectl top node display with open sidecar ([6f99581](https://github.com/IBM/kui/commit/6f99581)), closes [#4737](https://github.com/IBM/kui/issues/4737)
- **plugins/plugin-kubectl:** kubectl apply edit-last-applied freezes in kui ([24a67da](https://github.com/IBM/kui/commit/24a67da)), closes [#4808](https://github.com/IBM/kui/issues/4808)
- **plugins/plugin-kubectl:** kubectl apply set-last-applied does not work ([9553907](https://github.com/IBM/kui/commit/9553907)), closes [#4844](https://github.com/IBM/kui/issues/4844)
- **plugins/plugin-kubectl:** kubectl logs -l with no matches yields internal error ([ed0374f](https://github.com/IBM/kui/commit/ed0374f)), closes [#4811](https://github.com/IBM/kui/issues/4811)
- **plugins/plugin-kubectl:** kubectl watch tables may lack namespace breadcrumb ([a0616c2](https://github.com/IBM/kui/commit/a0616c2)), closes [#4870](https://github.com/IBM/kui/issues/4870)
- **plugins/plugin-kubectl:** Logs tab should have a default tail limit ([d4cf08c](https://github.com/IBM/kui/commit/d4cf08c)), closes [#4810](https://github.com/IBM/kui/issues/4810) [#4818](https://github.com/IBM/kui/issues/4818)
- **plugins/plugin-kubectl:** oc get projects does not allow user selection ([3749371](https://github.com/IBM/kui/commit/3749371)), closes [#4805](https://github.com/IBM/kui/issues/4805)
- **plugins/plugin-kubectl:** oc logs does not work ([f0808a2](https://github.com/IBM/kui/commit/f0808a2)), closes [#4965](https://github.com/IBM/kui/issues/4965)
- **plugins/plugin-kubectl:** singleton breadcrumbs in kubectl help should not be clickable ([7815464](https://github.com/IBM/kui/commit/7815464)), closes [#4961](https://github.com/IBM/kui/issues/4961)
- avoid hard-coded use of /tmp in kubectl edit ([8e4cb70](https://github.com/IBM/kui/commit/8e4cb70)), closes [#4928](https://github.com/IBM/kui/issues/4928)
- **plugins/plugin-kubectl:** windows powershell fails to get default namespace ([a5fb2e1](https://github.com/IBM/kui/commit/a5fb2e1)), closes [#4912](https://github.com/IBM/kui/issues/4912)
- eliminate assumptions that "default" is the default kube namespace ([4eb392d](https://github.com/IBM/kui/commit/4eb392d)), closes [#4764](https://github.com/IBM/kui/issues/4764)
- Input element throws react error ([e6bb21b](https://github.com/IBM/kui/commit/e6bb21b)), closes [#4765](https://github.com/IBM/kui/issues/4765)
- kubectl edit apply twice does not work ([1976134](https://github.com/IBM/kui/commit/1976134)), closes [#4797](https://github.com/IBM/kui/issues/4797)
- **plugins/plugin-kubectl:** k edit -h does not open in sidecar ([b6f68f8](https://github.com/IBM/kui/commit/b6f68f8)), closes [#4661](https://github.com/IBM/kui/issues/4661)
- **plugins/plugin-kubectl:** k edit deploy has mysterious Pod tab ([914df36](https://github.com/IBM/kui/commit/914df36)), closes [#4703](https://github.com/IBM/kui/issues/4703)
- **plugins/plugin-kubectl:** kubectl logs tab has bad interleaving and cpu issues ([1c7cf17](https://github.com/IBM/kui/commit/1c7cf17)), closes [#4664](https://github.com/IBM/kui/issues/4664) [#4665](https://github.com/IBM/kui/issues/4665)
- **plugins/plugin-kubectl:** status shows as Containercreating when it should be ContainerCreating ([2c4a3b6](https://github.com/IBM/kui/commit/2c4a3b6)), closes [#4798](https://github.com/IBM/kui/issues/4798)
- **plugins/plugin-kubectl:** Terminal tab test incorrectly verifies k exec output ([20ab362](https://github.com/IBM/kui/commit/20ab362)), closes [#4802](https://github.com/IBM/kui/issues/4802)
- allow user to disable table title by feature flags, and disable table pagination ([5450512](https://github.com/IBM/kui/commit/5450512)), closes [#4640](https://github.com/IBM/kui/issues/4640) [#4655](https://github.com/IBM/kui/issues/4655)
- avoid recomputing tabs when switching back and forth ([cf5e41f](https://github.com/IBM/kui/commit/cf5e41f)), closes [#4666](https://github.com/IBM/kui/issues/4666)
- container filter of logs tab shows accumulated logs from previous selection ([08903b4](https://github.com/IBM/kui/commit/08903b4)), closes [#4644](https://github.com/IBM/kui/issues/4644) [#4658](https://github.com/IBM/kui/issues/4658)
- kubectl edit in sidecar doesn't show success message when a resource is applied ([cc59503](https://github.com/IBM/kui/commit/cc59503)), closes [#4691](https://github.com/IBM/kui/issues/4691)
- kubectl Logs tab should use an xterm ([9aa0176](https://github.com/IBM/kui/commit/9aa0176)), closes [#4750](https://github.com/IBM/kui/issues/4750) [#4747](https://github.com/IBM/kui/issues/4747)
- logs tab toolbar doesn't signify when pods are 404 ([135e1be](https://github.com/IBM/kui/commit/135e1be)), closes [#4646](https://github.com/IBM/kui/issues/4646)
- place namespace breadcrumb first ([5d3b2e4](https://github.com/IBM/kui/commit/5d3b2e4)), closes [#4699](https://github.com/IBM/kui/issues/4699)
- remove augmentModuleLoadPath API ([47dfcdf](https://github.com/IBM/kui/commit/47dfcdf)), closes [#4839](https://github.com/IBM/kui/issues/4839)
- sidecar toolbar can't due justice to longer error messages ([e67e0c9](https://github.com/IBM/kui/commit/e67e0c9)), closes [#4789](https://github.com/IBM/kui/issues/4789)
- the Logs/Terminal retry button should be visible on any exit code ([3366327](https://github.com/IBM/kui/commit/3366327)), closes [#4769](https://github.com/IBM/kui/issues/4769)
- TopNavSidecar tabs should auto-pause and auto-focus when switching ([2b00dd9](https://github.com/IBM/kui/commit/2b00dd9)), closes [#4741](https://github.com/IBM/kui/issues/4741) [#4748](https://github.com/IBM/kui/issues/4748)
- **plugins/plugin-kubectl:** automatically abort idle PTYs ([2638a65](https://github.com/IBM/kui/commit/2638a65)), closes [#4742](https://github.com/IBM/kui/issues/4742)
- **plugins/plugin-kubectl:** improve kubectl tab completion ([734f9e5](https://github.com/IBM/kui/commit/734f9e5)), closes [#4704](https://github.com/IBM/kui/issues/4704)
- **plugins/plugin-kubectl:** kubectl api-resources table should hide APIGROUP column with open sidecar ([ee347fa](https://github.com/IBM/kui/commit/ee347fa)), closes [#4728](https://github.com/IBM/kui/issues/4728)
- **plugins/plugin-kubectl:** remove kubectl edit cancel button ([83179e8](https://github.com/IBM/kui/commit/83179e8)), closes [#4695](https://github.com/IBM/kui/issues/4695)
- improve error reporting for kubectl apply ([fe21671](https://github.com/IBM/kui/commit/fe21671)), closes [#4605](https://github.com/IBM/kui/issues/4605)
- kubectl api-resources has duplicate rows and odd pagination behavior ([e740270](https://github.com/IBM/kui/commit/e740270)), closes [#4626](https://github.com/IBM/kui/issues/4626)
- **plugin-kubectl:** k get pods --all-namespaces has a title with "default" as the namespace ([2f95129](https://github.com/IBM/kui/commit/2f95129)), closes [#4466](https://github.com/IBM/kui/issues/4466)
- **plugins/plugin-kubectl:** remove Conditions tab ([eac3705](https://github.com/IBM/kui/commit/eac3705)), closes [#4606](https://github.com/IBM/kui/issues/4606)
- kubectl top node should show % text ([f861b76](https://github.com/IBM/kui/commit/f861b76)), closes [#4598](https://github.com/IBM/kui/issues/4598)
- reduce No log data followed by log data behavior in kube logs ([e1c0624](https://github.com/IBM/kui/commit/e1c0624)), closes [#4624](https://github.com/IBM/kui/issues/4624)
- **plugin-kubectl:** kubectl get error-type -w doesn't fail fast ([4ccb733](https://github.com/IBM/kui/commit/4ccb733)), closes [#4491](https://github.com/IBM/kui/issues/4491)
- **plugins/plugin-kubectl:** add missing test for get with not found ([3e77689](https://github.com/IBM/kui/commit/3e77689)), closes [#4492](https://github.com/IBM/kui/issues/4492)
- **plugins/plugin-kubectl:** cache kind canonicalization lookup ([e351a5f](https://github.com/IBM/kui/commit/e351a5f)), closes [#4489](https://github.com/IBM/kui/issues/4489)
- **plugins/plugin-kubectl:** CurrentContext widget shows "default" for openshift clusters ([59712c0](https://github.com/IBM/kui/commit/59712c0)), closes [#4347](https://github.com/IBM/kui/issues/4347)
- **plugins/plugin-kubectl:** inconsistent capitalization of breadcrumbs ([963b166](https://github.com/IBM/kui/commit/963b166)), closes [#4607](https://github.com/IBM/kui/issues/4607)
- **plugins/plugin-kubectl:** k get events -w bombs ([20c2caf](https://github.com/IBM/kui/commit/20c2caf)), closes [#4557](https://github.com/IBM/kui/issues/4557)
- **plugins/plugin-kubectl:** kubectl describe -h has old bold text ([b31d066](https://github.com/IBM/kui/commit/b31d066)), closes [#4568](https://github.com/IBM/kui/issues/4568)
- **plugins/plugin-kubectl:** kubectl edit should support editing a list of resources ([4cd4d43](https://github.com/IBM/kui/commit/4cd4d43)), closes [#4555](https://github.com/IBM/kui/issues/4555)
- **plugins/plugin-kubectl:** remove Show Logs registration ([382c685](https://github.com/IBM/kui/commit/382c685)), closes [#4603](https://github.com/IBM/kui/issues/4603)
- multiple tab completion bugs ([5513712](https://github.com/IBM/kui/commit/5513712)), closes [#4281](https://github.com/IBM/kui/issues/4281)
- replace Containers with Logs tab ([00e8786](https://github.com/IBM/kui/commit/00e8786)), closes [#4603](https://github.com/IBM/kui/issues/4603)
- **plugins/plugin-kubectl:** avoid use of /s regexp ([9468304](https://github.com/IBM/kui/commit/9468304)), closes [#4259](https://github.com/IBM/kui/issues/4259)
- **plugins/plugin-kubectl:** kubectl create secret hangs yellow ([e11dbb8](https://github.com/IBM/kui/commit/e11dbb8)), closes [#4571](https://github.com/IBM/kui/issues/4571)
- **plugins/plugin-kubectl:** kubectl get --all-namespaces --watch does not update ([663a972](https://github.com/IBM/kui/commit/663a972)), closes [#4581](https://github.com/IBM/kui/issues/4581)
- **plugins/plugin-kubectl:** kubectl get table with mix of existing and non-existing ([8d98d15](https://github.com/IBM/kui/commit/8d98d15)), closes [#4492](https://github.com/IBM/kui/issues/4492)
- **plugins/plugin-kubectl:** kubectl Show Events query not precise enough ([eda6b38](https://github.com/IBM/kui/commit/eda6b38)), closes [#4572](https://github.com/IBM/kui/issues/4572)
- **plugins/plugin-kubectl:** revert to editor-based Summary tab ([3ecd638](https://github.com/IBM/kui/commit/3ecd638)), closes [#4594](https://github.com/IBM/kui/issues/4594)
- add support for hiding elements at higher zoom levels ([7d2a7e0](https://github.com/IBM/kui/commit/7d2a7e0)), closes [#4232](https://github.com/IBM/kui/issues/4232)
- clicking on certain links in kubectl help result in odd behavior ([035894b](https://github.com/IBM/kui/commit/035894b)), closes [#4473](https://github.com/IBM/kui/issues/4473)
- clicking on container name in details sidecar should add -c to logs command ([61c7c08](https://github.com/IBM/kui/commit/61c7c08)), closes [#4498](https://github.com/IBM/kui/issues/4498)
- ibmcloud plugin list does not list unofficial plugins ([303fa00](https://github.com/IBM/kui/commit/303fa00)), closes [#4339](https://github.com/IBM/kui/issues/4339)
- make inBrowserOk the default ([2a3c811](https://github.com/IBM/kui/commit/2a3c811)), closes [#4275](https://github.com/IBM/kui/issues/4275)
- multiple kubectl help/usage bugs ([ebba36e](https://github.com/IBM/kui/commit/ebba36e)), closes [#4342](https://github.com/IBM/kui/issues/4342)
- optimize kubectl watch load on apiserver ([3f7a32f](https://github.com/IBM/kui/commit/3f7a32f)), closes [#4494](https://github.com/IBM/kui/issues/4494)
- PaginatedTable fails at distinguishing the rowKeys of `k get --all-namespaces` table ([6658729](https://github.com/IBM/kui/commit/6658729)), closes [#4579](https://github.com/IBM/kui/issues/4579)
- sidecar views do not respect tab-specificity ([5a1cae2](https://github.com/IBM/kui/commit/5a1cae2)), closes [#4362](https://github.com/IBM/kui/issues/4362)
- TopNavSidecar does not always show updates ([251e5c4](https://github.com/IBM/kui/commit/251e5c4)), closes [#4524](https://github.com/IBM/kui/issues/4524)
- **plugins/plugin-kubectl:** ensure Show Owner button appears near end of toolbar buttons ([224c586](https://github.com/IBM/kui/commit/224c586)), closes [#4124](https://github.com/IBM/kui/issues/4124)
- **plugins/plugin-kubectl:** kubectl explain -h should render as usage in sidecar ([8e00c3f](https://github.com/IBM/kui/commit/8e00c3f)), closes [#4211](https://github.com/IBM/kui/issues/4211)
- **plugins/plugin-kubectl:** kubectl explain Overview tab not formatted as expected ([ffa9183](https://github.com/IBM/kui/commit/ffa9183)), closes [#4304](https://github.com/IBM/kui/issues/4304)
- **plugins/plugin-kubectl:** update deprecated import of uuid ([5de8d4d](https://github.com/IBM/kui/commit/5de8d4d)), closes [#4316](https://github.com/IBM/kui/issues/4316)
- eliminate complex nesting of NavResponse model ([e849ae7](https://github.com/IBM/kui/commit/e849ae7)), closes [#4205](https://github.com/IBM/kui/issues/4205)
- **plugins/plugin-kubectl:** firefox does not support the /s flag to RegExp ([5b661a6](https://github.com/IBM/kui/commit/5b661a6)), closes [#4206](https://github.com/IBM/kui/issues/4206)
- **plugins/plugin-kubectl:** kubectl top nodes can present "NaN" ([30df3dd](https://github.com/IBM/kui/commit/30df3dd)), closes [#4189](https://github.com/IBM/kui/issues/4189)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- kubectl summary Form TextInputs can be cropped ([3becaf9](https://github.com/IBM/kui/commit/3becaf9)), closes [#4077](https://github.com/IBM/kui/issues/4077)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- tekton Step nodes show with hashed background ([8428d72](https://github.com/IBM/kui/commit/8428d72)), closes [#4114](https://github.com/IBM/kui/issues/4114)
- the colors of status badges: Error, ImagePullBackOff and ErrImagePull are incorrect ([fd206f6](https://github.com/IBM/kui/commit/fd206f6)), closes [#4171](https://github.com/IBM/kui/issues/4171)
- **plugins/plugin-kubectl:** in kube namespace table, selected namespace should float to top ([f0e597f](https://github.com/IBM/kui/commit/f0e597f)), closes [#4129](https://github.com/IBM/kui/issues/4129)
- **plugins/plugin-kubectl:** kubectl api-resources table shows 'unknown' in title ([0461710](https://github.com/IBM/kui/commit/0461710)), closes [#4145](https://github.com/IBM/kui/issues/4145)
- **plugins/plugin-kubectl:** kubectl describe (--help) fails ([10b8e8a](https://github.com/IBM/kui/commit/10b8e8a)), closes [#4012](https://github.com/IBM/kui/issues/4012)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- **plugins/plugin-kubectl:** more refinements to Form layout heuristics ([e92327d](https://github.com/IBM/kui/commit/e92327d)), closes [#4118](https://github.com/IBM/kui/issues/4118)
- **plugins/plugin-kubectl:** oc describe fails ([4f4de4e](https://github.com/IBM/kui/commit/4f4de4e)), closes [#4008](https://github.com/IBM/kui/issues/4008)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- **plugins/plugin-kubectl:** watch table doesn't have breadcrumbs title ([43fbe6a](https://github.com/IBM/kui/commit/43fbe6a)), closes [#4135](https://github.com/IBM/kui/issues/4135)
- **plugins/plugin-kubectl:** watcher table disappears when kui is launched as kubectl plugin ([167eabc](https://github.com/IBM/kui/commit/167eabc)), closes [#4120](https://github.com/IBM/kui/issues/4120) [#4123](https://github.com/IBM/kui/issues/4123)
- **plugins/plugin-kubectl:** we shouldn't render namespace widget when the namespace is empty in kube config ([98a9406](https://github.com/IBM/kui/commit/98a9406)), closes [#4274](https://github.com/IBM/kui/issues/4274)
- ensure kubectl Delete toolbar button appears at far right ([9eb3079](https://github.com/IBM/kui/commit/9eb3079)), closes [#4116](https://github.com/IBM/kui/issues/4116)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)

### Features

- add button to WatchPane to show table back in terminal ([dc22591](https://github.com/IBM/kui/commit/dc22591)), closes [#4530](https://github.com/IBM/kui/issues/4530)
- add capability to show welcome widget to new users in Terminal ([0c33e6e](https://github.com/IBM/kui/commit/0c33e6e)), closes [#4990](https://github.com/IBM/kui/issues/4990) [#5007](https://github.com/IBM/kui/issues/5007)
- add isSelected and Divider to log container selection menu ([59bdaa5](https://github.com/IBM/kui/commit/59bdaa5)), closes [#4647](https://github.com/IBM/kui/issues/4647)
- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Patternfly Breadcrumb support ([91e0504](https://github.com/IBM/kui/commit/91e0504)), closes [#4381](https://github.com/IBM/kui/issues/4381)
- add Retry button to sidecar toolbar when log streaming stopped abnormally ([47872f4](https://github.com/IBM/kui/commit/47872f4)), closes [#4755](https://github.com/IBM/kui/issues/4755)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add Stop Watching capability to WatchPane ([09043c1](https://github.com/IBM/kui/commit/09043c1)), closes [#4554](https://github.com/IBM/kui/issues/4554)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- allow users to select container in kubectl Logs ([f4304c5](https://github.com/IBM/kui/commit/f4304c5)), closes [#4627](https://github.com/IBM/kui/issues/4627)
- clicking on events in watch table should drill down to events ([c6dc99f](https://github.com/IBM/kui/commit/c6dc99f)), closes [#5173](https://github.com/IBM/kui/issues/5173)
- commands should be able to separate resource model fetch from view transformation functions ([e903bc7](https://github.com/IBM/kui/commit/e903bc7)), closes [#4437](https://github.com/IBM/kui/issues/4437)
- ibmcloud plugin ([aa0f72f](https://github.com/IBM/kui/commit/aa0f72f)), closes [#4353](https://github.com/IBM/kui/issues/4353)
- improve kubectl edit experience ([4c4a1c9](https://github.com/IBM/kui/commit/4c4a1c9)), closes [#4783](https://github.com/IBM/kui/issues/4783)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- improve rendering of kubectl subcommand help ([e36ed29](https://github.com/IBM/kui/commit/e36ed29)), closes [#4824](https://github.com/IBM/kui/issues/4824)
- initial odo catalog list enhancements ([8534267](https://github.com/IBM/kui/commit/8534267)), closes [#4485](https://github.com/IBM/kui/issues/4485)
- kubectl apply view-last-applied ([6d601ef](https://github.com/IBM/kui/commit/6d601ef)), closes [#4822](https://github.com/IBM/kui/issues/4822)
- kubectl edit via kui's editor ([414e813](https://github.com/IBM/kui/commit/414e813)), closes [#762](https://github.com/IBM/kui/issues/762)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- line highlights on editor save, used for k edit apply errors ([3efa6a5](https://github.com/IBM/kui/commit/3efa6a5)), closes [#4795](https://github.com/IBM/kui/issues/4795)
- MiniSplits ([70b8441](https://github.com/IBM/kui/commit/70b8441)), closes [#5112](https://github.com/IBM/kui/issues/5112)
- only enable WatchPane based on a feature flag ([eb80d0e](https://github.com/IBM/kui/commit/eb80d0e)), closes [#4678](https://github.com/IBM/kui/issues/4678) [#4604](https://github.com/IBM/kui/issues/4604)
- patternfly4 themes ([5f58f71](https://github.com/IBM/kui/commit/5f58f71)), closes [#4364](https://github.com/IBM/kui/issues/4364)
- pin a watchable terminal response in a split pane ([662f413](https://github.com/IBM/kui/commit/662f413)), closes [#4865](https://github.com/IBM/kui/issues/4865) [#4573](https://github.com/IBM/kui/issues/4573) [#4885](https://github.com/IBM/kui/issues/4885) [#4894](https://github.com/IBM/kui/issues/4894)
- port kubectl get ns to RadioTable ([be0eabf](https://github.com/IBM/kui/commit/be0eabf)), closes [#4510](https://github.com/IBM/kui/issues/4510) [#4511](https://github.com/IBM/kui/issues/4511)
- refine kubectl contexts table; add support for RadioTable row titles ([11bb074](https://github.com/IBM/kui/commit/11bb074)), closes [#5131](https://github.com/IBM/kui/issues/5131)
- show resource version in toolbar text ([1a6e335](https://github.com/IBM/kui/commit/1a6e335)), closes [#4790](https://github.com/IBM/kui/issues/4790)
- split screen Terminal ([3a6b422](https://github.com/IBM/kui/commit/3a6b422)), closes [#4814](https://github.com/IBM/kui/issues/4814) [#4821](https://github.com/IBM/kui/issues/4821)
- support for events in crud table footer ([0b90ead](https://github.com/IBM/kui/commit/0b90ead)), closes [#5125](https://github.com/IBM/kui/issues/5125)
- support for events in table footer ([51669af](https://github.com/IBM/kui/commit/51669af)), closes [#5115](https://github.com/IBM/kui/issues/5115)
- **plugins/plugin-kubectl:** add Show Node button for kubectl pods ([04e29d2](https://github.com/IBM/kui/commit/04e29d2)), closes [#4214](https://github.com/IBM/kui/issues/4214)
- **plugins/plugin-kubectl:** add support for kustomize apply/delete/create ([b95cbdb](https://github.com/IBM/kui/commit/b95cbdb)), closes [#4203](https://github.com/IBM/kui/issues/4203)
- **plugins/plugin-kubectl:** configmap summary should show data ([50c7e10](https://github.com/IBM/kui/commit/50c7e10)), closes [#4025](https://github.com/IBM/kui/issues/4025)
- **plugins/plugin-kubectl:** enhance odo project list as RadioTable ([62272e6](https://github.com/IBM/kui/commit/62272e6)), closes [#4517](https://github.com/IBM/kui/issues/4517)
- **plugins/plugin-kubectl:** improve odo usage experience ([639ca32](https://github.com/IBM/kui/commit/639ca32)), closes [#4345](https://github.com/IBM/kui/issues/4345)
- **plugins/plugin-kubectl:** kubectl events tab ([2d71f24](https://github.com/IBM/kui/commit/2d71f24)), closes [#4706](https://github.com/IBM/kui/issues/4706)
- **plugins/plugin-kubectl:** namespace onclick should drill down to sidecar ([e74f66d](https://github.com/IBM/kui/commit/e74f66d)), closes [#4714](https://github.com/IBM/kui/issues/4714)
- **plugins/plugin-kubectl:** optimize rendering of kubectl Summary tab ([7c6480d](https://github.com/IBM/kui/commit/7c6480d)), closes [#4725](https://github.com/IBM/kui/issues/4725)
- **plugins/plugin-kubectl:** optimizing Node summary impl ([8ac11b9](https://github.com/IBM/kui/commit/8ac11b9)), closes [#4833](https://github.com/IBM/kui/issues/4833)
- **plugins/plugin-kubectl:** Show Previous option for Logs tab ([2307d2f](https://github.com/IBM/kui/commit/2307d2f)), closes [#4864](https://github.com/IBM/kui/issues/4864)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- simplified co-hosting of client and proxy in a container ([00af4b4](https://github.com/IBM/kui/commit/00af4b4)), closes [#4213](https://github.com/IBM/kui/issues/4213)
- SPI for icons ([3d034e3](https://github.com/IBM/kui/commit/3d034e3)), closes [#4441](https://github.com/IBM/kui/issues/4441) [#4364](https://github.com/IBM/kui/issues/4364)
- target kubectl logs and kubectl exec to Logs and Terminal tabs ([409e632](https://github.com/IBM/kui/commit/409e632)), closes [#4762](https://github.com/IBM/kui/issues/4762)
- **plugins/plugin-kubectl:** Terminal tab for Pod kubernetes resources ([c47e432](https://github.com/IBM/kui/commit/c47e432)), closes [#4639](https://github.com/IBM/kui/issues/4639)
- top tab buttons ([ff8cfba](https://github.com/IBM/kui/commit/ff8cfba)), closes [#4434](https://github.com/IBM/kui/issues/4434)
- watcher panel for open-ended watch jobs ([6dfe7df](https://github.com/IBM/kui/commit/6dfe7df)), closes [#4503](https://github.com/IBM/kui/issues/4503)
- **plugins/plugin-kubectl:** port kubectl contexts table to RadioTable ([3cb4dcb](https://github.com/IBM/kui/commit/3cb4dcb)), closes [#4513](https://github.com/IBM/kui/issues/4513)
- **plugins/plugin-kubectl:** ReplicaSet should have Pods tab ([42cd286](https://github.com/IBM/kui/commit/42cd286)), closes [#4110](https://github.com/IBM/kui/issues/4110)
- **plugins/plugin-kubectl:** restore Show Logs button for kubectl ([6b17dbd](https://github.com/IBM/kui/commit/6b17dbd)), closes [#4089](https://github.com/IBM/kui/issues/4089)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)

### BREAKING CHANGES

- removes support for inBrowserOk

# [8.10.0](https://github.com/IBM/kui/compare/v4.5.0...v8.10.0) (2020-06-17)

### Bug Fixes

- avoid using kui-custom command for switching kubectl namespace ([43863f2](https://github.com/IBM/kui/commit/43863f2)), closes [#4806](https://github.com/IBM/kui/issues/4806)
- don't blink yellow forever for kubectl events ([a59ee86](https://github.com/IBM/kui/commit/a59ee86)), closes [#4869](https://github.com/IBM/kui/issues/4869)
- empty watch tables/grids should show 'No resources' ([c0bfe99](https://github.com/IBM/kui/commit/c0bfe99)), closes [#4884](https://github.com/IBM/kui/issues/4884)
- improve hover effect for status stripe buttons ([50ced8f](https://github.com/IBM/kui/commit/50ced8f)), closes [#4896](https://github.com/IBM/kui/issues/4896)
- **plugins/plugin-kubectl:** get-namespace table sometimes doens't show the correct selected namespace ([af66aa4](https://github.com/IBM/kui/commit/af66aa4)), closes [#4812](https://github.com/IBM/kui/issues/4812)
- **plugins/plugin-kubectl:** kubectl apply set-last-applied does not work ([9553907](https://github.com/IBM/kui/commit/9553907)), closes [#4844](https://github.com/IBM/kui/issues/4844)
- **plugins/plugin-kubectl:** kubectl logs -l with no matches yields internal error ([ed0374f](https://github.com/IBM/kui/commit/ed0374f)), closes [#4811](https://github.com/IBM/kui/issues/4811)
- **plugins/plugin-kubectl:** kubectl watch tables may lack namespace breadcrumb ([a0616c2](https://github.com/IBM/kui/commit/a0616c2)), closes [#4870](https://github.com/IBM/kui/issues/4870)
- pexecs serviced by now-removed splits fail ([f6176a1](https://github.com/IBM/kui/commit/f6176a1)), closes [#4875](https://github.com/IBM/kui/issues/4875)
- **plugins/plugin-kubectl:** kubectl apply edit-last-applied freezes in kui ([24a67da](https://github.com/IBM/kui/commit/24a67da)), closes [#4808](https://github.com/IBM/kui/issues/4808)
- **plugins/plugin-kubectl:** Logs tab should have a default tail limit ([d4cf08c](https://github.com/IBM/kui/commit/d4cf08c)), closes [#4810](https://github.com/IBM/kui/issues/4810) [#4818](https://github.com/IBM/kui/issues/4818)
- **plugins/plugin-kubectl:** oc get projects does not allow user selection ([3749371](https://github.com/IBM/kui/commit/3749371)), closes [#4805](https://github.com/IBM/kui/issues/4805)
- allow user to disable table title by feature flags, and disable table pagination ([5450512](https://github.com/IBM/kui/commit/5450512)), closes [#4640](https://github.com/IBM/kui/issues/4640) [#4655](https://github.com/IBM/kui/issues/4655)
- avoid recomputing tabs when switching back and forth ([cf5e41f](https://github.com/IBM/kui/commit/cf5e41f)), closes [#4666](https://github.com/IBM/kui/issues/4666)
- container filter of logs tab shows accumulated logs from previous selection ([08903b4](https://github.com/IBM/kui/commit/08903b4)), closes [#4644](https://github.com/IBM/kui/issues/4644) [#4658](https://github.com/IBM/kui/issues/4658)
- eliminate assumptions that "default" is the default kube namespace ([4eb392d](https://github.com/IBM/kui/commit/4eb392d)), closes [#4764](https://github.com/IBM/kui/issues/4764)
- improve error reporting for kubectl apply ([fe21671](https://github.com/IBM/kui/commit/fe21671)), closes [#4605](https://github.com/IBM/kui/issues/4605)
- Input element throws react error ([e6bb21b](https://github.com/IBM/kui/commit/e6bb21b)), closes [#4765](https://github.com/IBM/kui/issues/4765)
- kubectl api-resources has duplicate rows and odd pagination behavior ([e740270](https://github.com/IBM/kui/commit/e740270)), closes [#4626](https://github.com/IBM/kui/issues/4626)
- kubectl edit apply twice does not work ([1976134](https://github.com/IBM/kui/commit/1976134)), closes [#4797](https://github.com/IBM/kui/issues/4797)
- kubectl edit in sidecar doesn't show success message when a resource is applied ([cc59503](https://github.com/IBM/kui/commit/cc59503)), closes [#4691](https://github.com/IBM/kui/issues/4691)
- kubectl top node should show % text ([f861b76](https://github.com/IBM/kui/commit/f861b76)), closes [#4598](https://github.com/IBM/kui/issues/4598)
- logs tab toolbar doesn't signify when pods are 404 ([135e1be](https://github.com/IBM/kui/commit/135e1be)), closes [#4646](https://github.com/IBM/kui/issues/4646)
- reduce No log data followed by log data behavior in kube logs ([e1c0624](https://github.com/IBM/kui/commit/e1c0624)), closes [#4624](https://github.com/IBM/kui/issues/4624)
- remove augmentModuleLoadPath API ([47dfcdf](https://github.com/IBM/kui/commit/47dfcdf)), closes [#4839](https://github.com/IBM/kui/issues/4839)
- sidecar toolbar can't due justice to longer error messages ([e67e0c9](https://github.com/IBM/kui/commit/e67e0c9)), closes [#4789](https://github.com/IBM/kui/issues/4789)
- summary tab is not read-only for kubectl edit command ([9f7ff82](https://github.com/IBM/kui/commit/9f7ff82)), closes [#4809](https://github.com/IBM/kui/issues/4809)
- **plugins/plugin-kubectl:** auto-pause logs when user scrolls ([94b85e6](https://github.com/IBM/kui/commit/94b85e6)), closes [#4668](https://github.com/IBM/kui/issues/4668)
- **plugins/plugin-kubectl:** automatically abort idle PTYs ([2638a65](https://github.com/IBM/kui/commit/2638a65)), closes [#4742](https://github.com/IBM/kui/issues/4742)
- **plugins/plugin-kubectl:** ExecIntoPod's terminal is not theme-aligned ([067cda3](https://github.com/IBM/kui/commit/067cda3)), closes [#4722](https://github.com/IBM/kui/issues/4722)
- **plugins/plugin-kubectl:** helm help parsed usage incorrectly ([b222da2](https://github.com/IBM/kui/commit/b222da2)), closes [#4692](https://github.com/IBM/kui/issues/4692)
- **plugins/plugin-kubectl:** i18n for No log data message ([589a4cd](https://github.com/IBM/kui/commit/589a4cd)), closes [#4656](https://github.com/IBM/kui/issues/4656)
- **plugins/plugin-kubectl:** ImagePullBackoff should be considered a "red" state ([198100d](https://github.com/IBM/kui/commit/198100d)), closes [#4734](https://github.com/IBM/kui/issues/4734)
- **plugins/plugin-kubectl:** improve kubectl tab completion ([734f9e5](https://github.com/IBM/kui/commit/734f9e5)), closes [#4704](https://github.com/IBM/kui/issues/4704)
- **plugins/plugin-kubectl:** inconsistent capitalization of breadcrumbs ([963b166](https://github.com/IBM/kui/commit/963b166)), closes [#4607](https://github.com/IBM/kui/issues/4607)
- **plugins/plugin-kubectl:** k edit -h does not open in sidecar ([b6f68f8](https://github.com/IBM/kui/commit/b6f68f8)), closes [#4661](https://github.com/IBM/kui/issues/4661)
- **plugins/plugin-kubectl:** kubectl create secret hangs yellow ([e11dbb8](https://github.com/IBM/kui/commit/e11dbb8)), closes [#4571](https://github.com/IBM/kui/issues/4571)
- **plugins/plugin-kubectl:** kubectl get --all-namespaces --watch does not update ([663a972](https://github.com/IBM/kui/commit/663a972)), closes [#4581](https://github.com/IBM/kui/issues/4581)
- **plugins/plugin-kubectl:** kubectl logs tab has bad interleaving and cpu issues ([1c7cf17](https://github.com/IBM/kui/commit/1c7cf17)), closes [#4664](https://github.com/IBM/kui/issues/4664) [#4665](https://github.com/IBM/kui/issues/4665)
- **plugins/plugin-kubectl:** kubectl Show Events query not precise enough ([eda6b38](https://github.com/IBM/kui/commit/eda6b38)), closes [#4572](https://github.com/IBM/kui/issues/4572)
- **plugins/plugin-kubectl:** remove kubectl edit cancel button ([83179e8](https://github.com/IBM/kui/commit/83179e8)), closes [#4695](https://github.com/IBM/kui/issues/4695)
- **plugins/plugin-kubectl:** revert to editor-based Summary tab ([3ecd638](https://github.com/IBM/kui/commit/3ecd638)), closes [#4594](https://github.com/IBM/kui/issues/4594)
- **plugins/plugin-kubectl:** status shows as Containercreating when it should be ContainerCreating ([2c4a3b6](https://github.com/IBM/kui/commit/2c4a3b6)), closes [#4798](https://github.com/IBM/kui/issues/4798)
- **plugins/plugin-kubectl:** Terminal tab test incorrectly verifies k exec output ([20ab362](https://github.com/IBM/kui/commit/20ab362)), closes [#4802](https://github.com/IBM/kui/issues/4802)
- kubectl Logs tab should use an xterm ([9aa0176](https://github.com/IBM/kui/commit/9aa0176)), closes [#4750](https://github.com/IBM/kui/issues/4750) [#4747](https://github.com/IBM/kui/issues/4747)
- place namespace breadcrumb first ([5d3b2e4](https://github.com/IBM/kui/commit/5d3b2e4)), closes [#4699](https://github.com/IBM/kui/issues/4699)
- replace Containers with Logs tab ([00e8786](https://github.com/IBM/kui/commit/00e8786)), closes [#4603](https://github.com/IBM/kui/issues/4603)
- the Logs/Terminal retry button should be visible on any exit code ([3366327](https://github.com/IBM/kui/commit/3366327)), closes [#4769](https://github.com/IBM/kui/issues/4769)
- TopNavSidecar tabs should auto-pause and auto-focus when switching ([2b00dd9](https://github.com/IBM/kui/commit/2b00dd9)), closes [#4741](https://github.com/IBM/kui/issues/4741) [#4748](https://github.com/IBM/kui/issues/4748)
- **plugins/plugin-kubectl:** improve kubectl top node display with open sidecar ([6f99581](https://github.com/IBM/kui/commit/6f99581)), closes [#4737](https://github.com/IBM/kui/issues/4737)
- **plugins/plugin-kubectl:** k edit deploy has mysterious Pod tab ([914df36](https://github.com/IBM/kui/commit/914df36)), closes [#4703](https://github.com/IBM/kui/issues/4703)
- **plugins/plugin-kubectl:** kubectl api-resources table should hide APIGROUP column with open sidecar ([ee347fa](https://github.com/IBM/kui/commit/ee347fa)), closes [#4728](https://github.com/IBM/kui/issues/4728)
- **plugins/plugin-kubectl:** remove Conditions tab ([eac3705](https://github.com/IBM/kui/commit/eac3705)), closes [#4606](https://github.com/IBM/kui/issues/4606)
- **plugins/plugin-kubectl:** remove Show Logs registration ([382c685](https://github.com/IBM/kui/commit/382c685)), closes [#4603](https://github.com/IBM/kui/issues/4603)
- PaginatedTable fails at distinguishing the rowKeys of `k get --all-namespaces` table ([6658729](https://github.com/IBM/kui/commit/6658729)), closes [#4579](https://github.com/IBM/kui/issues/4579)
- **plugins/plugin-kubectl:** add missing test for get with not found ([3e77689](https://github.com/IBM/kui/commit/3e77689)), closes [#4492](https://github.com/IBM/kui/issues/4492)
- **plugins/plugin-kubectl:** cache kind canonicalization lookup ([e351a5f](https://github.com/IBM/kui/commit/e351a5f)), closes [#4489](https://github.com/IBM/kui/issues/4489)
- **plugins/plugin-kubectl:** k get events -w bombs ([20c2caf](https://github.com/IBM/kui/commit/20c2caf)), closes [#4557](https://github.com/IBM/kui/issues/4557)
- **plugins/plugin-kubectl:** kubectl describe -h has old bold text ([b31d066](https://github.com/IBM/kui/commit/b31d066)), closes [#4568](https://github.com/IBM/kui/issues/4568)
- add support for hiding elements at higher zoom levels ([7d2a7e0](https://github.com/IBM/kui/commit/7d2a7e0)), closes [#4232](https://github.com/IBM/kui/issues/4232)
- clicking on container name in details sidecar should add -c to logs command ([61c7c08](https://github.com/IBM/kui/commit/61c7c08)), closes [#4498](https://github.com/IBM/kui/issues/4498)
- **plugins/plugin-kubectl:** kubectl edit should support editing a list of resources ([4cd4d43](https://github.com/IBM/kui/commit/4cd4d43)), closes [#4555](https://github.com/IBM/kui/issues/4555)
- eliminate complex nesting of NavResponse model ([e849ae7](https://github.com/IBM/kui/commit/e849ae7)), closes [#4205](https://github.com/IBM/kui/issues/4205)
- ibmcloud plugin list does not list unofficial plugins ([303fa00](https://github.com/IBM/kui/commit/303fa00)), closes [#4339](https://github.com/IBM/kui/issues/4339)
- make inBrowserOk the default ([2a3c811](https://github.com/IBM/kui/commit/2a3c811)), closes [#4275](https://github.com/IBM/kui/issues/4275)
- multiple kubectl help/usage bugs ([ebba36e](https://github.com/IBM/kui/commit/ebba36e)), closes [#4342](https://github.com/IBM/kui/issues/4342)
- multiple tab completion bugs ([5513712](https://github.com/IBM/kui/commit/5513712)), closes [#4281](https://github.com/IBM/kui/issues/4281)
- optimize kubectl watch load on apiserver ([3f7a32f](https://github.com/IBM/kui/commit/3f7a32f)), closes [#4494](https://github.com/IBM/kui/issues/4494)
- the colors of status badges: Error, ImagePullBackOff and ErrImagePull are incorrect ([fd206f6](https://github.com/IBM/kui/commit/fd206f6)), closes [#4171](https://github.com/IBM/kui/issues/4171)
- TopNavSidecar does not always show updates ([251e5c4](https://github.com/IBM/kui/commit/251e5c4)), closes [#4524](https://github.com/IBM/kui/issues/4524)
- **plugin-kubectl:** k get pods --all-namespaces has a title with "default" as the namespace ([2f95129](https://github.com/IBM/kui/commit/2f95129)), closes [#4466](https://github.com/IBM/kui/issues/4466)
- **plugin-kubectl:** kubectl get error-type -w doesn't fail fast ([4ccb733](https://github.com/IBM/kui/commit/4ccb733)), closes [#4491](https://github.com/IBM/kui/issues/4491)
- **plugins/plugin-kubectl:** avoid use of /s regexp ([9468304](https://github.com/IBM/kui/commit/9468304)), closes [#4259](https://github.com/IBM/kui/issues/4259)
- **plugins/plugin-kubectl:** CurrentContext widget shows "default" for openshift clusters ([59712c0](https://github.com/IBM/kui/commit/59712c0)), closes [#4347](https://github.com/IBM/kui/issues/4347)
- **plugins/plugin-kubectl:** firefox does not support the /s flag to RegExp ([5b661a6](https://github.com/IBM/kui/commit/5b661a6)), closes [#4206](https://github.com/IBM/kui/issues/4206)
- **plugins/plugin-kubectl:** in kube namespace table, selected namespace should float to top ([f0e597f](https://github.com/IBM/kui/commit/f0e597f)), closes [#4129](https://github.com/IBM/kui/issues/4129)
- **plugins/plugin-kubectl:** kubectl api-resources table shows 'unknown' in title ([0461710](https://github.com/IBM/kui/commit/0461710)), closes [#4145](https://github.com/IBM/kui/issues/4145)
- **plugins/plugin-kubectl:** kubectl describe (--help) fails ([10b8e8a](https://github.com/IBM/kui/commit/10b8e8a)), closes [#4012](https://github.com/IBM/kui/issues/4012)
- **plugins/plugin-kubectl:** kubectl explain -h should render as usage in sidecar ([8e00c3f](https://github.com/IBM/kui/commit/8e00c3f)), closes [#4211](https://github.com/IBM/kui/issues/4211)
- **plugins/plugin-kubectl:** kubectl explain Overview tab not formatted as expected ([ffa9183](https://github.com/IBM/kui/commit/ffa9183)), closes [#4304](https://github.com/IBM/kui/issues/4304)
- **plugins/plugin-kubectl:** kubectl get table with mix of existing and non-existing ([8d98d15](https://github.com/IBM/kui/commit/8d98d15)), closes [#4492](https://github.com/IBM/kui/issues/4492)
- clicking on certain links in kubectl help result in odd behavior ([035894b](https://github.com/IBM/kui/commit/035894b)), closes [#4473](https://github.com/IBM/kui/issues/4473)
- ensure kubectl Delete toolbar button appears at far right ([9eb3079](https://github.com/IBM/kui/commit/9eb3079)), closes [#4116](https://github.com/IBM/kui/issues/4116)
- sidecar views do not respect tab-specificity ([5a1cae2](https://github.com/IBM/kui/commit/5a1cae2)), closes [#4362](https://github.com/IBM/kui/issues/4362)
- **plugins/plugin-kubectl:** ensure Show Owner button appears near end of toolbar buttons ([224c586](https://github.com/IBM/kui/commit/224c586)), closes [#4124](https://github.com/IBM/kui/issues/4124)
- **plugins/plugin-kubectl:** kubectl top nodes can present "NaN" ([30df3dd](https://github.com/IBM/kui/commit/30df3dd)), closes [#4189](https://github.com/IBM/kui/issues/4189)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- **plugins/plugin-kubectl:** more refinements to Form layout heuristics ([e92327d](https://github.com/IBM/kui/commit/e92327d)), closes [#4118](https://github.com/IBM/kui/issues/4118)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- **plugins/plugin-kubectl:** update deprecated import of uuid ([5de8d4d](https://github.com/IBM/kui/commit/5de8d4d)), closes [#4316](https://github.com/IBM/kui/issues/4316)
- **plugins/plugin-kubectl:** watch table doesn't have breadcrumbs title ([43fbe6a](https://github.com/IBM/kui/commit/43fbe6a)), closes [#4135](https://github.com/IBM/kui/issues/4135)
- **plugins/plugin-kubectl:** watcher table disappears when kui is launched as kubectl plugin ([167eabc](https://github.com/IBM/kui/commit/167eabc)), closes [#4120](https://github.com/IBM/kui/issues/4120) [#4123](https://github.com/IBM/kui/issues/4123)
- **plugins/plugin-kubectl:** we shouldn't render namespace widget when the namespace is empty in kube config ([98a9406](https://github.com/IBM/kui/commit/98a9406)), closes [#4274](https://github.com/IBM/kui/issues/4274)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- kubectl summary Form TextInputs can be cropped ([3becaf9](https://github.com/IBM/kui/commit/3becaf9)), closes [#4077](https://github.com/IBM/kui/issues/4077)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- tekton Step nodes show with hashed background ([8428d72](https://github.com/IBM/kui/commit/8428d72)), closes [#4114](https://github.com/IBM/kui/issues/4114)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)
- **plugins/plugin-kubectl:** oc describe fails ([4f4de4e](https://github.com/IBM/kui/commit/4f4de4e)), closes [#4008](https://github.com/IBM/kui/issues/4008)

### Features

- pin a watchable terminal response in a split pane ([662f413](https://github.com/IBM/kui/commit/662f413)), closes [#4865](https://github.com/IBM/kui/issues/4865) [#4573](https://github.com/IBM/kui/issues/4573) [#4885](https://github.com/IBM/kui/issues/4885) [#4894](https://github.com/IBM/kui/issues/4894)
- **plugins/plugin-kubectl:** Show Previous option for Logs tab ([2307d2f](https://github.com/IBM/kui/commit/2307d2f)), closes [#4864](https://github.com/IBM/kui/issues/4864)
- add button to WatchPane to show table back in terminal ([dc22591](https://github.com/IBM/kui/commit/dc22591)), closes [#4530](https://github.com/IBM/kui/issues/4530)
- add isSelected and Divider to log container selection menu ([59bdaa5](https://github.com/IBM/kui/commit/59bdaa5)), closes [#4647](https://github.com/IBM/kui/issues/4647)
- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Patternfly Breadcrumb support ([91e0504](https://github.com/IBM/kui/commit/91e0504)), closes [#4381](https://github.com/IBM/kui/issues/4381)
- add Retry button to sidecar toolbar when log streaming stopped abnormally ([47872f4](https://github.com/IBM/kui/commit/47872f4)), closes [#4755](https://github.com/IBM/kui/issues/4755)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add Stop Watching capability to WatchPane ([09043c1](https://github.com/IBM/kui/commit/09043c1)), closes [#4554](https://github.com/IBM/kui/issues/4554)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- allow users to select container in kubectl Logs ([f4304c5](https://github.com/IBM/kui/commit/f4304c5)), closes [#4627](https://github.com/IBM/kui/issues/4627)
- commands should be able to separate resource model fetch from view transformation functions ([e903bc7](https://github.com/IBM/kui/commit/e903bc7)), closes [#4437](https://github.com/IBM/kui/issues/4437)
- ibmcloud plugin ([aa0f72f](https://github.com/IBM/kui/commit/aa0f72f)), closes [#4353](https://github.com/IBM/kui/issues/4353)
- improve kubectl edit experience ([4c4a1c9](https://github.com/IBM/kui/commit/4c4a1c9)), closes [#4783](https://github.com/IBM/kui/issues/4783)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- improve rendering of kubectl subcommand help ([e36ed29](https://github.com/IBM/kui/commit/e36ed29)), closes [#4824](https://github.com/IBM/kui/issues/4824)
- initial odo catalog list enhancements ([8534267](https://github.com/IBM/kui/commit/8534267)), closes [#4485](https://github.com/IBM/kui/issues/4485)
- kubectl apply view-last-applied ([6d601ef](https://github.com/IBM/kui/commit/6d601ef)), closes [#4822](https://github.com/IBM/kui/issues/4822)
- kubectl edit via kui's editor ([414e813](https://github.com/IBM/kui/commit/414e813)), closes [#762](https://github.com/IBM/kui/issues/762)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- line highlights on editor save, used for k edit apply errors ([3efa6a5](https://github.com/IBM/kui/commit/3efa6a5)), closes [#4795](https://github.com/IBM/kui/issues/4795)
- only enable WatchPane based on a feature flag ([eb80d0e](https://github.com/IBM/kui/commit/eb80d0e)), closes [#4678](https://github.com/IBM/kui/issues/4678) [#4604](https://github.com/IBM/kui/issues/4604)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- show resource version in toolbar text ([1a6e335](https://github.com/IBM/kui/commit/1a6e335)), closes [#4790](https://github.com/IBM/kui/issues/4790)
- split screen Terminal ([3a6b422](https://github.com/IBM/kui/commit/3a6b422)), closes [#4814](https://github.com/IBM/kui/issues/4814) [#4821](https://github.com/IBM/kui/issues/4821)
- **plugins/plugin-kubectl:** add Show Node button for kubectl pods ([04e29d2](https://github.com/IBM/kui/commit/04e29d2)), closes [#4214](https://github.com/IBM/kui/issues/4214)
- **plugins/plugin-kubectl:** add support for kustomize apply/delete/create ([b95cbdb](https://github.com/IBM/kui/commit/b95cbdb)), closes [#4203](https://github.com/IBM/kui/issues/4203)
- **plugins/plugin-kubectl:** configmap summary should show data ([50c7e10](https://github.com/IBM/kui/commit/50c7e10)), closes [#4025](https://github.com/IBM/kui/issues/4025)
- **plugins/plugin-kubectl:** improve odo usage experience ([639ca32](https://github.com/IBM/kui/commit/639ca32)), closes [#4345](https://github.com/IBM/kui/issues/4345)
- **plugins/plugin-kubectl:** kubectl events tab ([2d71f24](https://github.com/IBM/kui/commit/2d71f24)), closes [#4706](https://github.com/IBM/kui/issues/4706)
- **plugins/plugin-kubectl:** optimizing Node summary impl ([8ac11b9](https://github.com/IBM/kui/commit/8ac11b9)), closes [#4833](https://github.com/IBM/kui/issues/4833)
- target kubectl logs and kubectl exec to Logs and Terminal tabs ([409e632](https://github.com/IBM/kui/commit/409e632)), closes [#4762](https://github.com/IBM/kui/issues/4762)
- **plugins/plugin-kubectl:** enhance odo project list as RadioTable ([62272e6](https://github.com/IBM/kui/commit/62272e6)), closes [#4517](https://github.com/IBM/kui/issues/4517)
- **plugins/plugin-kubectl:** namespace onclick should drill down to sidecar ([e74f66d](https://github.com/IBM/kui/commit/e74f66d)), closes [#4714](https://github.com/IBM/kui/issues/4714)
- **plugins/plugin-kubectl:** optimize rendering of kubectl Summary tab ([7c6480d](https://github.com/IBM/kui/commit/7c6480d)), closes [#4725](https://github.com/IBM/kui/issues/4725)
- **plugins/plugin-kubectl:** port kubectl contexts table to RadioTable ([3cb4dcb](https://github.com/IBM/kui/commit/3cb4dcb)), closes [#4513](https://github.com/IBM/kui/issues/4513)
- **plugins/plugin-kubectl:** Terminal tab for Pod kubernetes resources ([c47e432](https://github.com/IBM/kui/commit/c47e432)), closes [#4639](https://github.com/IBM/kui/issues/4639)
- patternfly4 themes ([5f58f71](https://github.com/IBM/kui/commit/5f58f71)), closes [#4364](https://github.com/IBM/kui/issues/4364)
- port kubectl get ns to RadioTable ([be0eabf](https://github.com/IBM/kui/commit/be0eabf)), closes [#4510](https://github.com/IBM/kui/issues/4510) [#4511](https://github.com/IBM/kui/issues/4511)
- simplified co-hosting of client and proxy in a container ([00af4b4](https://github.com/IBM/kui/commit/00af4b4)), closes [#4213](https://github.com/IBM/kui/issues/4213)
- SPI for icons ([3d034e3](https://github.com/IBM/kui/commit/3d034e3)), closes [#4441](https://github.com/IBM/kui/issues/4441) [#4364](https://github.com/IBM/kui/issues/4364)
- top tab buttons ([ff8cfba](https://github.com/IBM/kui/commit/ff8cfba)), closes [#4434](https://github.com/IBM/kui/issues/4434)
- watcher panel for open-ended watch jobs ([6dfe7df](https://github.com/IBM/kui/commit/6dfe7df)), closes [#4503](https://github.com/IBM/kui/issues/4503)
- **plugins/plugin-kubectl:** ReplicaSet should have Pods tab ([42cd286](https://github.com/IBM/kui/commit/42cd286)), closes [#4110](https://github.com/IBM/kui/issues/4110)
- **plugins/plugin-kubectl:** restore Show Logs button for kubectl ([6b17dbd](https://github.com/IBM/kui/commit/6b17dbd)), closes [#4089](https://github.com/IBM/kui/issues/4089)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)

### BREAKING CHANGES

- removes support for inBrowserOk

# [8.9.0](https://github.com/IBM/kui/compare/v4.5.0...v8.9.0) (2020-06-09)

### Bug Fixes

- **plugins/plugin-kubectl:** k get events -w bombs ([20c2caf](https://github.com/IBM/kui/commit/20c2caf)), closes [#4557](https://github.com/IBM/kui/issues/4557)
- **plugins/plugin-kubectl:** kubectl apply edit-last-applied freezes in kui ([24a67da](https://github.com/IBM/kui/commit/24a67da)), closes [#4808](https://github.com/IBM/kui/issues/4808)
- **plugins/plugin-kubectl:** kubectl apply set-last-applied does not work ([9553907](https://github.com/IBM/kui/commit/9553907)), closes [#4844](https://github.com/IBM/kui/issues/4844)
- **plugins/plugin-kubectl:** oc get projects does not allow user selection ([3749371](https://github.com/IBM/kui/commit/3749371)), closes [#4805](https://github.com/IBM/kui/issues/4805)
- allow user to disable table title by feature flags, and disable table pagination ([5450512](https://github.com/IBM/kui/commit/5450512)), closes [#4640](https://github.com/IBM/kui/issues/4640) [#4655](https://github.com/IBM/kui/issues/4655)
- avoid using kui-custom command for switching kubectl namespace ([43863f2](https://github.com/IBM/kui/commit/43863f2)), closes [#4806](https://github.com/IBM/kui/issues/4806)
- clicking on container name in details sidecar should add -c to logs command ([61c7c08](https://github.com/IBM/kui/commit/61c7c08)), closes [#4498](https://github.com/IBM/kui/issues/4498)
- eliminate assumptions that "default" is the default kube namespace ([4eb392d](https://github.com/IBM/kui/commit/4eb392d)), closes [#4764](https://github.com/IBM/kui/issues/4764)
- Input element throws react error ([e6bb21b](https://github.com/IBM/kui/commit/e6bb21b)), closes [#4765](https://github.com/IBM/kui/issues/4765)
- kubectl edit apply twice does not work ([1976134](https://github.com/IBM/kui/commit/1976134)), closes [#4797](https://github.com/IBM/kui/issues/4797)
- kubectl edit in sidecar doesn't show success message when a resource is applied ([cc59503](https://github.com/IBM/kui/commit/cc59503)), closes [#4691](https://github.com/IBM/kui/issues/4691)
- kubectl Logs tab should use an xterm ([9aa0176](https://github.com/IBM/kui/commit/9aa0176)), closes [#4750](https://github.com/IBM/kui/issues/4750) [#4747](https://github.com/IBM/kui/issues/4747)
- remove augmentModuleLoadPath API ([47dfcdf](https://github.com/IBM/kui/commit/47dfcdf)), closes [#4839](https://github.com/IBM/kui/issues/4839)
- summary tab is not read-only for kubectl edit command ([9f7ff82](https://github.com/IBM/kui/commit/9f7ff82)), closes [#4809](https://github.com/IBM/kui/issues/4809)
- **plugin-kubectl:** k get pods --all-namespaces has a title with "default" as the namespace ([2f95129](https://github.com/IBM/kui/commit/2f95129)), closes [#4466](https://github.com/IBM/kui/issues/4466)
- **plugin-kubectl:** kubectl get error-type -w doesn't fail fast ([4ccb733](https://github.com/IBM/kui/commit/4ccb733)), closes [#4491](https://github.com/IBM/kui/issues/4491)
- **plugins/plugin-kubectl:** add missing test for get with not found ([3e77689](https://github.com/IBM/kui/commit/3e77689)), closes [#4492](https://github.com/IBM/kui/issues/4492)
- **plugins/plugin-kubectl:** auto-pause logs when user scrolls ([94b85e6](https://github.com/IBM/kui/commit/94b85e6)), closes [#4668](https://github.com/IBM/kui/issues/4668)
- **plugins/plugin-kubectl:** automatically abort idle PTYs ([2638a65](https://github.com/IBM/kui/commit/2638a65)), closes [#4742](https://github.com/IBM/kui/issues/4742)
- **plugins/plugin-kubectl:** cache kind canonicalization lookup ([e351a5f](https://github.com/IBM/kui/commit/e351a5f)), closes [#4489](https://github.com/IBM/kui/issues/4489)
- **plugins/plugin-kubectl:** CurrentContext widget shows "default" for openshift clusters ([59712c0](https://github.com/IBM/kui/commit/59712c0)), closes [#4347](https://github.com/IBM/kui/issues/4347)
- **plugins/plugin-kubectl:** ExecIntoPod's terminal is not theme-aligned ([067cda3](https://github.com/IBM/kui/commit/067cda3)), closes [#4722](https://github.com/IBM/kui/issues/4722)
- **plugins/plugin-kubectl:** get-namespace table sometimes doens't show the correct selected namespace ([af66aa4](https://github.com/IBM/kui/commit/af66aa4)), closes [#4812](https://github.com/IBM/kui/issues/4812)
- **plugins/plugin-kubectl:** helm help parsed usage incorrectly ([b222da2](https://github.com/IBM/kui/commit/b222da2)), closes [#4692](https://github.com/IBM/kui/issues/4692)
- **plugins/plugin-kubectl:** i18n for No log data message ([589a4cd](https://github.com/IBM/kui/commit/589a4cd)), closes [#4656](https://github.com/IBM/kui/issues/4656)
- **plugins/plugin-kubectl:** ImagePullBackoff should be considered a "red" state ([198100d](https://github.com/IBM/kui/commit/198100d)), closes [#4734](https://github.com/IBM/kui/issues/4734)
- **plugins/plugin-kubectl:** improve kubectl tab completion ([734f9e5](https://github.com/IBM/kui/commit/734f9e5)), closes [#4704](https://github.com/IBM/kui/issues/4704)
- **plugins/plugin-kubectl:** improve kubectl top node display with open sidecar ([6f99581](https://github.com/IBM/kui/commit/6f99581)), closes [#4737](https://github.com/IBM/kui/issues/4737)
- **plugins/plugin-kubectl:** inconsistent capitalization of breadcrumbs ([963b166](https://github.com/IBM/kui/commit/963b166)), closes [#4607](https://github.com/IBM/kui/issues/4607)
- **plugins/plugin-kubectl:** k edit deploy has mysterious Pod tab ([914df36](https://github.com/IBM/kui/commit/914df36)), closes [#4703](https://github.com/IBM/kui/issues/4703)
- **plugins/plugin-kubectl:** kubectl api-resources table should hide APIGROUP column with open sidecar ([ee347fa](https://github.com/IBM/kui/commit/ee347fa)), closes [#4728](https://github.com/IBM/kui/issues/4728)
- **plugins/plugin-kubectl:** kubectl describe -h has old bold text ([b31d066](https://github.com/IBM/kui/commit/b31d066)), closes [#4568](https://github.com/IBM/kui/issues/4568)
- **plugins/plugin-kubectl:** kubectl edit should support editing a list of resources ([4cd4d43](https://github.com/IBM/kui/commit/4cd4d43)), closes [#4555](https://github.com/IBM/kui/issues/4555)
- **plugins/plugin-kubectl:** kubectl get --all-namespaces --watch does not update ([663a972](https://github.com/IBM/kui/commit/663a972)), closes [#4581](https://github.com/IBM/kui/issues/4581)
- **plugins/plugin-kubectl:** kubectl logs -l with no matches yields internal error ([ed0374f](https://github.com/IBM/kui/commit/ed0374f)), closes [#4811](https://github.com/IBM/kui/issues/4811)
- **plugins/plugin-kubectl:** Logs tab should have a default tail limit ([d4cf08c](https://github.com/IBM/kui/commit/d4cf08c)), closes [#4810](https://github.com/IBM/kui/issues/4810) [#4818](https://github.com/IBM/kui/issues/4818)
- **plugins/plugin-kubectl:** Terminal tab test incorrectly verifies k exec output ([20ab362](https://github.com/IBM/kui/commit/20ab362)), closes [#4802](https://github.com/IBM/kui/issues/4802)
- add support for hiding elements at higher zoom levels ([7d2a7e0](https://github.com/IBM/kui/commit/7d2a7e0)), closes [#4232](https://github.com/IBM/kui/issues/4232)
- avoid recomputing tabs when switching back and forth ([cf5e41f](https://github.com/IBM/kui/commit/cf5e41f)), closes [#4666](https://github.com/IBM/kui/issues/4666)
- clicking on certain links in kubectl help result in odd behavior ([035894b](https://github.com/IBM/kui/commit/035894b)), closes [#4473](https://github.com/IBM/kui/issues/4473)
- container filter of logs tab shows accumulated logs from previous selection ([08903b4](https://github.com/IBM/kui/commit/08903b4)), closes [#4644](https://github.com/IBM/kui/issues/4644) [#4658](https://github.com/IBM/kui/issues/4658)
- eliminate complex nesting of NavResponse model ([e849ae7](https://github.com/IBM/kui/commit/e849ae7)), closes [#4205](https://github.com/IBM/kui/issues/4205)
- ibmcloud plugin list does not list unofficial plugins ([303fa00](https://github.com/IBM/kui/commit/303fa00)), closes [#4339](https://github.com/IBM/kui/issues/4339)
- improve error reporting for kubectl apply ([fe21671](https://github.com/IBM/kui/commit/fe21671)), closes [#4605](https://github.com/IBM/kui/issues/4605)
- kubectl api-resources has duplicate rows and odd pagination behavior ([e740270](https://github.com/IBM/kui/commit/e740270)), closes [#4626](https://github.com/IBM/kui/issues/4626)
- logs tab toolbar doesn't signify when pods are 404 ([135e1be](https://github.com/IBM/kui/commit/135e1be)), closes [#4646](https://github.com/IBM/kui/issues/4646)
- make inBrowserOk the default ([2a3c811](https://github.com/IBM/kui/commit/2a3c811)), closes [#4275](https://github.com/IBM/kui/issues/4275)
- multiple kubectl help/usage bugs ([ebba36e](https://github.com/IBM/kui/commit/ebba36e)), closes [#4342](https://github.com/IBM/kui/issues/4342)
- optimize kubectl watch load on apiserver ([3f7a32f](https://github.com/IBM/kui/commit/3f7a32f)), closes [#4494](https://github.com/IBM/kui/issues/4494)
- sidecar toolbar can't due justice to longer error messages ([e67e0c9](https://github.com/IBM/kui/commit/e67e0c9)), closes [#4789](https://github.com/IBM/kui/issues/4789)
- **plugins/plugin-kubectl:** status shows as Containercreating when it should be ContainerCreating ([2c4a3b6](https://github.com/IBM/kui/commit/2c4a3b6)), closes [#4798](https://github.com/IBM/kui/issues/4798)
- PaginatedTable fails at distinguishing the rowKeys of `k get --all-namespaces` table ([6658729](https://github.com/IBM/kui/commit/6658729)), closes [#4579](https://github.com/IBM/kui/issues/4579)
- place namespace breadcrumb first ([5d3b2e4](https://github.com/IBM/kui/commit/5d3b2e4)), closes [#4699](https://github.com/IBM/kui/issues/4699)
- reduce No log data followed by log data behavior in kube logs ([e1c0624](https://github.com/IBM/kui/commit/e1c0624)), closes [#4624](https://github.com/IBM/kui/issues/4624)
- the Logs/Terminal retry button should be visible on any exit code ([3366327](https://github.com/IBM/kui/commit/3366327)), closes [#4769](https://github.com/IBM/kui/issues/4769)
- TopNavSidecar does not always show updates ([251e5c4](https://github.com/IBM/kui/commit/251e5c4)), closes [#4524](https://github.com/IBM/kui/issues/4524)
- TopNavSidecar tabs should auto-pause and auto-focus when switching ([2b00dd9](https://github.com/IBM/kui/commit/2b00dd9)), closes [#4741](https://github.com/IBM/kui/issues/4741) [#4748](https://github.com/IBM/kui/issues/4748)
- **plugins/plugin-kubectl:** avoid use of /s regexp ([9468304](https://github.com/IBM/kui/commit/9468304)), closes [#4259](https://github.com/IBM/kui/issues/4259)
- **plugins/plugin-kubectl:** ensure Show Owner button appears near end of toolbar buttons ([224c586](https://github.com/IBM/kui/commit/224c586)), closes [#4124](https://github.com/IBM/kui/issues/4124)
- **plugins/plugin-kubectl:** firefox does not support the /s flag to RegExp ([5b661a6](https://github.com/IBM/kui/commit/5b661a6)), closes [#4206](https://github.com/IBM/kui/issues/4206)
- **plugins/plugin-kubectl:** in kube namespace table, selected namespace should float to top ([f0e597f](https://github.com/IBM/kui/commit/f0e597f)), closes [#4129](https://github.com/IBM/kui/issues/4129)
- **plugins/plugin-kubectl:** k edit -h does not open in sidecar ([b6f68f8](https://github.com/IBM/kui/commit/b6f68f8)), closes [#4661](https://github.com/IBM/kui/issues/4661)
- **plugins/plugin-kubectl:** kubectl api-resources table shows 'unknown' in title ([0461710](https://github.com/IBM/kui/commit/0461710)), closes [#4145](https://github.com/IBM/kui/issues/4145)
- **plugins/plugin-kubectl:** kubectl create secret hangs yellow ([e11dbb8](https://github.com/IBM/kui/commit/e11dbb8)), closes [#4571](https://github.com/IBM/kui/issues/4571)
- **plugins/plugin-kubectl:** kubectl describe (--help) fails ([10b8e8a](https://github.com/IBM/kui/commit/10b8e8a)), closes [#4012](https://github.com/IBM/kui/issues/4012)
- **plugins/plugin-kubectl:** kubectl explain -h should render as usage in sidecar ([8e00c3f](https://github.com/IBM/kui/commit/8e00c3f)), closes [#4211](https://github.com/IBM/kui/issues/4211)
- **plugins/plugin-kubectl:** kubectl explain Overview tab not formatted as expected ([ffa9183](https://github.com/IBM/kui/commit/ffa9183)), closes [#4304](https://github.com/IBM/kui/issues/4304)
- **plugins/plugin-kubectl:** kubectl get table with mix of existing and non-existing ([8d98d15](https://github.com/IBM/kui/commit/8d98d15)), closes [#4492](https://github.com/IBM/kui/issues/4492)
- **plugins/plugin-kubectl:** kubectl logs tab has bad interleaving and cpu issues ([1c7cf17](https://github.com/IBM/kui/commit/1c7cf17)), closes [#4664](https://github.com/IBM/kui/issues/4664) [#4665](https://github.com/IBM/kui/issues/4665)
- **plugins/plugin-kubectl:** kubectl Show Events query not precise enough ([eda6b38](https://github.com/IBM/kui/commit/eda6b38)), closes [#4572](https://github.com/IBM/kui/issues/4572)
- **plugins/plugin-kubectl:** remove Conditions tab ([eac3705](https://github.com/IBM/kui/commit/eac3705)), closes [#4606](https://github.com/IBM/kui/issues/4606)
- **plugins/plugin-kubectl:** remove kubectl edit cancel button ([83179e8](https://github.com/IBM/kui/commit/83179e8)), closes [#4695](https://github.com/IBM/kui/issues/4695)
- **plugins/plugin-kubectl:** remove Show Logs registration ([382c685](https://github.com/IBM/kui/commit/382c685)), closes [#4603](https://github.com/IBM/kui/issues/4603)
- kubectl top node should show % text ([f861b76](https://github.com/IBM/kui/commit/f861b76)), closes [#4598](https://github.com/IBM/kui/issues/4598)
- replace Containers with Logs tab ([00e8786](https://github.com/IBM/kui/commit/00e8786)), closes [#4603](https://github.com/IBM/kui/issues/4603)
- sidecar views do not respect tab-specificity ([5a1cae2](https://github.com/IBM/kui/commit/5a1cae2)), closes [#4362](https://github.com/IBM/kui/issues/4362)
- **plugins/plugin-kubectl:** kubectl top nodes can present "NaN" ([30df3dd](https://github.com/IBM/kui/commit/30df3dd)), closes [#4189](https://github.com/IBM/kui/issues/4189)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- **plugins/plugin-kubectl:** more refinements to Form layout heuristics ([e92327d](https://github.com/IBM/kui/commit/e92327d)), closes [#4118](https://github.com/IBM/kui/issues/4118)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- **plugins/plugin-kubectl:** update deprecated import of uuid ([5de8d4d](https://github.com/IBM/kui/commit/5de8d4d)), closes [#4316](https://github.com/IBM/kui/issues/4316)
- **plugins/plugin-kubectl:** watch table doesn't have breadcrumbs title ([43fbe6a](https://github.com/IBM/kui/commit/43fbe6a)), closes [#4135](https://github.com/IBM/kui/issues/4135)
- **plugins/plugin-kubectl:** we shouldn't render namespace widget when the namespace is empty in kube config ([98a9406](https://github.com/IBM/kui/commit/98a9406)), closes [#4274](https://github.com/IBM/kui/issues/4274)
- ensure kubectl Delete toolbar button appears at far right ([9eb3079](https://github.com/IBM/kui/commit/9eb3079)), closes [#4116](https://github.com/IBM/kui/issues/4116)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- kubectl summary Form TextInputs can be cropped ([3becaf9](https://github.com/IBM/kui/commit/3becaf9)), closes [#4077](https://github.com/IBM/kui/issues/4077)
- multiple tab completion bugs ([5513712](https://github.com/IBM/kui/commit/5513712)), closes [#4281](https://github.com/IBM/kui/issues/4281)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- tekton Step nodes show with hashed background ([8428d72](https://github.com/IBM/kui/commit/8428d72)), closes [#4114](https://github.com/IBM/kui/issues/4114)
- the colors of status badges: Error, ImagePullBackOff and ErrImagePull are incorrect ([fd206f6](https://github.com/IBM/kui/commit/fd206f6)), closes [#4171](https://github.com/IBM/kui/issues/4171)
- **plugins/plugin-kubectl:** watcher table disappears when kui is launched as kubectl plugin ([167eabc](https://github.com/IBM/kui/commit/167eabc)), closes [#4120](https://github.com/IBM/kui/issues/4120) [#4123](https://github.com/IBM/kui/issues/4123)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)
- **plugins/plugin-kubectl:** oc describe fails ([4f4de4e](https://github.com/IBM/kui/commit/4f4de4e)), closes [#4008](https://github.com/IBM/kui/issues/4008)
- **plugins/plugin-kubectl:** revert to editor-based Summary tab ([3ecd638](https://github.com/IBM/kui/commit/3ecd638)), closes [#4594](https://github.com/IBM/kui/issues/4594)

### Features

- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Patternfly Breadcrumb support ([91e0504](https://github.com/IBM/kui/commit/91e0504)), closes [#4381](https://github.com/IBM/kui/issues/4381)
- add Retry button to sidecar toolbar when log streaming stopped abnormally ([47872f4](https://github.com/IBM/kui/commit/47872f4)), closes [#4755](https://github.com/IBM/kui/issues/4755)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add Stop Watching capability to WatchPane ([09043c1](https://github.com/IBM/kui/commit/09043c1)), closes [#4554](https://github.com/IBM/kui/issues/4554)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- commands should be able to separate resource model fetch from view transformation functions ([e903bc7](https://github.com/IBM/kui/commit/e903bc7)), closes [#4437](https://github.com/IBM/kui/issues/4437)
- ibmcloud plugin ([aa0f72f](https://github.com/IBM/kui/commit/aa0f72f)), closes [#4353](https://github.com/IBM/kui/issues/4353)
- improve kubectl edit experience ([4c4a1c9](https://github.com/IBM/kui/commit/4c4a1c9)), closes [#4783](https://github.com/IBM/kui/issues/4783)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- improve rendering of kubectl subcommand help ([e36ed29](https://github.com/IBM/kui/commit/e36ed29)), closes [#4824](https://github.com/IBM/kui/issues/4824)
- initial odo catalog list enhancements ([8534267](https://github.com/IBM/kui/commit/8534267)), closes [#4485](https://github.com/IBM/kui/issues/4485)
- kubectl apply view-last-applied ([6d601ef](https://github.com/IBM/kui/commit/6d601ef)), closes [#4822](https://github.com/IBM/kui/issues/4822)
- line highlights on editor save, used for k edit apply errors ([3efa6a5](https://github.com/IBM/kui/commit/3efa6a5)), closes [#4795](https://github.com/IBM/kui/issues/4795)
- split screen Terminal ([3a6b422](https://github.com/IBM/kui/commit/3a6b422)), closes [#4814](https://github.com/IBM/kui/issues/4814) [#4821](https://github.com/IBM/kui/issues/4821)
- **plugins/plugin-kubectl:** namespace onclick should drill down to sidecar ([e74f66d](https://github.com/IBM/kui/commit/e74f66d)), closes [#4714](https://github.com/IBM/kui/issues/4714)
- **plugins/plugin-kubectl:** optimizing Node summary impl ([8ac11b9](https://github.com/IBM/kui/commit/8ac11b9)), closes [#4833](https://github.com/IBM/kui/issues/4833)
- kubectl edit via kui's editor ([414e813](https://github.com/IBM/kui/commit/414e813)), closes [#762](https://github.com/IBM/kui/issues/762)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- patternfly4 themes ([5f58f71](https://github.com/IBM/kui/commit/5f58f71)), closes [#4364](https://github.com/IBM/kui/issues/4364)
- port kubectl get ns to RadioTable ([be0eabf](https://github.com/IBM/kui/commit/be0eabf)), closes [#4510](https://github.com/IBM/kui/issues/4510) [#4511](https://github.com/IBM/kui/issues/4511)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- show resource version in toolbar text ([1a6e335](https://github.com/IBM/kui/commit/1a6e335)), closes [#4790](https://github.com/IBM/kui/issues/4790)
- target kubectl logs and kubectl exec to Logs and Terminal tabs ([409e632](https://github.com/IBM/kui/commit/409e632)), closes [#4762](https://github.com/IBM/kui/issues/4762)
- **plugins/plugin-kubectl:** kubectl events tab ([2d71f24](https://github.com/IBM/kui/commit/2d71f24)), closes [#4706](https://github.com/IBM/kui/issues/4706)
- **plugins/plugin-kubectl:** optimize rendering of kubectl Summary tab ([7c6480d](https://github.com/IBM/kui/commit/7c6480d)), closes [#4725](https://github.com/IBM/kui/issues/4725)
- **plugins/plugin-kubectl:** Terminal tab for Pod kubernetes resources ([c47e432](https://github.com/IBM/kui/commit/c47e432)), closes [#4639](https://github.com/IBM/kui/issues/4639)
- add button to WatchPane to show table back in terminal ([dc22591](https://github.com/IBM/kui/commit/dc22591)), closes [#4530](https://github.com/IBM/kui/issues/4530)
- add isSelected and Divider to log container selection menu ([59bdaa5](https://github.com/IBM/kui/commit/59bdaa5)), closes [#4647](https://github.com/IBM/kui/issues/4647)
- allow users to select container in kubectl Logs ([f4304c5](https://github.com/IBM/kui/commit/f4304c5)), closes [#4627](https://github.com/IBM/kui/issues/4627)
- only enable WatchPane based on a feature flag ([eb80d0e](https://github.com/IBM/kui/commit/eb80d0e)), closes [#4678](https://github.com/IBM/kui/issues/4678) [#4604](https://github.com/IBM/kui/issues/4604)
- SPI for icons ([3d034e3](https://github.com/IBM/kui/commit/3d034e3)), closes [#4441](https://github.com/IBM/kui/issues/4441) [#4364](https://github.com/IBM/kui/issues/4364)
- top tab buttons ([ff8cfba](https://github.com/IBM/kui/commit/ff8cfba)), closes [#4434](https://github.com/IBM/kui/issues/4434)
- watcher panel for open-ended watch jobs ([6dfe7df](https://github.com/IBM/kui/commit/6dfe7df)), closes [#4503](https://github.com/IBM/kui/issues/4503)
- **plugins/plugin-kubectl:** add Show Node button for kubectl pods ([04e29d2](https://github.com/IBM/kui/commit/04e29d2)), closes [#4214](https://github.com/IBM/kui/issues/4214)
- **plugins/plugin-kubectl:** add support for kustomize apply/delete/create ([b95cbdb](https://github.com/IBM/kui/commit/b95cbdb)), closes [#4203](https://github.com/IBM/kui/issues/4203)
- **plugins/plugin-kubectl:** configmap summary should show data ([50c7e10](https://github.com/IBM/kui/commit/50c7e10)), closes [#4025](https://github.com/IBM/kui/issues/4025)
- **plugins/plugin-kubectl:** enhance odo project list as RadioTable ([62272e6](https://github.com/IBM/kui/commit/62272e6)), closes [#4517](https://github.com/IBM/kui/issues/4517)
- **plugins/plugin-kubectl:** improve odo usage experience ([639ca32](https://github.com/IBM/kui/commit/639ca32)), closes [#4345](https://github.com/IBM/kui/issues/4345)
- **plugins/plugin-kubectl:** port kubectl contexts table to RadioTable ([3cb4dcb](https://github.com/IBM/kui/commit/3cb4dcb)), closes [#4513](https://github.com/IBM/kui/issues/4513)
- simplified co-hosting of client and proxy in a container ([00af4b4](https://github.com/IBM/kui/commit/00af4b4)), closes [#4213](https://github.com/IBM/kui/issues/4213)
- **plugins/plugin-kubectl:** ReplicaSet should have Pods tab ([42cd286](https://github.com/IBM/kui/commit/42cd286)), closes [#4110](https://github.com/IBM/kui/issues/4110)
- **plugins/plugin-kubectl:** restore Show Logs button for kubectl ([6b17dbd](https://github.com/IBM/kui/commit/6b17dbd)), closes [#4089](https://github.com/IBM/kui/issues/4089)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)

### BREAKING CHANGES

- removes support for inBrowserOk

# [8.7.0](https://github.com/IBM/kui/compare/v4.5.0...v8.7.0) (2020-05-08)

### Bug Fixes

- optimize kubectl watch load on apiserver ([3f7a32f](https://github.com/IBM/kui/commit/3f7a32f)), closes [#4494](https://github.com/IBM/kui/issues/4494)
- **plugin-kubectl:** k get pods --all-namespaces has a title with "default" as the namespace ([2f95129](https://github.com/IBM/kui/commit/2f95129)), closes [#4466](https://github.com/IBM/kui/issues/4466)
- **plugin-kubectl:** kubectl get error-type -w doesn't fail fast ([4ccb733](https://github.com/IBM/kui/commit/4ccb733)), closes [#4491](https://github.com/IBM/kui/issues/4491)
- **plugins/plugin-kubectl:** add missing test for get with not found ([3e77689](https://github.com/IBM/kui/commit/3e77689)), closes [#4492](https://github.com/IBM/kui/issues/4492)
- **plugins/plugin-kubectl:** cache kind canonicalization lookup ([e351a5f](https://github.com/IBM/kui/commit/e351a5f)), closes [#4489](https://github.com/IBM/kui/issues/4489)
- **plugins/plugin-kubectl:** kubectl get table with mix of existing and non-existing ([8d98d15](https://github.com/IBM/kui/commit/8d98d15)), closes [#4492](https://github.com/IBM/kui/issues/4492)
- add support for hiding elements at higher zoom levels ([7d2a7e0](https://github.com/IBM/kui/commit/7d2a7e0)), closes [#4232](https://github.com/IBM/kui/issues/4232)
- clicking on certain links in kubectl help result in odd behavior ([035894b](https://github.com/IBM/kui/commit/035894b)), closes [#4473](https://github.com/IBM/kui/issues/4473)
- eliminate complex nesting of NavResponse model ([e849ae7](https://github.com/IBM/kui/commit/e849ae7)), closes [#4205](https://github.com/IBM/kui/issues/4205)
- ibmcloud plugin list does not list unofficial plugins ([303fa00](https://github.com/IBM/kui/commit/303fa00)), closes [#4339](https://github.com/IBM/kui/issues/4339)
- make inBrowserOk the default ([2a3c811](https://github.com/IBM/kui/commit/2a3c811)), closes [#4275](https://github.com/IBM/kui/issues/4275)
- multiple kubectl help/usage bugs ([ebba36e](https://github.com/IBM/kui/commit/ebba36e)), closes [#4342](https://github.com/IBM/kui/issues/4342)
- sidecar views do not respect tab-specificity ([5a1cae2](https://github.com/IBM/kui/commit/5a1cae2)), closes [#4362](https://github.com/IBM/kui/issues/4362)
- **plugins/plugin-kubectl:** avoid use of /s regexp ([9468304](https://github.com/IBM/kui/commit/9468304)), closes [#4259](https://github.com/IBM/kui/issues/4259)
- **plugins/plugin-kubectl:** CurrentContext widget shows "default" for openshift clusters ([59712c0](https://github.com/IBM/kui/commit/59712c0)), closes [#4347](https://github.com/IBM/kui/issues/4347)
- **plugins/plugin-kubectl:** ensure Show Owner button appears near end of toolbar buttons ([224c586](https://github.com/IBM/kui/commit/224c586)), closes [#4124](https://github.com/IBM/kui/issues/4124)
- **plugins/plugin-kubectl:** firefox does not support the /s flag to RegExp ([5b661a6](https://github.com/IBM/kui/commit/5b661a6)), closes [#4206](https://github.com/IBM/kui/issues/4206)
- **plugins/plugin-kubectl:** in kube namespace table, selected namespace should float to top ([f0e597f](https://github.com/IBM/kui/commit/f0e597f)), closes [#4129](https://github.com/IBM/kui/issues/4129)
- **plugins/plugin-kubectl:** kubectl api-resources table shows 'unknown' in title ([0461710](https://github.com/IBM/kui/commit/0461710)), closes [#4145](https://github.com/IBM/kui/issues/4145)
- **plugins/plugin-kubectl:** kubectl describe (--help) fails ([10b8e8a](https://github.com/IBM/kui/commit/10b8e8a)), closes [#4012](https://github.com/IBM/kui/issues/4012)
- **plugins/plugin-kubectl:** kubectl explain -h should render as usage in sidecar ([8e00c3f](https://github.com/IBM/kui/commit/8e00c3f)), closes [#4211](https://github.com/IBM/kui/issues/4211)
- **plugins/plugin-kubectl:** kubectl explain Overview tab not formatted as expected ([ffa9183](https://github.com/IBM/kui/commit/ffa9183)), closes [#4304](https://github.com/IBM/kui/issues/4304)
- **plugins/plugin-kubectl:** kubectl top nodes can present "NaN" ([30df3dd](https://github.com/IBM/kui/commit/30df3dd)), closes [#4189](https://github.com/IBM/kui/issues/4189)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- **plugins/plugin-kubectl:** more refinements to Form layout heuristics ([e92327d](https://github.com/IBM/kui/commit/e92327d)), closes [#4118](https://github.com/IBM/kui/issues/4118)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- **plugins/plugin-kubectl:** update deprecated import of uuid ([5de8d4d](https://github.com/IBM/kui/commit/5de8d4d)), closes [#4316](https://github.com/IBM/kui/issues/4316)
- **plugins/plugin-kubectl:** watch table doesn't have breadcrumbs title ([43fbe6a](https://github.com/IBM/kui/commit/43fbe6a)), closes [#4135](https://github.com/IBM/kui/issues/4135)
- **plugins/plugin-kubectl:** watcher table disappears when kui is launched as kubectl plugin ([167eabc](https://github.com/IBM/kui/commit/167eabc)), closes [#4120](https://github.com/IBM/kui/issues/4120) [#4123](https://github.com/IBM/kui/issues/4123)
- **plugins/plugin-kubectl:** we shouldn't render namespace widget when the namespace is empty in kube config ([98a9406](https://github.com/IBM/kui/commit/98a9406)), closes [#4274](https://github.com/IBM/kui/issues/4274)
- ensure kubectl Delete toolbar button appears at far right ([9eb3079](https://github.com/IBM/kui/commit/9eb3079)), closes [#4116](https://github.com/IBM/kui/issues/4116)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- kubectl summary Form TextInputs can be cropped ([3becaf9](https://github.com/IBM/kui/commit/3becaf9)), closes [#4077](https://github.com/IBM/kui/issues/4077)
- multiple tab completion bugs ([5513712](https://github.com/IBM/kui/commit/5513712)), closes [#4281](https://github.com/IBM/kui/issues/4281)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- tekton Step nodes show with hashed background ([8428d72](https://github.com/IBM/kui/commit/8428d72)), closes [#4114](https://github.com/IBM/kui/issues/4114)
- the colors of status badges: Error, ImagePullBackOff and ErrImagePull are incorrect ([fd206f6](https://github.com/IBM/kui/commit/fd206f6)), closes [#4171](https://github.com/IBM/kui/issues/4171)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)
- **plugins/plugin-kubectl:** oc describe fails ([4f4de4e](https://github.com/IBM/kui/commit/4f4de4e)), closes [#4008](https://github.com/IBM/kui/issues/4008)

### Features

- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Patternfly Breadcrumb support ([91e0504](https://github.com/IBM/kui/commit/91e0504)), closes [#4381](https://github.com/IBM/kui/issues/4381)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- commands should be able to separate resource model fetch from view transformation functions ([e903bc7](https://github.com/IBM/kui/commit/e903bc7)), closes [#4437](https://github.com/IBM/kui/issues/4437)
- ibmcloud plugin ([aa0f72f](https://github.com/IBM/kui/commit/aa0f72f)), closes [#4353](https://github.com/IBM/kui/issues/4353)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- initial odo catalog list enhancements ([8534267](https://github.com/IBM/kui/commit/8534267)), closes [#4485](https://github.com/IBM/kui/issues/4485)
- kubectl edit via kui's editor ([414e813](https://github.com/IBM/kui/commit/414e813)), closes [#762](https://github.com/IBM/kui/issues/762)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- patternfly4 themes ([5f58f71](https://github.com/IBM/kui/commit/5f58f71)), closes [#4364](https://github.com/IBM/kui/issues/4364)
- SPI for icons ([3d034e3](https://github.com/IBM/kui/commit/3d034e3)), closes [#4441](https://github.com/IBM/kui/issues/4441) [#4364](https://github.com/IBM/kui/issues/4364)
- top tab buttons ([ff8cfba](https://github.com/IBM/kui/commit/ff8cfba)), closes [#4434](https://github.com/IBM/kui/issues/4434)
- **plugins/plugin-kubectl:** add Show Node button for kubectl pods ([04e29d2](https://github.com/IBM/kui/commit/04e29d2)), closes [#4214](https://github.com/IBM/kui/issues/4214)
- **plugins/plugin-kubectl:** improve odo usage experience ([639ca32](https://github.com/IBM/kui/commit/639ca32)), closes [#4345](https://github.com/IBM/kui/issues/4345)
- simplified co-hosting of client and proxy in a container ([00af4b4](https://github.com/IBM/kui/commit/00af4b4)), closes [#4213](https://github.com/IBM/kui/issues/4213)
- **plugins/plugin-kubectl:** add support for kustomize apply/delete/create ([b95cbdb](https://github.com/IBM/kui/commit/b95cbdb)), closes [#4203](https://github.com/IBM/kui/issues/4203)
- **plugins/plugin-kubectl:** configmap summary should show data ([50c7e10](https://github.com/IBM/kui/commit/50c7e10)), closes [#4025](https://github.com/IBM/kui/issues/4025)
- **plugins/plugin-kubectl:** ReplicaSet should have Pods tab ([42cd286](https://github.com/IBM/kui/commit/42cd286)), closes [#4110](https://github.com/IBM/kui/issues/4110)
- **plugins/plugin-kubectl:** restore Show Logs button for kubectl ([6b17dbd](https://github.com/IBM/kui/commit/6b17dbd)), closes [#4089](https://github.com/IBM/kui/issues/4089)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)

### BREAKING CHANGES

- removes support for inBrowserOk

## [8.6.1](https://github.com/IBM/kui/compare/v4.5.0...v8.6.1) (2020-04-25)

### Bug Fixes

- sidecar views do not respect tab-specificity ([5a1cae2](https://github.com/IBM/kui/commit/5a1cae2)), closes [#4362](https://github.com/IBM/kui/issues/4362)
- **plugins/plugin-kubectl:** CurrentContext widget shows "default" for openshift clusters ([59712c0](https://github.com/IBM/kui/commit/59712c0)), closes [#4347](https://github.com/IBM/kui/issues/4347)
- ibmcloud plugin list does not list unofficial plugins ([303fa00](https://github.com/IBM/kui/commit/303fa00)), closes [#4339](https://github.com/IBM/kui/issues/4339)
- make inBrowserOk the default ([2a3c811](https://github.com/IBM/kui/commit/2a3c811)), closes [#4275](https://github.com/IBM/kui/issues/4275)
- multiple kubectl help/usage bugs ([ebba36e](https://github.com/IBM/kui/commit/ebba36e)), closes [#4342](https://github.com/IBM/kui/issues/4342)
- **plugins/plugin-kubectl:** avoid use of /s regexp ([9468304](https://github.com/IBM/kui/commit/9468304)), closes [#4259](https://github.com/IBM/kui/issues/4259)
- **plugins/plugin-kubectl:** ensure Show Owner button appears near end of toolbar buttons ([224c586](https://github.com/IBM/kui/commit/224c586)), closes [#4124](https://github.com/IBM/kui/issues/4124)
- **plugins/plugin-kubectl:** firefox does not support the /s flag to RegExp ([5b661a6](https://github.com/IBM/kui/commit/5b661a6)), closes [#4206](https://github.com/IBM/kui/issues/4206)
- **plugins/plugin-kubectl:** in kube namespace table, selected namespace should float to top ([f0e597f](https://github.com/IBM/kui/commit/f0e597f)), closes [#4129](https://github.com/IBM/kui/issues/4129)
- **plugins/plugin-kubectl:** kubectl api-resources table shows 'unknown' in title ([0461710](https://github.com/IBM/kui/commit/0461710)), closes [#4145](https://github.com/IBM/kui/issues/4145)
- **plugins/plugin-kubectl:** kubectl explain -h should render as usage in sidecar ([8e00c3f](https://github.com/IBM/kui/commit/8e00c3f)), closes [#4211](https://github.com/IBM/kui/issues/4211)
- **plugins/plugin-kubectl:** kubectl explain Overview tab not formatted as expected ([ffa9183](https://github.com/IBM/kui/commit/ffa9183)), closes [#4304](https://github.com/IBM/kui/issues/4304)
- **plugins/plugin-kubectl:** update deprecated import of uuid ([5de8d4d](https://github.com/IBM/kui/commit/5de8d4d)), closes [#4316](https://github.com/IBM/kui/issues/4316)
- **plugins/plugin-kubectl:** we shouldn't render namespace widget when the namespace is empty in kube config ([98a9406](https://github.com/IBM/kui/commit/98a9406)), closes [#4274](https://github.com/IBM/kui/issues/4274)
- add support for hiding elements at higher zoom levels ([7d2a7e0](https://github.com/IBM/kui/commit/7d2a7e0)), closes [#4232](https://github.com/IBM/kui/issues/4232)
- eliminate complex nesting of NavResponse model ([e849ae7](https://github.com/IBM/kui/commit/e849ae7)), closes [#4205](https://github.com/IBM/kui/issues/4205)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- multiple tab completion bugs ([5513712](https://github.com/IBM/kui/commit/5513712)), closes [#4281](https://github.com/IBM/kui/issues/4281)
- **plugins/plugin-kubectl:** kubectl top nodes can present "NaN" ([30df3dd](https://github.com/IBM/kui/commit/30df3dd)), closes [#4189](https://github.com/IBM/kui/issues/4189)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- kubectl summary Form TextInputs can be cropped ([3becaf9](https://github.com/IBM/kui/commit/3becaf9)), closes [#4077](https://github.com/IBM/kui/issues/4077)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- tekton Step nodes show with hashed background ([8428d72](https://github.com/IBM/kui/commit/8428d72)), closes [#4114](https://github.com/IBM/kui/issues/4114)
- the colors of status badges: Error, ImagePullBackOff and ErrImagePull are incorrect ([fd206f6](https://github.com/IBM/kui/commit/fd206f6)), closes [#4171](https://github.com/IBM/kui/issues/4171)
- **plugins/plugin-kubectl:** kubectl describe (--help) fails ([10b8e8a](https://github.com/IBM/kui/commit/10b8e8a)), closes [#4012](https://github.com/IBM/kui/issues/4012)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- **plugins/plugin-kubectl:** more refinements to Form layout heuristics ([e92327d](https://github.com/IBM/kui/commit/e92327d)), closes [#4118](https://github.com/IBM/kui/issues/4118)
- **plugins/plugin-kubectl:** oc describe fails ([4f4de4e](https://github.com/IBM/kui/commit/4f4de4e)), closes [#4008](https://github.com/IBM/kui/issues/4008)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- **plugins/plugin-kubectl:** watch table doesn't have breadcrumbs title ([43fbe6a](https://github.com/IBM/kui/commit/43fbe6a)), closes [#4135](https://github.com/IBM/kui/issues/4135)
- **plugins/plugin-kubectl:** watcher table disappears when kui is launched as kubectl plugin ([167eabc](https://github.com/IBM/kui/commit/167eabc)), closes [#4120](https://github.com/IBM/kui/issues/4120) [#4123](https://github.com/IBM/kui/issues/4123)
- ensure kubectl Delete toolbar button appears at far right ([9eb3079](https://github.com/IBM/kui/commit/9eb3079)), closes [#4116](https://github.com/IBM/kui/issues/4116)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)

### Features

- ibmcloud plugin ([aa0f72f](https://github.com/IBM/kui/commit/aa0f72f)), closes [#4353](https://github.com/IBM/kui/issues/4353)
- **plugins/plugin-kubectl:** add Show Node button for kubectl pods ([04e29d2](https://github.com/IBM/kui/commit/04e29d2)), closes [#4214](https://github.com/IBM/kui/issues/4214)
- **plugins/plugin-kubectl:** add support for kustomize apply/delete/create ([b95cbdb](https://github.com/IBM/kui/commit/b95cbdb)), closes [#4203](https://github.com/IBM/kui/issues/4203)
- **plugins/plugin-kubectl:** improve odo usage experience ([639ca32](https://github.com/IBM/kui/commit/639ca32)), closes [#4345](https://github.com/IBM/kui/issues/4345)
- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- simplified co-hosting of client and proxy in a container ([00af4b4](https://github.com/IBM/kui/commit/00af4b4)), closes [#4213](https://github.com/IBM/kui/issues/4213)
- **plugins/plugin-kubectl:** configmap summary should show data ([50c7e10](https://github.com/IBM/kui/commit/50c7e10)), closes [#4025](https://github.com/IBM/kui/issues/4025)
- **plugins/plugin-kubectl:** ReplicaSet should have Pods tab ([42cd286](https://github.com/IBM/kui/commit/42cd286)), closes [#4110](https://github.com/IBM/kui/issues/4110)
- **plugins/plugin-kubectl:** restore Show Logs button for kubectl ([6b17dbd](https://github.com/IBM/kui/commit/6b17dbd)), closes [#4089](https://github.com/IBM/kui/issues/4089)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)

### BREAKING CHANGES

- removes support for inBrowserOk

# [8.6.0](https://github.com/IBM/kui/compare/v4.5.0...v8.6.0) (2020-04-23)

### Bug Fixes

- **plugins/plugin-kubectl:** CurrentContext widget shows "default" for openshift clusters ([59712c0](https://github.com/IBM/kui/commit/59712c0)), closes [#4347](https://github.com/IBM/kui/issues/4347)
- ibmcloud plugin list does not list unofficial plugins ([303fa00](https://github.com/IBM/kui/commit/303fa00)), closes [#4339](https://github.com/IBM/kui/issues/4339)
- make inBrowserOk the default ([2a3c811](https://github.com/IBM/kui/commit/2a3c811)), closes [#4275](https://github.com/IBM/kui/issues/4275)
- multiple kubectl help/usage bugs ([ebba36e](https://github.com/IBM/kui/commit/ebba36e)), closes [#4342](https://github.com/IBM/kui/issues/4342)
- **plugins/plugin-kubectl:** avoid use of /s regexp ([9468304](https://github.com/IBM/kui/commit/9468304)), closes [#4259](https://github.com/IBM/kui/issues/4259)
- **plugins/plugin-kubectl:** ensure Show Owner button appears near end of toolbar buttons ([224c586](https://github.com/IBM/kui/commit/224c586)), closes [#4124](https://github.com/IBM/kui/issues/4124)
- **plugins/plugin-kubectl:** firefox does not support the /s flag to RegExp ([5b661a6](https://github.com/IBM/kui/commit/5b661a6)), closes [#4206](https://github.com/IBM/kui/issues/4206)
- **plugins/plugin-kubectl:** in kube namespace table, selected namespace should float to top ([f0e597f](https://github.com/IBM/kui/commit/f0e597f)), closes [#4129](https://github.com/IBM/kui/issues/4129)
- **plugins/plugin-kubectl:** kubectl api-resources table shows 'unknown' in title ([0461710](https://github.com/IBM/kui/commit/0461710)), closes [#4145](https://github.com/IBM/kui/issues/4145)
- **plugins/plugin-kubectl:** kubectl explain -h should render as usage in sidecar ([8e00c3f](https://github.com/IBM/kui/commit/8e00c3f)), closes [#4211](https://github.com/IBM/kui/issues/4211)
- **plugins/plugin-kubectl:** kubectl explain Overview tab not formatted as expected ([ffa9183](https://github.com/IBM/kui/commit/ffa9183)), closes [#4304](https://github.com/IBM/kui/issues/4304)
- **plugins/plugin-kubectl:** update deprecated import of uuid ([5de8d4d](https://github.com/IBM/kui/commit/5de8d4d)), closes [#4316](https://github.com/IBM/kui/issues/4316)
- **plugins/plugin-kubectl:** we shouldn't render namespace widget when the namespace is empty in kube config ([98a9406](https://github.com/IBM/kui/commit/98a9406)), closes [#4274](https://github.com/IBM/kui/issues/4274)
- add support for hiding elements at higher zoom levels ([7d2a7e0](https://github.com/IBM/kui/commit/7d2a7e0)), closes [#4232](https://github.com/IBM/kui/issues/4232)
- eliminate complex nesting of NavResponse model ([e849ae7](https://github.com/IBM/kui/commit/e849ae7)), closes [#4205](https://github.com/IBM/kui/issues/4205)
- multiple tab completion bugs ([5513712](https://github.com/IBM/kui/commit/5513712)), closes [#4281](https://github.com/IBM/kui/issues/4281)
- **plugins/plugin-kubectl:** kubectl top nodes can present "NaN" ([30df3dd](https://github.com/IBM/kui/commit/30df3dd)), closes [#4189](https://github.com/IBM/kui/issues/4189)
- ensure kubectl Delete toolbar button appears at far right ([9eb3079](https://github.com/IBM/kui/commit/9eb3079)), closes [#4116](https://github.com/IBM/kui/issues/4116)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- kubectl summary Form TextInputs can be cropped ([3becaf9](https://github.com/IBM/kui/commit/3becaf9)), closes [#4077](https://github.com/IBM/kui/issues/4077)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- the colors of status badges: Error, ImagePullBackOff and ErrImagePull are incorrect ([fd206f6](https://github.com/IBM/kui/commit/fd206f6)), closes [#4171](https://github.com/IBM/kui/issues/4171)
- **plugins/plugin-kubectl:** kubectl describe (--help) fails ([10b8e8a](https://github.com/IBM/kui/commit/10b8e8a)), closes [#4012](https://github.com/IBM/kui/issues/4012)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- **plugins/plugin-kubectl:** more refinements to Form layout heuristics ([e92327d](https://github.com/IBM/kui/commit/e92327d)), closes [#4118](https://github.com/IBM/kui/issues/4118)
- **plugins/plugin-kubectl:** oc describe fails ([4f4de4e](https://github.com/IBM/kui/commit/4f4de4e)), closes [#4008](https://github.com/IBM/kui/issues/4008)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- **plugins/plugin-kubectl:** watch table doesn't have breadcrumbs title ([43fbe6a](https://github.com/IBM/kui/commit/43fbe6a)), closes [#4135](https://github.com/IBM/kui/issues/4135)
- **plugins/plugin-kubectl:** watcher table disappears when kui is launched as kubectl plugin ([167eabc](https://github.com/IBM/kui/commit/167eabc)), closes [#4120](https://github.com/IBM/kui/issues/4120) [#4123](https://github.com/IBM/kui/issues/4123)
- tekton Step nodes show with hashed background ([8428d72](https://github.com/IBM/kui/commit/8428d72)), closes [#4114](https://github.com/IBM/kui/issues/4114)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)

### Features

- ibmcloud plugin ([aa0f72f](https://github.com/IBM/kui/commit/aa0f72f)), closes [#4353](https://github.com/IBM/kui/issues/4353)
- **plugins/plugin-kubectl:** add Show Node button for kubectl pods ([04e29d2](https://github.com/IBM/kui/commit/04e29d2)), closes [#4214](https://github.com/IBM/kui/issues/4214)
- **plugins/plugin-kubectl:** add support for kustomize apply/delete/create ([b95cbdb](https://github.com/IBM/kui/commit/b95cbdb)), closes [#4203](https://github.com/IBM/kui/issues/4203)
- **plugins/plugin-kubectl:** improve odo usage experience ([639ca32](https://github.com/IBM/kui/commit/639ca32)), closes [#4345](https://github.com/IBM/kui/issues/4345)
- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- simplified co-hosting of client and proxy in a container ([00af4b4](https://github.com/IBM/kui/commit/00af4b4)), closes [#4213](https://github.com/IBM/kui/issues/4213)
- **plugins/plugin-kubectl:** configmap summary should show data ([50c7e10](https://github.com/IBM/kui/commit/50c7e10)), closes [#4025](https://github.com/IBM/kui/issues/4025)
- **plugins/plugin-kubectl:** ReplicaSet should have Pods tab ([42cd286](https://github.com/IBM/kui/commit/42cd286)), closes [#4110](https://github.com/IBM/kui/issues/4110)
- **plugins/plugin-kubectl:** restore Show Logs button for kubectl ([6b17dbd](https://github.com/IBM/kui/commit/6b17dbd)), closes [#4089](https://github.com/IBM/kui/issues/4089)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)

### BREAKING CHANGES

- removes support for inBrowserOk

# [8.5.0](https://github.com/IBM/kui/compare/v4.5.0...v8.5.0) (2020-04-19)

### Bug Fixes

- make inBrowserOk the default ([2a3c811](https://github.com/IBM/kui/commit/2a3c811)), closes [#4275](https://github.com/IBM/kui/issues/4275)
- **plugins/plugin-kubectl:** avoid use of /s regexp ([9468304](https://github.com/IBM/kui/commit/9468304)), closes [#4259](https://github.com/IBM/kui/issues/4259)
- **plugins/plugin-kubectl:** ensure Show Owner button appears near end of toolbar buttons ([224c586](https://github.com/IBM/kui/commit/224c586)), closes [#4124](https://github.com/IBM/kui/issues/4124)
- **plugins/plugin-kubectl:** firefox does not support the /s flag to RegExp ([5b661a6](https://github.com/IBM/kui/commit/5b661a6)), closes [#4206](https://github.com/IBM/kui/issues/4206)
- **plugins/plugin-kubectl:** in kube namespace table, selected namespace should float to top ([f0e597f](https://github.com/IBM/kui/commit/f0e597f)), closes [#4129](https://github.com/IBM/kui/issues/4129)
- **plugins/plugin-kubectl:** kubectl api-resources table shows 'unknown' in title ([0461710](https://github.com/IBM/kui/commit/0461710)), closes [#4145](https://github.com/IBM/kui/issues/4145)
- **plugins/plugin-kubectl:** kubectl explain -h should render as usage in sidecar ([8e00c3f](https://github.com/IBM/kui/commit/8e00c3f)), closes [#4211](https://github.com/IBM/kui/issues/4211)
- **plugins/plugin-kubectl:** kubectl explain Overview tab not formatted as expected ([ffa9183](https://github.com/IBM/kui/commit/ffa9183)), closes [#4304](https://github.com/IBM/kui/issues/4304)
- **plugins/plugin-kubectl:** kubectl top nodes can present "NaN" ([30df3dd](https://github.com/IBM/kui/commit/30df3dd)), closes [#4189](https://github.com/IBM/kui/issues/4189)
- **plugins/plugin-kubectl:** more refinements to Form layout heuristics ([e92327d](https://github.com/IBM/kui/commit/e92327d)), closes [#4118](https://github.com/IBM/kui/issues/4118)
- **plugins/plugin-kubectl:** update deprecated import of uuid ([5de8d4d](https://github.com/IBM/kui/commit/5de8d4d)), closes [#4316](https://github.com/IBM/kui/issues/4316)
- **plugins/plugin-kubectl:** we shouldn't render namespace widget when the namespace is empty in kube config ([98a9406](https://github.com/IBM/kui/commit/98a9406)), closes [#4274](https://github.com/IBM/kui/issues/4274)
- add support for hiding elements at higher zoom levels ([7d2a7e0](https://github.com/IBM/kui/commit/7d2a7e0)), closes [#4232](https://github.com/IBM/kui/issues/4232)
- eliminate complex nesting of NavResponse model ([e849ae7](https://github.com/IBM/kui/commit/e849ae7)), closes [#4205](https://github.com/IBM/kui/issues/4205)
- ensure kubectl Delete toolbar button appears at far right ([9eb3079](https://github.com/IBM/kui/commit/9eb3079)), closes [#4116](https://github.com/IBM/kui/issues/4116)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- kubectl summary Form TextInputs can be cropped ([3becaf9](https://github.com/IBM/kui/commit/3becaf9)), closes [#4077](https://github.com/IBM/kui/issues/4077)
- multiple tab completion bugs ([5513712](https://github.com/IBM/kui/commit/5513712)), closes [#4281](https://github.com/IBM/kui/issues/4281)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- the colors of status badges: Error, ImagePullBackOff and ErrImagePull are incorrect ([fd206f6](https://github.com/IBM/kui/commit/fd206f6)), closes [#4171](https://github.com/IBM/kui/issues/4171)
- **plugins/plugin-kubectl:** kubectl describe (--help) fails ([10b8e8a](https://github.com/IBM/kui/commit/10b8e8a)), closes [#4012](https://github.com/IBM/kui/issues/4012)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- **plugins/plugin-kubectl:** oc describe fails ([4f4de4e](https://github.com/IBM/kui/commit/4f4de4e)), closes [#4008](https://github.com/IBM/kui/issues/4008)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- **plugins/plugin-kubectl:** watch table doesn't have breadcrumbs title ([43fbe6a](https://github.com/IBM/kui/commit/43fbe6a)), closes [#4135](https://github.com/IBM/kui/issues/4135)
- **plugins/plugin-kubectl:** watcher table disappears when kui is launched as kubectl plugin ([167eabc](https://github.com/IBM/kui/commit/167eabc)), closes [#4120](https://github.com/IBM/kui/issues/4120) [#4123](https://github.com/IBM/kui/issues/4123)
- tekton Step nodes show with hashed background ([8428d72](https://github.com/IBM/kui/commit/8428d72)), closes [#4114](https://github.com/IBM/kui/issues/4114)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)

### Features

- **plugins/plugin-kubectl:** add Show Node button for kubectl pods ([04e29d2](https://github.com/IBM/kui/commit/04e29d2)), closes [#4214](https://github.com/IBM/kui/issues/4214)
- simplified co-hosting of client and proxy in a container ([00af4b4](https://github.com/IBM/kui/commit/00af4b4)), closes [#4213](https://github.com/IBM/kui/issues/4213)
- **plugins/plugin-kubectl:** add support for kustomize apply/delete/create ([b95cbdb](https://github.com/IBM/kui/commit/b95cbdb)), closes [#4203](https://github.com/IBM/kui/issues/4203)
- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- **plugins/plugin-kubectl:** configmap summary should show data ([50c7e10](https://github.com/IBM/kui/commit/50c7e10)), closes [#4025](https://github.com/IBM/kui/issues/4025)
- **plugins/plugin-kubectl:** ReplicaSet should have Pods tab ([42cd286](https://github.com/IBM/kui/commit/42cd286)), closes [#4110](https://github.com/IBM/kui/issues/4110)
- **plugins/plugin-kubectl:** restore Show Logs button for kubectl ([6b17dbd](https://github.com/IBM/kui/commit/6b17dbd)), closes [#4089](https://github.com/IBM/kui/issues/4089)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)

### BREAKING CHANGES

- removes support for inBrowserOk

## [8.4.2](https://github.com/IBM/kui/compare/v4.5.0...v8.4.2) (2020-04-10)

### Bug Fixes

- add support for hiding elements at higher zoom levels ([7d2a7e0](https://github.com/IBM/kui/commit/7d2a7e0)), closes [#4232](https://github.com/IBM/kui/issues/4232)
- **plugins/plugin-kubectl:** kubectl explain -h should render as usage in sidecar ([8e00c3f](https://github.com/IBM/kui/commit/8e00c3f)), closes [#4211](https://github.com/IBM/kui/issues/4211)
- eliminate complex nesting of NavResponse model ([e849ae7](https://github.com/IBM/kui/commit/e849ae7)), closes [#4205](https://github.com/IBM/kui/issues/4205)
- **plugins/plugin-kubectl:** ensure Show Owner button appears near end of toolbar buttons ([224c586](https://github.com/IBM/kui/commit/224c586)), closes [#4124](https://github.com/IBM/kui/issues/4124)
- **plugins/plugin-kubectl:** firefox does not support the /s flag to RegExp ([5b661a6](https://github.com/IBM/kui/commit/5b661a6)), closes [#4206](https://github.com/IBM/kui/issues/4206)
- **plugins/plugin-kubectl:** in kube namespace table, selected namespace should float to top ([f0e597f](https://github.com/IBM/kui/commit/f0e597f)), closes [#4129](https://github.com/IBM/kui/issues/4129)
- **plugins/plugin-kubectl:** kubectl top nodes can present "NaN" ([30df3dd](https://github.com/IBM/kui/commit/30df3dd)), closes [#4189](https://github.com/IBM/kui/issues/4189)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- kubectl summary Form TextInputs can be cropped ([3becaf9](https://github.com/IBM/kui/commit/3becaf9)), closes [#4077](https://github.com/IBM/kui/issues/4077)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- tekton Step nodes show with hashed background ([8428d72](https://github.com/IBM/kui/commit/8428d72)), closes [#4114](https://github.com/IBM/kui/issues/4114)
- the colors of status badges: Error, ImagePullBackOff and ErrImagePull are incorrect ([fd206f6](https://github.com/IBM/kui/commit/fd206f6)), closes [#4171](https://github.com/IBM/kui/issues/4171)
- **plugins/plugin-kubectl:** kubectl api-resources table shows 'unknown' in title ([0461710](https://github.com/IBM/kui/commit/0461710)), closes [#4145](https://github.com/IBM/kui/issues/4145)
- **plugins/plugin-kubectl:** kubectl describe (--help) fails ([10b8e8a](https://github.com/IBM/kui/commit/10b8e8a)), closes [#4012](https://github.com/IBM/kui/issues/4012)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- **plugins/plugin-kubectl:** more refinements to Form layout heuristics ([e92327d](https://github.com/IBM/kui/commit/e92327d)), closes [#4118](https://github.com/IBM/kui/issues/4118)
- **plugins/plugin-kubectl:** oc describe fails ([4f4de4e](https://github.com/IBM/kui/commit/4f4de4e)), closes [#4008](https://github.com/IBM/kui/issues/4008)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- **plugins/plugin-kubectl:** watch table doesn't have breadcrumbs title ([43fbe6a](https://github.com/IBM/kui/commit/43fbe6a)), closes [#4135](https://github.com/IBM/kui/issues/4135)
- **plugins/plugin-kubectl:** watcher table disappears when kui is launched as kubectl plugin ([167eabc](https://github.com/IBM/kui/commit/167eabc)), closes [#4120](https://github.com/IBM/kui/issues/4120) [#4123](https://github.com/IBM/kui/issues/4123)
- ensure kubectl Delete toolbar button appears at far right ([9eb3079](https://github.com/IBM/kui/commit/9eb3079)), closes [#4116](https://github.com/IBM/kui/issues/4116)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)

### Features

- **plugins/plugin-kubectl:** add Show Node button for kubectl pods ([04e29d2](https://github.com/IBM/kui/commit/04e29d2)), closes [#4214](https://github.com/IBM/kui/issues/4214)
- simplified co-hosting of client and proxy in a container ([00af4b4](https://github.com/IBM/kui/commit/00af4b4)), closes [#4213](https://github.com/IBM/kui/issues/4213)
- **plugins/plugin-kubectl:** add support for kustomize apply/delete/create ([b95cbdb](https://github.com/IBM/kui/commit/b95cbdb)), closes [#4203](https://github.com/IBM/kui/issues/4203)
- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- **plugins/plugin-kubectl:** configmap summary should show data ([50c7e10](https://github.com/IBM/kui/commit/50c7e10)), closes [#4025](https://github.com/IBM/kui/issues/4025)
- **plugins/plugin-kubectl:** ReplicaSet should have Pods tab ([42cd286](https://github.com/IBM/kui/commit/42cd286)), closes [#4110](https://github.com/IBM/kui/issues/4110)
- **plugins/plugin-kubectl:** restore Show Logs button for kubectl ([6b17dbd](https://github.com/IBM/kui/commit/6b17dbd)), closes [#4089](https://github.com/IBM/kui/issues/4089)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)

## [8.4.1](https://github.com/IBM/kui/compare/v4.5.0...v8.4.1) (2020-04-10)

### Bug Fixes

- add support for hiding elements at higher zoom levels ([7d2a7e0](https://github.com/IBM/kui/commit/7d2a7e0)), closes [#4232](https://github.com/IBM/kui/issues/4232)
- **plugins/plugin-kubectl:** kubectl explain -h should render as usage in sidecar ([8e00c3f](https://github.com/IBM/kui/commit/8e00c3f)), closes [#4211](https://github.com/IBM/kui/issues/4211)
- eliminate complex nesting of NavResponse model ([e849ae7](https://github.com/IBM/kui/commit/e849ae7)), closes [#4205](https://github.com/IBM/kui/issues/4205)
- **plugins/plugin-kubectl:** ensure Show Owner button appears near end of toolbar buttons ([224c586](https://github.com/IBM/kui/commit/224c586)), closes [#4124](https://github.com/IBM/kui/issues/4124)
- **plugins/plugin-kubectl:** firefox does not support the /s flag to RegExp ([5b661a6](https://github.com/IBM/kui/commit/5b661a6)), closes [#4206](https://github.com/IBM/kui/issues/4206)
- **plugins/plugin-kubectl:** in kube namespace table, selected namespace should float to top ([f0e597f](https://github.com/IBM/kui/commit/f0e597f)), closes [#4129](https://github.com/IBM/kui/issues/4129)
- **plugins/plugin-kubectl:** kubectl top nodes can present "NaN" ([30df3dd](https://github.com/IBM/kui/commit/30df3dd)), closes [#4189](https://github.com/IBM/kui/issues/4189)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- kubectl summary Form TextInputs can be cropped ([3becaf9](https://github.com/IBM/kui/commit/3becaf9)), closes [#4077](https://github.com/IBM/kui/issues/4077)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- tekton Step nodes show with hashed background ([8428d72](https://github.com/IBM/kui/commit/8428d72)), closes [#4114](https://github.com/IBM/kui/issues/4114)
- the colors of status badges: Error, ImagePullBackOff and ErrImagePull are incorrect ([fd206f6](https://github.com/IBM/kui/commit/fd206f6)), closes [#4171](https://github.com/IBM/kui/issues/4171)
- **plugins/plugin-kubectl:** kubectl api-resources table shows 'unknown' in title ([0461710](https://github.com/IBM/kui/commit/0461710)), closes [#4145](https://github.com/IBM/kui/issues/4145)
- **plugins/plugin-kubectl:** kubectl describe (--help) fails ([10b8e8a](https://github.com/IBM/kui/commit/10b8e8a)), closes [#4012](https://github.com/IBM/kui/issues/4012)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- **plugins/plugin-kubectl:** more refinements to Form layout heuristics ([e92327d](https://github.com/IBM/kui/commit/e92327d)), closes [#4118](https://github.com/IBM/kui/issues/4118)
- **plugins/plugin-kubectl:** oc describe fails ([4f4de4e](https://github.com/IBM/kui/commit/4f4de4e)), closes [#4008](https://github.com/IBM/kui/issues/4008)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- **plugins/plugin-kubectl:** watch table doesn't have breadcrumbs title ([43fbe6a](https://github.com/IBM/kui/commit/43fbe6a)), closes [#4135](https://github.com/IBM/kui/issues/4135)
- **plugins/plugin-kubectl:** watcher table disappears when kui is launched as kubectl plugin ([167eabc](https://github.com/IBM/kui/commit/167eabc)), closes [#4120](https://github.com/IBM/kui/issues/4120) [#4123](https://github.com/IBM/kui/issues/4123)
- ensure kubectl Delete toolbar button appears at far right ([9eb3079](https://github.com/IBM/kui/commit/9eb3079)), closes [#4116](https://github.com/IBM/kui/issues/4116)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)

### Features

- **plugins/plugin-kubectl:** add Show Node button for kubectl pods ([04e29d2](https://github.com/IBM/kui/commit/04e29d2)), closes [#4214](https://github.com/IBM/kui/issues/4214)
- simplified co-hosting of client and proxy in a container ([00af4b4](https://github.com/IBM/kui/commit/00af4b4)), closes [#4213](https://github.com/IBM/kui/issues/4213)
- **plugins/plugin-kubectl:** add support for kustomize apply/delete/create ([b95cbdb](https://github.com/IBM/kui/commit/b95cbdb)), closes [#4203](https://github.com/IBM/kui/issues/4203)
- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- **plugins/plugin-kubectl:** configmap summary should show data ([50c7e10](https://github.com/IBM/kui/commit/50c7e10)), closes [#4025](https://github.com/IBM/kui/issues/4025)
- **plugins/plugin-kubectl:** ReplicaSet should have Pods tab ([42cd286](https://github.com/IBM/kui/commit/42cd286)), closes [#4110](https://github.com/IBM/kui/issues/4110)
- **plugins/plugin-kubectl:** restore Show Logs button for kubectl ([6b17dbd](https://github.com/IBM/kui/commit/6b17dbd)), closes [#4089](https://github.com/IBM/kui/issues/4089)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)

# [8.4.0](https://github.com/IBM/kui/compare/v4.5.0...v8.4.0) (2020-04-10)

### Bug Fixes

- add support for hiding elements at higher zoom levels ([7d2a7e0](https://github.com/IBM/kui/commit/7d2a7e0)), closes [#4232](https://github.com/IBM/kui/issues/4232)
- **plugins/plugin-kubectl:** kubectl explain -h should render as usage in sidecar ([8e00c3f](https://github.com/IBM/kui/commit/8e00c3f)), closes [#4211](https://github.com/IBM/kui/issues/4211)
- eliminate complex nesting of NavResponse model ([e849ae7](https://github.com/IBM/kui/commit/e849ae7)), closes [#4205](https://github.com/IBM/kui/issues/4205)
- **plugins/plugin-kubectl:** ensure Show Owner button appears near end of toolbar buttons ([224c586](https://github.com/IBM/kui/commit/224c586)), closes [#4124](https://github.com/IBM/kui/issues/4124)
- **plugins/plugin-kubectl:** firefox does not support the /s flag to RegExp ([5b661a6](https://github.com/IBM/kui/commit/5b661a6)), closes [#4206](https://github.com/IBM/kui/issues/4206)
- **plugins/plugin-kubectl:** in kube namespace table, selected namespace should float to top ([f0e597f](https://github.com/IBM/kui/commit/f0e597f)), closes [#4129](https://github.com/IBM/kui/issues/4129)
- **plugins/plugin-kubectl:** kubectl top nodes can present "NaN" ([30df3dd](https://github.com/IBM/kui/commit/30df3dd)), closes [#4189](https://github.com/IBM/kui/issues/4189)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- kubectl summary Form TextInputs can be cropped ([3becaf9](https://github.com/IBM/kui/commit/3becaf9)), closes [#4077](https://github.com/IBM/kui/issues/4077)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- tekton Step nodes show with hashed background ([8428d72](https://github.com/IBM/kui/commit/8428d72)), closes [#4114](https://github.com/IBM/kui/issues/4114)
- the colors of status badges: Error, ImagePullBackOff and ErrImagePull are incorrect ([fd206f6](https://github.com/IBM/kui/commit/fd206f6)), closes [#4171](https://github.com/IBM/kui/issues/4171)
- **plugins/plugin-kubectl:** kubectl api-resources table shows 'unknown' in title ([0461710](https://github.com/IBM/kui/commit/0461710)), closes [#4145](https://github.com/IBM/kui/issues/4145)
- **plugins/plugin-kubectl:** kubectl describe (--help) fails ([10b8e8a](https://github.com/IBM/kui/commit/10b8e8a)), closes [#4012](https://github.com/IBM/kui/issues/4012)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- **plugins/plugin-kubectl:** more refinements to Form layout heuristics ([e92327d](https://github.com/IBM/kui/commit/e92327d)), closes [#4118](https://github.com/IBM/kui/issues/4118)
- **plugins/plugin-kubectl:** oc describe fails ([4f4de4e](https://github.com/IBM/kui/commit/4f4de4e)), closes [#4008](https://github.com/IBM/kui/issues/4008)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- **plugins/plugin-kubectl:** watch table doesn't have breadcrumbs title ([43fbe6a](https://github.com/IBM/kui/commit/43fbe6a)), closes [#4135](https://github.com/IBM/kui/issues/4135)
- **plugins/plugin-kubectl:** watcher table disappears when kui is launched as kubectl plugin ([167eabc](https://github.com/IBM/kui/commit/167eabc)), closes [#4120](https://github.com/IBM/kui/issues/4120) [#4123](https://github.com/IBM/kui/issues/4123)
- ensure kubectl Delete toolbar button appears at far right ([9eb3079](https://github.com/IBM/kui/commit/9eb3079)), closes [#4116](https://github.com/IBM/kui/issues/4116)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)

### Features

- **plugins/plugin-kubectl:** add Show Node button for kubectl pods ([04e29d2](https://github.com/IBM/kui/commit/04e29d2)), closes [#4214](https://github.com/IBM/kui/issues/4214)
- simplified co-hosting of client and proxy in a container ([00af4b4](https://github.com/IBM/kui/commit/00af4b4)), closes [#4213](https://github.com/IBM/kui/issues/4213)
- **plugins/plugin-kubectl:** add support for kustomize apply/delete/create ([b95cbdb](https://github.com/IBM/kui/commit/b95cbdb)), closes [#4203](https://github.com/IBM/kui/issues/4203)
- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- **plugins/plugin-kubectl:** configmap summary should show data ([50c7e10](https://github.com/IBM/kui/commit/50c7e10)), closes [#4025](https://github.com/IBM/kui/issues/4025)
- **plugins/plugin-kubectl:** ReplicaSet should have Pods tab ([42cd286](https://github.com/IBM/kui/commit/42cd286)), closes [#4110](https://github.com/IBM/kui/issues/4110)
- **plugins/plugin-kubectl:** restore Show Logs button for kubectl ([6b17dbd](https://github.com/IBM/kui/commit/6b17dbd)), closes [#4089](https://github.com/IBM/kui/issues/4089)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)

# [8.1.0](https://github.com/IBM/kui/compare/v4.5.0...v8.1.0) (2020-04-04)

### Bug Fixes

- **plugins/plugin-kubectl:** kubectl top nodes can present "NaN" ([30df3dd](https://github.com/IBM/kui/commit/30df3dd)), closes [#4189](https://github.com/IBM/kui/issues/4189)
- the colors of status badges: Error, ImagePullBackOff and ErrImagePull are incorrect ([fd206f6](https://github.com/IBM/kui/commit/fd206f6)), closes [#4171](https://github.com/IBM/kui/issues/4171)
- **plugins/plugin-kubectl:** ensure Show Owner button appears near end of toolbar buttons ([224c586](https://github.com/IBM/kui/commit/224c586)), closes [#4124](https://github.com/IBM/kui/issues/4124)
- **plugins/plugin-kubectl:** in kube namespace table, selected namespace should float to top ([f0e597f](https://github.com/IBM/kui/commit/f0e597f)), closes [#4129](https://github.com/IBM/kui/issues/4129)
- **plugins/plugin-kubectl:** kubectl api-resources table shows 'unknown' in title ([0461710](https://github.com/IBM/kui/commit/0461710)), closes [#4145](https://github.com/IBM/kui/issues/4145)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- **plugins/plugin-kubectl:** more refinements to Form layout heuristics ([e92327d](https://github.com/IBM/kui/commit/e92327d)), closes [#4118](https://github.com/IBM/kui/issues/4118)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- **plugins/plugin-kubectl:** watch table doesn't have breadcrumbs title ([43fbe6a](https://github.com/IBM/kui/commit/43fbe6a)), closes [#4135](https://github.com/IBM/kui/issues/4135)
- **plugins/plugin-kubectl:** watcher table disappears when kui is launched as kubectl plugin ([167eabc](https://github.com/IBM/kui/commit/167eabc)), closes [#4120](https://github.com/IBM/kui/issues/4120) [#4123](https://github.com/IBM/kui/issues/4123)
- ensure kubectl Delete toolbar button appears at far right ([9eb3079](https://github.com/IBM/kui/commit/9eb3079)), closes [#4116](https://github.com/IBM/kui/issues/4116)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- kubectl summary Form TextInputs can be cropped ([3becaf9](https://github.com/IBM/kui/commit/3becaf9)), closes [#4077](https://github.com/IBM/kui/issues/4077)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- tekton Step nodes show with hashed background ([8428d72](https://github.com/IBM/kui/commit/8428d72)), closes [#4114](https://github.com/IBM/kui/issues/4114)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)
- **plugins/plugin-kubectl:** kubectl describe (--help) fails ([10b8e8a](https://github.com/IBM/kui/commit/10b8e8a)), closes [#4012](https://github.com/IBM/kui/issues/4012)
- **plugins/plugin-kubectl:** oc describe fails ([4f4de4e](https://github.com/IBM/kui/commit/4f4de4e)), closes [#4008](https://github.com/IBM/kui/issues/4008)

### Features

- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- **plugins/plugin-kubectl:** configmap summary should show data ([50c7e10](https://github.com/IBM/kui/commit/50c7e10)), closes [#4025](https://github.com/IBM/kui/issues/4025)
- **plugins/plugin-kubectl:** ReplicaSet should have Pods tab ([42cd286](https://github.com/IBM/kui/commit/42cd286)), closes [#4110](https://github.com/IBM/kui/issues/4110)
- **plugins/plugin-kubectl:** restore Show Logs button for kubectl ([6b17dbd](https://github.com/IBM/kui/commit/6b17dbd)), closes [#4089](https://github.com/IBM/kui/issues/4089)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)
