"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChartScatter = exports.ChartScatterSortOrder = void 0;
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const hoist_non_react_statics_1 = tslib_1.__importDefault(require("hoist-non-react-statics"));
const victory_scatter_1 = require("victory-scatter");
const ChartContainer_1 = require("../ChartContainer");
const ChartTheme_1 = require("../ChartTheme");
const ChartUtils_1 = require("../ChartUtils");
var ChartScatterSortOrder;
(function (ChartScatterSortOrder) {
    ChartScatterSortOrder["ascending"] = "ascending";
    ChartScatterSortOrder["descending"] = "descending";
})(ChartScatterSortOrder = exports.ChartScatterSortOrder || (exports.ChartScatterSortOrder = {}));
exports.ChartScatter = (_a) => {
    var { containerComponent = React.createElement(ChartContainer_1.ChartContainer, null), themeColor, themeVariant, 
    // destructure last
    theme = ChartUtils_1.getTheme(themeColor, themeVariant), size = ({ active }) => (active ? ChartTheme_1.ChartScatterStyles.activeSize : ChartTheme_1.ChartScatterStyles.size) } = _a, rest = tslib_1.__rest(_a, ["containerComponent", "themeColor", "themeVariant", "theme", "size"]);
    // Clone so users can override container props
    const container = React.cloneElement(containerComponent, Object.assign({ theme }, containerComponent.props));
    // Note: containerComponent is required for theme
    return React.createElement(victory_scatter_1.VictoryScatter, Object.assign({ containerComponent: container, size: size, theme: theme }, rest));
};
exports.ChartScatter.displayName = 'ChartScatter';
// Note: VictoryLine.role must be hoisted
hoist_non_react_statics_1.default(exports.ChartScatter, victory_scatter_1.VictoryScatter);
//# sourceMappingURL=ChartScatter.js.map