"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChartAxis = void 0;
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const hoist_non_react_statics_1 = tslib_1.__importDefault(require("hoist-non-react-statics"));
const victory_axis_1 = require("victory-axis");
const ChartContainer_1 = require("../ChartContainer");
const ChartUtils_1 = require("../ChartUtils");
exports.ChartAxis = (_a) => {
    var { containerComponent = React.createElement(ChartContainer_1.ChartContainer, null), showGrid = false, themeColor, themeVariant, 
    // destructure last
    theme = ChartUtils_1.getTheme(themeColor, themeVariant) } = _a, rest = tslib_1.__rest(_a, ["containerComponent", "showGrid", "themeColor", "themeVariant", "theme"]);
    // Clone so users can override container props
    const container = React.cloneElement(containerComponent, Object.assign({ theme }, containerComponent.props));
    // Note: containerComponent is required for theme
    return (React.createElement(victory_axis_1.VictoryAxis, Object.assign({ containerComponent: container, theme: showGrid ? ChartUtils_1.getAxisTheme(themeColor, themeVariant) : theme }, rest)));
};
exports.ChartAxis.displayName = 'ChartAxis';
hoist_non_react_statics_1.default(exports.ChartAxis, victory_axis_1.VictoryAxis);
//# sourceMappingURL=ChartAxis.js.map