/*
 * Copyright 2017 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { dirname, join } from 'path';
import { Common, CLI, ReplExpect, Selectors, SidecarExpect, Util } from '@kui-shell/test';
const ROOT = dirname(require.resolve('@kui-shell/core/tests/package.json'));
const rootRelative = (dir) => join(ROOT, dir);
describe(`bash-like head ${process.env.MOCHA_RUN_TARGET || ''}`, function () {
    before(Common.before(this));
    after(Common.after(this));
    it('should head package.json and see 10 lines', () => CLI.command(`head ${rootRelative('package.json')}`, this.app)
        .then(ReplExpect.ok)
        .then(SidecarExpect.open)
        .then(res => this.app.client.waitUntil(() => __awaiter(this, void 0, void 0, function* () {
        const linesNumbers = yield this.app.client.$$(Selectors.SIDECAR_CUSTOM_CONTENT_LINE_NUMBERS(res.count, res.splitIndex));
        return linesNumbers.length === 10;
    })))
        .catch(Common.oops(this)));
    it('should head -n 5 package.json and see 5 lines', () => CLI.command(`head -n 5 ${rootRelative('package.json')}`, this.app)
        .then(ReplExpect.ok)
        .then(SidecarExpect.open)
        .then(res => this.app.client.waitUntil(() => __awaiter(this, void 0, void 0, function* () {
        const linesNumbers = yield this.app.client.$$(Selectors.SIDECAR_CUSTOM_CONTENT_LINE_NUMBERS(res.count, res.splitIndex));
        return linesNumbers.length === 5;
    })))
        .catch(Common.oops(this)));
    it('should head -c 1 package.json and see 1 bytes', () => CLI.command(`head -c 1 ${rootRelative('package.json')}`, this.app)
        .then(ReplExpect.ok)
        .then(SidecarExpect.open)
        .then(res => this.app.client.waitUntil(() => __awaiter(this, void 0, void 0, function* () {
        const value = yield Util.getValueFromMonaco(res);
        const bufferSize = Buffer.from(value).length;
        return bufferSize === 1;
    })))
        .catch(Common.oops(this)));
    it('should head /kui/welcome.json and see 10 lines', () => CLI.command('head /kui/welcome.json', this.app)
        .then(ReplExpect.ok)
        .then(SidecarExpect.open)
        .then(res => this.app.client.waitUntil(() => __awaiter(this, void 0, void 0, function* () {
        const linesNumbers = yield this.app.client.$$(Selectors.SIDECAR_CUSTOM_CONTENT_LINE_NUMBERS(res.count, res.splitIndex));
        return linesNumbers.length === 10;
    })))
        .catch(Common.oops(this)));
    it('should head -n 5 /kui/welcome.json and see 5 lines', () => CLI.command('head -n 5 /kui/welcome.json', this.app)
        .then(ReplExpect.ok)
        .then(SidecarExpect.open)
        .then(res => this.app.client.waitUntil(() => __awaiter(this, void 0, void 0, function* () {
        const linesNumbers = yield this.app.client.$$(Selectors.SIDECAR_CUSTOM_CONTENT_LINE_NUMBERS(res.count, res.splitIndex));
        return linesNumbers.length === 5;
    })))
        .catch(Common.oops(this)));
    it('should head -c 1 /kui/welcome.json and see 1 bytes', () => CLI.command('head -c 1 /kui/welcome.json', this.app)
        .then(ReplExpect.ok)
        .then(SidecarExpect.open)
        .then(res => this.app.client.waitUntil(() => __awaiter(this, void 0, void 0, function* () {
        const value = yield Util.getValueFromMonaco(res);
        const bufferSize = Buffer.from(value).length;
        return bufferSize === 1;
    })))
        .catch(Common.oops(this)));
});
//# sourceMappingURL=tail.js.map