import { Server } from 'https';
import { Channel } from './channel';
import { Registrar } from '@kui-shell/core';
/** handler for shell/pty exit */
export declare type ExitHandler = (exitCode: number) => void;
/**
 * Verify a session's validity
 *
 */
interface Session {
    uid: number;
    gid: number;
    token: string;
}
export interface SessionCookie {
    key: string;
    session: Session;
}
export declare const disableBashSessions: () => Promise<ExitHandler>;
/**
 * Determine, and cache, the user's login shell
 *
 */
declare type Shell = {
    shellExe: string;
    shellOpts: string[];
};
export declare const getLoginShell: () => Promise<string>;
export declare function getShellOpts(): Promise<Shell>;
export declare function setShellAliases(aliases: Record<string, string>): void;
/**
 *
 *
 */
export declare const onConnection: (exitNow: ExitHandler, uid?: number, gid?: number) => (ws: Channel) => Promise<void>;
export declare const main: (N: string, server?: Server, preexistingPort?: number, expectedCookie?: SessionCookie) => Promise<number | {
    wss: Server;
    port: number;
}>;
declare const _default: (commandTree: Registrar) => void;
/**
 * Register command handlers
 *
 */
export default _default;
