import { Arguments, ParsedOptions, Registrar } from '@kui-shell/core';
/**
 * Command handler that dispatches to an outer shell
 *
 */
export declare const dispatchToShell: ({ tab, command, argv, argvNoOptions, execOptions, parsedOptions, createOutputStream }: Arguments) => Promise<any>;
/**
 * Execute the given command using a pty, but return a string
 *
 */
export declare function doExecWithStdoutViaPty<O extends ParsedOptions = ParsedOptions>(args: Arguments<O>): Promise<string>;
/**
 * On preload, register the catchall handler
 *
 */
export declare const preload: (commandTree: Registrar) => void;
