"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * Generic component used for reacting to a click event happening outside of a
 * given child component that used the forwarded `handleRef` function through
 * the `refKey` prop.
 */
var InnerClickListener = /*#__PURE__*/function (_React$Component) {
  (0, _inherits2.default)(InnerClickListener, _React$Component);

  var _super = _createSuper(InnerClickListener);

  function InnerClickListener(props) {
    var _this;

    (0, _classCallCheck2.default)(this, InnerClickListener);
    _this = _super.call(this, props); // We manually bind handlers in this Component, versus using class
    // properties, so that we can properly test the `handleRef` handler with
    // enzyme.

    _this.handleRef = _this.handleRef.bind((0, _assertThisInitialized2.default)(_this));
    _this.handleDocumentClick = _this.handleDocumentClick.bind((0, _assertThisInitialized2.default)(_this));
    return _this;
  }

  (0, _createClass2.default)(InnerClickListener, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      document.addEventListener('click', this.handleDocumentClick);
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      document.removeEventListener('click', this.handleDocumentClick);
    }
  }, {
    key: "handleDocumentClick",
    value: function handleDocumentClick(event) {
      // Ensure that the target exists in the DOM before checking the element
      if (this.element && (this.element.ownerDocument === event.target || this.element.ownerDocument.body.contains(event.target))) {
        if (this.element.contains && !this.element.contains(event.target)) {
          this.props.onClickOutside(event);
        }
      }
    }
  }, {
    key: "handleRef",
    value: function handleRef(el) {
      this.element = el;
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          refKey = _this$props.refKey,
          children = _this$props.children;
      return /*#__PURE__*/_react.default.cloneElement(children, (0, _defineProperty2.default)({}, refKey, this.handleRef));
    }
  }]);
  return InnerClickListener;
}(_react.default.Component);

exports.default = InnerClickListener;
(0, _defineProperty2.default)(InnerClickListener, "propTypes", {
  children: _propTypes.default.node.isRequired,
  onClickOutside: _propTypes.default.func.isRequired,
  refKey: _propTypes.default.string.isRequired
});