"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createComponentToggle = createComponentToggle;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireDefault(require("react"));

var _FeatureFlags = require("../components/FeatureFlags");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function createComponentToggle(spec) {
  var name = spec.name,
      _spec$flag = spec.flag,
      flag = _spec$flag === void 0 ? 'enable-v11-release' : _spec$flag,
      next = spec.next,
      classic = spec.classic;

  function ComponentToggle(props, ref) {
    var enabled = (0, _FeatureFlags.useFeatureFlag)(flag);

    if (enabled) {
      if (next) {
        return /*#__PURE__*/_react.default.createElement(next, _objectSpread(_objectSpread({}, props), {}, {
          ref: ref
        }));
      }

      return null;
    }

    return /*#__PURE__*/_react.default.createElement(classic, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref
    }));
  }

  var wrappedComponent = /*#__PURE__*/_react.default.forwardRef(ComponentToggle);

  wrappedComponent.displayName = "FeatureToggle(".concat(name, ")");
  return wrappedComponent;
}