"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SideNavWLargeSideNavItems = exports.SideNavRailWHeader = exports.SideNavRail = exports.FixedSideNavWDivider = exports.FixedSideNavWIcons = exports.FixedSideNav = exports.HeaderBaseWActionsAndSwitcher = exports.HeaderBaseWActionsAndRightPanel = exports.HeaderBaseWSideNav = exports.HeaderBaseWNavigationActionsAndSideNav = exports.HeaderBaseWNavigationAndActions = exports.HeaderBaseWSkipToContent = exports.HeaderBaseWActions = exports.HeaderBaseWNavigation = exports.HeaderBase = exports.default = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _react = _interopRequireWildcard(require("react"));

var _addonActions = require("@storybook/addon-actions");

var _classnames = _interopRequireDefault(require("classnames"));

var _ = require("../");

var _carbonComponentsReact = require("carbon-components-react");

var _iconsReact = require("@carbon/icons-react");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

/* eslint-disable react/prop-types */
var StoryContent = function StoryContent(_ref) {
  var _ref$useResponsiveOff = _ref.useResponsiveOffset,
      useResponsiveOffset = _ref$useResponsiveOff === void 0 ? true : _ref$useResponsiveOff;

  var _useState = (0, _react.useState)(false),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      open = _useState2[0],
      setOpen = _useState2[1];

  var classNameFirstColumn = (0, _classnames.default)({
    'bx--col-lg-13': true,
    'bx--offset-lg-3': useResponsiveOffset
  });

  var content = /*#__PURE__*/_react.default.createElement("div", {
    className: "bx--grid"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "bx--row"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: classNameFirstColumn
  }, /*#__PURE__*/_react.default.createElement("h2", {
    style: {
      margin: '0 0 30px'
    }
  }, "Purpose and function"), /*#__PURE__*/_react.default.createElement("p", null, "The shell is perhaps the most crucial piece of any UI built with", /*#__PURE__*/_react.default.createElement("a", {
    href: "www.carbondesignsystem.com"
  }, " Carbon"), ". It contains the shared navigation framework for the entire design system and ties the products in IBM\u2019s portfolio together in a cohesive and elegant way. The shell is the home of the topmost navigation, where users can quickly and dependably gain their bearings and move between pages.", /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement("br", null), "The shell was designed with maximum flexibility built in, to serve the needs of a broad range of products and users. Adopting the shell ensures compliance with IBM design standards, simplifies development efforts, and provides great user experiences. All IBM products built with Carbon are required to use the shell\u2019s header.", /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement("br", null), "To better understand the purpose and function of the UI shell, consider the \u201Cshell\u201D of MacOS, which contains the Apple menu, top-level navigation, and universal, OS-level controls at the top of the screen, as well as a universal dock along the bottom or side of the screen. The Carbon UI shell is roughly analogous in function to these parts of the Mac UI. For example, the app switcher portion of the shell can be compared to the dock in MacOS."), /*#__PURE__*/_react.default.createElement("h2", {
    style: {
      margin: '30px 0'
    }
  }, "Header responsive behavior"), /*#__PURE__*/_react.default.createElement("p", null, "As a header scales down to fit smaller screen sizes, headers with persistent side nav menus should have the side nav collapse into \u201Chamburger\u201D menu. See the example to better understand responsive behavior of the header."), /*#__PURE__*/_react.default.createElement("h2", {
    style: {
      margin: '30px 0'
    }
  }, "Secondary navigation"), /*#__PURE__*/_react.default.createElement("p", null, "The side-nav contains secondary navigation and fits below the header. It can be configured to be either fixed-width or flexible, with only one level of nested items allowed. Both links and category lists can be used in the side-nav and may be mixed together. There are several configurations of the side-nav, but only one configuration should be used per product section. If tabs are needed on a page when using a side-nav, then the tabs are secondary in hierarchy to the side-nav."), /*#__PURE__*/_react.default.createElement(_carbonComponentsReact.Button, {
    onClick: function onClick() {
      return setOpen(true);
    }
  }, "Launch modal"), /*#__PURE__*/_react.default.createElement(_carbonComponentsReact.Modal, {
    modalHeading: "Add a custom domain",
    modalLabel: "Account resources",
    primaryButtonText: "Add",
    secondaryButtonText: "Cancel",
    open: open,
    onRequestClose: function onRequestClose() {
      return setOpen(false);
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    style: {
      marginBottom: '1rem'
    }
  }, "Custom domains direct requests for your apps in this Cloud Foundry organization to a URL that you own. A custom domain can be a shared domain, a shared subdomain, or a shared domain and host.")))));

  var style = {
    height: '100%'
  };

  if (useResponsiveOffset) {
    style.margin = '0';
    style.width = '100%';
  }

  return /*#__PURE__*/_react.default.createElement(_.Content, {
    id: "main-content",
    style: style
  }, content);
};

var _default = {
  title: 'Components/UI Shell',
  parameters: {
    subcomponents: {
      Content: _.Content,
      Header: _.Header,
      HeaderMenuButton: _.HeaderMenuButton,
      HeaderName: _.HeaderName,
      HeaderNavigation: _.HeaderNavigation,
      HeaderMenu: _.HeaderMenu,
      HeaderMenuItem: _.HeaderMenuItem,
      HeaderGlobalBar: _.HeaderGlobalBar,
      HeaderGlobalAction: _.HeaderGlobalAction,
      HeaderPanel: _.HeaderPanel,
      HeaderSideNavItems: _.HeaderSideNavItems,
      SkipToContent: _.SkipToContent,
      SideNav: _.SideNav,
      SideNavItems: _.SideNavItems,
      SideNavDivider: _.SideNavDivider,
      SideNavLink: _.SideNavLink,
      SideNavMenu: _.SideNavMenu,
      SideNavMenuItem: _.SideNavMenuItem,
      Switcher: _.Switcher,
      SwitcherItem: _.SwitcherItem,
      SwitcherDivider: _.SwitcherDivider
    }
  }
};
exports.default = _default;

var HeaderBase = function HeaderBase() {
  return /*#__PURE__*/_react.default.createElement(_.Header, {
    "aria-label": "IBM Platform Name"
  }, /*#__PURE__*/_react.default.createElement(_.HeaderName, {
    href: "#",
    prefix: "IBM"
  }, "[Platform]"));
};

exports.HeaderBase = HeaderBase;

var HeaderBaseWNavigation = function HeaderBaseWNavigation() {
  return /*#__PURE__*/_react.default.createElement(_.HeaderContainer, {
    render: function render(_ref2) {
      var isSideNavExpanded = _ref2.isSideNavExpanded,
          onClickSideNavExpand = _ref2.onClickSideNavExpand;
      return /*#__PURE__*/_react.default.createElement(_.Header, {
        "aria-label": "IBM Platform Name"
      }, /*#__PURE__*/_react.default.createElement(_.SkipToContent, null), /*#__PURE__*/_react.default.createElement(_.HeaderMenuButton, {
        "aria-label": "Open menu",
        onClick: onClickSideNavExpand,
        isActive: isSideNavExpanded
      }), /*#__PURE__*/_react.default.createElement(_.HeaderName, {
        href: "#",
        prefix: "IBM"
      }, "[Platform]"), /*#__PURE__*/_react.default.createElement(_.HeaderNavigation, {
        "aria-label": "IBM [Platform]"
      }, /*#__PURE__*/_react.default.createElement(_.HeaderMenuItem, {
        isCurrentPage: true,
        href: "#"
      }, "Link 1"), /*#__PURE__*/_react.default.createElement(_.HeaderMenuItem, {
        href: "#"
      }, "Link 2"), /*#__PURE__*/_react.default.createElement(_.HeaderMenuItem, {
        href: "#"
      }, "Link 3"), /*#__PURE__*/_react.default.createElement(_.HeaderMenu, {
        "aria-label": "Link 4",
        menuLinkName: "Link 4"
      }, /*#__PURE__*/_react.default.createElement(_.HeaderMenuItem, {
        href: "#"
      }, "Sub-link 1"), /*#__PURE__*/_react.default.createElement(_.HeaderMenuItem, {
        href: "#"
      }, "Sub-link 2"), /*#__PURE__*/_react.default.createElement(_.HeaderMenuItem, {
        href: "#"
      }, "Sub-link 3"))), /*#__PURE__*/_react.default.createElement(_.SideNav, {
        "aria-label": "Side navigation",
        expanded: isSideNavExpanded,
        isPersistent: false
      }, /*#__PURE__*/_react.default.createElement(_.SideNavItems, null, /*#__PURE__*/_react.default.createElement(_.HeaderSideNavItems, null, /*#__PURE__*/_react.default.createElement(_.HeaderMenuItem, {
        href: "#"
      }, "Link 1"), /*#__PURE__*/_react.default.createElement(_.HeaderMenuItem, {
        href: "#"
      }, "Link 2"), /*#__PURE__*/_react.default.createElement(_.HeaderMenuItem, {
        href: "#"
      }, "Link 3"), /*#__PURE__*/_react.default.createElement(_.HeaderMenu, {
        "aria-label": "Link 4",
        menuLinkName: "Link 4"
      }, /*#__PURE__*/_react.default.createElement(_.HeaderMenuItem, {
        href: "#"
      }, "Sub-link 1"), /*#__PURE__*/_react.default.createElement(_.HeaderMenuItem, {
        href: "#"
      }, "Sub-link 2"), /*#__PURE__*/_react.default.createElement(_.HeaderMenuItem, {
        href: "#"
      }, "Sub-link 3"))))));
    }
  });
};

exports.HeaderBaseWNavigation = HeaderBaseWNavigation;
HeaderBaseWNavigation.storyName = 'Header Base w/ Navigation';

var HeaderBaseWActions = function HeaderBaseWActions() {
  return /*#__PURE__*/_react.default.createElement(_.Header, {
    "aria-label": "IBM Platform Name"
  }, /*#__PURE__*/_react.default.createElement(_.HeaderName, {
    href: "#",
    prefix: "IBM"
  }, "[Platform]"), /*#__PURE__*/_react.default.createElement(_.HeaderGlobalBar, null, /*#__PURE__*/_react.default.createElement(_.HeaderGlobalAction, {
    "aria-label": "Search",
    onClick: (0, _addonActions.action)('search click')
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.Search20, null)), /*#__PURE__*/_react.default.createElement(_.HeaderGlobalAction, {
    "aria-label": "Notifications",
    onClick: (0, _addonActions.action)('notification click')
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.Notification20, null)), /*#__PURE__*/_react.default.createElement(_.HeaderGlobalAction, {
    "aria-label": "App Switcher",
    onClick: (0, _addonActions.action)('app-switcher click'),
    tooltipAlignment: "end"
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.AppSwitcher20, null))));
};

exports.HeaderBaseWActions = HeaderBaseWActions;
HeaderBaseWActions.storyName = 'Header Base w/ Actions';

var HeaderBaseWSkipToContent = function HeaderBaseWSkipToContent() {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_.Header, {
    "aria-label": "IBM Platform Name"
  }, /*#__PURE__*/_react.default.createElement(_.SkipToContent, null), /*#__PURE__*/_react.default.createElement(_.HeaderName, {
    href: "#",
    prefix: "IBM"
  }, "[Platform]"), /*#__PURE__*/_react.default.createElement(_.HeaderGlobalBar, null, /*#__PURE__*/_react.default.createElement(_.HeaderGlobalAction, {
    "aria-label": "Search",
    onClick: (0, _addonActions.action)('search click')
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.Search20, null)), /*#__PURE__*/_react.default.createElement(_.HeaderGlobalAction, {
    "aria-label": "Notifications",
    onClick: (0, _addonActions.action)('notification click')
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.Notification20, null)), /*#__PURE__*/_react.default.createElement(_.HeaderGlobalAction, {
    "aria-label": "App Switcher",
    onClick: (0, _addonActions.action)('app-switcher click'),
    tooltipAlignment: "end"
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.AppSwitcher20, null)))), /*#__PURE__*/_react.default.createElement(StoryContent, null));
};

exports.HeaderBaseWSkipToContent = HeaderBaseWSkipToContent;
HeaderBaseWSkipToContent.storyName = 'Header Base w/ SkipToContent';

var HeaderBaseWNavigationAndActions = function HeaderBaseWNavigationAndActions() {
  return /*#__PURE__*/_react.default.createElement(_.HeaderContainer, {
    render: function render(_ref3) {
      var isSideNavExpanded = _ref3.isSideNavExpanded,
          onClickSideNavExpand = _ref3.onClickSideNavExpand;
      return /*#__PURE__*/_react.default.createElement(_.Header, {
        "aria-label": "IBM Platform Name"
      }, /*#__PURE__*/_react.default.createElement(_.SkipToContent, null), /*#__PURE__*/_react.default.createElement(_.HeaderMenuButton, {
        "aria-label": "Open menu",
        onClick: onClickSideNavExpand,
        isActive: isSideNavExpanded
      }), /*#__PURE__*/_react.default.createElement(_.HeaderName, {
        href: "#",
        prefix: "IBM"
      }, "[Platform]"), /*#__PURE__*/_react.default.createElement(_.HeaderNavigation, {
        "aria-label": "IBM [Platform]"
      }, /*#__PURE__*/_react.default.createElement(_.HeaderMenuItem, {
        href: "#"
      }, "Link 1"), /*#__PURE__*/_react.default.createElement(_.HeaderMenuItem, {
        href: "#"
      }, "Link 2"), /*#__PURE__*/_react.default.createElement(_.HeaderMenuItem, {
        href: "#"
      }, "Link 3"), /*#__PURE__*/_react.default.createElement(_.HeaderMenu, {
        "aria-label": "Link 4",
        menuLinkName: "Link 4"
      }, /*#__PURE__*/_react.default.createElement(_.HeaderMenuItem, {
        href: "#"
      }, "Sub-link 1"), /*#__PURE__*/_react.default.createElement(_.HeaderMenuItem, {
        href: "#"
      }, "Sub-link 2"), /*#__PURE__*/_react.default.createElement(_.HeaderMenuItem, {
        href: "#"
      }, "Sub-link 3"))), /*#__PURE__*/_react.default.createElement(_.HeaderGlobalBar, null, /*#__PURE__*/_react.default.createElement(_.HeaderGlobalAction, {
        "aria-label": "Search",
        onClick: (0, _addonActions.action)('search click')
      }, /*#__PURE__*/_react.default.createElement(_iconsReact.Search20, null)), /*#__PURE__*/_react.default.createElement(_.HeaderGlobalAction, {
        "aria-label": "Notifications",
        onClick: (0, _addonActions.action)('notification click')
      }, /*#__PURE__*/_react.default.createElement(_iconsReact.Notification20, null)), /*#__PURE__*/_react.default.createElement(_.HeaderGlobalAction, {
        "aria-label": "App Switcher",
        onClick: (0, _addonActions.action)('app-switcher click'),
        tooltipAlignment: "end"
      }, /*#__PURE__*/_react.default.createElement(_iconsReact.AppSwitcher20, null))), /*#__PURE__*/_react.default.createElement(_.SideNav, {
        "aria-label": "Side navigation",
        expanded: isSideNavExpanded,
        isPersistent: false
      }, /*#__PURE__*/_react.default.createElement(_.SideNavItems, null, /*#__PURE__*/_react.default.createElement(_.HeaderSideNavItems, null, /*#__PURE__*/_react.default.createElement(_.HeaderMenuItem, {
        href: "#"
      }, "Link 1"), /*#__PURE__*/_react.default.createElement(_.HeaderMenuItem, {
        href: "#"
      }, "Link 2"), /*#__PURE__*/_react.default.createElement(_.HeaderMenuItem, {
        href: "#"
      }, "Link 3"), /*#__PURE__*/_react.default.createElement(_.HeaderMenu, {
        "aria-label": "Link 4",
        menuLinkName: "Link 4"
      }, /*#__PURE__*/_react.default.createElement(_.HeaderMenuItem, {
        href: "#"
      }, "Sub-link 1"), /*#__PURE__*/_react.default.createElement(_.HeaderMenuItem, {
        href: "#"
      }, "Sub-link 2"), /*#__PURE__*/_react.default.createElement(_.HeaderMenuItem, {
        href: "#"
      }, "Sub-link 3"))))));
    }
  });
};

exports.HeaderBaseWNavigationAndActions = HeaderBaseWNavigationAndActions;
HeaderBaseWNavigationAndActions.storyName = 'Header Base w/ Navigation and Actions';

var HeaderBaseWNavigationActionsAndSideNav = function HeaderBaseWNavigationActionsAndSideNav() {
  return /*#__PURE__*/_react.default.createElement(_.HeaderContainer, {
    render: function render(_ref4) {
      var isSideNavExpanded = _ref4.isSideNavExpanded,
          onClickSideNavExpand = _ref4.onClickSideNavExpand;
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_.Header, {
        "aria-label": "IBM Platform Name"
      }, /*#__PURE__*/_react.default.createElement(_.SkipToContent, null), /*#__PURE__*/_react.default.createElement(_.HeaderMenuButton, {
        "aria-label": "Open menu",
        onClick: onClickSideNavExpand,
        isActive: isSideNavExpanded
      }), /*#__PURE__*/_react.default.createElement(_.HeaderName, {
        href: "#",
        prefix: "IBM"
      }, "[Platform]"), /*#__PURE__*/_react.default.createElement(_.HeaderNavigation, {
        "aria-label": "IBM [Platform]"
      }, /*#__PURE__*/_react.default.createElement(_.HeaderMenuItem, {
        href: "#"
      }, "Link 1"), /*#__PURE__*/_react.default.createElement(_.HeaderMenuItem, {
        href: "#"
      }, "Link 2"), /*#__PURE__*/_react.default.createElement(_.HeaderMenuItem, {
        href: "#"
      }, "Link 3"), /*#__PURE__*/_react.default.createElement(_.HeaderMenu, {
        "aria-label": "Link 4",
        menuLinkName: "Link 4"
      }, /*#__PURE__*/_react.default.createElement(_.HeaderMenuItem, {
        href: "#one"
      }, "Sub-link 1"), /*#__PURE__*/_react.default.createElement(_.HeaderMenuItem, {
        href: "#two"
      }, "Sub-link 2"), /*#__PURE__*/_react.default.createElement(_.HeaderMenuItem, {
        href: "#three"
      }, "Sub-link 3"))), /*#__PURE__*/_react.default.createElement(_.HeaderGlobalBar, null, /*#__PURE__*/_react.default.createElement(_.HeaderGlobalAction, {
        "aria-label": "Search",
        onClick: (0, _addonActions.action)('search click')
      }, /*#__PURE__*/_react.default.createElement(_iconsReact.Search20, null)), /*#__PURE__*/_react.default.createElement(_.HeaderGlobalAction, {
        "aria-label": "Notifications",
        onClick: (0, _addonActions.action)('notification click')
      }, /*#__PURE__*/_react.default.createElement(_iconsReact.Notification20, null)), /*#__PURE__*/_react.default.createElement(_.HeaderGlobalAction, {
        "aria-label": "App Switcher",
        onClick: (0, _addonActions.action)('app-switcher click'),
        tooltipAlignment: "end"
      }, /*#__PURE__*/_react.default.createElement(_iconsReact.AppSwitcher20, null))), /*#__PURE__*/_react.default.createElement(_.SideNav, {
        "aria-label": "Side navigation",
        expanded: isSideNavExpanded
      }, /*#__PURE__*/_react.default.createElement(_.SideNavItems, null, /*#__PURE__*/_react.default.createElement(_.HeaderSideNavItems, {
        hasDivider: true
      }, /*#__PURE__*/_react.default.createElement(_.HeaderMenuItem, {
        href: "#"
      }, "Link 1"), /*#__PURE__*/_react.default.createElement(_.HeaderMenuItem, {
        href: "#"
      }, "Link 2"), /*#__PURE__*/_react.default.createElement(_.HeaderMenuItem, {
        href: "#"
      }, "Link 3"), /*#__PURE__*/_react.default.createElement(_.HeaderMenu, {
        "aria-label": "Link 4",
        menuLinkName: "Link 4"
      }, /*#__PURE__*/_react.default.createElement(_.HeaderMenuItem, {
        href: "#"
      }, "Sub-link 1"), /*#__PURE__*/_react.default.createElement(_.HeaderMenuItem, {
        href: "#"
      }, "Sub-link 2"), /*#__PURE__*/_react.default.createElement(_.HeaderMenuItem, {
        href: "#"
      }, "Sub-link 3"))), /*#__PURE__*/_react.default.createElement(_.SideNavMenu, {
        renderIcon: _iconsReact.Fade16,
        title: "Category title"
      }, /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
        href: "https://www.carbondesignsystem.com/"
      }, "Link"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
        href: "https://www.carbondesignsystem.com/"
      }, "Link"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
        href: "https://www.carbondesignsystem.com/"
      }, "Link")), /*#__PURE__*/_react.default.createElement(_.SideNavMenu, {
        renderIcon: _iconsReact.Fade16,
        title: "Category title"
      }, /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
        href: "https://www.carbondesignsystem.com/"
      }, "Link"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
        href: "https://www.carbondesignsystem.com/"
      }, "Link"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
        href: "https://www.carbondesignsystem.com/"
      }, "Link")), /*#__PURE__*/_react.default.createElement(_.SideNavMenu, {
        renderIcon: _iconsReact.Fade16,
        title: "Category title",
        isActive: true
      }, /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
        href: "https://www.carbondesignsystem.com/"
      }, "Link"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
        "aria-current": "page",
        href: "https://www.carbondesignsystem.com/"
      }, "Link"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
        href: "https://www.carbondesignsystem.com/"
      }, "Link")), /*#__PURE__*/_react.default.createElement(_.SideNavLink, {
        renderIcon: _iconsReact.Fade16,
        href: "https://www.carbondesignsystem.com/"
      }, "Link"), /*#__PURE__*/_react.default.createElement(_.SideNavLink, {
        renderIcon: _iconsReact.Fade16,
        href: "https://www.carbondesignsystem.com/"
      }, "Link")))), /*#__PURE__*/_react.default.createElement(StoryContent, null));
    }
  });
};

exports.HeaderBaseWNavigationActionsAndSideNav = HeaderBaseWNavigationActionsAndSideNav;
HeaderBaseWNavigationActionsAndSideNav.storyName = 'Header Base w/ Navigation, Actions and SideNav';

var HeaderBaseWSideNav = function HeaderBaseWSideNav() {
  return /*#__PURE__*/_react.default.createElement(_.HeaderContainer, {
    render: function render(_ref5) {
      var isSideNavExpanded = _ref5.isSideNavExpanded,
          onClickSideNavExpand = _ref5.onClickSideNavExpand;
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_.Header, {
        "aria-label": "IBM Platform Name"
      }, /*#__PURE__*/_react.default.createElement(_.SkipToContent, null), /*#__PURE__*/_react.default.createElement(_.HeaderMenuButton, {
        "aria-label": "Open menu",
        onClick: onClickSideNavExpand,
        isActive: isSideNavExpanded
      }), /*#__PURE__*/_react.default.createElement(_.HeaderName, {
        href: "#",
        prefix: "IBM"
      }, "[Platform]"), /*#__PURE__*/_react.default.createElement(_.SideNav, {
        "aria-label": "Side navigation",
        expanded: isSideNavExpanded
      }, /*#__PURE__*/_react.default.createElement(_.SideNavItems, null, /*#__PURE__*/_react.default.createElement(_.SideNavMenu, {
        renderIcon: _iconsReact.Fade16,
        title: "Category title"
      }, /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
        href: "https://www.carbondesignsystem.com/"
      }, "Link"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
        href: "https://www.carbondesignsystem.com/"
      }, "Link"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
        href: "https://www.carbondesignsystem.com/"
      }, "Link")), /*#__PURE__*/_react.default.createElement(_.SideNavMenu, {
        renderIcon: _iconsReact.Fade16,
        title: "Category title",
        isActive: true
      }, /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
        href: "https://www.carbondesignsystem.com/"
      }, "Link"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
        "aria-current": "page",
        href: "https://www.carbondesignsystem.com/"
      }, "Link"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
        href: "https://www.carbondesignsystem.com/"
      }, "Link")), /*#__PURE__*/_react.default.createElement(_.SideNavMenu, {
        renderIcon: _iconsReact.Fade16,
        title: "Category title"
      }, /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
        href: "https://www.carbondesignsystem.com/"
      }, "Link"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
        href: "https://www.carbondesignsystem.com/"
      }, "Link"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
        href: "https://www.carbondesignsystem.com/"
      }, "Link")), /*#__PURE__*/_react.default.createElement(_.SideNavLink, {
        renderIcon: _iconsReact.Fade16,
        href: "https://www.carbondesignsystem.com/"
      }, "Link"), /*#__PURE__*/_react.default.createElement(_.SideNavLink, {
        renderIcon: _iconsReact.Fade16,
        href: "https://www.carbondesignsystem.com/"
      }, "Link")))), /*#__PURE__*/_react.default.createElement(StoryContent, null));
    }
  });
};

exports.HeaderBaseWSideNav = HeaderBaseWSideNav;
HeaderBaseWSideNav.storyName = 'Header Base w/ SideNav';

var HeaderBaseWActionsAndRightPanel = function HeaderBaseWActionsAndRightPanel() {
  return /*#__PURE__*/_react.default.createElement(_.Header, {
    "aria-label": "IBM Platform Name"
  }, /*#__PURE__*/_react.default.createElement(_.HeaderName, {
    href: "#",
    prefix: "IBM"
  }, "[Platform]"), /*#__PURE__*/_react.default.createElement(_.HeaderGlobalBar, null, /*#__PURE__*/_react.default.createElement(_.HeaderGlobalAction, {
    "aria-label": "Search",
    onClick: (0, _addonActions.action)('search click')
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.Search20, null)), /*#__PURE__*/_react.default.createElement(_.HeaderGlobalAction, {
    "aria-label": "Notifications",
    isActive: true,
    onClick: (0, _addonActions.action)('notification click')
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.Notification20, null)), /*#__PURE__*/_react.default.createElement(_.HeaderGlobalAction, {
    "aria-label": "App Switcher",
    onClick: (0, _addonActions.action)('app-switcher click'),
    tooltipAlignment: "end"
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.AppSwitcher20, null))), /*#__PURE__*/_react.default.createElement(_.HeaderPanel, {
    "aria-label": "Header Panel",
    expanded: true
  }));
};

exports.HeaderBaseWActionsAndRightPanel = HeaderBaseWActionsAndRightPanel;
HeaderBaseWActionsAndRightPanel.storyName = 'Header Base w/ Actions and Right Panel';

var HeaderBaseWActionsAndSwitcher = function HeaderBaseWActionsAndSwitcher() {
  return /*#__PURE__*/_react.default.createElement(_.Header, {
    "aria-label": "IBM Platform Name"
  }, /*#__PURE__*/_react.default.createElement(_.HeaderName, {
    href: "#",
    prefix: "IBM"
  }, "[Platform]"), /*#__PURE__*/_react.default.createElement(_.HeaderGlobalBar, null, /*#__PURE__*/_react.default.createElement(_.HeaderGlobalAction, {
    "aria-label": "Search",
    onClick: (0, _addonActions.action)('search click')
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.Search20, null)), /*#__PURE__*/_react.default.createElement(_.HeaderGlobalAction, {
    "aria-label": "Notifications",
    onClick: (0, _addonActions.action)('notification click')
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.Notification20, null)), /*#__PURE__*/_react.default.createElement(_.HeaderGlobalAction, {
    "aria-label": "App Switcher",
    isActive: true,
    onClick: (0, _addonActions.action)('app-switcher click'),
    tooltipAlignment: "end"
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.AppSwitcher20, null))), /*#__PURE__*/_react.default.createElement(_.HeaderPanel, {
    "aria-label": "Header Panel",
    expanded: true
  }, /*#__PURE__*/_react.default.createElement(_.Switcher, {
    "aria-label": "Switcher Container"
  }, /*#__PURE__*/_react.default.createElement(_.SwitcherItem, {
    isSelected: true,
    "aria-label": "Link 1",
    href: "#"
  }, "Link 1"), /*#__PURE__*/_react.default.createElement(_.SwitcherDivider, null), /*#__PURE__*/_react.default.createElement(_.SwitcherItem, {
    href: "#",
    "aria-label": "Link 2"
  }, "Link 2"), /*#__PURE__*/_react.default.createElement(_.SwitcherItem, {
    href: "#",
    "aria-label": "Link 3"
  }, "Link 3"), /*#__PURE__*/_react.default.createElement(_.SwitcherItem, {
    href: "#",
    "aria-label": "Link 4"
  }, "Link 4"), /*#__PURE__*/_react.default.createElement(_.SwitcherItem, {
    href: "#",
    "aria-label": "Link 5"
  }, "Link 5"), /*#__PURE__*/_react.default.createElement(_.SwitcherDivider, null), /*#__PURE__*/_react.default.createElement(_.SwitcherItem, {
    href: "#",
    "aria-label": "Link 6"
  }, "Link 6"))));
};

exports.HeaderBaseWActionsAndSwitcher = HeaderBaseWActionsAndSwitcher;
HeaderBaseWActionsAndSwitcher.storyName = 'Header Base w/ Actions and Switcher';

var FixedSideNav = function FixedSideNav() {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_.SideNav, {
    isFixedNav: true,
    expanded: true,
    isChildOfHeader: false,
    "aria-label": "Side navigation"
  }, /*#__PURE__*/_react.default.createElement(_.SideNavItems, null, /*#__PURE__*/_react.default.createElement(_.SideNavMenu, {
    title: "L0 menu"
  }, /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
    href: "https://www.carbondesignsystem.com/"
  }, "L0 menu item"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
    href: "https://www.carbondesignsystem.com/"
  }, "L0 menu item"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
    href: "https://www.carbondesignsystem.com/"
  }, "L0 menu item")), /*#__PURE__*/_react.default.createElement(_.SideNavMenu, {
    title: "L0 menu",
    isActive: true
  }, /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
    href: "https://www.carbondesignsystem.com/"
  }, "L0 menu item"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
    "aria-current": "page",
    href: "https://www.carbondesignsystem.com/"
  }, "L0 menu item"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
    href: "https://www.carbondesignsystem.com/"
  }, "L0 menu item")), /*#__PURE__*/_react.default.createElement(_.SideNavMenu, {
    title: "L0 menu"
  }, /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
    href: "https://www.carbondesignsystem.com/"
  }, "L0 menu item"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
    href: "https://www.carbondesignsystem.com/"
  }, "L0 menu item"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
    href: "https://www.carbondesignsystem.com/"
  }, "L0 menu item")), /*#__PURE__*/_react.default.createElement(_.SideNavLink, {
    href: "https://www.carbondesignsystem.com/"
  }, "L0 link"), /*#__PURE__*/_react.default.createElement(_.SideNavLink, {
    href: "https://www.carbondesignsystem.com/"
  }, "L0 link"))), /*#__PURE__*/_react.default.createElement(StoryContent, {
    useResponsiveOffset: false
  }));
};

exports.FixedSideNav = FixedSideNav;
FixedSideNav.storyName = 'Fixed SideNav';

var FixedSideNavWIcons = function FixedSideNavWIcons() {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_.SideNav, {
    isFixedNav: true,
    expanded: true,
    isChildOfHeader: false,
    "aria-label": "Side navigation"
  }, /*#__PURE__*/_react.default.createElement(_.SideNavItems, null, /*#__PURE__*/_react.default.createElement(_.SideNavMenu, {
    renderIcon: _iconsReact.Fade16,
    title: "Category title"
  }, /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
    href: "https://www.carbondesignsystem.com/"
  }, "Link"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
    href: "https://www.carbondesignsystem.com/"
  }, "Link"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
    href: "https://www.carbondesignsystem.com/"
  }, "Link")), /*#__PURE__*/_react.default.createElement(_.SideNavMenu, {
    renderIcon: _iconsReact.Fade16,
    title: "Category title",
    isActive: true
  }, /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
    href: "https://www.carbondesignsystem.com/"
  }, "Link"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
    "aria-current": "page",
    href: "https://www.carbondesignsystem.com/"
  }, "Link"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
    href: "https://www.carbondesignsystem.com/"
  }, "Link")), /*#__PURE__*/_react.default.createElement(_.SideNavMenu, {
    renderIcon: _iconsReact.Fade16,
    title: "Category title"
  }, /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
    href: "https://www.carbondesignsystem.com/"
  }, "Link"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
    href: "https://www.carbondesignsystem.com/"
  }, "Link"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
    href: "https://www.carbondesignsystem.com/"
  }, "Link")), /*#__PURE__*/_react.default.createElement(_.SideNavLink, {
    renderIcon: _iconsReact.Fade16,
    href: "https://www.carbondesignsystem.com/"
  }, "Link"), /*#__PURE__*/_react.default.createElement(_.SideNavLink, {
    renderIcon: _iconsReact.Fade16,
    href: "https://www.carbondesignsystem.com/"
  }, "Link"))), /*#__PURE__*/_react.default.createElement(StoryContent, {
    useResponsiveOffset: false
  }));
};

exports.FixedSideNavWIcons = FixedSideNavWIcons;
FixedSideNavWIcons.storyName = 'Fixed SideNav w/ Icons';

var FixedSideNavWDivider = function FixedSideNavWDivider() {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_.SideNav, {
    isFixedNav: true,
    expanded: true,
    isChildOfHeader: false,
    "aria-label": "Side navigation"
  }, /*#__PURE__*/_react.default.createElement(_.SideNavItems, null, /*#__PURE__*/_react.default.createElement(_.SideNavMenu, {
    title: "L0 menu"
  }, /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
    href: "https://www.carbondesignsystem.com/"
  }, "L0 menu item"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
    href: "https://www.carbondesignsystem.com/"
  }, "L0 menu item"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
    href: "https://www.carbondesignsystem.com/"
  }, "L0 menu item")), /*#__PURE__*/_react.default.createElement(_.SideNavMenu, {
    title: "L0 menu",
    isActive: true
  }, /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
    href: "https://www.carbondesignsystem.com/"
  }, "L0 menu item"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
    "aria-current": "page",
    href: "https://www.carbondesignsystem.com/"
  }, "L0 menu item"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
    href: "https://www.carbondesignsystem.com/"
  }, "L0 menu item")), /*#__PURE__*/_react.default.createElement(_.SideNavMenu, {
    title: "L0 menu"
  }, /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
    href: "https://www.carbondesignsystem.com/"
  }, "L0 menu item"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
    href: "https://www.carbondesignsystem.com/"
  }, "L0 menu item"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
    href: "https://www.carbondesignsystem.com/"
  }, "L0 menu item")), /*#__PURE__*/_react.default.createElement(_.SideNavDivider, null), /*#__PURE__*/_react.default.createElement(_.SideNavLink, {
    href: "https://www.carbondesignsystem.com/"
  }, "L0 link"), /*#__PURE__*/_react.default.createElement(_.SideNavLink, {
    href: "https://www.carbondesignsystem.com/"
  }, "L0 link"))), /*#__PURE__*/_react.default.createElement(StoryContent, {
    useResponsiveOffset: false
  }));
};

exports.FixedSideNavWDivider = FixedSideNavWDivider;
FixedSideNavWDivider.storyName = 'Fixed SideNav w/ Divider';

var SideNavRail = function SideNavRail() {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_.SideNav, {
    "aria-label": "Side navigation",
    isRail: true
  }, /*#__PURE__*/_react.default.createElement(_.SideNavItems, null, /*#__PURE__*/_react.default.createElement(_.SideNavMenu, {
    renderIcon: _iconsReact.Fade16,
    title: "Category title"
  }, /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
    href: "https://www.carbondesignsystem.com/"
  }, "Link"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
    "aria-current": "page",
    href: "https://www.carbondesignsystem.com/"
  }, "Link"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
    href: "https://www.carbondesignsystem.com/"
  }, "Link")), /*#__PURE__*/_react.default.createElement(_.SideNavMenu, {
    renderIcon: _iconsReact.Fade16,
    title: "Category title"
  }, /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
    href: "https://www.carbondesignsystem.com/"
  }, "Link"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
    href: "https://www.carbondesignsystem.com/"
  }, "Link"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
    href: "https://www.carbondesignsystem.com/"
  }, "Link")), /*#__PURE__*/_react.default.createElement(_.SideNavMenu, {
    renderIcon: _iconsReact.Fade16,
    title: "Category title"
  }, /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
    href: "https://www.carbondesignsystem.com/"
  }, "Link"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
    href: "https://www.carbondesignsystem.com/"
  }, "Link"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
    href: "https://www.carbondesignsystem.com/"
  }, "Link")), /*#__PURE__*/_react.default.createElement(_.SideNavLink, {
    renderIcon: _iconsReact.Fade16,
    href: "https://www.carbondesignsystem.com/"
  }, "Link"), /*#__PURE__*/_react.default.createElement(_.SideNavLink, {
    renderIcon: _iconsReact.Fade16,
    href: "https://www.carbondesignsystem.com/"
  }, "Link"))), /*#__PURE__*/_react.default.createElement(StoryContent, null));
};

exports.SideNavRail = SideNavRail;
SideNavRail.storyName = 'SideNav Rail';

var SideNavRailWHeader = function SideNavRailWHeader() {
  return /*#__PURE__*/_react.default.createElement(_.HeaderContainer, {
    render: function render(_ref6) {
      var isSideNavExpanded = _ref6.isSideNavExpanded,
          onClickSideNavExpand = _ref6.onClickSideNavExpand;
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_.Header, {
        "aria-label": "IBM Platform Name"
      }, /*#__PURE__*/_react.default.createElement(_.SkipToContent, null), /*#__PURE__*/_react.default.createElement(_.HeaderMenuButton, {
        "aria-label": "Open menu",
        isCollapsible: true,
        onClick: onClickSideNavExpand,
        isActive: isSideNavExpanded
      }), /*#__PURE__*/_react.default.createElement(_.HeaderName, {
        href: "#",
        prefix: "IBM"
      }, "[Platform]"), /*#__PURE__*/_react.default.createElement(_.HeaderNavigation, {
        "aria-label": "IBM [Platform]"
      }, /*#__PURE__*/_react.default.createElement(_.HeaderMenuItem, {
        href: "#"
      }, "Link 1"), /*#__PURE__*/_react.default.createElement(_.HeaderMenuItem, {
        href: "#"
      }, "Link 2"), /*#__PURE__*/_react.default.createElement(_.HeaderMenuItem, {
        href: "#"
      }, "Link 3"), /*#__PURE__*/_react.default.createElement(_.HeaderMenu, {
        "aria-label": "Link 4",
        menuLinkName: "Link 4"
      }, /*#__PURE__*/_react.default.createElement(_.HeaderMenuItem, {
        href: "#"
      }, "Sub-link 1"), /*#__PURE__*/_react.default.createElement(_.HeaderMenuItem, {
        href: "#"
      }, "Sub-link 2"), /*#__PURE__*/_react.default.createElement(_.HeaderMenuItem, {
        href: "#"
      }, "Sub-link 3"))), /*#__PURE__*/_react.default.createElement(_.HeaderGlobalBar, null, /*#__PURE__*/_react.default.createElement(_.HeaderGlobalAction, {
        "aria-label": "Search",
        onClick: (0, _addonActions.action)('search click')
      }, /*#__PURE__*/_react.default.createElement(_iconsReact.Search20, null)), /*#__PURE__*/_react.default.createElement(_.HeaderGlobalAction, {
        "aria-label": "Notifications",
        onClick: (0, _addonActions.action)('notification click')
      }, /*#__PURE__*/_react.default.createElement(_iconsReact.Notification20, null)), /*#__PURE__*/_react.default.createElement(_.HeaderGlobalAction, {
        "aria-label": "App Switcher",
        onClick: (0, _addonActions.action)('app-switcher click'),
        tooltipAlignment: "end"
      }, /*#__PURE__*/_react.default.createElement(_iconsReact.AppSwitcher20, null))), /*#__PURE__*/_react.default.createElement(_.SideNav, {
        "aria-label": "Side navigation",
        isRail: true,
        expanded: isSideNavExpanded,
        onOverlayClick: onClickSideNavExpand
      }, /*#__PURE__*/_react.default.createElement(_.SideNavItems, null, /*#__PURE__*/_react.default.createElement(_.SideNavMenu, {
        renderIcon: _iconsReact.Fade16,
        title: "Category title"
      }, /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
        href: "https://www.carbondesignsystem.com/"
      }, "Link"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
        "aria-current": "page",
        href: "https://www.carbondesignsystem.com/"
      }, "Link"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
        href: "https://www.carbondesignsystem.com/"
      }, "Link")), /*#__PURE__*/_react.default.createElement(_.SideNavMenu, {
        renderIcon: _iconsReact.Fade16,
        title: "Category title"
      }, /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
        href: "https://www.carbondesignsystem.com/"
      }, "Link"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
        "aria-current": "page",
        href: "https://www.carbondesignsystem.com/"
      }, "Link"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
        href: "https://www.carbondesignsystem.com/"
      }, "Link")), /*#__PURE__*/_react.default.createElement(_.SideNavMenu, {
        renderIcon: _iconsReact.Fade16,
        title: "Category title"
      }, /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
        href: "https://www.carbondesignsystem.com/"
      }, "Link"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
        "aria-current": "page",
        href: "https://www.carbondesignsystem.com/"
      }, "Link"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
        href: "https://www.carbondesignsystem.com/"
      }, "Link")), /*#__PURE__*/_react.default.createElement(_.SideNavLink, {
        renderIcon: _iconsReact.Fade16,
        href: "https://www.carbondesignsystem.com/"
      }, "Link"), /*#__PURE__*/_react.default.createElement(_.SideNavLink, {
        renderIcon: _iconsReact.Fade16,
        href: "https://www.carbondesignsystem.com/"
      }, "Link")))), /*#__PURE__*/_react.default.createElement(StoryContent, null));
    }
  });
};

exports.SideNavRailWHeader = SideNavRailWHeader;
SideNavRailWHeader.storyName = 'SideNav Rail w/Header';

var SideNavWLargeSideNavItems = function SideNavWLargeSideNavItems() {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_.SideNav, {
    expanded: true,
    isChildOfHeader: false,
    "aria-label": "Side navigation"
  }, /*#__PURE__*/_react.default.createElement(_.SideNavItems, null, /*#__PURE__*/_react.default.createElement(_.SideNavMenu, {
    title: "Large menu",
    large: true
  }, /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
    href: "https://www.carbondesignsystem.com/"
  }, "Menu 1"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
    href: "https://www.carbondesignsystem.com/"
  }, "Menu 2"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
    href: "https://www.carbondesignsystem.com/"
  }, "Menu 3")), /*#__PURE__*/_react.default.createElement(_.SideNavLink, {
    href: "https://www.carbondesignsystem.com/",
    large: true
  }, "Large link"), /*#__PURE__*/_react.default.createElement(_.SideNavMenu, {
    renderIcon: _iconsReact.Fade16,
    title: "Large menu w/icon",
    large: true
  }, /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
    href: "https://www.carbondesignsystem.com/"
  }, "Menu 1"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
    href: "https://www.carbondesignsystem.com/"
  }, "Menu 2"), /*#__PURE__*/_react.default.createElement(_.SideNavMenuItem, {
    href: "https://www.carbondesignsystem.com/"
  }, "Menu 3")), /*#__PURE__*/_react.default.createElement(_.SideNavLink, {
    renderIcon: _iconsReact.Fade16,
    href: "https://www.carbondesignsystem.com/",
    large: true
  }, "Large link w/icon"))), /*#__PURE__*/_react.default.createElement(StoryContent, null));
};

exports.SideNavWLargeSideNavItems = SideNavWLargeSideNavItems;
SideNavWLargeSideNavItems.storyName = 'SideNav w/ large side nav items';