"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _classnames = _interopRequireDefault(require("classnames"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _AriaPropTypes = require("../../prop-types/AriaPropTypes");

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["aria-label", "aria-labelledby", "children", "className"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var HeaderNavigation = /*#__PURE__*/function (_React$Component) {
  (0, _inherits2.default)(HeaderNavigation, _React$Component);

  var _super = _createSuper(HeaderNavigation);

  function HeaderNavigation(props) {
    var _this;

    (0, _classCallCheck2.default)(this, HeaderNavigation);
    _this = _super.call(this, props);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleItemRef", function (index) {
      return function (node) {
        _this.items[index] = node;
      };
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "_renderNavItem", function (child, index) {
      if ( /*#__PURE__*/_react.default.isValidElement(child)) {
        return /*#__PURE__*/_react.default.cloneElement(child, {
          ref: _this.handleItemRef(index)
        });
      }
    });
    _this.items = [];
    _this.state = {
      selectedIndex: 0
    };
    return _this;
  }

  (0, _createClass2.default)(HeaderNavigation, [{
    key: "render",
    value: function render() {
      var prefix = this.context;
      var _this$props = this.props,
          ariaLabel = _this$props['aria-label'],
          ariaLabelledBy = _this$props['aria-labelledby'],
          children = _this$props.children,
          customClassName = _this$props.className,
          rest = (0, _objectWithoutProperties2.default)(_this$props, _excluded);
      var className = (0, _classnames.default)("".concat(prefix, "--header__nav"), customClassName); // Assign both label strategies in this option, only one should be defined
      // so when we spread that should be the one that is applied to the node

      var accessibilityLabel = {
        'aria-label': ariaLabel,
        'aria-labelledby': ariaLabelledBy
      };
      return /*#__PURE__*/_react.default.createElement("nav", (0, _extends2.default)({}, rest, accessibilityLabel, {
        className: className
      }), /*#__PURE__*/_react.default.createElement("ul", (0, _extends2.default)({}, accessibilityLabel, {
        className: "".concat(prefix, "--header__menu-bar")
      }), _react.default.Children.map(children, this._renderNavItem)));
    }
    /**
     * Render an individual menuitem, adding a `ref` for each child inside of
     * `this.items` to properly manage focus.
     */

  }]);
  return HeaderNavigation;
}(_react.default.Component);

exports.default = HeaderNavigation;
(0, _defineProperty2.default)(HeaderNavigation, "propTypes", _objectSpread(_objectSpread({}, _AriaPropTypes.AriaLabelPropType), {}, {
  /**
   * Provide valid children of HeaderNavigation, for example `HeaderMenuItem`
   * or `HeaderMenu`
   */
  children: _propTypes.default.node,

  /**
   * Optionally provide a custom class to apply to the underlying <nav> node
   */
  className: _propTypes.default.string
}));
(0, _defineProperty2.default)(HeaderNavigation, "contextType", _usePrefix.PrefixContext);