"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _iconsReact = require("@carbon/icons-react");

var _classnames = _interopRequireDefault(require("classnames"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _AriaPropTypes = require("../../prop-types/AriaPropTypes");

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["aria-label", "aria-labelledby", "className", "renderMenuIcon", "renderCloseIcon", "onClick", "isActive", "isCollapsible"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var HeaderMenuButton = function HeaderMenuButton(_ref) {
  var _cx;

  var ariaLabel = _ref['aria-label'],
      ariaLabelledBy = _ref['aria-labelledby'],
      customClassName = _ref.className,
      renderMenuIcon = _ref.renderMenuIcon,
      renderCloseIcon = _ref.renderCloseIcon,
      onClick = _ref.onClick,
      isActive = _ref.isActive,
      isCollapsible = _ref.isCollapsible,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();
  var className = (0, _classnames.default)((_cx = {}, (0, _defineProperty2.default)(_cx, customClassName, !!customClassName), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--header__action"), true), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--header__menu-trigger"), true), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--header__action--active"), isActive), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--header__menu-toggle"), true), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--header__menu-toggle__hidden"), !isCollapsible), _cx));
  var accessibilityLabel = {
    'aria-label': ariaLabel,
    'aria-labelledby': ariaLabelledBy
  };
  var menuIcon = renderMenuIcon ? renderMenuIcon : /*#__PURE__*/_react.default.createElement(_iconsReact.Menu20, null);
  var closeIcon = renderCloseIcon ? renderCloseIcon : /*#__PURE__*/_react.default.createElement(_iconsReact.Close20, null);
  return /*#__PURE__*/_react.default.createElement("button", (0, _extends2.default)({}, rest, accessibilityLabel, {
    className: className,
    title: ariaLabel,
    type: "button",
    onClick: onClick
  }), isActive ? closeIcon : menuIcon);
};

HeaderMenuButton.propTypes = _objectSpread(_objectSpread({}, _AriaPropTypes.AriaLabelPropType), {}, {
  /**
   * Optionally provide a custom class name that is applied to the underlying
   * button
   */
  className: _propTypes.default.string,
  isActive: _propTypes.default.bool,

  /**
   * Optionally provide an onClick handler that is called when the underlying
   * button fires it's onclick event
   */
  onClick: _propTypes.default.func
});
var _default = HeaderMenuButton;
exports.default = _default;