"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _iconsReact = require("@carbon/icons-react");

var _classnames = _interopRequireDefault(require("classnames"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _keyboard = require("../../internal/keyboard");

var _AriaPropTypes = require("../../prop-types/AriaPropTypes");

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["isCurrentPage", "aria-label", "aria-labelledby", "className", "children", "renderMenuContent", "menuLinkName", "focusRef"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * `HeaderMenu` is used to render submenu's in the `Header`. Most often children
 * will be a `HeaderMenuItem`. It handles certain keyboard events to help
 * with managing focus. It also passes along refs to each child so that it can
 * help manage focus state of its children.
 */
var HeaderMenu = /*#__PURE__*/function (_React$Component) {
  (0, _inherits2.default)(HeaderMenu, _React$Component);

  var _super = _createSuper(HeaderMenu);

  function HeaderMenu(props) {
    var _this;

    (0, _classCallCheck2.default)(this, HeaderMenu);
    _this = _super.call(this, props);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "_subMenus", /*#__PURE__*/_react.default.createRef());
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleOnClick", function (e) {
      var subMenusNode = _this._subMenus.current;

      if (!subMenusNode || !subMenusNode.contains(e.target)) {
        e.preventDefault();
      }

      _this.setState(function (prevState) {
        return {
          expanded: !prevState.expanded
        };
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleOnKeyDown", function (event) {
      // Handle enter or space key for toggling the expanded state of the menu.
      if ((0, _keyboard.matches)(event, [_keyboard.keys.Enter, _keyboard.keys.Space])) {
        event.stopPropagation();
        event.preventDefault();

        _this.setState(function (prevState) {
          return {
            expanded: !prevState.expanded
          };
        });

        return;
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleOnBlur", function (event) {
      // Rough guess for a blur event that is triggered outside of our menu or
      // menubar context
      var itemTriggeredBlur = _this.items.find(function (element) {
        return element === event.relatedTarget;
      });

      if (event.relatedTarget && (event.relatedTarget.getAttribute('href') && event.relatedTarget.getAttribute('href') !== '#' || itemTriggeredBlur)) {
        return;
      }

      _this.setState({
        expanded: false,
        selectedIndex: null
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleMenuButtonRef", function (node) {
      if (_this.props.focusRef) {
        _this.props.focusRef(node);
      }

      _this.menuButtonRef = node;
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleItemRef", function (index) {
      return function (node) {
        _this.items[index] = node;
      };
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleMenuClose", function (event) {
      // Handle ESC keydown for closing the expanded menu.
      if ((0, _keyboard.matches)(event, [_keyboard.keys.Escape]) && _this.state.expanded) {
        event.stopPropagation();
        event.preventDefault();

        _this.setState(function () {
          return {
            expanded: false,
            selectedIndex: null
          };
        }); // Return focus to menu button when the user hits ESC.


        _this.menuButtonRef.focus();

        return;
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "_renderMenuItem", function (item, index) {
      if ( /*#__PURE__*/_react.default.isValidElement(item)) {
        return /*#__PURE__*/_react.default.cloneElement(item, {
          ref: _this.handleItemRef(index)
        });
      }
    });
    _this.state = {
      // Used to manage the expansion state of the menu
      expanded: false,
      // Refers to the menuitem that is currently focused
      // Note: children should have `role="menuitem"` on node consuming ref
      selectedIndex: null
    };
    _this.items = [];
    return _this;
  }
  /**
   * Toggle the expanded state of the menu on click.
   */


  (0, _createClass2.default)(HeaderMenu, [{
    key: "render",
    value: function render() {
      var _cx;

      var prefix = this.context;
      var _this$props = this.props,
          isCurrentPage = _this$props.isCurrentPage,
          ariaLabel = _this$props['aria-label'],
          ariaLabelledBy = _this$props['aria-labelledby'],
          customClassName = _this$props.className,
          children = _this$props.children,
          MenuContent = _this$props.renderMenuContent,
          menuLinkName = _this$props.menuLinkName,
          focusRef = _this$props.focusRef,
          rest = (0, _objectWithoutProperties2.default)(_this$props, _excluded);
      var accessibilityLabel = {
        'aria-label': ariaLabel,
        'aria-labelledby': ariaLabelledBy
      };
      var className = (0, _classnames.default)((_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--header__submenu"), true), (0, _defineProperty2.default)(_cx, customClassName, true), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--header__submenu--current"), isCurrentPage), _cx)); // Notes on eslint comments and based on the examples in:
      // https://www.w3.org/TR/wai-aria-practices/examples/menubar/menubar-1/menubar-1.html#
      // - The focus is handled by the <a> menuitem, onMouseOver is for mouse
      // users
      // - aria-haspopup can definitely have the value "menu"
      // - aria-expanded is on their example node with role="menuitem"
      // - href can be set to javascript:void(0), ideally this will be a button

      return /*#__PURE__*/_react.default.createElement("li", (0, _extends2.default)({}, rest, {
        className: className,
        onKeyDown: this.handleMenuClose,
        onClick: this.handleOnClick,
        onBlur: this.handleOnBlur
      }), /*#__PURE__*/_react.default.createElement("a", (0, _extends2.default)({
        // eslint-disable-line jsx-a11y/role-supports-aria-props,jsx-a11y/anchor-is-valid
        "aria-haspopup": "menu" // eslint-disable-line jsx-a11y/aria-proptypes
        ,
        "aria-expanded": this.state.expanded,
        className: "".concat(prefix, "--header__menu-item ").concat(prefix, "--header__menu-title"),
        href: "#",
        onKeyDown: this.handleOnKeyDown,
        ref: this.handleMenuButtonRef,
        tabIndex: 0
      }, accessibilityLabel), menuLinkName, MenuContent ? /*#__PURE__*/_react.default.createElement(MenuContent, null) : /*#__PURE__*/_react.default.createElement(_iconsReact.ChevronDown16, {
        className: "".concat(this.context, "--header__menu-arrow")
      })), /*#__PURE__*/_react.default.createElement("ul", (0, _extends2.default)({}, accessibilityLabel, {
        ref: this._subMenus,
        className: "".concat(prefix, "--header__menu")
      }), _react.default.Children.map(children, this._renderMenuItem)));
    }
    /**
     * We capture the `ref` for each child inside of `this.items` to properly
     * manage focus. In addition to this focus management, all items receive a
     * `tabIndex: -1` so the user won't hit a large number of items in their tab
     * sequence when they might not want to go through all the items.
     */

  }]);
  return HeaderMenu;
}(_react.default.Component);

(0, _defineProperty2.default)(HeaderMenu, "propTypes", _objectSpread(_objectSpread({}, _AriaPropTypes.AriaLabelPropType), {}, {
  /**
   * Provide a custom ref handler for the menu button
   */
  focusRef: _propTypes.default.func,

  /**
   * Provide a label for the link text
   */
  menuLinkName: _propTypes.default.string.isRequired,

  /**
   * Optional component to render instead of string
   */
  renderMenuContent: _propTypes.default.func,

  /**
   * Optionally provide a tabIndex for the underlying menu button
   */
  tabIndex: _propTypes.default.number
}));
(0, _defineProperty2.default)(HeaderMenu, "contextType", _usePrefix.PrefixContext);

var HeaderMenuForwardRef = /*#__PURE__*/_react.default.forwardRef(function (props, ref) {
  return /*#__PURE__*/_react.default.createElement(HeaderMenu, (0, _extends2.default)({}, props, {
    focusRef: ref
  }));
});

HeaderMenuForwardRef.displayName = 'HeaderMenu';
var _default = HeaderMenuForwardRef;
exports.default = _default;