"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UncontrolledTooltip = exports.OnlyCustomIcon = exports.RenderCustomIcon = exports.NoIcon = exports.AutoOrientation = exports.DefaultBottom = exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _react = _interopRequireWildcard(require("react"));

var _carbonComponents = require("carbon-components");

var _addonKnobs = require("@storybook/addon-knobs");

var _Tooltip = _interopRequireDefault(require("../Tooltip"));

var _Tooltip2 = require("./Tooltip");

var _Button = _interopRequireDefault(require("../Button"));

var _iconsReact = require("@carbon/icons-react");

var _Tooltip3 = _interopRequireDefault(require("./Tooltip.mdx"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var prefix = _carbonComponents.settings.prefix;
var directions = {
  'Bottom (bottom)': 'bottom',
  'Left (left)': 'left',
  'Top (top)': 'top',
  'Right (right)': 'right'
};
var alignments = {
  'Start (start)': 'start',
  'Center (center)': 'center',
  'End (end)': 'end'
};
var props = {
  withIcon: function withIcon() {
    return {
      align: (0, _addonKnobs.select)('Tooltip alignment (align)', alignments, 'center'),
      direction: (0, _addonKnobs.select)('Tooltip direction (direction)', directions, 'bottom'),
      triggerText: (0, _addonKnobs.text)('Trigger text (triggerText)', 'Tooltip label'),
      tabIndex: (0, _addonKnobs.number)('Tab index (tabIndex in <Tooltip>)', 0),
      selectorPrimaryFocus: (0, _addonKnobs.text)('Primary focus element selector (selectorPrimaryFocus)', '')
    };
  },
  autoOrientation: function autoOrientation() {
    return {
      align: (0, _addonKnobs.select)('Tooltip alignment (align)', alignments, 'center'),
      direction: (0, _addonKnobs.select)('Tooltip direction (direction)', directions, 'bottom'),
      triggerText: (0, _addonKnobs.text)('Trigger text (triggerText)', 'Test'),
      tabIndex: (0, _addonKnobs.number)('Tab index (tabIndex in <Tooltip>)', 0),
      selectorPrimaryFocus: (0, _addonKnobs.text)('Primary focus element selector (selectorPrimaryFocus)', ''),
      autoOrientation: (0, _addonKnobs.boolean)('Auto orientation', true)
    };
  },
  withoutIcon: function withoutIcon() {
    return {
      showIcon: false,
      align: (0, _addonKnobs.select)('Tooltip alignment (align)', alignments, 'center'),
      direction: (0, _addonKnobs.select)('Tooltip direction (direction)', directions, 'bottom'),
      triggerText: (0, _addonKnobs.text)('Trigger text (triggerText)', 'Tooltip label'),
      tabIndex: (0, _addonKnobs.number)('Tab index (tabIndex in <Tooltip>)', 0),
      selectorPrimaryFocus: (0, _addonKnobs.text)('Primary focus element selector (selectorPrimaryFocus)', '')
    };
  },
  customIcon: function customIcon() {
    return {
      showIcon: true,
      align: (0, _addonKnobs.select)('Tooltip alignment (align)', alignments, 'center'),
      direction: (0, _addonKnobs.select)('Tooltip direction (direction)', directions, 'bottom'),
      triggerText: (0, _addonKnobs.text)('Trigger text (triggerText)', 'Tooltip label'),
      tabIndex: (0, _addonKnobs.number)('Tab index (tabIndex in <Tooltip>)', 0),
      selectorPrimaryFocus: (0, _addonKnobs.text)('Primary focus element selector (selectorPrimaryFocus)', ''),
      // eslint-disable-next-line react/display-name
      renderIcon: function renderIcon() {
        return /*#__PURE__*/_react.default.createElement("svg", {
          xmlns: "http://www.w3.org/2000/svg",
          width: "16",
          height: "16"
        }, /*#__PURE__*/_react.default.createElement("path", {
          d: "M8.5 11V6.5h-2v1h1V11H6v1h4v-1zM8 3.5c-.4 0-.8.3-.8.8s.4.7.8.7.8-.3.8-.8-.4-.7-.8-.7z"
        }), /*#__PURE__*/_react.default.createElement("path", {
          d: "M8 15c-3.9 0-7-3.1-7-7s3.1-7 7-7 7 3.1 7 7-3.1 7-7 7zM8 2C4.7 2 2 4.7 2 8s2.7 6 6 6 6-2.7 6-6-2.7-6-6-6z"
        }), /*#__PURE__*/_react.default.createElement("path", {
          fill: "none",
          d: "M0 0h16v16H0z"
        }));
      }
    };
  },
  customIconOnly: function customIconOnly() {
    return {
      showIcon: true,
      align: (0, _addonKnobs.select)('Tooltip alignment (align)', alignments, 'center'),
      direction: (0, _addonKnobs.select)('Tooltip direction (direction)', directions, 'bottom'),
      iconDescription: 'Helpful Information',
      tabIndex: (0, _addonKnobs.number)('Tab index (tabIndex in <Tooltip>)', 0),
      selectorPrimaryFocus: (0, _addonKnobs.text)('Primary focus element selector (selectorPrimaryFocus)', ''),
      renderIcon: _iconsReact.OverflowMenuVertical16
    };
  }
};
var containerStyles = {
  height: 'calc(100vh - 6rem)',
  display: 'flex',
  justifyContent: 'center',
  alignItems: 'center'
};
_Tooltip.default.displayName = 'Tooltip';

function UncontrolledTooltipExample() {
  var _useState = (0, _react.useState)(true),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      value = _useState2[0],
      setValue = _useState2[1];

  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_Button.default, {
    style: {
      padding: '15px 20px',
      margin: '4px 20px'
    },
    onClick: function onClick() {
      return setValue(false);
    }
  }, "Hide"), /*#__PURE__*/_react.default.createElement(_Button.default, {
    style: {
      padding: '15px 20px',
      margin: '4px 20px'
    },
    onClick: function onClick() {
      return setValue(true);
    }
  }, "Show"), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      padding: '15px',
      margin: '4px 20px'
    }
  }, /*#__PURE__*/_react.default.createElement(_Tooltip.default, (0, _extends2.default)({}, _objectSpread(_objectSpread({}, props.withoutIcon()), {}, {
    focusTrap: (0, _addonKnobs.boolean)('Focus trap (focusTrap)', true)
  }), {
    triggerText: /*#__PURE__*/_react.default.createElement("div", null, "My text wrapped with tooltip"),
    open: value
  }), /*#__PURE__*/_react.default.createElement("p", {
    id: "tooltip-body"
  }, "This is some tooltip text. This box shows the maximum amount of text that should appear inside. If more room is needed please use a modal instead."), /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--tooltip__footer")
  }, /*#__PURE__*/_react.default.createElement("a", {
    href: "/",
    className: "".concat(prefix, "--link")
  }, "Learn More"), /*#__PURE__*/_react.default.createElement(_Button.default, {
    size: "small"
  }, "Create")))));
}

var _default = {
  title: 'Components/Tooltip',
  component: _Tooltip2.Tooltip,
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    docs: {
      page: _Tooltip3.default
    }
  }
};
exports.default = _default;

var DefaultBottom = function DefaultBottom() {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: containerStyles
  }, /*#__PURE__*/_react.default.createElement(_Tooltip.default, props.withIcon(), /*#__PURE__*/_react.default.createElement("p", null, "This is some tooltip text. This box shows the maximum amount of text that should appear inside. If more room is needed please use a modal instead.")));
};

exports.DefaultBottom = DefaultBottom;
DefaultBottom.storyName = 'default (bottom)';
DefaultBottom.parameters = {
  info: {
    text: "\n        Interactive tooltip should be used if there are actions a user can take in the tooltip (e.g. a link or a button).\n        For more regular use case, e.g. giving the user more text information about something, use definition tooltip or icon tooltip.\n        By default, the tooltip will render above the element. The example below shows the default scenario.\n      "
  }
};

var AutoOrientation = function AutoOrientation() {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: _objectSpread(_objectSpread({}, containerStyles), {}, {
      justifyContent: 'unset',
      alignItems: 'unset',
      flexWrap: 'wrap'
    })
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      flex: '50%'
    }
  }, /*#__PURE__*/_react.default.createElement(_Tooltip.default, (0, _extends2.default)({}, props.autoOrientation(), {
    tooltipBodyId: "tooltip-body"
  }), /*#__PURE__*/_react.default.createElement("p", {
    id: "tooltip-body"
  }, "This is some tooltip text. This box shows the maximum amount of text that should appear inside. If more room is needed please use a modal instead."), /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--tooltip__footer")
  }, /*#__PURE__*/_react.default.createElement("a", {
    href: "/",
    className: "".concat(prefix, "--link")
  }, "Learn More"), /*#__PURE__*/_react.default.createElement(_Button.default, {
    size: "small"
  }, "Create")))), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      flex: '50%',
      textAlign: 'right'
    }
  }, /*#__PURE__*/_react.default.createElement(_Tooltip.default, (0, _extends2.default)({}, props.autoOrientation(), {
    tooltipBodyId: "tooltip-body"
  }), /*#__PURE__*/_react.default.createElement("p", {
    id: "tooltip-body"
  }, "This is some tooltip text. This box shows the maximum amount of text that should appear inside. If more room is needed please use a modal instead."), /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--tooltip__footer")
  }, /*#__PURE__*/_react.default.createElement("a", {
    href: "/",
    className: "".concat(prefix, "--link")
  }, "Learn More"), /*#__PURE__*/_react.default.createElement(_Button.default, {
    size: "small"
  }, "Create")))), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      flex: '50%',
      marginTop: 'auto'
    }
  }, /*#__PURE__*/_react.default.createElement(_Tooltip.default, (0, _extends2.default)({}, props.autoOrientation(), {
    tooltipBodyId: "tooltip-body"
  }), /*#__PURE__*/_react.default.createElement("p", {
    id: "tooltip-body"
  }, "This is some tooltip text. This box shows the maximum amount of text that should appear inside. If more room is needed please use a modal instead."), /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--tooltip__footer")
  }, /*#__PURE__*/_react.default.createElement("a", {
    href: "/",
    className: "".concat(prefix, "--link")
  }, "Learn More"), /*#__PURE__*/_react.default.createElement(_Button.default, {
    size: "small"
  }, "Create")))), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      flex: '50%',
      textAlign: 'right',
      marginTop: 'auto'
    }
  }, /*#__PURE__*/_react.default.createElement(_Tooltip.default, (0, _extends2.default)({}, props.autoOrientation(), {
    tooltipBodyId: "tooltip-body"
  }), /*#__PURE__*/_react.default.createElement("p", {
    id: "tooltip-body"
  }, "This is some tooltip text. This box shows the maximum amount of text that should appear inside. If more room is needed please use a modal instead."), /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--tooltip__footer")
  }, /*#__PURE__*/_react.default.createElement("a", {
    href: "/",
    className: "".concat(prefix, "--link")
  }, "Learn More"), /*#__PURE__*/_react.default.createElement(_Button.default, {
    size: "small"
  }, "Create")))));
};

exports.AutoOrientation = AutoOrientation;
AutoOrientation.storyName = 'auto orientation';
AutoOrientation.parameters = {
  info: {
    text: "\n        Interactive tooltip should be used if there are actions a user can take in the tooltip (e.g. a link or a button).\n        For more regular use case, e.g. giving the user more text information about something, use definition tooltip or icon tooltip.\n        By default, the tooltip will render above the element. The example below shows the default scenario.\n      "
  }
};

var NoIcon = function NoIcon() {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: containerStyles
  }, /*#__PURE__*/_react.default.createElement(_Tooltip.default, props.withoutIcon(), /*#__PURE__*/_react.default.createElement("p", null, "This is some tooltip text. This box shows the maximum amount of text that should appear inside. If more room is needed please use a modal instead."), /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--tooltip__footer")
  }, /*#__PURE__*/_react.default.createElement("a", {
    href: "/",
    className: "".concat(prefix, "--link")
  }, "Learn More"), /*#__PURE__*/_react.default.createElement(_Button.default, {
    size: "small"
  }, "Create"))));
};

exports.NoIcon = NoIcon;
NoIcon.storyName = 'no icon';
NoIcon.parameters = {
  info: {
    text: "\n        Interactive tooltip should be used if there are actions a user can take in the tooltip (e.g. a link or a button).\n        For more regular use case, e.g. giving the user more text information about something, use definition tooltip or icon tooltip.\n        By default, the tooltip will render with an information Icon. The example below shows the option to exclude the Icon.\n      "
  }
};

var RenderCustomIcon = function RenderCustomIcon() {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: containerStyles
  }, /*#__PURE__*/_react.default.createElement(_Tooltip.default, props.customIcon(), /*#__PURE__*/_react.default.createElement("p", null, "This is some tooltip text. This box shows the maximum amount of text that should appear inside. If more room is needed please use a modal instead."), /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--tooltip__footer")
  }, /*#__PURE__*/_react.default.createElement("a", {
    href: "/",
    className: "".concat(prefix, "--link")
  }, "Learn More"), /*#__PURE__*/_react.default.createElement(_Button.default, {
    size: "small"
  }, "Create"))));
};

exports.RenderCustomIcon = RenderCustomIcon;
RenderCustomIcon.storyName = 'render custom icon';
RenderCustomIcon.parameters = {
  info: {
    text: "\n        Interactive tooltip should be used if there are actions a user can take in the tooltip (e.g. a link or a button).\n        For more regular use case, e.g. giving the user more text information about something, use definition tooltip or icon tooltip.\n        By default, the tooltip will render with an information Icon. The example below shows the option to exclude the Icon.\n      "
  }
};

var OnlyCustomIcon = function OnlyCustomIcon() {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: containerStyles
  }, /*#__PURE__*/_react.default.createElement(_Tooltip.default, props.customIconOnly(), /*#__PURE__*/_react.default.createElement("p", null, "This is some tooltip text. This box shows the maximum amount of text that should appear inside. If more room is needed please use a modal instead."), /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--tooltip__footer")
  }, /*#__PURE__*/_react.default.createElement("a", {
    href: "/",
    className: "".concat(prefix, "--link")
  }, "Learn More"), /*#__PURE__*/_react.default.createElement(_Button.default, {
    size: "small"
  }, "Create"))));
};

exports.OnlyCustomIcon = OnlyCustomIcon;
OnlyCustomIcon.storyName = 'only custom icon';
OnlyCustomIcon.parameters = {
  info: {
    text: "\n        Interactive tooltip should be used if there are actions a user can take in the tooltip (e.g. a link or a button).\n        For more regular use case, e.g. giving the user more text information about something, use definition tooltip or icon tooltip.\n        By default, the tooltip will render with an information Icon. The example below shows the option to exclude the Icon.\n      "
  }
};

var UncontrolledTooltip = function UncontrolledTooltip() {
  return /*#__PURE__*/_react.default.createElement(UncontrolledTooltipExample, null);
};

exports.UncontrolledTooltip = UncontrolledTooltip;
UncontrolledTooltip.storyName = 'uncontrolled tooltip';