"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Skeleton = exports.SmallToggle = exports.Default = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _carbonComponentsReact = require("carbon-components-react");

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var _default = {
  title: 'Components/Toggle',
  parameters: {
    component: _carbonComponentsReact.Toggle
  }
};
exports.default = _default;

var Default = function Default() {
  return /*#__PURE__*/_react.default.createElement(_carbonComponentsReact.Toggle, {
    labelText: "Toggle element label",
    labelA: "Off",
    labelB: "On",
    defaultToggled: true,
    id: "toggle-1"
  });
};

exports.Default = Default;

var SmallToggle = function SmallToggle() {
  return /*#__PURE__*/_react.default.createElement(_carbonComponentsReact.Toggle, {
    size: "sm",
    labelText: "Toggle element label",
    labelA: "Off",
    labelB: "On",
    defaultToggled: true,
    id: "toggle-2"
  });
};

exports.SmallToggle = SmallToggle;

var Skeleton = function Skeleton() {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, "Medium toggle skeleton with label"), /*#__PURE__*/_react.default.createElement(_carbonComponentsReact.ToggleSkeleton, {
    labelText: "Toggle label",
    id: "toggle-skeleton-id"
  }), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement("p", null, "Small toggle skeleton with label"), /*#__PURE__*/_react.default.createElement(_carbonComponentsReact.ToggleSkeleton, {
    labelText: "Toggle label",
    id: "toggle-skeleton-id",
    size: "sm"
  }));
};

exports.Skeleton = Skeleton;