"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _usePrefix = require("../../../internal/usePrefix");

var _deprecate = _interopRequireDefault(require("../../../prop-types/deprecate"));

var _excluded = ["children", "className", "disabled", "hideLabel", "id", "invalidText", "invalid", "labelText", "light", "maxLength", "onChange", "onClick", "onBlur", "pattern", "placeholder", "size", "type", "value"];

var TimePicker = /*#__PURE__*/_react.default.forwardRef(function TimePicker(_ref, ref) {
  var _cx2, _cx3;

  var children = _ref.children,
      className = _ref.className,
      _ref$disabled = _ref.disabled,
      disabled = _ref$disabled === void 0 ? false : _ref$disabled,
      hideLabel = _ref.hideLabel,
      id = _ref.id,
      _ref$invalidText = _ref.invalidText,
      invalidText = _ref$invalidText === void 0 ? 'Invalid time format.' : _ref$invalidText,
      _ref$invalid = _ref.invalid,
      invalid = _ref$invalid === void 0 ? false : _ref$invalid,
      labelText = _ref.labelText,
      _ref$light = _ref.light,
      light = _ref$light === void 0 ? false : _ref$light,
      _ref$maxLength = _ref.maxLength,
      maxLength = _ref$maxLength === void 0 ? 5 : _ref$maxLength,
      _ref$onChange = _ref.onChange,
      onChange = _ref$onChange === void 0 ? function () {} : _ref$onChange,
      _ref$onClick = _ref.onClick,
      onClick = _ref$onClick === void 0 ? function () {} : _ref$onClick,
      _ref$onBlur = _ref.onBlur,
      onBlur = _ref$onBlur === void 0 ? function () {} : _ref$onBlur,
      _ref$pattern = _ref.pattern,
      pattern = _ref$pattern === void 0 ? '(1[012]|[1-9]):[0-5][0-9](\\s)?' : _ref$pattern,
      _ref$placeholder = _ref.placeholder,
      placeholder = _ref$placeholder === void 0 ? 'hh:mm' : _ref$placeholder,
      size = _ref.size,
      _ref$type = _ref.type,
      type = _ref$type === void 0 ? 'text' : _ref$type,
      value = _ref.value,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();

  var _React$useState = _react.default.useState(value),
      _React$useState2 = (0, _slicedToArray2.default)(_React$useState, 2),
      isValue = _React$useState2[0],
      setValue = _React$useState2[1];

  var _React$useState3 = _react.default.useState(value),
      _React$useState4 = (0, _slicedToArray2.default)(_React$useState3, 2),
      prevValue = _React$useState4[0],
      setPrevValue = _React$useState4[1];

  if (value !== prevValue) {
    setValue(value);
    setPrevValue(value);
  }

  function handleOnClick(evt) {
    if (!disabled) {
      setValue(isValue);
      onClick(evt);
    }
  }

  function handleOnChange(evt) {
    if (!disabled) {
      setValue(isValue);
      onChange(evt);
    }
  }

  function handleOnBlur(evt) {
    if (!disabled) {
      setValue(isValue);
      onBlur(evt);
    }
  }

  var timePickerInputClasses = (0, _classnames.default)("".concat(prefix, "--time-picker__input-field"), "".concat(prefix, "--text-input"), [className], (0, _defineProperty2.default)({}, "".concat(prefix, "--text-input--light"), light));
  var timePickerClasses = (0, _classnames.default)((_cx2 = {}, (0, _defineProperty2.default)(_cx2, "".concat(prefix, "--time-picker"), true), (0, _defineProperty2.default)(_cx2, "".concat(prefix, "--time-picker--light"), light), (0, _defineProperty2.default)(_cx2, "".concat(prefix, "--time-picker--invalid"), invalid), (0, _defineProperty2.default)(_cx2, "".concat(prefix, "--time-picker--").concat(size), size), (0, _defineProperty2.default)(_cx2, className, className), _cx2));
  var labelClasses = (0, _classnames.default)("".concat(prefix, "--label"), (_cx3 = {}, (0, _defineProperty2.default)(_cx3, "".concat(prefix, "--visually-hidden"), hideLabel), (0, _defineProperty2.default)(_cx3, "".concat(prefix, "--label--disabled"), disabled), _cx3));
  var label = labelText ? /*#__PURE__*/_react.default.createElement("label", {
    htmlFor: id,
    className: labelClasses
  }, labelText) : null;
  var error = invalid ? /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--form-requirement")
  }, invalidText) : null;
  return /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)("".concat(prefix, "--form-item"), className)
  }, label, /*#__PURE__*/_react.default.createElement("div", {
    className: timePickerClasses
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--time-picker__input")
  }, /*#__PURE__*/_react.default.createElement("input", (0, _extends2.default)({
    className: timePickerInputClasses,
    "data-invalid": invalid ? invalid : undefined,
    disabled: disabled,
    id: id,
    maxLength: maxLength,
    onClick: handleOnClick,
    onChange: handleOnChange,
    onBlur: handleOnBlur,
    placeholder: placeholder,
    pattern: pattern,
    ref: ref,
    type: type,
    value: value
  }, rest))), children), error);
});

TimePicker.propTypes = {
  /**
   * Pass in the children that will be rendered next to the form control
   */
  children: _propTypes.default.node,

  /**
   * Specify an optional className to be applied to the container node
   */
  className: _propTypes.default.string,

  /**
   * Specify whether the `<input>` should be disabled
   */
  disabled: _propTypes.default.bool,

  /**
   * Specify whether you want the underlying label to be visually hidden
   */
  hideLabel: _propTypes.default.bool,

  /**
   * Specify a custom `id` for the `<input>`
   */
  id: _propTypes.default.string.isRequired,

  /**
   * Specify whether the control is currently invalid
   */
  invalid: _propTypes.default.bool,

  /**
   * Provide the text that is displayed when the control is in an invalid state
   */
  invalidText: _propTypes.default.node,

  /**
   * Provide the text that will be read by a screen reader when visiting this
   * control
   */
  labelText: _propTypes.default.node,

  /**
   * `true` to use the light version. TODO: V12 remove this.
   */
  light: (0, _deprecate.default)(_propTypes.default.bool, 'The `light` prop for `Tile` is no longer needed and has been deprecated. It will be removed in the next major release. Use the Layer component instead.'),

  /**
   * Specify the maximum length of the time string in `<input>`
   */
  maxLength: _propTypes.default.number,

  /**
   * Optionally provide an `onBlur` handler that is called whenever the
   * `<input>` loses focus
   */
  onBlur: _propTypes.default.func,

  /**
   * Optionally provide an `onChange` handler that is called whenever `<input>`
   * is updated
   */
  onChange: _propTypes.default.func,

  /**
   * Optionally provide an `onClick` handler that is called whenever the
   * `<input>` is clicked
   */
  onClick: _propTypes.default.func,

  /**
   * Specify the regular expression working as the pattern of the time string in `<input>`
   */
  pattern: _propTypes.default.string,

  /**
   * Specify the placeholder attribute for the `<input>`
   */
  placeholder: _propTypes.default.string,

  /**
   * Specify the size of the Time Picker. Currently supports either `sm`, 'md' (default) or 'lg` as an option.
   */
  size: _propTypes.default.oneOf(['sm', 'md', 'lg']),

  /**
   * Specify the type of the `<input>`
   */
  type: _propTypes.default.string,

  /**
   * Specify the value of the `<input>`
   */
  value: _propTypes.default.string
};
var _default = TimePicker;
exports.default = _default;