"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

require("carbon-components/scss/components/tag/_tag.scss");

var _react = _interopRequireDefault(require("react"));

var _react2 = require("@cypress/react");

var _Tag = _interopRequireDefault(require("./Tag"));

var _Tag2 = _interopRequireDefault(require("./Tag.Skeleton"));

var _iconsReact = require("@carbon/icons-react");

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
describe('Tag', function () {
  beforeEach(function () {
    (0, _react2.mount)( /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_Tag.default, null, "This is a tag"), /*#__PURE__*/_react.default.createElement(_Tag.default, {
      onClick: function onClick() {}
    }, "This is an interactive tag"), /*#__PURE__*/_react.default.createElement(_Tag.default, {
      size: "sm"
    }, "This is a small tag"), /*#__PURE__*/_react.default.createElement(_Tag.default, {
      filter: true
    }, "This is a filter tag"), /*#__PURE__*/_react.default.createElement(_Tag.default, {
      renderIcon: _iconsReact.Tag16
    }, "Custom icon"), /*#__PURE__*/_react.default.createElement(_Tag.default, {
      filter: true,
      disabled: true
    }, "Disabled filter tag"), /*#__PURE__*/_react.default.createElement(_Tag.default, {
      type: "magenta"
    }, "magenta"), /*#__PURE__*/_react.default.createElement(_Tag.default, {
      type: "red"
    }, "red"), /*#__PURE__*/_react.default.createElement(_Tag.default, {
      type: "purple"
    }, "purple"), /*#__PURE__*/_react.default.createElement(_Tag.default, {
      type: "blue"
    }, "blue"), /*#__PURE__*/_react.default.createElement(_Tag.default, {
      type: "cyan"
    }, "cyan"), /*#__PURE__*/_react.default.createElement(_Tag.default, {
      type: "teal"
    }, "teal"), /*#__PURE__*/_react.default.createElement(_Tag.default, {
      type: "green"
    }, "green"), /*#__PURE__*/_react.default.createElement(_Tag.default, {
      type: "gray"
    }, "gray"), /*#__PURE__*/_react.default.createElement(_Tag.default, {
      type: "cool-gray"
    }, "cool-gray"), /*#__PURE__*/_react.default.createElement(_Tag.default, {
      type: "warm-gray"
    }, "warm-gray"), /*#__PURE__*/_react.default.createElement(_Tag.default, {
      type: "high-contrast"
    }, "high-contrast"), /*#__PURE__*/_react.default.createElement(_Tag2.default, null), /*#__PURE__*/_react.default.createElement(_Tag2.default, {
      size: "sm"
    })));
  });
  it('should render', function () {
    cy.findByText(/warm-gray/).should('be.visible'); // snapshots should always be taken _after_ an assertion that
    // a element/component should be visible. This is to ensure
    // the DOM has settled and the element has fully loaded.

    cy.percySnapshot();
  });
});