"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

require("carbon-components/scss/components/tabs/_tabs.scss");

var _react = _interopRequireDefault(require("react"));

var _react2 = require("@cypress/react");

var _Tabs = _interopRequireDefault(require("./Tabs"));

var _Tab = _interopRequireDefault(require("../Tab/Tab"));

var _Tabs2 = _interopRequireDefault(require("./Tabs.Skeleton"));

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
describe('Tabs', function () {
  beforeEach(function () {
    (0, _react2.mount)( /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_Tabs.default, null, /*#__PURE__*/_react.default.createElement(_Tab.default, {
      label: "Tab label 1"
    }, /*#__PURE__*/_react.default.createElement("p", null, "Content for first tab goes here.")), /*#__PURE__*/_react.default.createElement(_Tab.default, {
      label: "Tab label 2"
    }, /*#__PURE__*/_react.default.createElement("p", null, "Content for second tab goes here.")), /*#__PURE__*/_react.default.createElement(_Tab.default, {
      label: "Tab label 3",
      disabled: true
    }, /*#__PURE__*/_react.default.createElement("p", null, "Content for third tab goes here.")), /*#__PURE__*/_react.default.createElement(_Tab.default, {
      label: "Tab label 4 shows truncation",
      title: "Tab label 4 shows truncation"
    }, /*#__PURE__*/_react.default.createElement("p", null, "Content for fourth tab goes here."))), /*#__PURE__*/_react.default.createElement(_Tabs.default, {
      type: "container"
    }, /*#__PURE__*/_react.default.createElement(_Tab.default, {
      label: "Tab label 1"
    }, /*#__PURE__*/_react.default.createElement("p", null, "Yellow")), /*#__PURE__*/_react.default.createElement(_Tab.default, {
      label: "Tab label 2"
    }, /*#__PURE__*/_react.default.createElement("p", null, "Content for second tab goes here.")), /*#__PURE__*/_react.default.createElement(_Tab.default, {
      label: "Tab label 3 shows truncation",
      title: "Tab label 3 shows truncation"
    }, /*#__PURE__*/_react.default.createElement("p", null, "Content for third tab goes here.")), /*#__PURE__*/_react.default.createElement(_Tab.default, {
      label: "Tab label 4",
      disabled: true
    }, /*#__PURE__*/_react.default.createElement("p", null, "Content for fourth container tab goes here."))), /*#__PURE__*/_react.default.createElement(_Tabs2.default, {
      type: "default"
    }), /*#__PURE__*/_react.default.createElement(_Tabs2.default, {
      type: "container"
    })));
  });
  it('should render', function () {
    cy.findByText('Yellow').should('be.visible'); // snapshots should always be taken _after_ an assertion that
    // a element/component should be visible. This is to ensure
    // the DOM has settled and the element has fully loaded.

    cy.percySnapshot();
  });
});