"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Skeleton = exports.Contained = exports.IconOnly = exports.Default = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _Tabs = require("./Tabs");

var _Button = _interopRequireDefault(require("../../Button"));

var _Tabs2 = _interopRequireDefault(require("./Tabs.Skeleton"));

var _iconsReact = require("@carbon/icons-react");

var _carbonComponentsReact = require("carbon-components-react");

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var _default = {
  title: 'Components/Tabs',
  decorators: [function (Story) {
    return /*#__PURE__*/_react.default.createElement(_carbonComponentsReact.unstable_FeatureFlags, {
      flags: {
        'enable-v11-release': true
      }
    }, /*#__PURE__*/_react.default.createElement(Story, null));
  }],
  parameters: {
    component: _Tabs.Tabs,
    subcomponents: {
      TabList: _Tabs.TabList,
      Tab: _Tabs.Tab,
      TabPanels: _Tabs.TabPanels,
      TabPanel: _Tabs.TabPanel
    }
  }
};
exports.default = _default;

var Default = function Default() {
  return /*#__PURE__*/_react.default.createElement(_Tabs.Tabs, null, /*#__PURE__*/_react.default.createElement(_Tabs.TabList, {
    "aria-label": "List of tabs"
  }, /*#__PURE__*/_react.default.createElement(_Tabs.Tab, null, "Tab Label 1"), /*#__PURE__*/_react.default.createElement(_Tabs.Tab, null, "Tab Label 2"), /*#__PURE__*/_react.default.createElement(_Tabs.Tab, {
    disabled: true
  }, "Tab Label 3"), /*#__PURE__*/_react.default.createElement(_Tabs.Tab, null, "Tab Label 4 with a very long long label"), /*#__PURE__*/_react.default.createElement(_Tabs.Tab, null, "Tab Label 5")), /*#__PURE__*/_react.default.createElement(_Tabs.TabPanels, null, /*#__PURE__*/_react.default.createElement(_Tabs.TabPanel, null, "Tab Panel 1 ", /*#__PURE__*/_react.default.createElement(_Button.default, null, "Example button")), /*#__PURE__*/_react.default.createElement(_Tabs.TabPanel, null, "Tab Panel 2"), /*#__PURE__*/_react.default.createElement(_Tabs.TabPanel, null, "Tab Panel 3"), /*#__PURE__*/_react.default.createElement(_Tabs.TabPanel, null, "Tab Panel 4"), /*#__PURE__*/_react.default.createElement(_Tabs.TabPanel, null, "Tab Panel 5")));
};

exports.Default = Default;

var IconOnly = function IconOnly() {
  return /*#__PURE__*/_react.default.createElement(_Tabs.Tabs, null, /*#__PURE__*/_react.default.createElement(_Tabs.TabList, {
    "aria-label": "List of tabs"
  }, /*#__PURE__*/_react.default.createElement(_Tabs.Tab, {
    disabled: true
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.Monster20, null)), /*#__PURE__*/_react.default.createElement(_Tabs.Tab, null, /*#__PURE__*/_react.default.createElement(_iconsReact.Corn20, null)), /*#__PURE__*/_react.default.createElement(_Tabs.Tab, null, /*#__PURE__*/_react.default.createElement(_iconsReact.Bat20, null))), /*#__PURE__*/_react.default.createElement(_Tabs.TabPanels, null, /*#__PURE__*/_react.default.createElement(_Tabs.TabPanel, null, "Tab Panel 1"), /*#__PURE__*/_react.default.createElement(_Tabs.TabPanel, null, "Tab Panel 2"), /*#__PURE__*/_react.default.createElement(_Tabs.TabPanel, null, "Tab Panel 3")));
};

exports.IconOnly = IconOnly;

var Contained = function Contained() {
  return /*#__PURE__*/_react.default.createElement(_Tabs.Tabs, null, /*#__PURE__*/_react.default.createElement(_Tabs.TabList, {
    "aria-label": "List of tabs",
    contained: true
  }, /*#__PURE__*/_react.default.createElement(_Tabs.Tab, null, "Tab Label 1"), /*#__PURE__*/_react.default.createElement(_Tabs.Tab, null, "Tab Label 2"), /*#__PURE__*/_react.default.createElement(_Tabs.Tab, {
    disabled: true
  }, "Tab Label 3"), /*#__PURE__*/_react.default.createElement(_Tabs.Tab, null, "Tab Label 4 with a very long long title"), /*#__PURE__*/_react.default.createElement(_Tabs.Tab, null, "Tab Label 5")), /*#__PURE__*/_react.default.createElement(_Tabs.TabPanels, null, /*#__PURE__*/_react.default.createElement(_Tabs.TabPanel, null, "Tab Panel 1"), /*#__PURE__*/_react.default.createElement(_Tabs.TabPanel, null, "Tab Panel 2 ", /*#__PURE__*/_react.default.createElement(_Button.default, null, "Example button")), /*#__PURE__*/_react.default.createElement(_Tabs.TabPanel, null, "Tab Panel 3"), /*#__PURE__*/_react.default.createElement(_Tabs.TabPanel, null, "Tab Panel 4"), /*#__PURE__*/_react.default.createElement(_Tabs.TabPanel, null, "Tab Panel 5")));
};

exports.Contained = Contained;

var Skeleton = function Skeleton() {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      maxWidth: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_Tabs2.default, null));
};

exports.Skeleton = Skeleton;