"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _carbonComponents = require("carbon-components");

var _navigation = require("../../internal/keyboard/navigation");

var _useIsomorphicEffect = _interopRequireDefault(require("../../internal/useIsomorphicEffect"));

var _excluded = ["className", "selected", "children"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var prefix = _carbonComponents.settings.prefix;
/**
 * Determine if the node within the provided ref contains content that is tabbable.
 */

function useTabbableContent(ref) {
  var _useState = (0, _react.useState)(false),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      hasTabbableContent = _useState2[0],
      setHasTabbableContent = _useState2[1];

  (0, _useIsomorphicEffect.default)(function () {
    if (ref.current) {
      setHasTabbableContent(ref.current.querySelector(_navigation.selectorTabbable));
    }
  });
  return hasTabbableContent;
}

var TabContent = function TabContent(props) {
  var className = props.className,
      selected = props.selected,
      children = props.children,
      other = (0, _objectWithoutProperties2.default)(props, _excluded);
  var tabContentClasses = (0, _classnames.default)("".concat(prefix, "--tab-content"), (0, _defineProperty2.default)({}, className, className));
  var ref = (0, _react.useRef)(null);
  var hasTabbableContent = useTabbableContent(ref);
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    role: "tabpanel"
  }, other, {
    className: tabContentClasses,
    selected: selected,
    hidden: !selected,
    ref: ref,
    tabIndex: hasTabbableContent ? undefined : 0
  }), children);
};

TabContent.propTypes = {
  /**
   * Pass in content to render inside of the TabContent
   */
  children: _propTypes.default.node,

  /**
   * Provide a className for the tab content container
   */
  className: _propTypes.default.string,

  /**
   * Specify whether the TabContent is selected
   */
  selected: _propTypes.default.bool
};
TabContent.defaultProps = {
  selected: false
};
var _default = TabContent;
exports.default = _default;