"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StructuredListWrapper = StructuredListWrapper;
exports.StructuredListHead = StructuredListHead;
exports.StructuredListBody = StructuredListBody;
exports.StructuredListRow = StructuredListRow;
exports.StructuredListInput = StructuredListInput;
exports.StructuredListCell = StructuredListCell;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _setupGetInstanceId = _interopRequireDefault(require("../../tools/setupGetInstanceId"));

var _deprecate = _interopRequireDefault(require("../../prop-types/deprecate"));

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["children", "selection", "className", "ariaLabel", "isCondensed", "isFlush", "border"],
    _excluded2 = ["children", "className"],
    _excluded3 = ["children", "className"],
    _excluded4 = ["onKeyDown", "tabIndex", "children", "className", "head", "label"],
    _excluded5 = ["className", "value", "name", "title", "id"],
    _excluded6 = ["children", "className", "head", "noWrap"];
var getInstanceId = (0, _setupGetInstanceId.default)();

function StructuredListWrapper(props) {
  var _classNames;

  var children = props.children,
      selection = props.selection,
      className = props.className,
      ariaLabel = props.ariaLabel,
      isCondensed = props.isCondensed,
      isFlush = props.isFlush,
      _border = props.border,
      other = (0, _objectWithoutProperties2.default)(props, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();
  var classes = (0, _classnames.default)("".concat(prefix, "--structured-list"), className, (_classNames = {}, (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--structured-list--selection"), selection), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--structured-list--condensed"), isCondensed), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--structured-list--flush"), isFlush), _classNames));
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    role: "table",
    className: classes
  }, other, {
    "aria-label": ariaLabel
  }), children);
}

StructuredListWrapper.propTypes = {
  /**
   * Specify a label to be read by screen readers on the container node
   */
  ariaLabel: _propTypes.default.string,

  /**
   * Specify whether a border should be added to your StructuredListWrapper
   */
  border: (0, _deprecate.default)(_propTypes.default.bool, "\nThe prop `border` will be removed in the next major version of Carbon."),

  /**
   * Provide the contents of your StructuredListWrapper
   */
  children: _propTypes.default.node,

  /**
   * Specify an optional className to be applied to the container node
   */
  className: _propTypes.default.string,

  /**
   * Specify if structured list is condensed, default is false
   */
  isCondensed: _propTypes.default.bool,

  /**
   * Specify if structured list is flush, default is false
   */
  isFlush: _propTypes.default.bool,

  /**
   * Specify whether your StructuredListWrapper should have selections
   */
  selection: _propTypes.default.bool
};
StructuredListWrapper.defaultProps = {
  selection: false,
  ariaLabel: 'Structured list section',
  isCondensed: false,
  isFlush: false
};

function StructuredListHead(props) {
  var children = props.children,
      className = props.className,
      other = (0, _objectWithoutProperties2.default)(props, _excluded2);
  var prefix = (0, _usePrefix.usePrefix)();
  var classes = (0, _classnames.default)("".concat(prefix, "--structured-list-thead"), className);
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    role: "rowgroup",
    className: classes
  }, other), children);
}

StructuredListHead.propTypes = {
  /**
   * Provide the contents of your StructuredListHead
   */
  children: _propTypes.default.node,

  /**
   * Specify an optional className to be applied to the node
   */
  className: _propTypes.default.string
};

function StructuredListBody(props) {
  var children = props.children,
      className = props.className,
      other = (0, _objectWithoutProperties2.default)(props, _excluded3);
  var prefix = (0, _usePrefix.usePrefix)();
  var classes = (0, _classnames.default)("".concat(prefix, "--structured-list-tbody"), className);
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    className: classes,
    role: "rowgroup"
  }, other), children);
}

StructuredListBody.propTypes = {
  /**
   * Provide the contents of your StructuredListBody
   */
  children: _propTypes.default.node,

  /**
   * Specify an optional className to be applied to the container node
   */
  className: _propTypes.default.string,
  head: _propTypes.default.bool,

  /**
   * Provide a handler that is invoked on the key down event for the control
   */
  onKeyDown: _propTypes.default.func
};
StructuredListBody.defaultProps = {
  onKeyDown: function onKeyDown() {}
};

function StructuredListRow(props) {
  var onKeyDown = props.onKeyDown,
      tabIndex = props.tabIndex,
      children = props.children,
      className = props.className,
      head = props.head,
      label = props.label,
      other = (0, _objectWithoutProperties2.default)(props, _excluded4);
  var prefix = (0, _usePrefix.usePrefix)();
  var classes = (0, _classnames.default)("".concat(prefix, "--structured-list-row"), className, (0, _defineProperty2.default)({}, "".concat(prefix, "--structured-list-row--header-row"), head));
  return label ?
  /*#__PURE__*/
  // eslint-disable-next-line jsx-a11y/no-noninteractive-element-interactions
  _react.default.createElement("label", (0, _extends2.default)({}, other, {
    tabIndex: tabIndex,
    className: classes,
    onKeyDown: onKeyDown
  }), children) : /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    role: "row"
  }, other, {
    className: classes
  }), children);
}

StructuredListRow.propTypes = {
  /**
   * Provide the contents of your StructuredListRow
   */
  children: _propTypes.default.node,

  /**
   * Specify an optional className to be applied to the container node
   */
  className: _propTypes.default.string,

  /**
   * Specify whether your StructuredListRow should be used as a header row
   */
  head: _propTypes.default.bool,

  /**
   * Specify whether a `<label>` should be used
   */
  label: _propTypes.default.bool,

  /**
   * Provide a handler that is invoked on the key down event for the control,
   * if `<label>` is in use
   */
  onKeyDown: _propTypes.default.func,

  /**
   * Specify the tab index of the container node, if `<label>` is in use
   */
  tabIndex: _propTypes.default.number
};
StructuredListRow.defaultProps = {
  head: false,
  label: false,
  tabIndex: 0,
  onKeyDown: function onKeyDown() {}
};

function StructuredListInput(props) {
  var className = props.className,
      value = props.value,
      name = props.name,
      title = props.title,
      id = props.id,
      other = (0, _objectWithoutProperties2.default)(props, _excluded5);
  var prefix = (0, _usePrefix.usePrefix)();
  var classes = (0, _classnames.default)("".concat(prefix, "--structured-list-input"), className);
  var instanceId = id || getInstanceId();
  return /*#__PURE__*/_react.default.createElement("input", (0, _extends2.default)({}, other, {
    type: "radio",
    tabIndex: -1,
    id: instanceId,
    className: classes,
    value: value,
    name: name,
    title: title
  }));
}

StructuredListInput.propTypes = {
  /**
   * Specify an optional className to be applied to the input
   */
  className: _propTypes.default.string,

  /**
   * Specify whether the underlying input should be checked by default
   */
  defaultChecked: _propTypes.default.bool,

  /**
   * Specify a custom `id` for the input
   */
  id: _propTypes.default.string,

  /**
   * Provide a `name` for the input
   */
  name: _propTypes.default.string,

  /**
   * Provide an optional hook that is called each time the input is updated
   */
  onChange: _propTypes.default.func,

  /**
   * Provide a `title` for the input
   */
  title: _propTypes.default.string,

  /**
   * Specify the value of the input
   */
  value: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]).isRequired
};
StructuredListInput.defaultProps = {
  onChange: function onChange() {},
  value: 'value',
  title: 'title'
};

function StructuredListCell(props) {
  var _classNames3;

  var children = props.children,
      className = props.className,
      head = props.head,
      noWrap = props.noWrap,
      other = (0, _objectWithoutProperties2.default)(props, _excluded6);
  var prefix = (0, _usePrefix.usePrefix)();
  var classes = (0, _classnames.default)(className, (_classNames3 = {}, (0, _defineProperty2.default)(_classNames3, "".concat(prefix, "--structured-list-th"), head), (0, _defineProperty2.default)(_classNames3, "".concat(prefix, "--structured-list-td"), !head), (0, _defineProperty2.default)(_classNames3, "".concat(prefix, "--structured-list-content--nowrap"), noWrap), _classNames3));
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    className: classes,
    role: head ? 'columnheader' : 'cell'
  }, other), children);
}

StructuredListCell.propTypes = {
  /**
   * Provide the contents of your StructuredListCell
   */
  children: _propTypes.default.node,

  /**
   * Specify an optional className to be applied to the container node
   */
  className: _propTypes.default.string,

  /**
   * Specify whether your StructuredListCell should be used as a header cell
   */
  head: _propTypes.default.bool,

  /**
   * Specify whether your StructuredListCell should have text wrapping
   */
  noWrap: _propTypes.default.bool
};
StructuredListCell.defaultProps = {
  head: false,
  noWrap: false
};