"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["rowCount", "border", "className"];

var StructuredListSkeleton = function StructuredListSkeleton(_ref) {
  var _cx;

  var rowCount = _ref.rowCount,
      border = _ref.border,
      className = _ref.className,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();
  var StructuredListSkeletonClasses = (0, _classnames.default)(className, (_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--skeleton"), true), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--structured-list"), true), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--structured-list--border"), border), _cx));
  var rows = [];

  for (var i = 0; i < rowCount; i++) {
    rows.push( /*#__PURE__*/_react.default.createElement("div", {
      className: "".concat(prefix, "--structured-list-row"),
      key: i
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "".concat(prefix, "--structured-list-td")
    }), /*#__PURE__*/_react.default.createElement("div", {
      className: "".concat(prefix, "--structured-list-td")
    }), /*#__PURE__*/_react.default.createElement("div", {
      className: "".concat(prefix, "--structured-list-td")
    })));
  }

  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    className: StructuredListSkeletonClasses
  }, rest), /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--structured-list-thead")
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--structured-list-row ").concat(prefix, "--structured-list-row--header-row")
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--structured-list-th")
  }, /*#__PURE__*/_react.default.createElement("span", null)), /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--structured-list-th")
  }, /*#__PURE__*/_react.default.createElement("span", null)), /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--structured-list-th")
  }, /*#__PURE__*/_react.default.createElement("span", null)))), /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--structured-list-tbody")
  }, rows));
};

StructuredListSkeleton.propTypes = {
  /**
   * Specify whether a border should be added to your StructuredListSkeleton
   */
  border: _propTypes.default.bool,

  /**
   * Specify an optional className to add.
   */
  className: _propTypes.default.string,

  /**
   * number of table rows
   */
  rowCount: _propTypes.default.number
};
StructuredListSkeleton.defaultProps = {
  rowCount: 5,
  border: false
};
var _default = StructuredListSkeleton;
exports.default = _default;