"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Playground = exports.Horizontal = exports.Default = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _Stack = require("../Stack");

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var _default = {
  title: 'Layout/Stack',
  component: _Stack.Stack,
  parameters: {
    controls: {
      hideNoControlsWarning: true
    }
  },
  argTypes: {
    children: {
      table: {
        disable: true
      }
    }
  }
};
exports.default = _default;

var Default = function Default() {
  return /*#__PURE__*/_react.default.createElement(_Stack.Stack, {
    gap: 6
  }, /*#__PURE__*/_react.default.createElement("div", null, "Item 1"), /*#__PURE__*/_react.default.createElement("div", null, "Item 2"), /*#__PURE__*/_react.default.createElement("div", null, "Item 3"));
};

exports.Default = Default;

var Horizontal = function Horizontal() {
  return /*#__PURE__*/_react.default.createElement(_Stack.Stack, {
    gap: 6,
    orientation: "horizontal"
  }, /*#__PURE__*/_react.default.createElement("div", null, "Item 1"), /*#__PURE__*/_react.default.createElement("div", null, "Item 2"), /*#__PURE__*/_react.default.createElement("div", null, "Item 3"));
};

exports.Horizontal = Horizontal;

var PlaygroundStory = function PlaygroundStory(props) {
  return /*#__PURE__*/_react.default.createElement(_Stack.Stack, props, /*#__PURE__*/_react.default.createElement("div", null, "Item 1"), /*#__PURE__*/_react.default.createElement("div", null, "Item 2"), /*#__PURE__*/_react.default.createElement("div", null, "Item 3"));
};

var Playground = PlaygroundStory.bind({});
exports.Playground = Playground;
Playground.argTypes = {
  gap: {
    options: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
    control: {
      type: 'select'
    }
  },
  orientation: {
    options: ['horizontal', 'vertical'],
    control: {
      type: 'select'
    }
  }
};