"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["paragraph", "lineCount", "width", "heading", "className"];
var randoms = [0.973051493507435, 0.15334737213558558, 0.5671034553053769];

function getRandomInt(min, max, n) {
  return Math.floor(randoms[n % 3] * (max - min + 1)) + min;
}

var SkeletonText = function SkeletonText(_ref) {
  var _classNames;

  var paragraph = _ref.paragraph,
      lineCount = _ref.lineCount,
      width = _ref.width,
      heading = _ref.heading,
      className = _ref.className,
      other = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();
  var skeletonTextClasses = (0, _classnames.default)((_classNames = {}, (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--skeleton__text"), true), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--skeleton__heading"), heading), (0, _defineProperty2.default)(_classNames, className, className), _classNames));
  var widthNum = parseInt(width, 10);
  var widthPx = width.includes('px');
  var widthPercent = width.includes('%');

  if (widthPercent && paragraph) {
    var lines = [];

    for (var i = 0; i < lineCount; i++) {
      var randomWidth = getRandomInt(0, 75, i) + 'px';
      lines.push( /*#__PURE__*/_react.default.createElement("p", (0, _extends2.default)({
        className: skeletonTextClasses,
        style: {
          width: "calc(".concat(width, " - ").concat(randomWidth, ")")
        },
        key: i
      }, other)));
    }

    return /*#__PURE__*/_react.default.createElement("div", null, lines);
  }

  if (widthPx && paragraph) {
    var _lines = [];

    for (var j = 0; j < lineCount; j++) {
      var _randomWidth = getRandomInt(widthNum - 75, widthNum, j) + 'px';

      _lines.push( /*#__PURE__*/_react.default.createElement("p", (0, _extends2.default)({
        className: skeletonTextClasses,
        style: {
          width: _randomWidth
        },
        key: j
      }, other)));
    }

    return /*#__PURE__*/_react.default.createElement("div", null, _lines);
  }

  return /*#__PURE__*/_react.default.createElement("p", (0, _extends2.default)({
    className: skeletonTextClasses,
    style: {
      width: width
    }
  }, other));
};

SkeletonText.propTypes = {
  /**
   * Specify an optional className to be applied to the container node
   */
  className: _propTypes.default.string,

  /**
   * generates skeleton text at a larger size
   */
  heading: _propTypes.default.bool,

  /**
   * the number of lines in a paragraph
   */
  lineCount: _propTypes.default.number,

  /**
   * will generate multiple lines of text
   */
  paragraph: _propTypes.default.bool,

  /**
   * width (in px or %) of single line of text or max-width of paragraph lines
   */
  width: _propTypes.default.string
};
SkeletonText.defaultProps = {
  paragraph: false,
  width: '100%',
  heading: false,
  lineCount: 3
};
var _default = SkeletonText;
exports.default = _default;