"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports._SkeletonText = exports._SkeletonPlaceholder = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _SkeletonText2 = _interopRequireDefault(require("../../SkeletonText"));

var _SkeletonPlaceholder2 = _interopRequireDefault(require("../../SkeletonPlaceholder"));

var _addonKnobs = require("@storybook/addon-knobs");

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var classNames = {
  'my--skeleton__placeholder--small': 'my--skeleton__placeholder--small',
  'my--skeleton__placeholder--medium': 'my--skeleton__placeholder--medium',
  'my--skeleton__placeholder--large': 'my--skeleton__placeholder--large'
};

var placeholderProps = function placeholderProps() {
  return {
    className: (0, _addonKnobs.select)('Classes with different sizes', classNames)
  };
};

var widths = {
  '100%': '100%',
  '250px': '250px'
};

var textProps = function textProps() {
  return {
    heading: (0, _addonKnobs.boolean)('Skeleton text at a larger size (heading)'),
    paragraph: (0, _addonKnobs.boolean)('Use multiple lines of text (paragraph)'),
    lineCount: (0, _addonKnobs.number)('The number of lines in a paragraph (lineCount)', 3),
    width: (0, _addonKnobs.select)('Width (in px or %) of single line of text or max-width of paragraph lines (width)', widths, '100%')
  };
};

var _default = {
  title: 'Components/Skeleton',
  decorators: [_addonKnobs.withKnobs]
};
exports.default = _default;

var _SkeletonPlaceholder = function _SkeletonPlaceholder() {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      height: '250px',
      width: '250px'
    }
  }, /*#__PURE__*/_react.default.createElement("style", {
    dangerouslySetInnerHTML: {
      __html: "\n      .my--skeleton__placeholder--small {\n        height: 100px;\n        width: 100px;\n      }\n\n      .my--skeleton__placeholder--medium {\n        height: 150px;\n        width: 150px;\n      }\n\n      .my--skeleton__placeholder--large {\n        height: 250px;\n        width: 250px;\n      }\n    "
    }
  }), /*#__PURE__*/_react.default.createElement(_SkeletonPlaceholder2.default, placeholderProps()));
};

exports._SkeletonPlaceholder = _SkeletonPlaceholder;

var _SkeletonText = function _SkeletonText() {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '300px'
    }
  }, /*#__PURE__*/_react.default.createElement(_SkeletonText2.default, textProps()));
};

exports._SkeletonText = _SkeletonText;