"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _carbonComponents = require("carbon-components");

var _excluded = ["className", "value", "disabled", "hidden", "text"];
var prefix = _carbonComponents.settings.prefix;

var SelectItem = function SelectItem(_ref) {
  var _classNames;

  var className = _ref.className,
      value = _ref.value,
      disabled = _ref.disabled,
      hidden = _ref.hidden,
      text = _ref.text,
      other = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var selectItemClasses = (0, _classnames.default)((_classNames = {}, (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--select-option"), true), (0, _defineProperty2.default)(_classNames, className, className), _classNames));
  return /*#__PURE__*/_react.default.createElement("option", (0, _extends2.default)({}, other, {
    className: selectItemClasses,
    value: value,
    disabled: disabled,
    hidden: hidden
  }), text);
};

SelectItem.propTypes = {
  /**
   * Specify an optional className to be applied to the node
   */
  className: _propTypes.default.string,

  /**
   * Specify whether the <SelectItem> should be disabled
   */
  disabled: _propTypes.default.bool,

  /**
   * Specify whether the <SelectItem> is hidden
   */
  hidden: _propTypes.default.bool,

  /**
   * Provide the contents of your <SelectItem>
   */
  text: _propTypes.default.string.isRequired,

  /**
   * Specify the value of the <SelectItem>
   */
  value: _propTypes.default.any.isRequired
};
SelectItem.defaultProps = {
  disabled: false,
  hidden: false,
  value: '',
  text: ''
};
var _default = SelectItem;
exports.default = _default;